/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.UInt32Value;
import io.grpc.Internal;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.internal.Matchers;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public final class XdsClientWrapperForServerSds {
    private static final Logger logger = Logger.getLogger(XdsClientWrapperForServerSds.class.getName());
    private AtomicReference<EnvoyServerProtoData.Listener> curListener = new AtomicReference();
    private ObjectPool<XdsClient> xdsClientPool;
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;
    @Nullable
    private XdsClient xdsClient;
    private final int port;
    private XdsClient.LdsResourceWatcher listenerWatcher;
    private boolean newServerApi;
    private String grpcServerResourceId;
    @VisibleForTesting
    final Set<ServerWatcher> serverWatchers = new HashSet<ServerWatcher>();

    XdsClientWrapperForServerSds(int port) {
        this(port, SharedXdsClientPoolProvider.getDefaultProvider());
    }

    @VisibleForTesting
    XdsClientWrapperForServerSds(int port, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this.port = port;
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolFactory");
    }

    @VisibleForTesting
    XdsClient getXdsClient() {
        return this.xdsClient;
    }

    public TlsContextManager getTlsContextManager() {
        return this.xdsClient.getTlsContextManager();
    }

    @VisibleForTesting
    public void start() {
        try {
            this.xdsClientPool = this.xdsClientPoolFactory.getOrCreate();
        }
        catch (Exception e) {
            this.reportError(e, true);
            return;
        }
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        this.listenerWatcher = new XdsClient.LdsResourceWatcher(){

            @Override
            public void onChanged(XdsClient.LdsUpdate update) {
                XdsClientWrapperForServerSds.this.releaseOldSuppliers(XdsClientWrapperForServerSds.this.curListener.getAndSet(update.listener()));
                XdsClientWrapperForServerSds.this.reportSuccess();
            }

            @Override
            public void onResourceDoesNotExist(String resourceName) {
                logger.log(Level.WARNING, "Resource {0} is unavailable", resourceName);
                XdsClientWrapperForServerSds.this.releaseOldSuppliers(XdsClientWrapperForServerSds.this.curListener.getAndSet(null));
                XdsClientWrapperForServerSds.this.reportError((Throwable)Status.NOT_FOUND.asException(), true);
            }

            @Override
            public void onError(Status error) {
                logger.log(Level.WARNING, "LdsResourceWatcher in XdsClientWrapperForServerSds: {0}", error);
                if (XdsClientWrapperForServerSds.isResourceAbsent(error)) {
                    XdsClientWrapperForServerSds.this.releaseOldSuppliers(XdsClientWrapperForServerSds.this.curListener.getAndSet(null));
                    XdsClientWrapperForServerSds.this.reportError((Throwable)error.asException(), true);
                } else {
                    XdsClientWrapperForServerSds.this.reportError((Throwable)error.asException(), false);
                }
            }
        };
        this.newServerApi = this.xdsClient.getBootstrapInfo().getServers().get(0).isUseProtocolV3();
        if (!this.newServerApi) {
            this.reportError(new XdsInitializationException("requires use of xds_v3 in xds bootstrap"), true);
            return;
        }
        this.grpcServerResourceId = this.xdsClient.getBootstrapInfo().getServerListenerResourceNameTemplate();
        if (this.grpcServerResourceId == null) {
            this.reportError(new XdsInitializationException("missing server_listener_resource_name_template value in xds bootstrap"), true);
            return;
        }
        this.grpcServerResourceId = this.grpcServerResourceId.replaceAll("%s", "0.0.0.0:" + this.port);
        this.xdsClient.watchLdsResource(this.grpcServerResourceId, this.listenerWatcher);
    }

    private void releaseOldSuppliers(EnvoyServerProtoData.Listener oldListener) {
        if (oldListener != null) {
            List<EnvoyServerProtoData.FilterChain> filterChains = oldListener.getFilterChains();
            for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
                XdsClientWrapperForServerSds.releaseSupplier(filterChain);
            }
            XdsClientWrapperForServerSds.releaseSupplier(oldListener.getDefaultFilterChain());
        }
    }

    private static void releaseSupplier(EnvoyServerProtoData.FilterChain filterChain) {
        SslContextProviderSupplier sslContextProviderSupplier;
        if (filterChain != null && (sslContextProviderSupplier = filterChain.getSslContextProviderSupplier()) != null) {
            sslContextProviderSupplier.close();
        }
    }

    private static boolean isResourceAbsent(Status status) {
        Status.Code code = status.getCode();
        switch (code) {
            case NOT_FOUND: 
            case INVALID_ARGUMENT: 
            case PERMISSION_DENIED: 
            case UNIMPLEMENTED: 
            case UNAUTHENTICATED: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public SslContextProviderSupplier getSslContextProviderSupplier(Channel channel) {
        EnvoyServerProtoData.Listener copyListener = this.curListener.get();
        if (copyListener != null && channel != null) {
            SocketAddress localAddress = channel.localAddress();
            SocketAddress remoteAddress = channel.remoteAddress();
            if (localAddress instanceof InetSocketAddress && remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress localInetAddr = (InetSocketAddress)localAddress;
                InetSocketAddress remoteInetAddr = (InetSocketAddress)remoteAddress;
                Preconditions.checkState((this.port == localInetAddr.getPort() ? 1 : 0) != 0, (Object)"Channel localAddress port does not match requested listener port");
                return XdsClientWrapperForServerSds.getSslContextProviderSupplier(localInetAddr, remoteInetAddr, copyListener);
            }
        }
        return null;
    }

    private static SslContextProviderSupplier getSslContextProviderSupplier(InetSocketAddress localInetAddr, InetSocketAddress remoteInetAddr, EnvoyServerProtoData.Listener listener) {
        List<EnvoyServerProtoData.FilterChain> filterChains = listener.getFilterChains();
        filterChains = XdsClientWrapperForServerSds.filterOnDestinationPort(filterChains);
        filterChains = XdsClientWrapperForServerSds.filterOnIpAddress(filterChains, localInetAddr.getAddress(), true);
        filterChains = XdsClientWrapperForServerSds.filterOnServerNames(filterChains);
        filterChains = XdsClientWrapperForServerSds.filterOnTransportProtocol(filterChains);
        filterChains = XdsClientWrapperForServerSds.filterOnApplicationProtocols(filterChains);
        filterChains = XdsClientWrapperForServerSds.filterOnSourceType(filterChains, remoteInetAddr.getAddress(), localInetAddr.getAddress());
        filterChains = XdsClientWrapperForServerSds.filterOnIpAddress(filterChains, remoteInetAddr.getAddress(), false);
        if ((filterChains = XdsClientWrapperForServerSds.filterOnSourcePort(filterChains, remoteInetAddr.getPort())).size() > 1) {
            throw new IllegalStateException("Found 2 matching filter-chains");
        }
        if (filterChains.size() == 1) {
            return filterChains.get(0).getSslContextProviderSupplier();
        }
        if (listener.getDefaultFilterChain() == null) {
            throw new RuntimeException("no matching filter chain. local: " + localInetAddr + " remote: " + remoteInetAddr);
        }
        return listener.getDefaultFilterChain().getSslContextProviderSupplier();
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnApplicationProtocols(List<EnvoyServerProtoData.FilterChain> filterChains) {
        ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            if (!filterChainMatch.getApplicationProtocols().isEmpty()) continue;
            filtered.add(filterChain);
        }
        return filtered;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnTransportProtocol(List<EnvoyServerProtoData.FilterChain> filterChains) {
        ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            String transportProtocol = filterChainMatch.getTransportProtocol();
            if (!Strings.isNullOrEmpty((String)transportProtocol) && !"raw_buffer".equals(transportProtocol)) continue;
            filtered.add(filterChain);
        }
        return filtered;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnServerNames(List<EnvoyServerProtoData.FilterChain> filterChains) {
        ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            if (!filterChainMatch.getServerNames().isEmpty()) continue;
            filtered.add(filterChain);
        }
        return filtered;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnDestinationPort(List<EnvoyServerProtoData.FilterChain> filterChains) {
        ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            if (filterChainMatch.getDestinationPort() != UInt32Value.getDefaultInstance().getValue()) continue;
            filtered.add(filterChain);
        }
        return filtered;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnSourcePort(List<EnvoyServerProtoData.FilterChain> filterChains, int sourcePort) {
        ArrayList<EnvoyServerProtoData.FilterChain> filteredOnMatch = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        ArrayList<EnvoyServerProtoData.FilterChain> filteredOnEmpty = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            List<Integer> sourcePortsToMatch = filterChainMatch.getSourcePorts();
            if (sourcePortsToMatch.isEmpty()) {
                filteredOnEmpty.add(filterChain);
                continue;
            }
            if (!sourcePortsToMatch.contains(sourcePort)) continue;
            filteredOnMatch.add(filterChain);
        }
        return filteredOnMatch.isEmpty() ? filteredOnEmpty : filteredOnMatch;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnSourceType(List<EnvoyServerProtoData.FilterChain> filterChains, InetAddress sourceAddress, InetAddress destAddress) {
        ArrayList<EnvoyServerProtoData.FilterChain> filtered = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            EnvoyServerProtoData.FilterChainMatch filterChainMatch = filterChain.getFilterChainMatch();
            EnvoyServerProtoData.ConnectionSourceType sourceType = filterChainMatch.getConnectionSourceType();
            boolean matching = false;
            matching = sourceType == EnvoyServerProtoData.ConnectionSourceType.SAME_IP_OR_LOOPBACK ? sourceAddress.isLoopbackAddress() || sourceAddress.isAnyLocalAddress() || sourceAddress.equals(destAddress) : (sourceType == EnvoyServerProtoData.ConnectionSourceType.EXTERNAL ? !sourceAddress.isLoopbackAddress() && !sourceAddress.isAnyLocalAddress() : true);
            if (!matching) continue;
            filtered.add(filterChain);
        }
        return filtered;
    }

    private static int getMatchingPrefixLength(EnvoyServerProtoData.FilterChainMatch filterChainMatch, InetAddress address, boolean forDestination) {
        int matchingPrefixLength;
        List<EnvoyServerProtoData.CidrRange> cidrRanges;
        boolean isIPv6 = address instanceof Inet6Address;
        List<EnvoyServerProtoData.CidrRange> list = cidrRanges = forDestination ? filterChainMatch.getPrefixRanges() : filterChainMatch.getSourcePrefixRanges();
        if (cidrRanges.isEmpty()) {
            matchingPrefixLength = 0;
        } else {
            matchingPrefixLength = -1;
            for (EnvoyServerProtoData.CidrRange cidrRange : cidrRanges) {
                int prefixLen;
                Matchers.CidrMatcher matcher;
                InetAddress cidrAddr = cidrRange.getAddressPrefix();
                boolean cidrIsIpv6 = cidrAddr instanceof Inet6Address;
                if (isIPv6 != cidrIsIpv6 || !(matcher = Matchers.CidrMatcher.create(cidrAddr, prefixLen = cidrRange.getPrefixLen())).matches(address) || prefixLen <= matchingPrefixLength) continue;
                matchingPrefixLength = prefixLen;
            }
        }
        return matchingPrefixLength;
    }

    private static List<EnvoyServerProtoData.FilterChain> filterOnIpAddress(List<EnvoyServerProtoData.FilterChain> filterChains, InetAddress address, boolean forDestination) {
        ArrayList<EnvoyServerProtoData.FilterChain> topOnes = new ArrayList<EnvoyServerProtoData.FilterChain>(filterChains.size());
        int topMatchingPrefixLen = -1;
        for (EnvoyServerProtoData.FilterChain filterChain : filterChains) {
            int currentMatchingPrefixLen = XdsClientWrapperForServerSds.getMatchingPrefixLength(filterChain.getFilterChainMatch(), address, forDestination);
            if (currentMatchingPrefixLen < 0 || currentMatchingPrefixLen < topMatchingPrefixLen) continue;
            if (currentMatchingPrefixLen > topMatchingPrefixLen) {
                topMatchingPrefixLen = currentMatchingPrefixLen;
                topOnes.clear();
            }
            topOnes.add(filterChain);
        }
        return topOnes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerWatcher(ServerWatcher serverWatcher) {
        Preconditions.checkNotNull((Object)serverWatcher, (Object)"serverWatcher");
        Set<ServerWatcher> set = this.serverWatchers;
        synchronized (set) {
            this.serverWatchers.add(serverWatcher);
        }
        EnvoyServerProtoData.Listener copyListener = this.curListener.get();
        if (copyListener != null) {
            serverWatcher.onListenerUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerWatcher(ServerWatcher serverWatcher) {
        Preconditions.checkNotNull((Object)serverWatcher, (Object)"serverWatcher");
        Set<ServerWatcher> set = this.serverWatchers;
        synchronized (set) {
            this.serverWatchers.remove(serverWatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ServerWatcher> getServerWatchers() {
        Set<ServerWatcher> set = this.serverWatchers;
        synchronized (set) {
            return ImmutableSet.copyOf(this.serverWatchers);
        }
    }

    private void reportError(Throwable throwable, boolean isAbsent) {
        for (ServerWatcher watcher : this.getServerWatchers()) {
            watcher.onError(throwable, isAbsent);
        }
    }

    private void reportSuccess() {
        for (ServerWatcher watcher : this.getServerWatchers()) {
            watcher.onListenerUpdate();
        }
    }

    @VisibleForTesting
    public XdsClient.LdsResourceWatcher getListenerWatcher() {
        return this.listenerWatcher;
    }

    public void shutdown() {
        logger.log(Level.FINER, "Shutdown");
        if (this.xdsClient != null) {
            this.xdsClient.cancelLdsResourceWatch(this.grpcServerResourceId, this.listenerWatcher);
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
        this.releaseOldSuppliers(this.curListener.getAndSet(null));
    }

    public static interface ServerWatcher {
        public void onError(Throwable var1, boolean var2);

        public void onListenerUpdate();
    }
}

