/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.InternalConfigSelector;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.Filter;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.LameFilter;
import io.grpc.xds.RouterFilter;
import io.grpc.xds.SharedCallCounterMap;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.XxHash64;
import io.grpc.xds.internal.Matchers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

final class XdsNameResolver
extends NameResolver {
    static final CallOptions.Key<String> CLUSTER_SELECTION_KEY = CallOptions.Key.create((String)"io.grpc.xds.CLUSTER_SELECTION_KEY");
    static final CallOptions.Key<Long> RPC_HASH_KEY = CallOptions.Key.create((String)"io.grpc.xds.RPC_HASH_KEY");
    private static final Filter.NamedFilterConfig LAME_FILTER = new Filter.NamedFilterConfig(null, LameFilter.LAME_CONFIG);
    @VisibleForTesting
    static boolean enableTimeout = Strings.isNullOrEmpty((String)System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_TIMEOUT")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_TIMEOUT"));
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final String authority;
    private final NameResolver.ServiceConfigParser serviceConfigParser;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService scheduler;
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;
    private final ThreadSafeRandom random;
    private final FilterRegistry filterRegistry;
    private final XxHash64 hashFunc = XxHash64.INSTANCE;
    private final ConcurrentMap<String, AtomicInteger> clusterRefs = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConfigSelector configSelector = new ConfigSelector();
    private volatile RoutingConfig routingConfig = RoutingConfig.access$100();
    private NameResolver.Listener2 listener;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private XdsNameResolverProvider.CallCounterProvider callCounterProvider;
    private ResolveState resolveState;

    XdsNameResolver(String name, NameResolver.ServiceConfigParser serviceConfigParser, SynchronizationContext syncContext, ScheduledExecutorService scheduler) {
        this(name, serviceConfigParser, syncContext, scheduler, SharedXdsClientPoolProvider.getDefaultProvider(), ThreadSafeRandom.ThreadSafeRandomImpl.instance, FilterRegistry.getDefaultRegistry());
    }

    @VisibleForTesting
    XdsNameResolver(String name, NameResolver.ServiceConfigParser serviceConfigParser, SynchronizationContext syncContext, ScheduledExecutorService scheduler, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory, ThreadSafeRandom random, FilterRegistry filterRegistry) {
        this.authority = GrpcUtil.checkAuthority((String)((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
        this.serviceConfigParser = (NameResolver.ServiceConfigParser)Preconditions.checkNotNull((Object)serviceConfigParser, (Object)"serviceConfigParser");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolFactory");
        this.random = (ThreadSafeRandom)Preconditions.checkNotNull((Object)random, (Object)"random");
        this.filterRegistry = (FilterRegistry)Preconditions.checkNotNull((Object)filterRegistry, (Object)"filterRegistry");
        this.logId = InternalLogId.allocate((String)"xds-resolver", (String)name);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created resolver for {0}", name);
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(NameResolver.Listener2 listener) {
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        try {
            this.xdsClientPool = this.xdsClientPoolFactory.getOrCreate();
        }
        catch (Exception e) {
            listener.onError(Status.UNAVAILABLE.withDescription("Failed to initialize xDS").withCause((Throwable)e));
            return;
        }
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        this.callCounterProvider = SharedCallCounterMap.getInstance();
        this.resolveState = new ResolveState();
        this.resolveState.start();
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.resolveState != null) {
            this.resolveState.stop();
        }
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    @VisibleForTesting
    static Map<String, ?> generateServiceConfigWithMethodConfig(@Nullable Long timeoutNano, @Nullable VirtualHost.Route.RouteAction.RetryPolicy retryPolicy) {
        if (timeoutNano == null && (retryPolicy == null || retryPolicy.retryableStatusCodes().isEmpty())) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder methodConfig = ImmutableMap.builder();
        methodConfig.put((Object)"name", Collections.singletonList(Collections.emptyMap()));
        if (retryPolicy != null && !retryPolicy.retryableStatusCodes().isEmpty()) {
            ImmutableMap.Builder rawRetryPolicy = ImmutableMap.builder();
            rawRetryPolicy.put((Object)"maxAttempts", (Object)retryPolicy.maxAttempts());
            rawRetryPolicy.put((Object)"initialBackoff", (Object)Durations.toString((Duration)retryPolicy.initialBackoff()));
            rawRetryPolicy.put((Object)"maxBackoff", (Object)Durations.toString((Duration)retryPolicy.maxBackoff()));
            rawRetryPolicy.put((Object)"backoffMultiplier", (Object)2.0);
            ArrayList<String> codes = new ArrayList<String>(retryPolicy.retryableStatusCodes().size());
            for (Status.Code code : retryPolicy.retryableStatusCodes()) {
                codes.add(code.name());
            }
            rawRetryPolicy.put((Object)"retryableStatusCodes", Collections.unmodifiableList(codes));
            if (retryPolicy.perAttemptRecvTimeout() != null) {
                rawRetryPolicy.put((Object)"perAttemptRecvTimeout", (Object)Durations.toString((Duration)retryPolicy.perAttemptRecvTimeout()));
            }
            methodConfig.put((Object)"retryPolicy", (Object)rawRetryPolicy.build());
        }
        if (timeoutNano != null) {
            String timeout = (double)timeoutNano.longValue() / 1.0E9 + "s";
            methodConfig.put((Object)"timeout", (Object)timeout);
        }
        return Collections.singletonMap("methodConfig", Collections.singletonList(methodConfig.build()));
    }

    @VisibleForTesting
    static Map<String, ?> generateServiceConfigWithLoadBalancingConfig(Collection<String> clusters) {
        HashMap<String, Map<String, List<Map<String, Map<String, String>>>>> childPolicy = new HashMap<String, Map<String, List<Map<String, Map<String, String>>>>>();
        for (String cluster : clusters) {
            List<Map<String, Map<String, String>>> lbPolicy = Collections.singletonList(Collections.singletonMap("cds_experimental", Collections.singletonMap("cluster", cluster)));
            childPolicy.put(cluster, Collections.singletonMap("lbPolicy", lbPolicy));
        }
        return Collections.singletonMap("loadBalancingConfig", Collections.singletonList(Collections.singletonMap("cluster_manager_experimental", Collections.singletonMap("childPolicy", Collections.unmodifiableMap(childPolicy)))));
    }

    @VisibleForTesting
    XdsClient getXdsClient() {
        return this.xdsClient;
    }

    private void updateResolutionResult() {
        Map<String, ?> rawServiceConfig = XdsNameResolver.generateServiceConfigWithLoadBalancingConfig(this.clusterRefs.keySet());
        if (this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Generated service config:\n{0}", new Gson().toJson(rawServiceConfig));
        }
        NameResolver.ConfigOrError parsedServiceConfig = this.serviceConfigParser.parseServiceConfig(rawServiceConfig);
        Attributes attrs = Attributes.newBuilder().set(InternalXdsAttributes.XDS_CLIENT_POOL, this.xdsClientPool).set(InternalXdsAttributes.CALL_COUNTER_PROVIDER, (Object)this.callCounterProvider).set(InternalConfigSelector.KEY, (Object)this.configSelector).build();
        NameResolver.ResolutionResult result = NameResolver.ResolutionResult.newBuilder().setAttributes(attrs).setServiceConfig(parsedServiceConfig).build();
        this.listener.onResult(result);
    }

    @Nullable
    @VisibleForTesting
    static VirtualHost findVirtualHostForHostName(List<VirtualHost> virtualHosts, String hostName) {
        int matchingLen = -1;
        boolean exactMatchFound = false;
        VirtualHost targetVirtualHost = null;
        for (VirtualHost vHost : virtualHosts) {
            for (String domain : vHost.domains()) {
                boolean selected = false;
                if (XdsNameResolver.matchHostName(hostName, domain)) {
                    if (!domain.contains("*")) {
                        exactMatchFound = true;
                        targetVirtualHost = vHost;
                        break;
                    }
                    if (domain.length() > matchingLen) {
                        selected = true;
                    } else if (domain.length() == matchingLen && domain.startsWith("*")) {
                        selected = true;
                    }
                }
                if (!selected) continue;
                matchingLen = domain.length();
                targetVirtualHost = vHost;
            }
            if (!exactMatchFound) continue;
            break;
        }
        return targetVirtualHost;
    }

    @VisibleForTesting
    static boolean matchHostName(String hostName, String pattern) {
        Preconditions.checkArgument((hostName.length() != 0 && !hostName.startsWith(".") && !hostName.endsWith(".") ? 1 : 0) != 0, (Object)"Invalid host name");
        Preconditions.checkArgument((pattern.length() != 0 && !pattern.startsWith(".") && !pattern.endsWith(".") ? 1 : 0) != 0, (Object)"Invalid pattern/domain name");
        hostName = hostName.toLowerCase(Locale.US);
        pattern = pattern.toLowerCase(Locale.US);
        if (!pattern.contains("*")) {
            return hostName.equals(pattern);
        }
        if (pattern.length() == 1) {
            return true;
        }
        int index = pattern.indexOf(42);
        if (pattern.indexOf(42, index + 1) != -1) {
            return false;
        }
        if (index != 0 && index != pattern.length() - 1) {
            return false;
        }
        if (hostName.length() < pattern.length()) {
            return false;
        }
        if (index == 0 && hostName.endsWith(pattern.substring(1))) {
            return true;
        }
        return index == pattern.length() - 1 && hostName.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    private static ClientInterceptor combineInterceptors(final List<ClientInterceptor> interceptors) {
        Preconditions.checkArgument((!interceptors.isEmpty() ? 1 : 0) != 0, (Object)"empty interceptors");
        if (interceptors.size() == 1) {
            return interceptors.get(0);
        }
        return new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                next = ClientInterceptors.interceptForward((Channel)next, (List)interceptors);
                return next.newCall(method, callOptions);
            }
        };
    }

    @VisibleForTesting
    static boolean matchRoute(VirtualHost.Route.RouteMatch routeMatch, String fullMethodName, Metadata headers, ThreadSafeRandom random) {
        if (!XdsNameResolver.matchPath(routeMatch.pathMatcher(), fullMethodName)) {
            return false;
        }
        for (Matchers.HeaderMatcher headerMatcher : routeMatch.headerMatchers()) {
            if (XdsNameResolver.matchHeader(headerMatcher, XdsNameResolver.getHeaderValue(headers, headerMatcher.name()))) continue;
            return false;
        }
        Matchers.FractionMatcher fraction = routeMatch.fractionMatcher();
        return fraction == null || random.nextInt(fraction.denominator()) < fraction.numerator();
    }

    private static boolean matchPath(VirtualHost.Route.RouteMatch.PathMatcher pathMatcher, String fullMethodName) {
        if (pathMatcher.path() != null) {
            return pathMatcher.caseSensitive() ? pathMatcher.path().equals(fullMethodName) : pathMatcher.path().equalsIgnoreCase(fullMethodName);
        }
        if (pathMatcher.prefix() != null) {
            return pathMatcher.caseSensitive() ? fullMethodName.startsWith(pathMatcher.prefix()) : fullMethodName.toLowerCase().startsWith(pathMatcher.prefix().toLowerCase());
        }
        return pathMatcher.regEx().matches(fullMethodName);
    }

    private static boolean matchHeader(Matchers.HeaderMatcher headerMatcher, @Nullable String value) {
        boolean baseMatch;
        if (headerMatcher.present() != null) {
            return value == null == headerMatcher.present().equals(headerMatcher.inverted());
        }
        if (value == null) {
            return false;
        }
        if (headerMatcher.exactValue() != null) {
            baseMatch = headerMatcher.exactValue().equals(value);
        } else if (headerMatcher.safeRegEx() != null) {
            baseMatch = headerMatcher.safeRegEx().matches(value);
        } else if (headerMatcher.range() != null) {
            try {
                long numValue = Long.parseLong(value);
                baseMatch = numValue >= headerMatcher.range().start() && numValue <= headerMatcher.range().end();
            }
            catch (NumberFormatException ignored) {
                baseMatch = false;
            }
        } else {
            baseMatch = headerMatcher.prefix() != null ? value.startsWith(headerMatcher.prefix()) : value.endsWith(headerMatcher.suffix());
        }
        return baseMatch != headerMatcher.inverted();
    }

    @Nullable
    private static String getHeaderValue(Metadata headers, String headerName) {
        Metadata.Key key;
        if (headerName.endsWith("-bin")) {
            return null;
        }
        if (headerName.equals("content-type")) {
            return "application/grpc";
        }
        try {
            key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Iterable values = headers.getAll(key);
        return values == null ? null : Joiner.on((String)",").join(values);
    }

    private static class RoutingConfig {
        private final long fallbackTimeoutNano;
        final List<VirtualHost.Route> routes;
        @Nullable
        final List<Filter.NamedFilterConfig> filterChain;
        final Map<String, Filter.FilterConfig> virtualHostOverrideConfig;
        private static RoutingConfig empty = new RoutingConfig(0L, Collections.emptyList(), null, Collections.emptyMap());

        private RoutingConfig(long fallbackTimeoutNano, List<VirtualHost.Route> routes, @Nullable List<Filter.NamedFilterConfig> filterChain, Map<String, Filter.FilterConfig> virtualHostOverrideConfig) {
            this.fallbackTimeoutNano = fallbackTimeoutNano;
            this.routes = routes;
            Preconditions.checkArgument((filterChain == null || !filterChain.isEmpty() ? 1 : 0) != 0, (Object)"filterChain is empty");
            this.filterChain = filterChain == null ? null : Collections.unmodifiableList(filterChain);
            this.virtualHostOverrideConfig = Collections.unmodifiableMap(virtualHostOverrideConfig);
        }
    }

    private class ResolveState
    implements XdsClient.LdsResourceWatcher {
        private final NameResolver.ConfigOrError emptyServiceConfig;
        private final NameResolver.ResolutionResult emptyResult;
        private boolean stopped;
        @Nullable
        private Set<String> existingClusters;
        @Nullable
        private RouteDiscoveryState routeDiscoveryState;

        private ResolveState() {
            this.emptyServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(Collections.emptyMap());
            this.emptyResult = NameResolver.ResolutionResult.newBuilder().setServiceConfig(this.emptyServiceConfig).build();
        }

        @Override
        public void onChanged(final XdsClient.LdsUpdate update) {
            XdsNameResolver.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (ResolveState.this.stopped) {
                        return;
                    }
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Receive LDS resource update: {0}", update);
                    HttpConnectionManager httpConnectionManager = update.httpConnectionManager();
                    ImmutableList<VirtualHost> virtualHosts = httpConnectionManager.virtualHosts();
                    String rdsName = httpConnectionManager.rdsName();
                    ResolveState.this.cleanUpRouteDiscoveryState();
                    if (virtualHosts != null) {
                        ResolveState.this.updateRoutes(virtualHosts, httpConnectionManager.httpMaxStreamDurationNano(), httpConnectionManager.httpFilterConfigs());
                    } else {
                        ResolveState.this.routeDiscoveryState = new RouteDiscoveryState(rdsName, httpConnectionManager.httpMaxStreamDurationNano(), (List)httpConnectionManager.httpFilterConfigs());
                        XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching RDS resource {0}", rdsName);
                        XdsNameResolver.this.xdsClient.watchRdsResource(rdsName, ResolveState.this.routeDiscoveryState);
                    }
                }
            });
        }

        @Override
        public void onError(final Status error) {
            XdsNameResolver.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (ResolveState.this.stopped) {
                        return;
                    }
                    XdsNameResolver.this.listener.onError(error);
                }
            });
        }

        @Override
        public void onResourceDoesNotExist(final String resourceName) {
            XdsNameResolver.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (ResolveState.this.stopped) {
                        return;
                    }
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "LDS resource {0} unavailable", resourceName);
                    ResolveState.this.cleanUpRouteDiscoveryState();
                    ResolveState.this.cleanUpRoutes();
                }
            });
        }

        private void start() {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching LDS resource {0}", XdsNameResolver.this.authority);
            XdsNameResolver.this.xdsClient.watchLdsResource(XdsNameResolver.this.authority, this);
        }

        private void stop() {
            XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching LDS resource {0}", XdsNameResolver.this.authority);
            this.stopped = true;
            this.cleanUpRouteDiscoveryState();
            XdsNameResolver.this.xdsClient.cancelLdsResourceWatch(XdsNameResolver.this.authority, this);
        }

        private void updateRoutes(List<VirtualHost> virtualHosts, long httpMaxStreamDurationNano, @Nullable List<Filter.NamedFilterConfig> filterConfigs) {
            VirtualHost virtualHost = XdsNameResolver.findVirtualHostForHostName(virtualHosts, XdsNameResolver.this.authority);
            if (virtualHost == null) {
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed to find virtual host matching hostname {0}", XdsNameResolver.this.authority);
                this.cleanUpRoutes();
                return;
            }
            Object routes = virtualHost.routes();
            ArrayList<Filter.NamedFilterConfig> filterChain = null;
            if (filterConfigs != null) {
                boolean hasRouter = false;
                filterChain = new ArrayList<Filter.NamedFilterConfig>(filterConfigs.size());
                for (Filter.NamedFilterConfig namedFilter : filterConfigs) {
                    filterChain.add(namedFilter);
                    if (!namedFilter.filterConfig.equals(RouterFilter.ROUTER_CONFIG)) continue;
                    hasRouter = true;
                    break;
                }
                if (!hasRouter) {
                    filterChain.add(LAME_FILTER);
                    routes = Collections.emptyList();
                }
            }
            Sets.SetView clusters = new HashSet();
            for (VirtualHost.Route route : routes) {
                VirtualHost.Route.RouteAction action = route.routeAction();
                if (action == null) continue;
                if (action.cluster() != null) {
                    clusters.add(action.cluster());
                    continue;
                }
                if (action.weightedClusters() == null) continue;
                for (VirtualHost.Route.RouteAction.ClusterWeight weighedCluster : action.weightedClusters()) {
                    clusters.add(weighedCluster.name());
                }
            }
            boolean shouldUpdateResult = this.existingClusters == null;
            Sets.SetView addedClusters = this.existingClusters == null ? clusters : Sets.difference(clusters, this.existingClusters);
            Sets.SetView deletedClusters = this.existingClusters == null ? Collections.emptySet() : Sets.difference(this.existingClusters, (Set)clusters);
            this.existingClusters = clusters;
            for (String cluster : addedClusters) {
                if (XdsNameResolver.this.clusterRefs.containsKey(cluster)) {
                    ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).incrementAndGet();
                    continue;
                }
                XdsNameResolver.this.clusterRefs.put(cluster, new AtomicInteger(1));
                shouldUpdateResult = true;
            }
            if (shouldUpdateResult) {
                XdsNameResolver.this.updateResolutionResult();
            }
            XdsNameResolver.this.routingConfig = new RoutingConfig(httpMaxStreamDurationNano, (List)routes, filterChain, (Map)virtualHost.filterConfigOverrides());
            shouldUpdateResult = false;
            for (String cluster : deletedClusters) {
                int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
                if (count != 0) continue;
                XdsNameResolver.this.clusterRefs.remove(cluster);
                shouldUpdateResult = true;
            }
            if (shouldUpdateResult) {
                XdsNameResolver.this.updateResolutionResult();
            }
        }

        private void cleanUpRoutes() {
            if (this.existingClusters != null) {
                for (String cluster : this.existingClusters) {
                    int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
                    if (count != 0) continue;
                    XdsNameResolver.this.clusterRefs.remove(cluster);
                }
                this.existingClusters = null;
            }
            XdsNameResolver.this.routingConfig = RoutingConfig.empty;
            XdsNameResolver.this.listener.onResult(this.emptyResult);
        }

        private void cleanUpRouteDiscoveryState() {
            if (this.routeDiscoveryState != null) {
                String rdsName = this.routeDiscoveryState.resourceName;
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching RDS resource {0}", rdsName);
                XdsNameResolver.this.xdsClient.cancelRdsResourceWatch(rdsName, this.routeDiscoveryState);
                this.routeDiscoveryState = null;
            }
        }

        private class RouteDiscoveryState
        implements XdsClient.RdsResourceWatcher {
            private final String resourceName;
            private final long httpMaxStreamDurationNano;
            @Nullable
            private final List<Filter.NamedFilterConfig> filterConfigs;

            private RouteDiscoveryState(String resourceName, @Nullable long httpMaxStreamDurationNano, List<Filter.NamedFilterConfig> filterConfigs) {
                this.resourceName = resourceName;
                this.httpMaxStreamDurationNano = httpMaxStreamDurationNano;
                this.filterConfigs = filterConfigs;
            }

            @Override
            public void onChanged(final XdsClient.RdsUpdate update) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (RouteDiscoveryState.this != ResolveState.this.routeDiscoveryState) {
                            return;
                        }
                        XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received RDS resource update: {0}", update);
                        ResolveState.this.updateRoutes(update.virtualHosts, RouteDiscoveryState.this.httpMaxStreamDurationNano, RouteDiscoveryState.this.filterConfigs);
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (RouteDiscoveryState.this != ResolveState.this.routeDiscoveryState) {
                            return;
                        }
                        XdsNameResolver.this.listener.onError(error);
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (RouteDiscoveryState.this != ResolveState.this.routeDiscoveryState) {
                            return;
                        }
                        XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "RDS resource {0} unavailable", resourceName);
                        ResolveState.this.cleanUpRoutes();
                    }
                });
            }
        }
    }

    private final class ConfigSelector
    extends InternalConfigSelector {
        private ConfigSelector() {
        }

        public InternalConfigSelector.Result selectConfig(LoadBalancer.PickSubchannelArgs args) {
            HashMap<String, Filter.FilterConfig> selectedOverrideConfigs;
            RoutingConfig routingCfg;
            String cluster = null;
            VirtualHost.Route selectedRoute = null;
            ArrayList<ClientInterceptor> filterInterceptors = new ArrayList<ClientInterceptor>();
            Metadata headers = args.getHeaders();
            block0: do {
                routingCfg = XdsNameResolver.this.routingConfig;
                selectedOverrideConfigs = new HashMap<String, Filter.FilterConfig>(routingCfg.virtualHostOverrideConfig);
                if (routingCfg.filterChain != null && ((Filter.NamedFilterConfig)Iterables.getLast(routingCfg.filterChain)).equals(LAME_FILTER)) break;
                for (VirtualHost.Route route : routingCfg.routes) {
                    if (!XdsNameResolver.matchRoute(route.routeMatch(), "/" + args.getMethodDescriptor().getFullMethodName(), headers, XdsNameResolver.this.random)) continue;
                    selectedRoute = route;
                    selectedOverrideConfigs.putAll((Map<String, Filter.FilterConfig>)route.filterConfigOverrides());
                    break;
                }
                if (selectedRoute == null) {
                    return InternalConfigSelector.Result.forError((Status)Status.UNAVAILABLE.withDescription("Could not find xDS route matching RPC"));
                }
                if (selectedRoute.routeAction() == null) {
                    return InternalConfigSelector.Result.forError((Status)Status.UNAVAILABLE.withDescription("Could not route RPC to Route with non-forwarding action"));
                }
                VirtualHost.Route.RouteAction action = selectedRoute.routeAction();
                if (action.cluster() != null) {
                    cluster = action.cluster();
                    continue;
                }
                if (action.weightedClusters() == null) continue;
                int totalWeight = 0;
                for (VirtualHost.Route.RouteAction.ClusterWeight weightedCluster : action.weightedClusters()) {
                    totalWeight += weightedCluster.weight();
                }
                int select = XdsNameResolver.this.random.nextInt(totalWeight);
                int accumulator = 0;
                for (Object weightedCluster : action.weightedClusters()) {
                    if (select >= (accumulator += ((VirtualHost.Route.RouteAction.ClusterWeight)weightedCluster).weight())) continue;
                    cluster = ((VirtualHost.Route.RouteAction.ClusterWeight)weightedCluster).name();
                    selectedOverrideConfigs.putAll((Map<String, Filter.FilterConfig>)((VirtualHost.Route.RouteAction.ClusterWeight)weightedCluster).filterConfigOverrides());
                    continue block0;
                }
            } while (!this.retainCluster(cluster));
            Long timeoutNanos = null;
            if (enableTimeout) {
                if (selectedRoute != null) {
                    timeoutNanos = selectedRoute.routeAction().timeoutNano();
                }
                if (timeoutNanos == null) {
                    timeoutNanos = routingCfg.fallbackTimeoutNano;
                }
                if (timeoutNanos <= 0L) {
                    timeoutNanos = null;
                }
            }
            VirtualHost.Route.RouteAction.RetryPolicy retryPolicy = selectedRoute == null ? null : selectedRoute.routeAction().retryPolicy();
            Map<String, ?> rawServiceConfig = XdsNameResolver.generateServiceConfigWithMethodConfig(timeoutNanos, retryPolicy);
            NameResolver.ConfigOrError parsedServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(rawServiceConfig);
            Object config = parsedServiceConfig.getConfig();
            if (config == null) {
                this.releaseCluster(cluster);
                return InternalConfigSelector.Result.forError((Status)parsedServiceConfig.getError().augmentDescription("Failed to parse service config (method config)"));
            }
            if (routingCfg.filterChain != null) {
                for (Filter.NamedFilterConfig namedFilter : routingCfg.filterChain) {
                    ClientInterceptor interceptor;
                    Filter.FilterConfig filterConfig = namedFilter.filterConfig;
                    Filter filter = namedFilter.equals(LAME_FILTER) ? LameFilter.INSTANCE : XdsNameResolver.this.filterRegistry.get(filterConfig.typeUrl());
                    if (!(filter instanceof Filter.ClientInterceptorBuilder) || (interceptor = ((Filter.ClientInterceptorBuilder)((Object)filter)).buildClientInterceptor(filterConfig, (Filter.FilterConfig)selectedOverrideConfigs.get(namedFilter.name), args, XdsNameResolver.this.scheduler)) == null) continue;
                    filterInterceptors.add(interceptor);
                }
                if (((Filter.NamedFilterConfig)Iterables.getLast(routingCfg.filterChain)).equals(LAME_FILTER)) {
                    return InternalConfigSelector.Result.newBuilder().setConfig(config).setInterceptor(XdsNameResolver.combineInterceptors(filterInterceptors)).build();
                }
            }
            final String finalCluster = cluster;
            final long hash = this.generateHash((List<VirtualHost.Route.RouteAction.HashPolicy>)selectedRoute.routeAction().hashPolicies(), headers);
            class ClusterSelectionInterceptor
            implements ClientInterceptor {
                ClusterSelectionInterceptor() {
                }

                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    CallOptions callOptionsForCluster = callOptions.withOption(CLUSTER_SELECTION_KEY, (Object)finalCluster).withOption(RPC_HASH_KEY, (Object)hash);
                    return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptionsForCluster)){

                        public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                            listener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>((ClientCall.Listener)listener){
                                boolean committed;

                                public void onHeaders(Metadata headers) {
                                    this.committed = true;
                                    ConfigSelector.this.releaseCluster(finalCluster);
                                    this.delegate().onHeaders(headers);
                                }

                                public void onClose(Status status, Metadata trailers) {
                                    if (!this.committed) {
                                        ConfigSelector.this.releaseCluster(finalCluster);
                                    }
                                    this.delegate().onClose(status, trailers);
                                }
                            };
                            this.delegate().start(listener, headers);
                        }
                    };
                }
            }
            filterInterceptors.add(new ClusterSelectionInterceptor());
            return InternalConfigSelector.Result.newBuilder().setConfig(config).setInterceptor(XdsNameResolver.combineInterceptors(filterInterceptors)).build();
        }

        private boolean retainCluster(String cluster) {
            int count;
            AtomicInteger refCount = (AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster);
            if (refCount == null) {
                return false;
            }
            do {
                if ((count = refCount.get()) != 0) continue;
                return false;
            } while (!refCount.compareAndSet(count, count + 1));
            return true;
        }

        private void releaseCluster(final String cluster) {
            int count = ((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).decrementAndGet();
            if (count == 0) {
                XdsNameResolver.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (((AtomicInteger)XdsNameResolver.this.clusterRefs.get(cluster)).get() == 0) {
                            XdsNameResolver.this.clusterRefs.remove(cluster);
                            XdsNameResolver.this.updateResolutionResult();
                        }
                    }
                });
            }
        }

        private long generateHash(List<VirtualHost.Route.RouteAction.HashPolicy> hashPolicies, Metadata headers) {
            Long hash = null;
            for (VirtualHost.Route.RouteAction.HashPolicy policy : hashPolicies) {
                Long newHash = null;
                if (policy.type() == VirtualHost.Route.RouteAction.HashPolicy.Type.HEADER) {
                    String value = XdsNameResolver.getHeaderValue(headers, policy.headerName());
                    if (value != null) {
                        if (policy.regEx() != null && policy.regExSubstitution() != null) {
                            value = policy.regEx().matcher((CharSequence)value).replaceAll(policy.regExSubstitution());
                        }
                        newHash = XdsNameResolver.this.hashFunc.hashAsciiString(value);
                    }
                } else if (policy.type() == VirtualHost.Route.RouteAction.HashPolicy.Type.CHANNEL_ID) {
                    newHash = XdsNameResolver.this.hashFunc.hashLong(XdsNameResolver.this.logId.getId());
                }
                if (newHash != null) {
                    long oldHash = hash != null ? hash << 1 | hash >> 63 : 0L;
                    hash = oldHash ^ newHash;
                }
                if (!policy.isTerminal() || hash == null) continue;
                break;
            }
            return hash == null ? XdsNameResolver.this.random.nextLong() : hash.longValue();
        }
    }
}

