/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsNameResolver;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

@Internal
public final class XdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "xds";

    public XdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new XdsNameResolver(name, args.getServiceConfigParser(), args.getSynchronizationContext(), args.getScheduledExecutorService());
        }
        return null;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 4;
    }

    static interface CallCounterProvider {
        public AtomicLong getOrCreate(String var1, @Nullable String var2);
    }

    static interface XdsClientPoolFactory {
        public void setBootstrapOverride(Map<String, ?> var1);

        @Nullable
        public ObjectPool<XdsClient> get();

        public ObjectPool<XdsClient> getOrCreate() throws XdsInitializationException;
    }
}

