/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.Attributes;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerBuilder;
import io.grpc.Internal;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.xds.XdsClientWrapperForServerSds;
import io.grpc.xds.internal.sds.SdsProtocolNegotiators;
import io.grpc.xds.internal.sds.ServerWrapperForXds;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7514")
public final class XdsServerBuilder
extends ForwardingServerBuilder<XdsServerBuilder> {
    private final NettyServerBuilder delegate;
    private final int port;
    private XdsServingStatusListener xdsServingStatusListener;
    private AtomicBoolean isServerBuilt = new AtomicBoolean(false);

    private XdsServerBuilder(NettyServerBuilder nettyDelegate, int port) {
        this.delegate = nettyDelegate;
        this.port = port;
        this.xdsServingStatusListener = new DefaultListener("port:" + port);
    }

    @Internal
    protected ServerBuilder<?> delegate() {
        Preconditions.checkState((!this.isServerBuilt.get() ? 1 : 0) != 0, (Object)"Server already built!");
        return this.delegate;
    }

    public XdsServerBuilder xdsServingStatusListener(XdsServingStatusListener xdsServingStatusListener) {
        this.xdsServingStatusListener = (XdsServingStatusListener)Preconditions.checkNotNull((Object)xdsServingStatusListener, (Object)"xdsServingStatusListener");
        return this;
    }

    @DoNotCall(value="Unsupported. Use forPort(int, ServerCredentials) instead")
    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Unsupported call - use forPort(int, ServerCredentials)");
    }

    public static XdsServerBuilder forPort(int port, ServerCredentials serverCredentials) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forPort((int)port, (ServerCredentials)serverCredentials);
        return new XdsServerBuilder(nettyDelegate, port);
    }

    public Server build() {
        return this.buildServer(new XdsClientWrapperForServerSds(this.port));
    }

    @VisibleForTesting
    ServerWrapperForXds buildServer(XdsClientWrapperForServerSds xdsClient) {
        Preconditions.checkState((boolean)this.isServerBuilt.compareAndSet(false, true), (Object)"Server already built!");
        InternalNettyServerBuilder.eagAttributes((NettyServerBuilder)this.delegate, (Attributes)Attributes.newBuilder().set(SdsProtocolNegotiators.SERVER_XDS_CLIENT, (Object)xdsClient).build());
        return new ServerWrapperForXds((ServerBuilder<?>)this.delegate, xdsClient, this.xdsServingStatusListener);
    }

    public ServerBuilder<?> transportBuilder() {
        return this.delegate;
    }

    private static class DefaultListener
    implements XdsServingStatusListener {
        private final Logger logger = Logger.getLogger(DefaultListener.class.getName());
        private final String prefix;
        boolean notServing;

        DefaultListener(String prefix) {
            this.prefix = prefix;
            this.notServing = true;
        }

        @Override
        public void onServing() {
            if (this.notServing) {
                this.notServing = false;
                this.logger.warning("[" + this.prefix + "] Entering serving state.");
            }
        }

        @Override
        public void onNotServing(Throwable throwable) {
            this.logger.warning("[" + this.prefix + "] " + throwable.getMessage());
            this.notServing = true;
        }
    }

    public static interface XdsServingStatusListener {
        public void onServing();

        public void onNotServing(Throwable var1);
    }
}

