/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.certprovider.CertProviderSslContextProvider;
import io.grpc.xds.internal.certprovider.CertificateProviderStore;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;

@Internal
public final class CertProviderServerSslContextProvider
extends CertProviderSslContextProvider {
    private CertProviderServerSslContextProvider(Node node, Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, (CommonTlsContext.CertificateProviderInstance)Preconditions.checkNotNull((Object)certInstance, (Object)"Server SSL requires certInstance"), rootCertInstance, staticCertValidationContext, downstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final SslContextBuilder getSslContextBuilder(CertificateValidationContext certificateValidationContextdationContext) throws CertStoreException, CertificateException, IOException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.savedKey, (Iterable)this.savedCertChain);
        this.setClientAuthValues(sslContextBuilder, this.isMtls() ? new SdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContextdationContext) : null);
        sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
        return sslContextBuilder;
    }

    @Internal
    public static final class Factory {
        private static final Factory DEFAULT_INSTANCE = new Factory(CertificateProviderStore.getInstance());
        private final CertificateProviderStore certificateProviderStore;

        @VisibleForTesting
        public Factory(CertificateProviderStore certificateProviderStore) {
            this.certificateProviderStore = certificateProviderStore;
        }

        public static Factory getInstance() {
            return DEFAULT_INSTANCE;
        }

        public CertProviderServerSslContextProvider getProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, Node node, Map<String, Bootstrapper.CertificateProviderInfo> certProviders) {
            Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
            CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
            CommonTlsContext.CertificateProviderInstance rootCertInstance = null;
            CertificateValidationContext staticCertValidationContext = null;
            if (commonTlsContext.hasCombinedValidationContext()) {
                CommonTlsContext.CombinedCertificateValidationContext combinedValidationContext = commonTlsContext.getCombinedValidationContext();
                if (combinedValidationContext.hasValidationContextCertificateProviderInstance()) {
                    rootCertInstance = combinedValidationContext.getValidationContextCertificateProviderInstance();
                }
                if (combinedValidationContext.hasDefaultValidationContext()) {
                    staticCertValidationContext = combinedValidationContext.getDefaultValidationContext();
                }
            } else if (commonTlsContext.hasValidationContextCertificateProviderInstance()) {
                rootCertInstance = commonTlsContext.getValidationContextCertificateProviderInstance();
            } else if (commonTlsContext.hasValidationContext()) {
                staticCertValidationContext = commonTlsContext.getValidationContext();
            }
            CommonTlsContext.CertificateProviderInstance certInstance = null;
            if (commonTlsContext.hasTlsCertificateCertificateProviderInstance()) {
                certInstance = commonTlsContext.getTlsCertificateCertificateProviderInstance();
            }
            return new CertProviderServerSslContextProvider(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, downstreamTlsContext, this.certificateProviderStore);
        }
    }
}

