/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.Internal;
import io.grpc.InternalLogId;
import io.grpc.TlsChannelCredentials;
import io.grpc.alts.GoogleDefaultChannelCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonParser;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.Locality;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public class BootstrapperImpl
extends Bootstrapper {
    private static final String BOOTSTRAP_PATH_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP";
    @VisibleForTesting
    static String bootstrapPathFromEnvVar = System.getenv("GRPC_XDS_BOOTSTRAP");
    private static final String BOOTSTRAP_PATH_SYS_PROPERTY = "io.grpc.xds.bootstrap";
    @VisibleForTesting
    static String bootstrapPathFromSysProp = System.getProperty("io.grpc.xds.bootstrap");
    private static final String BOOTSTRAP_CONFIG_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP_CONFIG";
    @VisibleForTesting
    static String bootstrapConfigFromEnvVar = System.getenv("GRPC_XDS_BOOTSTRAP_CONFIG");
    private static final String BOOTSTRAP_CONFIG_SYS_PROPERTY = "io.grpc.xds.bootstrapConfig";
    @VisibleForTesting
    static String bootstrapConfigFromSysProp = System.getProperty("io.grpc.xds.bootstrapConfig");
    private static final String XDS_V3_SERVER_FEATURE = "xds_v3";
    @VisibleForTesting
    static final String CLIENT_FEATURE_DISABLE_OVERPROVISIONING = "envoy.lb.does_not_support_overprovisioning";
    private final XdsLogger logger;
    private FileReader reader = LocalFileReader.INSTANCE;

    public BootstrapperImpl() {
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"bootstrapper", null));
    }

    @Override
    public Bootstrapper.BootstrapInfo bootstrap() throws XdsInitializationException {
        Map rawBootstrap;
        String fileContent;
        String filePath;
        String string = filePath = bootstrapPathFromEnvVar != null ? bootstrapPathFromEnvVar : bootstrapPathFromSysProp;
        if (filePath != null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap file from {0}", filePath);
            try {
                fileContent = this.reader.readFile(filePath);
            }
            catch (IOException e) {
                throw new XdsInitializationException("Fail to read bootstrap file", e);
            }
        } else {
            String string2 = fileContent = bootstrapConfigFromEnvVar != null ? bootstrapConfigFromEnvVar : bootstrapConfigFromSysProp;
        }
        if (fileContent == null) {
            throw new XdsInitializationException("Cannot find bootstrap configuration\nEnvironment variables searched:\n- GRPC_XDS_BOOTSTRAP\n- GRPC_XDS_BOOTSTRAP_CONFIG\n\nJava System Properties searched:\n- io.grpc.xds.bootstrap\n- io.grpc.xds.bootstrapConfig\n\n");
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap from " + filePath);
        try {
            rawBootstrap = (Map)JsonParser.parse((String)fileContent);
        }
        catch (IOException e) {
            throw new XdsInitializationException("Failed to parse JSON", e);
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Bootstrap configuration:\n{0}", rawBootstrap);
        return this.bootstrap(rawBootstrap);
    }

    @Override
    Bootstrapper.BootstrapInfo bootstrap(Map<String, ?> rawData) throws XdsInitializationException {
        ArrayList<Bootstrapper.ServerInfo> servers = new ArrayList<Bootstrapper.ServerInfo>();
        List rawServerConfigs = JsonUtil.getList(rawData, (String)"xds_servers");
        if (rawServerConfigs == null) {
            throw new XdsInitializationException("Invalid bootstrap: 'xds_servers' does not exist.");
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} xDS servers", rawServerConfigs.size());
        List serverConfigList = JsonUtil.checkObjectList((List)rawServerConfigs);
        for (Map serverConfig : serverConfigList) {
            String serverUri = JsonUtil.getString((Map)serverConfig, (String)"server_uri");
            if (serverUri == null) {
                throw new XdsInitializationException("Invalid bootstrap: missing 'server_uri'");
            }
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "xDS server URI: {0}", serverUri);
            List rawChannelCredsList = JsonUtil.getList((Map)serverConfig, (String)"channel_creds");
            if (rawChannelCredsList == null || rawChannelCredsList.isEmpty()) {
                throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " 'channel_creds' required");
            }
            ChannelCredentials channelCredentials = BootstrapperImpl.parseChannelCredentials(JsonUtil.checkObjectList((List)rawChannelCredsList), serverUri);
            if (channelCredentials == null) {
                throw new XdsInitializationException("Server " + serverUri + ": no supported channel credentials found");
            }
            boolean useProtocolV3 = false;
            List serverFeatures = JsonUtil.getListOfStrings((Map)serverConfig, (String)"server_features");
            if (serverFeatures != null) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Server features: {0}", serverFeatures);
                useProtocolV3 = serverFeatures.contains(XDS_V3_SERVER_FEATURE);
            }
            servers.add(new Bootstrapper.ServerInfo(serverUri, channelCredentials, useProtocolV3));
        }
        EnvoyProtoData.Node.Builder nodeBuilder = EnvoyProtoData.Node.newBuilder();
        Map rawNode = JsonUtil.getObject(rawData, (String)"node");
        if (rawNode != null) {
            Map rawLocality;
            Map metadata;
            String cluster;
            String id = JsonUtil.getString((Map)rawNode, (String)"id");
            if (id != null) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Node id: {0}", id);
                nodeBuilder.setId(id);
            }
            if ((cluster = JsonUtil.getString((Map)rawNode, (String)"cluster")) != null) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Node cluster: {0}", cluster);
                nodeBuilder.setCluster(cluster);
            }
            if ((metadata = JsonUtil.getObject((Map)rawNode, (String)"metadata")) != null) {
                nodeBuilder.setMetadata(metadata);
            }
            if ((rawLocality = JsonUtil.getObject((Map)rawNode, (String)"locality")) != null) {
                String region = "";
                String zone = "";
                String subZone = "";
                if (rawLocality.containsKey("region")) {
                    region = JsonUtil.getString((Map)rawLocality, (String)"region");
                }
                if (rawLocality.containsKey("zone")) {
                    zone = JsonUtil.getString((Map)rawLocality, (String)"zone");
                }
                if (rawLocality.containsKey("sub_zone")) {
                    subZone = JsonUtil.getString((Map)rawLocality, (String)"sub_zone");
                }
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Locality region: {0}, zone: {0}, subZone: {0}", region, zone, subZone);
                Locality locality = Locality.create(region, zone, subZone);
                nodeBuilder.setLocality(locality);
            }
        }
        GrpcUtil.GrpcBuildVersion buildVersion = GrpcUtil.getGrpcBuildVersion();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Build version: {0}", buildVersion);
        nodeBuilder.setBuildVersion(buildVersion.toString());
        nodeBuilder.setUserAgentName(buildVersion.getUserAgent());
        nodeBuilder.setUserAgentVersion(buildVersion.getImplementationVersion());
        nodeBuilder.addClientFeatures(CLIENT_FEATURE_DISABLE_OVERPROVISIONING);
        Map certProvidersBlob = JsonUtil.getObject(rawData, (String)"certificate_providers");
        HashMap<String, Bootstrapper.CertificateProviderInfo> certProviders = null;
        if (certProvidersBlob != null) {
            certProviders = new HashMap<String, Bootstrapper.CertificateProviderInfo>(certProvidersBlob.size());
            for (String name : certProvidersBlob.keySet()) {
                Map valueMap = JsonUtil.getObject((Map)certProvidersBlob, (String)name);
                String pluginName = BootstrapperImpl.checkForNull(JsonUtil.getString((Map)valueMap, (String)"plugin_name"), "plugin_name");
                Map config = BootstrapperImpl.checkForNull(JsonUtil.getObject((Map)valueMap, (String)"config"), "config");
                Bootstrapper.CertificateProviderInfo certificateProviderInfo = new Bootstrapper.CertificateProviderInfo(pluginName, config);
                certProviders.put(name, certificateProviderInfo);
            }
        }
        String grpcServerResourceId = JsonUtil.getString(rawData, (String)"server_listener_resource_name_template");
        return new Bootstrapper.BootstrapInfo(servers, nodeBuilder.build(), certProviders, grpcServerResourceId);
    }

    @VisibleForTesting
    void setFileReader(FileReader reader) {
        this.reader = reader;
    }

    private static <T> T checkForNull(T value, String fieldName) throws XdsInitializationException {
        if (value == null) {
            throw new XdsInitializationException("Invalid bootstrap: '" + fieldName + "' does not exist.");
        }
        return value;
    }

    @Nullable
    private static ChannelCredentials parseChannelCredentials(List<Map<String, ?>> jsonList, String serverUri) throws XdsInitializationException {
        for (Map<String, ?> channelCreds : jsonList) {
            String type = JsonUtil.getString(channelCreds, (String)"type");
            if (type == null) {
                throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " with 'channel_creds' type unspecified");
            }
            switch (type) {
                case "google_default": {
                    return GoogleDefaultChannelCredentials.create();
                }
                case "insecure": {
                    return InsecureChannelCredentials.create();
                }
                case "tls": {
                    return TlsChannelCredentials.create();
                }
            }
        }
        return null;
    }

    private static enum LocalFileReader implements FileReader
    {
        INSTANCE;


        @Override
        public String readFile(String path) throws IOException {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        }
    }

    static interface FileReader {
        public String readFile(String var1) throws IOException;
    }
}

