/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.InternalServerInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.xds.AutoValue_XdsServerWrapper_ServerRoutingConfig;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.Filter;
import io.grpc.xds.FilterChainMatchingProtocolNegotiators;
import io.grpc.xds.FilterChainSelectorManager;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.RoutingUtils;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.XdsServerBuilder;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class XdsServerWrapper
extends Server {
    private static final Logger logger = Logger.getLogger(XdsServerWrapper.class.getName());
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.log(Level.SEVERE, "Exception!" + e);
        }
    });
    public static final Attributes.Key<AtomicReference<ServerRoutingConfig>> ATTR_SERVER_ROUTING_CONFIG = Attributes.Key.create((String)"io.grpc.xds.ServerWrapper.serverRoutingConfig");
    @VisibleForTesting
    static final long RETRY_DELAY_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private final String listenerAddress;
    private final ServerBuilder<?> delegateBuilder;
    private boolean sharedTimeService;
    private final ScheduledExecutorService timeService;
    private final FilterRegistry filterRegistry;
    private final ThreadSafeRandom random = ThreadSafeRandom.ThreadSafeRandomImpl.instance;
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;
    private final XdsServerBuilder.XdsServingStatusListener listener;
    private final FilterChainSelectorManager filterChainSelectorManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean isServing;
    private final CountDownLatch internalTerminationLatch = new CountDownLatch(1);
    private final SettableFuture<Exception> initialStartFuture = SettableFuture.create();
    private boolean initialStarted;
    private SynchronizationContext.ScheduledHandle restartTimer;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private DiscoveryState discoveryState;
    private volatile Server delegate;

    XdsServerWrapper(String listenerAddress, ServerBuilder<?> delegateBuilder, XdsServerBuilder.XdsServingStatusListener listener, FilterChainSelectorManager filterChainSelectorManager, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory, FilterRegistry filterRegistry) {
        this(listenerAddress, delegateBuilder, listener, filterChainSelectorManager, xdsClientPoolFactory, filterRegistry, (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE));
        this.sharedTimeService = true;
    }

    @VisibleForTesting
    XdsServerWrapper(String listenerAddress, ServerBuilder<?> delegateBuilder, XdsServerBuilder.XdsServingStatusListener listener, FilterChainSelectorManager filterChainSelectorManager, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory, FilterRegistry filterRegistry, ScheduledExecutorService timeService) {
        this.listenerAddress = (String)Preconditions.checkNotNull((Object)listenerAddress, (Object)"listenerAddress");
        this.delegateBuilder = (ServerBuilder)Preconditions.checkNotNull(delegateBuilder, (Object)"delegateBuilder");
        this.delegateBuilder.intercept((ServerInterceptor)new ConfigApplyingInterceptor());
        this.listener = (XdsServerBuilder.XdsServingStatusListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.filterChainSelectorManager = (FilterChainSelectorManager)Preconditions.checkNotNull((Object)filterChainSelectorManager, (Object)"filterChainSelectorManager");
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolFactory");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
        this.filterRegistry = (FilterRegistry)Preconditions.checkNotNull((Object)filterRegistry, (Object)"filterRegistry");
        this.delegate = delegateBuilder.build();
    }

    public Server start() throws IOException {
        Exception exception;
        Preconditions.checkState((boolean)this.started.compareAndSet(false, true), (Object)"Already started");
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                XdsServerWrapper.this.internalStart();
            }
        });
        try {
            exception = (Exception)this.initialStartFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (exception != null) {
            throw exception instanceof IOException ? (IOException)exception : new IOException(exception);
        }
        return this;
    }

    private void internalStart() {
        try {
            this.xdsClientPool = this.xdsClientPoolFactory.getOrCreate();
        }
        catch (Exception e) {
            StatusException statusException = Status.UNAVAILABLE.withDescription("Failed to initialize xDS").withCause((Throwable)e).asException();
            this.listener.onNotServing((Throwable)statusException);
            this.initialStartFuture.set((Object)statusException);
            return;
        }
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        boolean useProtocolV3 = this.xdsClient.getBootstrapInfo().getServers().get(0).isUseProtocolV3();
        String listenerTemplate = this.xdsClient.getBootstrapInfo().getServerListenerResourceNameTemplate();
        if (!useProtocolV3 || listenerTemplate == null) {
            StatusException statusException = Status.UNAVAILABLE.withDescription("Can only support xDS v3 with listener resource name template").asException();
            this.listener.onNotServing((Throwable)statusException);
            this.initialStartFuture.set((Object)statusException);
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
            return;
        }
        this.discoveryState = new DiscoveryState(listenerTemplate.replaceAll("%s", this.listenerAddress));
    }

    public Server shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsServerWrapper.this.delegate.isShutdown()) {
                    XdsServerWrapper.this.delegate.shutdown();
                }
                XdsServerWrapper.this.internalShutdown();
            }
        });
        return this;
    }

    public Server shutdownNow() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsServerWrapper.this.delegate.isShutdown()) {
                    XdsServerWrapper.this.delegate.shutdownNow();
                }
                XdsServerWrapper.this.internalShutdown();
            }
        });
        return this;
    }

    private void internalShutdown() {
        logger.log(Level.FINER, "Shutting down XdsServerWrapper");
        if (this.discoveryState != null) {
            this.discoveryState.shutdown();
        }
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
        if (this.restartTimer != null) {
            this.restartTimer.cancel();
        }
        if (this.sharedTimeService) {
            SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.timeService);
        }
        this.isServing = false;
        this.internalTerminationLatch.countDown();
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public boolean isTerminated() {
        return this.internalTerminationLatch.getCount() == 0L && this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        if (!this.internalTerminationLatch.await(timeout, unit)) {
            return false;
        }
        long remainingTime = unit.toNanos(timeout) - (System.nanoTime() - startTime);
        return this.delegate.awaitTermination(remainingTime, TimeUnit.NANOSECONDS);
    }

    public void awaitTermination() throws InterruptedException {
        this.internalTerminationLatch.await();
        this.delegate.awaitTermination();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public List<? extends SocketAddress> getListenSockets() {
        return this.delegate.getListenSockets();
    }

    public List<ServerServiceDefinition> getServices() {
        return this.delegate.getServices();
    }

    public List<ServerServiceDefinition> getImmutableServices() {
        return this.delegate.getImmutableServices();
    }

    public List<ServerServiceDefinition> getMutableServices() {
        return this.delegate.getMutableServices();
    }

    private void startDelegateServer() {
        if (this.restartTimer != null && this.restartTimer.isPending()) {
            return;
        }
        if (this.isServing) {
            return;
        }
        if (this.delegate.isShutdown()) {
            this.delegate = this.delegateBuilder.build();
        }
        try {
            this.delegate.start();
            this.listener.onServing();
            this.isServing = true;
            if (!this.initialStarted) {
                this.initialStarted = true;
                this.initialStartFuture.set(null);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Fail to start delegate server: {0}", e);
            if (!this.initialStarted) {
                this.initialStarted = true;
                this.initialStartFuture.set((Object)e);
            }
            this.restartTimer = this.syncContext.schedule((Runnable)new RestartTask(), RETRY_DELAY_NANOS, TimeUnit.NANOSECONDS, this.timeService);
        }
    }

    @AutoValue
    static abstract class ServerRoutingConfig {
        @VisibleForTesting
        static final ServerRoutingConfig FAILING_ROUTING_CONFIG = ServerRoutingConfig.create((ImmutableList<VirtualHost>)ImmutableList.of(), (ImmutableMap<VirtualHost.Route, ServerInterceptor>)ImmutableMap.of());

        ServerRoutingConfig() {
        }

        abstract ImmutableList<VirtualHost> virtualHosts();

        abstract ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors();

        public static ServerRoutingConfig create(ImmutableList<VirtualHost> virtualHosts, ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors) {
            Preconditions.checkNotNull(virtualHosts, (Object)"virtualHosts");
            Preconditions.checkNotNull(interceptors, (Object)"interceptors");
            return new AutoValue_XdsServerWrapper_ServerRoutingConfig(virtualHosts, interceptors);
        }
    }

    @VisibleForTesting
    final class ConfigApplyingInterceptor
    implements ServerInterceptor {
        private final ServerInterceptor noopInterceptor = new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(call, headers);
            }
        };

        ConfigApplyingInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            ServerRoutingConfig routingConfig;
            AtomicReference routingConfigRef = (AtomicReference)call.getAttributes().get(ATTR_SERVER_ROUTING_CONFIG);
            ServerRoutingConfig serverRoutingConfig = routingConfig = routingConfigRef == null ? null : (ServerRoutingConfig)routingConfigRef.get();
            if (routingConfig == null || routingConfig == ServerRoutingConfig.FAILING_ROUTING_CONFIG) {
                String errorMsg = "Missing or broken xDS routing config: RDS config unavailable.";
                call.close(Status.UNAVAILABLE.withDescription(errorMsg), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            ImmutableList<VirtualHost> virtualHosts = routingConfig.virtualHosts();
            VirtualHost virtualHost = RoutingUtils.findVirtualHostForHostName(virtualHosts, call.getAuthority());
            if (virtualHost == null) {
                call.close(Status.UNAVAILABLE.withDescription("Could not find xDS virtual host matching RPC"), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            VirtualHost.Route selectedRoute = null;
            MethodDescriptor method = call.getMethodDescriptor();
            for (VirtualHost.Route route : virtualHost.routes()) {
                if (!RoutingUtils.matchRoute(route.routeMatch(), "/" + method.getFullMethodName(), headers, XdsServerWrapper.this.random)) continue;
                selectedRoute = route;
                break;
            }
            if (selectedRoute == null) {
                call.close(Status.UNAVAILABLE.withDescription("Could not find xDS route matching RPC"), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            if (selectedRoute.routeAction() != null) {
                call.close(Status.UNAVAILABLE.withDescription("Invalid xDS route action for matching route: only Route.non_forwarding_action should be allowed."), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            ServerInterceptor routeInterceptor = this.noopInterceptor;
            ImmutableMap<VirtualHost.Route, ServerInterceptor> perRouteInterceptors = routingConfig.interceptors();
            if (perRouteInterceptors != null && perRouteInterceptors.get(selectedRoute) != null) {
                routeInterceptor = (ServerInterceptor)perRouteInterceptors.get(selectedRoute);
            }
            return routeInterceptor.interceptCall(call, headers, next);
        }
    }

    private final class DiscoveryState
    implements XdsClient.LdsResourceWatcher {
        private final String resourceName;
        private final Map<String, RouteDiscoveryState> routeDiscoveryStates = new HashMap<String, RouteDiscoveryState>();
        private final Set<String> pendingRds = new HashSet<String>();
        private List<EnvoyServerProtoData.FilterChain> filterChains = new ArrayList<EnvoyServerProtoData.FilterChain>();
        @Nullable
        private EnvoyServerProtoData.FilterChain defaultFilterChain;
        private boolean stopped;
        private final Map<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>> savedRdsRoutingConfigRef = new HashMap<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>>();
        private final ServerInterceptor noopInterceptor = new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(call, headers);
            }
        };

        private DiscoveryState(String resourceName) {
            this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName");
            XdsServerWrapper.this.xdsClient.watchLdsResource(resourceName, this);
        }

        @Override
        public void onChanged(final XdsClient.LdsUpdate update) {
            XdsServerWrapper.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (DiscoveryState.this.stopped) {
                        return;
                    }
                    Preconditions.checkNotNull((Object)update.listener(), (Object)"update");
                    if (!DiscoveryState.this.pendingRds.isEmpty()) {
                        DiscoveryState.this.releaseSuppliersInFlight();
                        DiscoveryState.this.pendingRds.clear();
                    }
                    DiscoveryState.this.filterChains = update.listener().getFilterChains();
                    DiscoveryState.this.defaultFilterChain = update.listener().getDefaultFilterChain();
                    ArrayList<EnvoyServerProtoData.FilterChain> allFilterChains = DiscoveryState.this.filterChains;
                    if (DiscoveryState.this.defaultFilterChain != null) {
                        allFilterChains = new ArrayList<EnvoyServerProtoData.FilterChain>(DiscoveryState.this.filterChains);
                        allFilterChains.add(DiscoveryState.this.defaultFilterChain);
                    }
                    HashSet<String> allRds = new HashSet<String>();
                    for (EnvoyServerProtoData.FilterChain filterChain : allFilterChains) {
                        HttpConnectionManager hcm = filterChain.getHttpConnectionManager();
                        if (hcm.virtualHosts() != null) continue;
                        RouteDiscoveryState rdsState = (RouteDiscoveryState)DiscoveryState.this.routeDiscoveryStates.get(hcm.rdsName());
                        if (rdsState == null) {
                            rdsState = new RouteDiscoveryState(hcm.rdsName());
                            DiscoveryState.this.routeDiscoveryStates.put(hcm.rdsName(), rdsState);
                            XdsServerWrapper.this.xdsClient.watchRdsResource(hcm.rdsName(), rdsState);
                        }
                        if (rdsState.isPending) {
                            DiscoveryState.this.pendingRds.add(hcm.rdsName());
                        }
                        allRds.add(hcm.rdsName());
                    }
                    for (Map.Entry entry : DiscoveryState.this.routeDiscoveryStates.entrySet()) {
                        if (allRds.contains(entry.getKey())) continue;
                        XdsServerWrapper.this.xdsClient.cancelRdsResourceWatch((String)entry.getKey(), (XdsClient.RdsResourceWatcher)entry.getValue());
                    }
                    DiscoveryState.this.routeDiscoveryStates.keySet().retainAll(allRds);
                    if (DiscoveryState.this.pendingRds.isEmpty()) {
                        DiscoveryState.this.updateSelector();
                    }
                }
            });
        }

        @Override
        public void onResourceDoesNotExist(final String resourceName) {
            XdsServerWrapper.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (DiscoveryState.this.stopped) {
                        return;
                    }
                    StatusException statusException = Status.UNAVAILABLE.withDescription("Listener " + resourceName + " unavailable").asException();
                    DiscoveryState.this.handleConfigNotFound(statusException);
                }
            });
        }

        @Override
        public void onError(final Status error) {
            XdsServerWrapper.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (DiscoveryState.this.stopped) {
                        return;
                    }
                    boolean isPermanentError = DiscoveryState.this.isPermanentError(error);
                    logger.log(Level.FINE, "{0} error from XdsClient: {1}", new Object[]{isPermanentError ? "Permanent" : "Transient", error});
                    if (isPermanentError) {
                        DiscoveryState.this.handleConfigNotFound(error.asException());
                    } else if (!XdsServerWrapper.this.isServing) {
                        XdsServerWrapper.this.listener.onNotServing((Throwable)error.asException());
                    }
                }
            });
        }

        private void shutdown() {
            this.stopped = true;
            this.cleanUpRouteDiscoveryStates();
            logger.log(Level.FINE, "Stop watching LDS resource {0}", this.resourceName);
            XdsServerWrapper.this.xdsClient.cancelLdsResourceWatch(this.resourceName, this);
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector.NO_FILTER_CHAIN);
            for (SslContextProviderSupplier s : toRelease) {
                s.close();
            }
            this.releaseSuppliersInFlight();
        }

        private void updateSelector() {
            HashMap<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>> filterChainRouting = new HashMap<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>>();
            this.savedRdsRoutingConfigRef.clear();
            for (EnvoyServerProtoData.FilterChain filterChain : this.filterChains) {
                filterChainRouting.put(filterChain, this.generateRoutingConfig(filterChain));
            }
            FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector selector = new FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector(Collections.unmodifiableMap(filterChainRouting), this.defaultFilterChain == null ? null : this.defaultFilterChain.getSslContextProviderSupplier(), this.defaultFilterChain == null ? new AtomicReference() : this.generateRoutingConfig(this.defaultFilterChain));
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(selector);
            for (SslContextProviderSupplier e : toRelease) {
                e.close();
            }
            XdsServerWrapper.this.startDelegateServer();
        }

        private AtomicReference<ServerRoutingConfig> generateRoutingConfig(EnvoyServerProtoData.FilterChain filterChain) {
            HttpConnectionManager hcm = filterChain.getHttpConnectionManager();
            if (hcm.virtualHosts() != null) {
                ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors = this.generatePerRouteInterceptors((List<Filter.NamedFilterConfig>)hcm.httpFilterConfigs(), (List<VirtualHost>)hcm.virtualHosts());
                return new AtomicReference<ServerRoutingConfig>(ServerRoutingConfig.create(hcm.virtualHosts(), interceptors));
            }
            RouteDiscoveryState rds = this.routeDiscoveryStates.get(hcm.rdsName());
            Preconditions.checkNotNull((Object)rds, (Object)"rds");
            AtomicReference<ServerRoutingConfig> serverRoutingConfigRef = new AtomicReference<ServerRoutingConfig>();
            if (rds.savedVirtualHosts != null) {
                ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors = this.generatePerRouteInterceptors((List<Filter.NamedFilterConfig>)hcm.httpFilterConfigs(), (List<VirtualHost>)rds.savedVirtualHosts);
                ServerRoutingConfig serverRoutingConfig = ServerRoutingConfig.create((ImmutableList<VirtualHost>)rds.savedVirtualHosts, interceptors);
                serverRoutingConfigRef.set(serverRoutingConfig);
            } else {
                serverRoutingConfigRef.set(ServerRoutingConfig.FAILING_ROUTING_CONFIG);
            }
            this.savedRdsRoutingConfigRef.put(filterChain, serverRoutingConfigRef);
            return serverRoutingConfigRef;
        }

        private ImmutableMap<VirtualHost.Route, ServerInterceptor> generatePerRouteInterceptors(List<Filter.NamedFilterConfig> namedFilterConfigs, List<VirtualHost> virtualHosts) {
            ImmutableMap.Builder perRouteInterceptors = new ImmutableMap.Builder();
            for (VirtualHost virtualHost : virtualHosts) {
                for (VirtualHost.Route route : virtualHost.routes()) {
                    ArrayList<ServerInterceptor> filterInterceptors = new ArrayList<ServerInterceptor>();
                    HashMap<String, Filter.FilterConfig> selectedOverrideConfigs = new HashMap<String, Filter.FilterConfig>((Map<String, Filter.FilterConfig>)virtualHost.filterConfigOverrides());
                    selectedOverrideConfigs.putAll((Map<String, Filter.FilterConfig>)route.filterConfigOverrides());
                    if (namedFilterConfigs != null) {
                        for (Filter.NamedFilterConfig namedFilterConfig : namedFilterConfigs) {
                            Filter.FilterConfig filterConfig = namedFilterConfig.filterConfig;
                            Filter filter = XdsServerWrapper.this.filterRegistry.get(filterConfig.typeUrl());
                            if (filter instanceof Filter.ServerInterceptorBuilder) {
                                ServerInterceptor interceptor = ((Filter.ServerInterceptorBuilder)((Object)filter)).buildServerInterceptor(filterConfig, (Filter.FilterConfig)selectedOverrideConfigs.get(namedFilterConfig.name));
                                if (interceptor == null) continue;
                                filterInterceptors.add(interceptor);
                                continue;
                            }
                            logger.log(Level.WARNING, "HttpFilterConfig(type URL: " + filterConfig.typeUrl() + ") is not supported on server-side. Probably a bug at ClientXdsClient verification.");
                        }
                    }
                    ServerInterceptor interceptor = this.combineInterceptors(filterInterceptors);
                    perRouteInterceptors.put((Object)route, (Object)interceptor);
                }
            }
            return perRouteInterceptors.build();
        }

        private ServerInterceptor combineInterceptors(final List<ServerInterceptor> interceptors) {
            if (interceptors.isEmpty()) {
                return this.noopInterceptor;
            }
            if (interceptors.size() == 1) {
                return interceptors.get(0);
            }
            return new ServerInterceptor(){

                public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                    for (int i = interceptors.size() - 1; i >= 0; --i) {
                        next = InternalServerInterceptors.interceptCallHandlerCreate((ServerInterceptor)((ServerInterceptor)interceptors.get(i)), next);
                    }
                    return next.startCall(call, headers);
                }
            };
        }

        private void handleConfigNotFound(StatusException exception) {
            this.cleanUpRouteDiscoveryStates();
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector.NO_FILTER_CHAIN);
            for (SslContextProviderSupplier s : toRelease) {
                s.close();
            }
            if (!XdsServerWrapper.this.initialStarted) {
                XdsServerWrapper.this.initialStarted = true;
                XdsServerWrapper.this.initialStartFuture.set((Object)exception);
            }
            if (XdsServerWrapper.this.restartTimer != null) {
                XdsServerWrapper.this.restartTimer.cancel();
            }
            if (!XdsServerWrapper.this.delegate.isShutdown()) {
                XdsServerWrapper.this.delegate.shutdown();
            }
            XdsServerWrapper.this.isServing = false;
            XdsServerWrapper.this.listener.onNotServing((Throwable)exception);
        }

        private void cleanUpRouteDiscoveryStates() {
            for (RouteDiscoveryState rdsState : this.routeDiscoveryStates.values()) {
                String rdsName = rdsState.resourceName;
                logger.log(Level.FINE, "Stop watching RDS resource {0}", rdsName);
                XdsServerWrapper.this.xdsClient.cancelRdsResourceWatch(rdsName, rdsState);
            }
            this.routeDiscoveryStates.clear();
            this.savedRdsRoutingConfigRef.clear();
        }

        private List<SslContextProviderSupplier> getSuppliersInUse() {
            ArrayList<SslContextProviderSupplier> toRelease = new ArrayList<SslContextProviderSupplier>();
            FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector selector = XdsServerWrapper.this.filterChainSelectorManager.getSelectorToUpdateSelector();
            if (selector != null) {
                for (EnvoyServerProtoData.FilterChain f : selector.getRoutingConfigs().keySet()) {
                    if (f.getSslContextProviderSupplier() == null) continue;
                    toRelease.add(f.getSslContextProviderSupplier());
                }
                SslContextProviderSupplier defaultSupplier = selector.getDefaultSslContextProviderSupplier();
                if (defaultSupplier != null) {
                    toRelease.add(defaultSupplier);
                }
            }
            return toRelease;
        }

        private void releaseSuppliersInFlight() {
            SslContextProviderSupplier supplier;
            for (EnvoyServerProtoData.FilterChain filterChain : this.filterChains) {
                supplier = filterChain.getSslContextProviderSupplier();
                if (supplier == null) continue;
                supplier.close();
            }
            if (this.defaultFilterChain != null && (supplier = this.defaultFilterChain.getSslContextProviderSupplier()) != null) {
                supplier.close();
            }
        }

        private boolean isPermanentError(Status error) {
            return EnumSet.of(Status.Code.INTERNAL, Status.Code.INVALID_ARGUMENT, Status.Code.FAILED_PRECONDITION, Status.Code.PERMISSION_DENIED, Status.Code.UNAUTHENTICATED).contains(error.getCode());
        }

        private final class RouteDiscoveryState
        implements XdsClient.RdsResourceWatcher {
            private final String resourceName;
            private ImmutableList<VirtualHost> savedVirtualHosts;
            private boolean isPending = true;

            private RouteDiscoveryState(String resourceName) {
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName");
            }

            @Override
            public void onChanged(final XdsClient.RdsUpdate update) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(RouteDiscoveryState.this.resourceName)) {
                            return;
                        }
                        if (RouteDiscoveryState.this.savedVirtualHosts == null && !RouteDiscoveryState.this.isPending) {
                            logger.log(Level.WARNING, "Received valid Rds {0} configuration.", RouteDiscoveryState.this.resourceName);
                        }
                        RouteDiscoveryState.this.savedVirtualHosts = ImmutableList.copyOf(update.virtualHosts);
                        RouteDiscoveryState.this.updateRdsRoutingConfig();
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(resourceName)) {
                            return;
                        }
                        logger.log(Level.WARNING, "Rds {0} unavailable", resourceName);
                        RouteDiscoveryState.this.savedVirtualHosts = null;
                        RouteDiscoveryState.this.updateRdsRoutingConfig();
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(RouteDiscoveryState.this.resourceName)) {
                            return;
                        }
                        logger.log(Level.WARNING, "Error loading RDS resource {0} from XdsClient: {1}.", new Object[]{RouteDiscoveryState.this.resourceName, error});
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            private void updateRdsRoutingConfig() {
                for (EnvoyServerProtoData.FilterChain filterChain : DiscoveryState.this.savedRdsRoutingConfigRef.keySet()) {
                    ServerRoutingConfig updatedRoutingConfig;
                    if (!this.resourceName.equals(filterChain.getHttpConnectionManager().rdsName())) continue;
                    if (this.savedVirtualHosts == null) {
                        updatedRoutingConfig = ServerRoutingConfig.FAILING_ROUTING_CONFIG;
                    } else {
                        ImmutableMap updatedInterceptors = DiscoveryState.this.generatePerRouteInterceptors(filterChain.getHttpConnectionManager().httpFilterConfigs(), this.savedVirtualHosts);
                        updatedRoutingConfig = ServerRoutingConfig.create(this.savedVirtualHosts, (ImmutableMap<VirtualHost.Route, ServerInterceptor>)updatedInterceptors);
                    }
                    ((AtomicReference)DiscoveryState.this.savedRdsRoutingConfigRef.get(filterChain)).set(updatedRoutingConfig);
                }
            }

            private void maybeUpdateSelector() {
                boolean isLastPending;
                this.isPending = false;
                boolean bl = isLastPending = DiscoveryState.this.pendingRds.remove(this.resourceName) && DiscoveryState.this.pendingRds.isEmpty();
                if (isLastPending) {
                    DiscoveryState.this.updateSelector();
                }
            }
        }
    }

    private final class RestartTask
    implements Runnable {
        private RestartTask() {
        }

        @Override
        public void run() {
            XdsServerWrapper.this.startDelegateServer();
        }
    }
}

