/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Internal;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.xds.GoogleCloudToProdNameResolver;
import io.grpc.xds.SharedXdsClientPoolProvider;
import java.net.URI;
import java.util.concurrent.Executor;

@Internal
public final class GoogleCloudToProdNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "google-c2p-experimental";

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new GoogleCloudToProdNameResolver(targetUri, args, (SharedResourceHolder.Resource<Executor>)GrpcUtil.SHARED_CHANNEL_EXECUTOR, SharedXdsClientPoolProvider.getDefaultProvider());
        }
        return null;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 4;
    }
}

