/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Any;
import io.grpc.ChannelCredentials;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.BootstrapperImpl;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.LoadReportClient;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Locality;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClusterResource;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.XdsListenerResource;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsResourceType;
import io.grpc.xds.XdsRouteConfigureResource;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClientXdsClient
extends XdsClient
implements XdsClient.XdsResponseHandler,
XdsClient.ResourceStore {
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "Uncaught exception in XdsClient SynchronizationContext. Panic!", e);
            throw new AssertionError((Object)e);
        }
    });
    private final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();
    private final LoadBalancerRegistry loadBalancerRegistry = LoadBalancerRegistry.getDefaultRegistry();
    private final Map<Bootstrapper.ServerInfo, AbstractXdsClient> serverChannelMap = new HashMap<Bootstrapper.ServerInfo, AbstractXdsClient>();
    private final Map<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>> resourceSubscribers = new HashMap<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>>();
    private final Map<AbstractXdsClient.ResourceType, XdsResourceType<? extends XdsClient.ResourceUpdate>> xdsResourceTypeMap = ImmutableMap.of((Object)((Object)AbstractXdsClient.ResourceType.LDS), (Object)XdsListenerResource.getInstance(), (Object)((Object)AbstractXdsClient.ResourceType.RDS), (Object)XdsRouteConfigureResource.getInstance(), (Object)((Object)AbstractXdsClient.ResourceType.CDS), (Object)XdsClusterResource.getInstance(), (Object)((Object)AbstractXdsClient.ResourceType.EDS), (Object)XdsEndpointResource.getInstance());
    private final LoadStatsManager2 loadStatsManager;
    private final Map<Bootstrapper.ServerInfo, LoadReportClient> serverLrsClientMap = new HashMap<Bootstrapper.ServerInfo, LoadReportClient>();
    private final XdsChannelFactory xdsChannelFactory;
    private final Bootstrapper.BootstrapInfo bootstrapInfo;
    private final Context context;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final TimeProvider timeProvider;
    private boolean reportingLoad;
    private final TlsContextManager tlsContextManager;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private volatile boolean isShutdown;

    ClientXdsClient(XdsChannelFactory xdsChannelFactory, Bootstrapper.BootstrapInfo bootstrapInfo, Context context, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, TimeProvider timeProvider, TlsContextManager tlsContextManager) {
        this.xdsChannelFactory = xdsChannelFactory;
        this.bootstrapInfo = bootstrapInfo;
        this.context = context;
        this.timeService = timeService;
        this.loadStatsManager = new LoadStatsManager2(stopwatchSupplier);
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.stopwatchSupplier = stopwatchSupplier;
        this.timeProvider = timeProvider;
        this.tlsContextManager = (TlsContextManager)Preconditions.checkNotNull((Object)tlsContextManager, (Object)"tlsContextManager");
        this.logId = InternalLogId.allocate((String)"xds-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    private void maybeCreateXdsChannelWithLrs(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.serverChannelMap.containsKey(serverInfo)) {
            return;
        }
        AbstractXdsClient xdsChannel = new AbstractXdsClient(this.xdsChannelFactory, serverInfo, this.bootstrapInfo.node(), this, this, this.context, this.timeService, this.syncContext, this.backoffPolicyProvider, this.stopwatchSupplier);
        LoadReportClient lrsClient = new LoadReportClient(this.loadStatsManager, xdsChannel.channel(), this.context, serverInfo.useProtocolV3(), this.bootstrapInfo.node(), this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        this.serverChannelMap.put(serverInfo, xdsChannel);
        this.serverLrsClientMap.put(serverInfo, lrsClient);
    }

    @Override
    public void handleResourceResponse(AbstractXdsClient.ResourceType resourceType, Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        XdsResourceType<? extends XdsClient.ResourceUpdate> xdsResourceType = this.xdsResourceTypeMap.get((Object)resourceType);
        if (xdsResourceType == null) {
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Ignore an unknown type of DiscoveryResponse");
            return;
        }
        Set<String> toParseResourceNames = null;
        if (resourceType != AbstractXdsClient.ResourceType.LDS && resourceType != AbstractXdsClient.ResourceType.RDS && this.resourceSubscribers.containsKey(xdsResourceType)) {
            toParseResourceNames = this.resourceSubscribers.get(xdsResourceType).keySet();
        }
        XdsResourceType.Args args = new XdsResourceType.Args(serverInfo, versionInfo, nonce, this.bootstrapInfo, this.filterRegistry, this.loadBalancerRegistry, this.tlsContextManager, toParseResourceNames);
        this.handleResourceUpdate(args, resources, xdsResourceType);
    }

    @Override
    public void handleStreamClosed(Status error) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cleanUpResourceTimers();
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                subscriber.onError(error);
            }
        }
    }

    @Override
    public void handleStreamRestarted(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                if (!((ResourceSubscriber)subscriber).serverInfo.equals(serverInfo)) continue;
                subscriber.restartTimer();
            }
        }
    }

    @Override
    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (ClientXdsClient.this.isShutdown) {
                    return;
                }
                ClientXdsClient.this.isShutdown = true;
                for (AbstractXdsClient xdsChannel : ClientXdsClient.this.serverChannelMap.values()) {
                    xdsChannel.shutdown();
                }
                if (ClientXdsClient.this.reportingLoad) {
                    for (LoadReportClient lrsClient : ClientXdsClient.this.serverLrsClientMap.values()) {
                        lrsClient.stopLoadReporting();
                    }
                }
                ClientXdsClient.this.cleanUpResourceTimers();
            }
        });
    }

    @Override
    boolean isShutDown() {
        return this.isShutdown;
    }

    private Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> getSubscribedResourcesMap(AbstractXdsClient.ResourceType type) {
        return this.resourceSubscribers.getOrDefault(this.xdsResourceTypeMap.get((Object)type), Collections.emptyMap());
    }

    @Override
    @Nullable
    public XdsResourceType<? extends XdsClient.ResourceUpdate> getXdsResourceType(AbstractXdsClient.ResourceType type) {
        return this.xdsResourceTypeMap.get((Object)type);
    }

    @Override
    @Nullable
    public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo serverInfo, AbstractXdsClient.ResourceType type) {
        Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> resources = this.getSubscribedResourcesMap(type);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String key : resources.keySet()) {
            if (!((ResourceSubscriber)resources.get(key)).serverInfo.equals(serverInfo)) continue;
            builder.add((Object)key);
        }
        ImmutableSet retVal = builder.build();
        return retVal.isEmpty() ? null : retVal;
    }

    @Override
    ListenableFuture<Map<AbstractXdsClient.ResourceType, Map<String, XdsClient.ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        final SettableFuture future = SettableFuture.create();
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ImmutableMap.Builder metadataSnapshot = ImmutableMap.builder();
                for (XdsResourceType resourceType : ClientXdsClient.this.xdsResourceTypeMap.values()) {
                    ImmutableMap.Builder metadataMap = ImmutableMap.builder();
                    Map resourceSubscriberMap = ClientXdsClient.this.resourceSubscribers.getOrDefault(resourceType, Collections.emptyMap());
                    for (Map.Entry resourceEntry : resourceSubscriberMap.entrySet()) {
                        metadataMap.put((Object)((String)resourceEntry.getKey()), (Object)((ResourceSubscriber)resourceEntry.getValue()).metadata);
                    }
                    metadataSnapshot.put((Object)resourceType.typeName(), (Object)metadataMap.buildOrThrow());
                }
                future.set((Object)metadataSnapshot.buildOrThrow());
            }
        });
        return future;
    }

    @Override
    TlsContextManager getTlsContextManager() {
        return this.tlsContextManager;
    }

    @Override
    <T extends XdsClient.ResourceUpdate> void watchXdsResource(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber;
                if (!ClientXdsClient.this.resourceSubscribers.containsKey(type)) {
                    ClientXdsClient.this.resourceSubscribers.put(type, new HashMap());
                }
                if ((subscriber = (ResourceSubscriber)((Map)ClientXdsClient.this.resourceSubscribers.get(type)).get(resourceName)) == null) {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe {0} resource {1}", type, resourceName);
                    subscriber = new ResourceSubscriber(type.typeName(), resourceName);
                    ((Map)ClientXdsClient.this.resourceSubscribers.get(type)).put(resourceName, subscriber);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(type);
                    }
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    <T extends XdsClient.ResourceUpdate> void cancelXdsResourceWatch(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)((Map)ClientXdsClient.this.resourceSubscribers.get(type)).get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ((Map)ClientXdsClient.this.resourceSubscribers.get(type)).remove(resourceName);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(type);
                    }
                    if (((Map)ClientXdsClient.this.resourceSubscribers.get(type)).isEmpty()) {
                        ClientXdsClient.this.resourceSubscribers.remove(type);
                    }
                }
            }
        });
    }

    @Override
    LoadStatsManager2.ClusterDropStats addClusterDropStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2.ClusterDropStats dropCounter = this.loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ((LoadReportClient)ClientXdsClient.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return dropCounter;
    }

    @Override
    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        LoadStatsManager2.ClusterLocalityStats loadCounter = this.loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!ClientXdsClient.this.reportingLoad) {
                    ((LoadReportClient)ClientXdsClient.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
                    ClientXdsClient.this.reportingLoad = true;
                }
            }
        });
        return loadCounter;
    }

    @Override
    Bootstrapper.BootstrapInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    public String toString() {
        return this.logId.toString();
    }

    private void cleanUpResourceTimers() {
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                subscriber.stopTimer();
            }
        }
    }

    private <T extends XdsClient.ResourceUpdate> void handleResourceUpdate(XdsResourceType.Args args, List<Any> resources, XdsResourceType<T> xdsResourceType) {
        XdsResourceType.ValidatedResourceUpdate<T> result = xdsResourceType.parse(args, resources);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received {0} Response version {1} nonce {2}. Parsed resources: {3}", new Object[]{xdsResourceType.typeName(), args.versionInfo, args.nonce, result.unpackedResources});
        Map parsedResources = result.parsedResources;
        Set<String> invalidResources = result.invalidResources;
        Set<String> retainedResources = result.retainedResources;
        List<String> errors = result.errors;
        String errorDetail = null;
        if (errors.isEmpty()) {
            Preconditions.checkArgument((boolean)invalidResources.isEmpty(), (Object)"found invalid resources but missing errors");
            this.serverChannelMap.get(args.serverInfo).ackResponse(xdsResourceType, args.versionInfo, args.nonce);
        } else {
            errorDetail = Joiner.on((char)'\n').join(errors);
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed processing {0} Response version {1} nonce {2}. Errors:\n{3}", new Object[]{xdsResourceType.typeName(), args.versionInfo, args.nonce, errorDetail});
            this.serverChannelMap.get(args.serverInfo).nackResponse(xdsResourceType, args.nonce, errorDetail);
        }
        long updateTime = this.timeProvider.currentTimeNanos();
        for (Map.Entry<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> entry : this.getSubscribedResourcesMap(xdsResourceType.typeName()).entrySet()) {
            String resourceName = entry.getKey();
            ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber = entry.getValue();
            if (parsedResources.containsKey(resourceName)) {
                subscriber.onData(parsedResources.get(resourceName), args.versionInfo, updateTime);
                continue;
            }
            if (invalidResources.contains(resourceName)) {
                subscriber.onRejected(args.versionInfo, updateTime, errorDetail);
            }
            if (xdsResourceType.dependentResource() == null) continue;
            if (invalidResources.contains(resourceName)) {
                if (((ResourceSubscriber)subscriber).data != null) {
                    this.retainDependentResource(subscriber, retainedResources);
                    continue;
                }
                subscriber.onError(Status.UNAVAILABLE.withDescription(errorDetail));
                continue;
            }
            subscriber.onAbsent();
            if (((ResourceSubscriber)subscriber).absent) continue;
            this.retainDependentResource(subscriber, retainedResources);
        }
        if (xdsResourceType.dependentResource() != null) {
            XdsResourceType<? extends XdsClient.ResourceUpdate> dependency = this.xdsResourceTypeMap.get((Object)xdsResourceType.dependentResource());
            Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> dependentSubscribers = this.resourceSubscribers.get(dependency);
            if (dependentSubscribers == null) {
                return;
            }
            for (String resource : dependentSubscribers.keySet()) {
                if (retainedResources.contains(resource)) continue;
                dependentSubscribers.get(resource).onAbsent();
            }
        }
    }

    private void retainDependentResource(ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber, Set<String> retainedResources) {
        if (((ResourceSubscriber)subscriber).data == null) {
            return;
        }
        String resourceName = null;
        if (((ResourceSubscriber)subscriber).type == AbstractXdsClient.ResourceType.LDS) {
            XdsListenerResource.LdsUpdate ldsUpdate = (XdsListenerResource.LdsUpdate)((ResourceSubscriber)subscriber).data;
            HttpConnectionManager hcm = ldsUpdate.httpConnectionManager();
            if (hcm != null) {
                resourceName = hcm.rdsName();
            }
        } else if (((ResourceSubscriber)subscriber).type == AbstractXdsClient.ResourceType.CDS) {
            XdsClusterResource.CdsUpdate cdsUpdate = (XdsClusterResource.CdsUpdate)((ResourceSubscriber)subscriber).data;
            resourceName = cdsUpdate.edsServiceName();
        }
        if (resourceName != null) {
            retainedResources.add(resourceName);
        }
    }

    static abstract class XdsChannelFactory {
        static final XdsChannelFactory DEFAULT_XDS_CHANNEL_FACTORY = new XdsChannelFactory(){

            @Override
            ManagedChannel create(Bootstrapper.ServerInfo serverInfo) {
                String target = serverInfo.target();
                ChannelCredentials channelCredentials = serverInfo.channelCredentials();
                return Grpc.newChannelBuilder((String)target, (ChannelCredentials)channelCredentials).keepAliveTime(5L, TimeUnit.MINUTES).build();
            }
        };

        XdsChannelFactory() {
        }

        abstract ManagedChannel create(Bootstrapper.ServerInfo var1);
    }

    @VisibleForTesting
    static final class ResourceInvalidException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ResourceInvalidException(String message) {
            super(message, null, false, false);
        }

        ResourceInvalidException(String message, Throwable cause) {
            super(cause != null ? message + ": " + cause.getMessage() : message, cause, false, false);
        }
    }

    private final class ResourceSubscriber<T extends XdsClient.ResourceUpdate> {
        @Nullable
        private final Bootstrapper.ServerInfo serverInfo;
        @Nullable
        private final AbstractXdsClient xdsChannel;
        private final AbstractXdsClient.ResourceType type;
        private final String resource;
        private final Set<XdsClient.ResourceWatcher<T>> watchers = new HashSet<XdsClient.ResourceWatcher<T>>();
        @Nullable
        private T data;
        private boolean absent;
        private boolean resourceDeletionIgnored;
        @Nullable
        private SynchronizationContext.ScheduledHandle respTimer;
        @Nullable
        private XdsClient.ResourceMetadata metadata;
        @Nullable
        private String errorDescription;

        ResourceSubscriber(AbstractXdsClient.ResourceType type, String resource) {
            ClientXdsClient.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.type = type;
            this.resource = resource;
            this.serverInfo = this.getServerInfo(resource);
            if (this.serverInfo == null) {
                this.errorDescription = "Wrong configuration: xds server does not exist for resource " + resource;
                this.xdsChannel = null;
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataUnknown();
            ClientXdsClient.this.maybeCreateXdsChannelWithLrs(this.serverInfo);
            this.xdsChannel = (AbstractXdsClient)ClientXdsClient.this.serverChannelMap.get(this.serverInfo);
            if (this.xdsChannel.isInBackoff()) {
                return;
            }
            this.restartTimer();
        }

        @Nullable
        private Bootstrapper.ServerInfo getServerInfo(String resource) {
            if (BootstrapperImpl.enableFederation && resource.startsWith("xdstp:")) {
                Bootstrapper.AuthorityInfo authorityInfo;
                URI uri = URI.create(resource);
                String authority = uri.getAuthority();
                if (authority == null) {
                    authority = "";
                }
                if ((authorityInfo = (Bootstrapper.AuthorityInfo)ClientXdsClient.this.bootstrapInfo.authorities().get((Object)authority)) == null || authorityInfo.xdsServers().isEmpty()) {
                    return null;
                }
                return (Bootstrapper.ServerInfo)authorityInfo.xdsServers().get(0);
            }
            return (Bootstrapper.ServerInfo)ClientXdsClient.this.bootstrapInfo.servers().get(0);
        }

        void addWatcher(XdsClient.ResourceWatcher<T> watcher) {
            Preconditions.checkArgument((!this.watchers.contains(watcher) ? 1 : 0) != 0, (String)"watcher %s already registered", watcher);
            this.watchers.add(watcher);
            if (this.errorDescription != null) {
                watcher.onError(Status.INVALID_ARGUMENT.withDescription(this.errorDescription));
                return;
            }
            if (this.data != null) {
                this.notifyWatcher(watcher, this.data);
            } else if (this.absent) {
                watcher.onResourceDoesNotExist(this.resource);
            }
        }

        void removeWatcher(XdsClient.ResourceWatcher<T> watcher) {
            Preconditions.checkArgument((boolean)this.watchers.contains(watcher), (String)"watcher %s not registered", watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataRequested();
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", new Object[]{ResourceSubscriber.this.type, ResourceSubscriber.this.resource});
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent();
                }

                public String toString() {
                    return (Object)((Object)ResourceSubscriber.this.type) + this.getClass().getSimpleName();
                }
            }
            this.respTimer = ClientXdsClient.this.syncContext.schedule((Runnable)new ResourceNotFound(), 15L, TimeUnit.SECONDS, ClientXdsClient.this.timeService);
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        void cancelResourceWatch() {
            if (this.isWatched()) {
                throw new IllegalStateException("Can't cancel resource watch with active watchers present");
            }
            this.stopTimer();
            String message = "Unsubscribing {0} resource {1} from server {2}";
            XdsLogger.XdsLogLevel logLevel = XdsLogger.XdsLogLevel.INFO;
            if (this.resourceDeletionIgnored) {
                message = message + " for which we previously ignored a deletion";
                logLevel = XdsLogger.XdsLogLevel.FORCE_INFO;
            }
            ClientXdsClient.this.logger.log(logLevel, message, new Object[]{this.type, this.resource, this.serverInfo != null ? this.serverInfo.target() : "unknown"});
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        void onData(XdsResourceType.ParsedResource<T> parsedResource, String version, long updateTime) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataAcked(parsedResource.getRawResource(), version, updateTime);
            T oldData = this.data;
            this.data = parsedResource.getResourceUpdate();
            this.absent = false;
            if (this.resourceDeletionIgnored) {
                ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.FORCE_INFO, "xds server {0}: server returned new version of resource for which we previously ignored a deletion: type {1} name {2}", new Object[]{this.serverInfo != null ? this.serverInfo.target() : "unknown", this.type, this.resource});
                this.resourceDeletionIgnored = false;
            }
            if (!Objects.equals(oldData, this.data)) {
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers) {
                    this.notifyWatcher(watcher, this.data);
                }
            }
        }

        void onAbsent() {
            boolean isStateOfTheWorld;
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            boolean ignoreResourceDeletionEnabled = this.serverInfo != null && this.serverInfo.ignoreResourceDeletion();
            boolean bl = isStateOfTheWorld = this.type == AbstractXdsClient.ResourceType.LDS || this.type == AbstractXdsClient.ResourceType.CDS;
            if (ignoreResourceDeletionEnabled && isStateOfTheWorld && this.data != null) {
                if (!this.resourceDeletionIgnored) {
                    ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.FORCE_WARNING, "xds server {0}: ignoring deletion for resource type {1} name {2}}", new Object[]{this.serverInfo.target(), this.type, this.resource});
                    this.resourceDeletionIgnored = true;
                }
                return;
            }
            ClientXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", new Object[]{this.type, this.resource});
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                this.metadata = XdsClient.ResourceMetadata.newResourceMetadataDoesNotExist();
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            }
        }

        void onError(Status error) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorAugmented = Status.fromCode((Status.Code)error.getCode()).withDescription(description + "nodeID: " + ClientXdsClient.this.bootstrapInfo.node().getId()).withCause(error.getCause());
            for (XdsClient.ResourceWatcher<T> watcher : this.watchers) {
                watcher.onError(errorAugmented);
            }
        }

        void onRejected(String rejectedVersion, long rejectedTime, String rejectedDetails) {
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataNacked(this.metadata, rejectedVersion, rejectedTime, rejectedDetails);
        }

        private void notifyWatcher(XdsClient.ResourceWatcher<T> watcher, T update) {
            watcher.onChanged(update);
        }
    }
}

