/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.Deadline;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.services.MetricReport;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.ForwardingSubchannel;
import io.grpc.util.RoundRobinLoadBalancer;
import io.grpc.xds.orca.OrcaOobUtil;
import io.grpc.xds.orca.OrcaPerRequestUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9885")
final class WeightedRoundRobinLoadBalancer
extends RoundRobinLoadBalancer {
    private static final Logger log = Logger.getLogger(WeightedRoundRobinLoadBalancer.class.getName());
    private WeightedRoundRobinLoadBalancerConfig config;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private SynchronizationContext.ScheduledHandle weightUpdateTimer;
    private final Runnable updateWeightTask;
    private final Random random;
    private final long infTime;
    private final Deadline.Ticker ticker;

    public WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, new Random());
    }

    public WeightedRoundRobinLoadBalancer(WrrHelper helper, Deadline.Ticker ticker, Random random) {
        super((LoadBalancer.Helper)helper);
        helper.setLoadBalancer(this);
        this.ticker = (Deadline.Ticker)Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
        this.infTime = ticker.nanoTime() + Long.MAX_VALUE;
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.updateWeightTask = new UpdateWeightTask();
        this.random = random;
        log.log(Level.FINE, "weighted_round_robin LB created");
    }

    @VisibleForTesting
    WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker, Random random) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, random);
    }

    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (resolvedAddresses.getLoadBalancingPolicyConfig() == null) {
            this.handleNameResolutionError(Status.UNAVAILABLE.withDescription("NameResolver returned no WeightedRoundRobinLoadBalancerConfig. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes()));
            return false;
        }
        this.config = (WeightedRoundRobinLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        boolean accepted = super.acceptResolvedAddresses(resolvedAddresses);
        if (this.weightUpdateTimer != null && this.weightUpdateTimer.isPending()) {
            this.weightUpdateTimer.cancel();
        }
        this.updateWeightTask.run();
        this.afterAcceptAddresses();
        return accepted;
    }

    public RoundRobinLoadBalancer.RoundRobinPicker createReadyPicker(List<LoadBalancer.Subchannel> activeList) {
        return new WeightedRoundRobinPicker(activeList, this.config.enableOobLoadReport, this.config.errorUtilizationPenalty);
    }

    private void afterAcceptAddresses() {
        for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
            WrrSubchannel weightedSubchannel = (WrrSubchannel)subchannel;
            if (this.config.enableOobLoadReport) {
                WrrSubchannel wrrSubchannel = weightedSubchannel;
                Objects.requireNonNull(wrrSubchannel);
                OrcaOobUtil.setListener((LoadBalancer.Subchannel)weightedSubchannel, wrrSubchannel.new WrrSubchannel.OrcaReportListener(this.config.errorUtilizationPenalty), OrcaOobUtil.OrcaReportingConfig.newBuilder().setReportInterval(this.config.oobReportingPeriodNanos, TimeUnit.NANOSECONDS).build());
                continue;
            }
            OrcaOobUtil.setListener((LoadBalancer.Subchannel)weightedSubchannel, null, null);
        }
    }

    public void shutdown() {
        if (this.weightUpdateTimer != null) {
            this.weightUpdateTimer.cancel();
        }
        super.shutdown();
    }

    static final class WeightedRoundRobinLoadBalancerConfig {
        final long blackoutPeriodNanos;
        final long weightExpirationPeriodNanos;
        final boolean enableOobLoadReport;
        final long oobReportingPeriodNanos;
        final long weightUpdatePeriodNanos;
        final float errorUtilizationPenalty;

        public static Builder newBuilder() {
            return new Builder();
        }

        private WeightedRoundRobinLoadBalancerConfig(long blackoutPeriodNanos, long weightExpirationPeriodNanos, boolean enableOobLoadReport, long oobReportingPeriodNanos, long weightUpdatePeriodNanos, float errorUtilizationPenalty) {
            this.blackoutPeriodNanos = blackoutPeriodNanos;
            this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
            this.enableOobLoadReport = enableOobLoadReport;
            this.oobReportingPeriodNanos = oobReportingPeriodNanos;
            this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
        }

        static final class Builder {
            long blackoutPeriodNanos = 10000000000L;
            long weightExpirationPeriodNanos = 180000000000L;
            boolean enableOobLoadReport = false;
            long oobReportingPeriodNanos = 10000000000L;
            long weightUpdatePeriodNanos = 1000000000L;
            float errorUtilizationPenalty = 1.0f;

            private Builder() {
            }

            Builder setBlackoutPeriodNanos(long blackoutPeriodNanos) {
                this.blackoutPeriodNanos = blackoutPeriodNanos;
                return this;
            }

            Builder setWeightExpirationPeriodNanos(long weightExpirationPeriodNanos) {
                this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
                return this;
            }

            Builder setEnableOobLoadReport(boolean enableOobLoadReport) {
                this.enableOobLoadReport = enableOobLoadReport;
                return this;
            }

            Builder setOobReportingPeriodNanos(long oobReportingPeriodNanos) {
                this.oobReportingPeriodNanos = oobReportingPeriodNanos;
                return this;
            }

            Builder setWeightUpdatePeriodNanos(long weightUpdatePeriodNanos) {
                this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
                return this;
            }

            Builder setErrorUtilizationPenalty(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
                return this;
            }

            WeightedRoundRobinLoadBalancerConfig build() {
                return new WeightedRoundRobinLoadBalancerConfig(this.blackoutPeriodNanos, this.weightExpirationPeriodNanos, this.enableOobLoadReport, this.oobReportingPeriodNanos, this.weightUpdatePeriodNanos, this.errorUtilizationPenalty);
            }
        }
    }

    @VisibleForTesting
    static final class StaticStrideScheduler {
        private final short[] scaledWeights;
        private final AtomicInteger sequence;
        private static final int K_MAX_WEIGHT = 65535;

        StaticStrideScheduler(float[] weights, Random random) {
            Preconditions.checkArgument((weights.length >= 1 ? 1 : 0) != 0, (Object)"Couldn't build scheduler: requires at least one weight");
            int numChannels = weights.length;
            int numWeightedChannels = 0;
            double sumWeight = 0.0;
            float maxWeight = 0.0f;
            short meanWeight = 0;
            for (float weight : weights) {
                if (!(weight > 0.0f)) continue;
                sumWeight += (double)weight;
                maxWeight = Math.max(weight, maxWeight);
                ++numWeightedChannels;
            }
            double scalingFactor = 65535.0f / maxWeight;
            meanWeight = numWeightedChannels > 0 ? (short)Math.round(scalingFactor * sumWeight / (double)numWeightedChannels) : (short)Math.round(scalingFactor);
            short[] scaledWeights = new short[numChannels];
            for (int i = 0; i < numChannels; ++i) {
                scaledWeights[i] = weights[i] <= 0.0f ? meanWeight : (short)Math.round((double)weights[i] * scalingFactor);
            }
            this.scaledWeights = scaledWeights;
            this.sequence = new AtomicInteger(random.nextInt());
        }

        private long nextSequence() {
            return Integer.toUnsignedLong(this.sequence.getAndIncrement());
        }

        @VisibleForTesting
        long getSequence() {
            return Integer.toUnsignedLong(this.sequence.get());
        }

        int pick() {
            long offset;
            long generation;
            int backendIndex;
            int weight;
            int i = 0;
            do {
                ++i;
                long sequence = this.nextSequence();
                backendIndex = (int)(sequence % (long)this.scaledWeights.length);
                generation = sequence / (long)this.scaledWeights.length;
            } while (((long)(weight = Short.toUnsignedInt(this.scaledWeights[backendIndex])) * generation + (offset = 32767L * (long)backendIndex)) % 65535L < (long)(65535 - weight));
            assert (i <= this.scaledWeights.length) : "scheduler has more than one pass through";
            return backendIndex;
        }
    }

    @VisibleForTesting
    final class WeightedRoundRobinPicker
    extends RoundRobinLoadBalancer.RoundRobinPicker {
        private final List<LoadBalancer.Subchannel> list;
        private final Map<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener> subchannelToReportListenerMap = new HashMap<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener>();
        private final boolean enableOobLoadReport;
        private final float errorUtilizationPenalty;
        private volatile StaticStrideScheduler scheduler;

        WeightedRoundRobinPicker(List<LoadBalancer.Subchannel> list, boolean enableOobLoadReport, float errorUtilizationPenalty) {
            Preconditions.checkNotNull(list, (Object)"list");
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"empty list");
            this.list = list;
            for (LoadBalancer.Subchannel subchannel : list) {
                WrrSubchannel wrrSubchannel = (WrrSubchannel)subchannel;
                Objects.requireNonNull(wrrSubchannel);
                this.subchannelToReportListenerMap.put(subchannel, wrrSubchannel.new WrrSubchannel.OrcaReportListener(errorUtilizationPenalty));
            }
            this.enableOobLoadReport = enableOobLoadReport;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
            this.updateWeight();
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            LoadBalancer.Subchannel subchannel = this.list.get(this.scheduler.pick());
            if (!this.enableOobLoadReport) {
                OrcaPerRequestUtil orcaPerRequestUtil = OrcaPerRequestUtil.getInstance();
                WrrSubchannel wrrSubchannel = (WrrSubchannel)subchannel;
                Objects.requireNonNull(wrrSubchannel);
                return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel, (ClientStreamTracer.Factory)orcaPerRequestUtil.newOrcaClientStreamTracerFactory(this.subchannelToReportListenerMap.getOrDefault(subchannel, wrrSubchannel.new WrrSubchannel.OrcaReportListener(this.errorUtilizationPenalty))));
            }
            return LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
        }

        private void updateWeight() {
            StaticStrideScheduler scheduler;
            float[] newWeights = new float[this.list.size()];
            for (int i = 0; i < this.list.size(); ++i) {
                WrrSubchannel subchannel = (WrrSubchannel)this.list.get(i);
                double newWeight = subchannel.getWeight();
                newWeights[i] = newWeight > 0.0 ? (float)newWeight : 0.0f;
            }
            this.scheduler = scheduler = new StaticStrideScheduler(newWeights, WeightedRoundRobinLoadBalancer.this.random);
        }

        public String toString() {
            return MoreObjects.toStringHelper(WeightedRoundRobinPicker.class).add("enableOobLoadReport", this.enableOobLoadReport).add("errorUtilizationPenalty", this.errorUtilizationPenalty).add("list", this.list).toString();
        }

        @VisibleForTesting
        List<LoadBalancer.Subchannel> getList() {
            return this.list;
        }

        public boolean isEquivalentTo(RoundRobinLoadBalancer.RoundRobinPicker picker) {
            if (!(picker instanceof WeightedRoundRobinPicker)) {
                return false;
            }
            WeightedRoundRobinPicker other = (WeightedRoundRobinPicker)picker;
            if (other == this) {
                return true;
            }
            return this.enableOobLoadReport == other.enableOobLoadReport && Float.compare(this.errorUtilizationPenalty, other.errorUtilizationPenalty) == 0 && this.list.size() == other.list.size() && new HashSet<LoadBalancer.Subchannel>(this.list).containsAll(other.list);
        }
    }

    @VisibleForTesting
    final class WrrSubchannel
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private volatile long lastUpdated;
        private volatile long nonEmptySince;
        private volatile double weight;

        WrrSubchannel(LoadBalancer.Subchannel delegate) {
            this.delegate = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        public void start(final LoadBalancer.SubchannelStateListener listener) {
            this.delegate().start(new LoadBalancer.SubchannelStateListener(){

                public void onSubchannelState(ConnectivityStateInfo newState) {
                    if (newState.getState().equals((Object)ConnectivityState.READY)) {
                        WrrSubchannel.this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                    }
                    listener.onSubchannelState(newState);
                }
            });
        }

        private double getWeight() {
            if (WeightedRoundRobinLoadBalancer.this.config == null) {
                return 0.0;
            }
            long now = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
            if (now - this.lastUpdated >= ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightExpirationPeriodNanos) {
                this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                return 0.0;
            }
            if (now - this.nonEmptySince < ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos && ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos > 0L) {
                return 0.0;
            }
            return this.weight;
        }

        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        final class OrcaReportListener
        implements OrcaPerRequestUtil.OrcaPerRequestReportListener,
        OrcaOobUtil.OrcaOobReportListener {
            private final float errorUtilizationPenalty;

            OrcaReportListener(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
            }

            @Override
            public void onLoadReport(MetricReport report) {
                double utilization;
                double newWeight = 0.0;
                double d = utilization = report.getApplicationUtilization() > 0.0 ? report.getApplicationUtilization() : report.getCpuUtilization();
                if (utilization > 0.0 && report.getQps() > 0.0) {
                    double penalty = 0.0;
                    if (report.getEps() > 0.0 && this.errorUtilizationPenalty > 0.0f) {
                        penalty = report.getEps() / report.getQps() * (double)this.errorUtilizationPenalty;
                    }
                    newWeight = report.getQps() / (utilization + penalty);
                }
                if (newWeight == 0.0) {
                    return;
                }
                if (WrrSubchannel.this.nonEmptySince == WeightedRoundRobinLoadBalancer.this.infTime) {
                    WrrSubchannel.this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                }
                WrrSubchannel.this.lastUpdated = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                WrrSubchannel.this.weight = newWeight;
            }
        }
    }

    private static final class WrrHelper
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private WeightedRoundRobinLoadBalancer wrr;

        WrrHelper(LoadBalancer.Helper helper) {
            this.delegate = helper;
        }

        void setLoadBalancer(WeightedRoundRobinLoadBalancer lb) {
            this.wrr = lb;
        }

        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            WeightedRoundRobinLoadBalancer weightedRoundRobinLoadBalancer = this.wrr;
            Objects.requireNonNull(weightedRoundRobinLoadBalancer);
            return weightedRoundRobinLoadBalancer.new WrrSubchannel(this.delegate().createSubchannel(args));
        }
    }

    private final class UpdateWeightTask
    implements Runnable {
        private UpdateWeightTask() {
        }

        @Override
        public void run() {
            if (WeightedRoundRobinLoadBalancer.this.currentPicker != null && WeightedRoundRobinLoadBalancer.this.currentPicker instanceof WeightedRoundRobinPicker) {
                ((WeightedRoundRobinPicker)WeightedRoundRobinLoadBalancer.this.currentPicker).updateWeight();
            }
            WeightedRoundRobinLoadBalancer.this.weightUpdateTimer = WeightedRoundRobinLoadBalancer.this.syncContext.schedule((Runnable)this, ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightUpdatePeriodNanos, TimeUnit.NANOSECONDS, WeightedRoundRobinLoadBalancer.this.timeService);
        }
    }
}

