// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/config/listener/v3/listener_components.proto

package io.envoyproxy.envoy.config.listener.v3;

/**
 * <pre>
 * Specifies the match criteria for selecting a specific filter chain for a
 * listener.
 *
 * In order for a filter chain to be selected, *ALL* of its criteria must be
 * fulfilled by the incoming connection, properties of which are set by the
 * networking stack and/or listener filters.
 *
 * The following order applies:
 *
 * 1. Destination port.
 * 2. Destination IP address.
 * 3. Server name (e.g. SNI for TLS protocol),
 * 4. Transport protocol.
 * 5. Application protocols (e.g. ALPN for TLS protocol).
 * 6. Directly connected source IP address (this will only be different from the source IP address
 *    when using a listener filter that overrides the source address, such as the :ref:`Proxy Protocol
 *    listener filter &lt;config_listener_filters_proxy_protocol&gt;`).
 * 7. Source type (e.g. any, local or external network).
 * 8. Source IP address.
 * 9. Source port.
 *
 * For criteria that allow ranges or wildcards, the most specific value in any
 * of the configured filter chains that matches the incoming connection is going
 * to be used (e.g. for SNI ``www.example.com`` the most specific match would be
 * ``www.example.com``, then ``*.example.com``, then ``*.com``, then any filter
 * chain without ``server_names`` requirements).
 *
 * A different way to reason about the filter chain matches:
 * Suppose there exists N filter chains. Prune the filter chain set using the above 8 steps.
 * In each step, filter chains which most specifically matches the attributes continue to the next step.
 * The listener guarantees at most 1 filter chain is left after all of the steps.
 *
 * Example:
 *
 * For destination port, filter chains specifying the destination port of incoming traffic are the
 * most specific match. If none of the filter chains specifies the exact destination port, the filter
 * chains which do not specify ports are the most specific match. Filter chains specifying the
 * wrong port can never be the most specific match.
 *
 * [#comment: Implemented rules are kept in the preference order, with deprecated fields
 * listed at the end, because that's how we want to list them in the docs.
 *
 * [#comment:TODO(PiotrSikora): Add support for configurable precedence of the rules]
 * [#next-free-field: 14]
 * </pre>
 *
 * Protobuf type {@code envoy.config.listener.v3.FilterChainMatch}
 */
public final class FilterChainMatch extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.config.listener.v3.FilterChainMatch)
    FilterChainMatchOrBuilder {
private static final long serialVersionUID = 0L;
  // Use FilterChainMatch.newBuilder() to construct.
  private FilterChainMatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private FilterChainMatch() {
    prefixRanges_ = java.util.Collections.emptyList();
    addressSuffix_ = "";
    directSourcePrefixRanges_ = java.util.Collections.emptyList();
    sourceType_ = 0;
    sourcePrefixRanges_ = java.util.Collections.emptyList();
    sourcePorts_ = emptyIntList();
    serverNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    transportProtocol_ = "";
    applicationProtocols_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new FilterChainMatch();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.config.listener.v3.ListenerComponentsProto.internal_static_envoy_config_listener_v3_FilterChainMatch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.config.listener.v3.ListenerComponentsProto.internal_static_envoy_config_listener_v3_FilterChainMatch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.class, io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.Builder.class);
  }

  /**
   * Protobuf enum {@code envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType}
   */
  public enum ConnectionSourceType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Any connection source matches.
     * </pre>
     *
     * <code>ANY = 0;</code>
     */
    ANY(0),
    /**
     * <pre>
     * Match a connection originating from the same host.
     * </pre>
     *
     * <code>SAME_IP_OR_LOOPBACK = 1;</code>
     */
    SAME_IP_OR_LOOPBACK(1),
    /**
     * <pre>
     * Match a connection originating from a different host.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    EXTERNAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Any connection source matches.
     * </pre>
     *
     * <code>ANY = 0;</code>
     */
    public static final int ANY_VALUE = 0;
    /**
     * <pre>
     * Match a connection originating from the same host.
     * </pre>
     *
     * <code>SAME_IP_OR_LOOPBACK = 1;</code>
     */
    public static final int SAME_IP_OR_LOOPBACK_VALUE = 1;
    /**
     * <pre>
     * Match a connection originating from a different host.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    public static final int EXTERNAL_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectionSourceType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConnectionSourceType forNumber(int value) {
      switch (value) {
        case 0: return ANY;
        case 1: return SAME_IP_OR_LOOPBACK;
        case 2: return EXTERNAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectionSourceType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ConnectionSourceType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ConnectionSourceType>() {
            public ConnectionSourceType findValueByNumber(int number) {
              return ConnectionSourceType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.getDescriptor().getEnumTypes().get(0);
    }

    private static final ConnectionSourceType[] VALUES = values();

    public static ConnectionSourceType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectionSourceType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType)
  }

  public static final int DESTINATION_PORT_FIELD_NUMBER = 8;
  private com.google.protobuf.UInt32Value destinationPort_;
  /**
   * <pre>
   * Optional destination port to consider when use_original_dst is set on the
   * listener in determining a filter chain match.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
   * @return Whether the destinationPort field is set.
   */
  @java.lang.Override
  public boolean hasDestinationPort() {
    return destinationPort_ != null;
  }
  /**
   * <pre>
   * Optional destination port to consider when use_original_dst is set on the
   * listener in determining a filter chain match.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
   * @return The destinationPort.
   */
  @java.lang.Override
  public com.google.protobuf.UInt32Value getDestinationPort() {
    return destinationPort_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : destinationPort_;
  }
  /**
   * <pre>
   * Optional destination port to consider when use_original_dst is set on the
   * listener in determining a filter chain match.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public com.google.protobuf.UInt32ValueOrBuilder getDestinationPortOrBuilder() {
    return destinationPort_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : destinationPort_;
  }

  public static final int PREFIX_RANGES_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> prefixRanges_;
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> getPrefixRangesList() {
    return prefixRanges_;
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
      getPrefixRangesOrBuilderList() {
    return prefixRanges_;
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
   */
  @java.lang.Override
  public int getPrefixRangesCount() {
    return prefixRanges_.size();
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.CidrRange getPrefixRanges(int index) {
    return prefixRanges_.get(index);
  }
  /**
   * <pre>
   * If non-empty, an IP address and prefix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder getPrefixRangesOrBuilder(
      int index) {
    return prefixRanges_.get(index);
  }

  public static final int ADDRESS_SUFFIX_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private volatile java.lang.Object addressSuffix_ = "";
  /**
   * <pre>
   * If non-empty, an IP address and suffix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>string address_suffix = 4;</code>
   * @return The addressSuffix.
   */
  @java.lang.Override
  public java.lang.String getAddressSuffix() {
    java.lang.Object ref = addressSuffix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      addressSuffix_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * If non-empty, an IP address and suffix length to match addresses when the
   * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>string address_suffix = 4;</code>
   * @return The bytes for addressSuffix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAddressSuffixBytes() {
    java.lang.Object ref = addressSuffix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      addressSuffix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUFFIX_LEN_FIELD_NUMBER = 5;
  private com.google.protobuf.UInt32Value suffixLen_;
  /**
   * <pre>
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
   * @return Whether the suffixLen field is set.
   */
  @java.lang.Override
  public boolean hasSuffixLen() {
    return suffixLen_ != null;
  }
  /**
   * <pre>
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
   * @return The suffixLen.
   */
  @java.lang.Override
  public com.google.protobuf.UInt32Value getSuffixLen() {
    return suffixLen_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : suffixLen_;
  }
  /**
   * <pre>
   * [#not-implemented-hide:]
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.UInt32ValueOrBuilder getSuffixLenOrBuilder() {
    return suffixLen_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : suffixLen_;
  }

  public static final int DIRECT_SOURCE_PREFIX_RANGES_FIELD_NUMBER = 13;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> directSourcePrefixRanges_;
  /**
   * <pre>
   * The criteria is satisfied if the directly connected source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the parameter is not
   * specified or the list is empty, the directly connected source IP address is ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> getDirectSourcePrefixRangesList() {
    return directSourcePrefixRanges_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the directly connected source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the parameter is not
   * specified or the list is empty, the directly connected source IP address is ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
      getDirectSourcePrefixRangesOrBuilderList() {
    return directSourcePrefixRanges_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the directly connected source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the parameter is not
   * specified or the list is empty, the directly connected source IP address is ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
   */
  @java.lang.Override
  public int getDirectSourcePrefixRangesCount() {
    return directSourcePrefixRanges_.size();
  }
  /**
   * <pre>
   * The criteria is satisfied if the directly connected source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the parameter is not
   * specified or the list is empty, the directly connected source IP address is ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.CidrRange getDirectSourcePrefixRanges(int index) {
    return directSourcePrefixRanges_.get(index);
  }
  /**
   * <pre>
   * The criteria is satisfied if the directly connected source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the parameter is not
   * specified or the list is empty, the directly connected source IP address is ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder getDirectSourcePrefixRangesOrBuilder(
      int index) {
    return directSourcePrefixRanges_.get(index);
  }

  public static final int SOURCE_TYPE_FIELD_NUMBER = 12;
  private int sourceType_ = 0;
  /**
   * <pre>
   * Specifies the connection source IP match type. Can be any, local or external network.
   * </pre>
   *
   * <code>.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
   * @return The enum numeric value on the wire for sourceType.
   */
  @java.lang.Override public int getSourceTypeValue() {
    return sourceType_;
  }
  /**
   * <pre>
   * Specifies the connection source IP match type. Can be any, local or external network.
   * </pre>
   *
   * <code>.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
   * @return The sourceType.
   */
  @java.lang.Override public io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType getSourceType() {
    io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType result = io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType.forNumber(sourceType_);
    return result == null ? io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType.UNRECOGNIZED : result;
  }

  public static final int SOURCE_PREFIX_RANGES_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> sourcePrefixRanges_;
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> getSourcePrefixRangesList() {
    return sourcePrefixRanges_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
      getSourcePrefixRangesOrBuilderList() {
    return sourcePrefixRanges_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
   */
  @java.lang.Override
  public int getSourcePrefixRangesCount() {
    return sourcePrefixRanges_.size();
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.CidrRange getSourcePrefixRanges(int index) {
    return sourcePrefixRanges_.get(index);
  }
  /**
   * <pre>
   * The criteria is satisfied if the source IP address of the downstream
   * connection is contained in at least one of the specified subnets. If the
   * parameter is not specified or the list is empty, the source IP address is
   * ignored.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder getSourcePrefixRangesOrBuilder(
      int index) {
    return sourcePrefixRanges_.get(index);
  }

  public static final int SOURCE_PORTS_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList sourcePorts_;
  /**
   * <pre>
   * The criteria is satisfied if the source port of the downstream connection
   * is contained in at least one of the specified ports. If the parameter is
   * not specified, the source port is ignored.
   * </pre>
   *
   * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
   * @return A list containing the sourcePorts.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer>
      getSourcePortsList() {
    return sourcePorts_;
  }
  /**
   * <pre>
   * The criteria is satisfied if the source port of the downstream connection
   * is contained in at least one of the specified ports. If the parameter is
   * not specified, the source port is ignored.
   * </pre>
   *
   * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
   * @return The count of sourcePorts.
   */
  public int getSourcePortsCount() {
    return sourcePorts_.size();
  }
  /**
   * <pre>
   * The criteria is satisfied if the source port of the downstream connection
   * is contained in at least one of the specified ports. If the parameter is
   * not specified, the source port is ignored.
   * </pre>
   *
   * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
   * @param index The index of the element to return.
   * @return The sourcePorts at the given index.
   */
  public int getSourcePorts(int index) {
    return sourcePorts_.getInt(index);
  }
  private int sourcePortsMemoizedSerializedSize = -1;

  public static final int SERVER_NAMES_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList serverNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   *
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   *
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
   *
   * .. attention::
   *
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   * @return A list containing the serverNames.
   */
  public com.google.protobuf.ProtocolStringList
      getServerNamesList() {
    return serverNames_;
  }
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   *
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   *
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
   *
   * .. attention::
   *
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   * @return The count of serverNames.
   */
  public int getServerNamesCount() {
    return serverNames_.size();
  }
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   *
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   *
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
   *
   * .. attention::
   *
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   * @param index The index of the element to return.
   * @return The serverNames at the given index.
   */
  public java.lang.String getServerNames(int index) {
    return serverNames_.get(index);
  }
  /**
   * <pre>
   * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
   * a filter chain match. Those values will be compared against the server names of a new
   * connection, when detected by one of the listener filters.
   *
   * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
   * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
   *
   * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
   * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
   *
   * .. attention::
   *
   *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
   *   information.
   * </pre>
   *
   * <code>repeated string server_names = 11;</code>
   * @param index The index of the value to return.
   * @return The bytes of the serverNames at the given index.
   */
  public com.google.protobuf.ByteString
      getServerNamesBytes(int index) {
    return serverNames_.getByteString(index);
  }

  public static final int TRANSPORT_PROTOCOL_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private volatile java.lang.Object transportProtocol_ = "";
  /**
   * <pre>
   * If non-empty, a transport protocol to consider when determining a filter chain match.
   * This value will be compared against the transport protocol of a new connection, when
   * it's detected by one of the listener filters.
   *
   * Suggested values include:
   *
   * * ``raw_buffer`` - default, used when no transport protocol is detected,
   * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *   when TLS protocol is detected.
   * </pre>
   *
   * <code>string transport_protocol = 9;</code>
   * @return The transportProtocol.
   */
  @java.lang.Override
  public java.lang.String getTransportProtocol() {
    java.lang.Object ref = transportProtocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      transportProtocol_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * If non-empty, a transport protocol to consider when determining a filter chain match.
   * This value will be compared against the transport protocol of a new connection, when
   * it's detected by one of the listener filters.
   *
   * Suggested values include:
   *
   * * ``raw_buffer`` - default, used when no transport protocol is detected,
   * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *   when TLS protocol is detected.
   * </pre>
   *
   * <code>string transport_protocol = 9;</code>
   * @return The bytes for transportProtocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getTransportProtocolBytes() {
    java.lang.Object ref = transportProtocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      transportProtocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APPLICATION_PROTOCOLS_FIELD_NUMBER = 10;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList applicationProtocols_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   *
   * Suggested values include:
   *
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *
   * .. attention::
   *
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   * @return A list containing the applicationProtocols.
   */
  public com.google.protobuf.ProtocolStringList
      getApplicationProtocolsList() {
    return applicationProtocols_;
  }
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   *
   * Suggested values include:
   *
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *
   * .. attention::
   *
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   * @return The count of applicationProtocols.
   */
  public int getApplicationProtocolsCount() {
    return applicationProtocols_.size();
  }
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   *
   * Suggested values include:
   *
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *
   * .. attention::
   *
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   * @param index The index of the element to return.
   * @return The applicationProtocols at the given index.
   */
  public java.lang.String getApplicationProtocols(int index) {
    return applicationProtocols_.get(index);
  }
  /**
   * <pre>
   * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
   * determining a filter chain match. Those values will be compared against the application
   * protocols of a new connection, when detected by one of the listener filters.
   *
   * Suggested values include:
   *
   * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
   *   &lt;config_listener_filters_tls_inspector&gt;`,
   * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
   *
   * .. attention::
   *
   *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
   *   application protocol detection based on the requested
   *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
   *
   *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
   *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
   *   unless all connecting clients are known to use ALPN.
   * </pre>
   *
   * <code>repeated string application_protocols = 10;</code>
   * @param index The index of the value to return.
   * @return The bytes of the applicationProtocols at the given index.
   */
  public com.google.protobuf.ByteString
      getApplicationProtocolsBytes(int index) {
    return applicationProtocols_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < prefixRanges_.size(); i++) {
      output.writeMessage(3, prefixRanges_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(addressSuffix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, addressSuffix_);
    }
    if (suffixLen_ != null) {
      output.writeMessage(5, getSuffixLen());
    }
    for (int i = 0; i < sourcePrefixRanges_.size(); i++) {
      output.writeMessage(6, sourcePrefixRanges_.get(i));
    }
    if (getSourcePortsList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(sourcePortsMemoizedSerializedSize);
    }
    for (int i = 0; i < sourcePorts_.size(); i++) {
      output.writeUInt32NoTag(sourcePorts_.getInt(i));
    }
    if (destinationPort_ != null) {
      output.writeMessage(8, getDestinationPort());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transportProtocol_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, transportProtocol_);
    }
    for (int i = 0; i < applicationProtocols_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, applicationProtocols_.getRaw(i));
    }
    for (int i = 0; i < serverNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, serverNames_.getRaw(i));
    }
    if (sourceType_ != io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType.ANY.getNumber()) {
      output.writeEnum(12, sourceType_);
    }
    for (int i = 0; i < directSourcePrefixRanges_.size(); i++) {
      output.writeMessage(13, directSourcePrefixRanges_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < prefixRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, prefixRanges_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(addressSuffix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, addressSuffix_);
    }
    if (suffixLen_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getSuffixLen());
    }
    for (int i = 0; i < sourcePrefixRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, sourcePrefixRanges_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourcePorts_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(sourcePorts_.getInt(i));
      }
      size += dataSize;
      if (!getSourcePortsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream
            .computeInt32SizeNoTag(dataSize);
      }
      sourcePortsMemoizedSerializedSize = dataSize;
    }
    if (destinationPort_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, getDestinationPort());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transportProtocol_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, transportProtocol_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < applicationProtocols_.size(); i++) {
        dataSize += computeStringSizeNoTag(applicationProtocols_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getApplicationProtocolsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < serverNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(serverNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getServerNamesList().size();
    }
    if (sourceType_ != io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType.ANY.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(12, sourceType_);
    }
    for (int i = 0; i < directSourcePrefixRanges_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(13, directSourcePrefixRanges_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.config.listener.v3.FilterChainMatch)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.config.listener.v3.FilterChainMatch other = (io.envoyproxy.envoy.config.listener.v3.FilterChainMatch) obj;

    if (hasDestinationPort() != other.hasDestinationPort()) return false;
    if (hasDestinationPort()) {
      if (!getDestinationPort()
          .equals(other.getDestinationPort())) return false;
    }
    if (!getPrefixRangesList()
        .equals(other.getPrefixRangesList())) return false;
    if (!getAddressSuffix()
        .equals(other.getAddressSuffix())) return false;
    if (hasSuffixLen() != other.hasSuffixLen()) return false;
    if (hasSuffixLen()) {
      if (!getSuffixLen()
          .equals(other.getSuffixLen())) return false;
    }
    if (!getDirectSourcePrefixRangesList()
        .equals(other.getDirectSourcePrefixRangesList())) return false;
    if (sourceType_ != other.sourceType_) return false;
    if (!getSourcePrefixRangesList()
        .equals(other.getSourcePrefixRangesList())) return false;
    if (!getSourcePortsList()
        .equals(other.getSourcePortsList())) return false;
    if (!getServerNamesList()
        .equals(other.getServerNamesList())) return false;
    if (!getTransportProtocol()
        .equals(other.getTransportProtocol())) return false;
    if (!getApplicationProtocolsList()
        .equals(other.getApplicationProtocolsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDestinationPort()) {
      hash = (37 * hash) + DESTINATION_PORT_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationPort().hashCode();
    }
    if (getPrefixRangesCount() > 0) {
      hash = (37 * hash) + PREFIX_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getPrefixRangesList().hashCode();
    }
    hash = (37 * hash) + ADDRESS_SUFFIX_FIELD_NUMBER;
    hash = (53 * hash) + getAddressSuffix().hashCode();
    if (hasSuffixLen()) {
      hash = (37 * hash) + SUFFIX_LEN_FIELD_NUMBER;
      hash = (53 * hash) + getSuffixLen().hashCode();
    }
    if (getDirectSourcePrefixRangesCount() > 0) {
      hash = (37 * hash) + DIRECT_SOURCE_PREFIX_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getDirectSourcePrefixRangesList().hashCode();
    }
    hash = (37 * hash) + SOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + sourceType_;
    if (getSourcePrefixRangesCount() > 0) {
      hash = (37 * hash) + SOURCE_PREFIX_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePrefixRangesList().hashCode();
    }
    if (getSourcePortsCount() > 0) {
      hash = (37 * hash) + SOURCE_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePortsList().hashCode();
    }
    if (getServerNamesCount() > 0) {
      hash = (37 * hash) + SERVER_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getServerNamesList().hashCode();
    }
    hash = (37 * hash) + TRANSPORT_PROTOCOL_FIELD_NUMBER;
    hash = (53 * hash) + getTransportProtocol().hashCode();
    if (getApplicationProtocolsCount() > 0) {
      hash = (37 * hash) + APPLICATION_PROTOCOLS_FIELD_NUMBER;
      hash = (53 * hash) + getApplicationProtocolsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.config.listener.v3.FilterChainMatch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies the match criteria for selecting a specific filter chain for a
   * listener.
   *
   * In order for a filter chain to be selected, *ALL* of its criteria must be
   * fulfilled by the incoming connection, properties of which are set by the
   * networking stack and/or listener filters.
   *
   * The following order applies:
   *
   * 1. Destination port.
   * 2. Destination IP address.
   * 3. Server name (e.g. SNI for TLS protocol),
   * 4. Transport protocol.
   * 5. Application protocols (e.g. ALPN for TLS protocol).
   * 6. Directly connected source IP address (this will only be different from the source IP address
   *    when using a listener filter that overrides the source address, such as the :ref:`Proxy Protocol
   *    listener filter &lt;config_listener_filters_proxy_protocol&gt;`).
   * 7. Source type (e.g. any, local or external network).
   * 8. Source IP address.
   * 9. Source port.
   *
   * For criteria that allow ranges or wildcards, the most specific value in any
   * of the configured filter chains that matches the incoming connection is going
   * to be used (e.g. for SNI ``www.example.com`` the most specific match would be
   * ``www.example.com``, then ``*.example.com``, then ``*.com``, then any filter
   * chain without ``server_names`` requirements).
   *
   * A different way to reason about the filter chain matches:
   * Suppose there exists N filter chains. Prune the filter chain set using the above 8 steps.
   * In each step, filter chains which most specifically matches the attributes continue to the next step.
   * The listener guarantees at most 1 filter chain is left after all of the steps.
   *
   * Example:
   *
   * For destination port, filter chains specifying the destination port of incoming traffic are the
   * most specific match. If none of the filter chains specifies the exact destination port, the filter
   * chains which do not specify ports are the most specific match. Filter chains specifying the
   * wrong port can never be the most specific match.
   *
   * [#comment: Implemented rules are kept in the preference order, with deprecated fields
   * listed at the end, because that's how we want to list them in the docs.
   *
   * [#comment:TODO(PiotrSikora): Add support for configurable precedence of the rules]
   * [#next-free-field: 14]
   * </pre>
   *
   * Protobuf type {@code envoy.config.listener.v3.FilterChainMatch}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.config.listener.v3.FilterChainMatch)
      io.envoyproxy.envoy.config.listener.v3.FilterChainMatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.listener.v3.ListenerComponentsProto.internal_static_envoy_config_listener_v3_FilterChainMatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.listener.v3.ListenerComponentsProto.internal_static_envoy_config_listener_v3_FilterChainMatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.class, io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      destinationPort_ = null;
      if (destinationPortBuilder_ != null) {
        destinationPortBuilder_.dispose();
        destinationPortBuilder_ = null;
      }
      if (prefixRangesBuilder_ == null) {
        prefixRanges_ = java.util.Collections.emptyList();
      } else {
        prefixRanges_ = null;
        prefixRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      addressSuffix_ = "";
      suffixLen_ = null;
      if (suffixLenBuilder_ != null) {
        suffixLenBuilder_.dispose();
        suffixLenBuilder_ = null;
      }
      if (directSourcePrefixRangesBuilder_ == null) {
        directSourcePrefixRanges_ = java.util.Collections.emptyList();
      } else {
        directSourcePrefixRanges_ = null;
        directSourcePrefixRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      sourceType_ = 0;
      if (sourcePrefixRangesBuilder_ == null) {
        sourcePrefixRanges_ = java.util.Collections.emptyList();
      } else {
        sourcePrefixRanges_ = null;
        sourcePrefixRangesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      sourcePorts_ = emptyIntList();
      serverNames_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      transportProtocol_ = "";
      applicationProtocols_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.config.listener.v3.ListenerComponentsProto.internal_static_envoy_config_listener_v3_FilterChainMatch_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.listener.v3.FilterChainMatch getDefaultInstanceForType() {
      return io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.listener.v3.FilterChainMatch build() {
      io.envoyproxy.envoy.config.listener.v3.FilterChainMatch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.listener.v3.FilterChainMatch buildPartial() {
      io.envoyproxy.envoy.config.listener.v3.FilterChainMatch result = new io.envoyproxy.envoy.config.listener.v3.FilterChainMatch(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(io.envoyproxy.envoy.config.listener.v3.FilterChainMatch result) {
      if (prefixRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          prefixRanges_ = java.util.Collections.unmodifiableList(prefixRanges_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.prefixRanges_ = prefixRanges_;
      } else {
        result.prefixRanges_ = prefixRangesBuilder_.build();
      }
      if (directSourcePrefixRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          directSourcePrefixRanges_ = java.util.Collections.unmodifiableList(directSourcePrefixRanges_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.directSourcePrefixRanges_ = directSourcePrefixRanges_;
      } else {
        result.directSourcePrefixRanges_ = directSourcePrefixRangesBuilder_.build();
      }
      if (sourcePrefixRangesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          sourcePrefixRanges_ = java.util.Collections.unmodifiableList(sourcePrefixRanges_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.sourcePrefixRanges_ = sourcePrefixRanges_;
      } else {
        result.sourcePrefixRanges_ = sourcePrefixRangesBuilder_.build();
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        sourcePorts_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.sourcePorts_ = sourcePorts_;
    }

    private void buildPartial0(io.envoyproxy.envoy.config.listener.v3.FilterChainMatch result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.destinationPort_ = destinationPortBuilder_ == null
            ? destinationPort_
            : destinationPortBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.addressSuffix_ = addressSuffix_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.suffixLen_ = suffixLenBuilder_ == null
            ? suffixLen_
            : suffixLenBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourceType_ = sourceType_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        serverNames_.makeImmutable();
        result.serverNames_ = serverNames_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.transportProtocol_ = transportProtocol_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        applicationProtocols_.makeImmutable();
        result.applicationProtocols_ = applicationProtocols_;
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.config.listener.v3.FilterChainMatch) {
        return mergeFrom((io.envoyproxy.envoy.config.listener.v3.FilterChainMatch)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.config.listener.v3.FilterChainMatch other) {
      if (other == io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.getDefaultInstance()) return this;
      if (other.hasDestinationPort()) {
        mergeDestinationPort(other.getDestinationPort());
      }
      if (prefixRangesBuilder_ == null) {
        if (!other.prefixRanges_.isEmpty()) {
          if (prefixRanges_.isEmpty()) {
            prefixRanges_ = other.prefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePrefixRangesIsMutable();
            prefixRanges_.addAll(other.prefixRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.prefixRanges_.isEmpty()) {
          if (prefixRangesBuilder_.isEmpty()) {
            prefixRangesBuilder_.dispose();
            prefixRangesBuilder_ = null;
            prefixRanges_ = other.prefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000002);
            prefixRangesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getPrefixRangesFieldBuilder() : null;
          } else {
            prefixRangesBuilder_.addAllMessages(other.prefixRanges_);
          }
        }
      }
      if (!other.getAddressSuffix().isEmpty()) {
        addressSuffix_ = other.addressSuffix_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasSuffixLen()) {
        mergeSuffixLen(other.getSuffixLen());
      }
      if (directSourcePrefixRangesBuilder_ == null) {
        if (!other.directSourcePrefixRanges_.isEmpty()) {
          if (directSourcePrefixRanges_.isEmpty()) {
            directSourcePrefixRanges_ = other.directSourcePrefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureDirectSourcePrefixRangesIsMutable();
            directSourcePrefixRanges_.addAll(other.directSourcePrefixRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.directSourcePrefixRanges_.isEmpty()) {
          if (directSourcePrefixRangesBuilder_.isEmpty()) {
            directSourcePrefixRangesBuilder_.dispose();
            directSourcePrefixRangesBuilder_ = null;
            directSourcePrefixRanges_ = other.directSourcePrefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000010);
            directSourcePrefixRangesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDirectSourcePrefixRangesFieldBuilder() : null;
          } else {
            directSourcePrefixRangesBuilder_.addAllMessages(other.directSourcePrefixRanges_);
          }
        }
      }
      if (other.sourceType_ != 0) {
        setSourceTypeValue(other.getSourceTypeValue());
      }
      if (sourcePrefixRangesBuilder_ == null) {
        if (!other.sourcePrefixRanges_.isEmpty()) {
          if (sourcePrefixRanges_.isEmpty()) {
            sourcePrefixRanges_ = other.sourcePrefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureSourcePrefixRangesIsMutable();
            sourcePrefixRanges_.addAll(other.sourcePrefixRanges_);
          }
          onChanged();
        }
      } else {
        if (!other.sourcePrefixRanges_.isEmpty()) {
          if (sourcePrefixRangesBuilder_.isEmpty()) {
            sourcePrefixRangesBuilder_.dispose();
            sourcePrefixRangesBuilder_ = null;
            sourcePrefixRanges_ = other.sourcePrefixRanges_;
            bitField0_ = (bitField0_ & ~0x00000040);
            sourcePrefixRangesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getSourcePrefixRangesFieldBuilder() : null;
          } else {
            sourcePrefixRangesBuilder_.addAllMessages(other.sourcePrefixRanges_);
          }
        }
      }
      if (!other.sourcePorts_.isEmpty()) {
        if (sourcePorts_.isEmpty()) {
          sourcePorts_ = other.sourcePorts_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureSourcePortsIsMutable();
          sourcePorts_.addAll(other.sourcePorts_);
        }
        onChanged();
      }
      if (!other.serverNames_.isEmpty()) {
        if (serverNames_.isEmpty()) {
          serverNames_ = other.serverNames_;
          bitField0_ |= 0x00000100;
        } else {
          ensureServerNamesIsMutable();
          serverNames_.addAll(other.serverNames_);
        }
        onChanged();
      }
      if (!other.getTransportProtocol().isEmpty()) {
        transportProtocol_ = other.transportProtocol_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.applicationProtocols_.isEmpty()) {
        if (applicationProtocols_.isEmpty()) {
          applicationProtocols_ = other.applicationProtocols_;
          bitField0_ |= 0x00000400;
        } else {
          ensureApplicationProtocolsIsMutable();
          applicationProtocols_.addAll(other.applicationProtocols_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26: {
              io.envoyproxy.envoy.config.core.v3.CidrRange m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.core.v3.CidrRange.parser(),
                      extensionRegistry);
              if (prefixRangesBuilder_ == null) {
                ensurePrefixRangesIsMutable();
                prefixRanges_.add(m);
              } else {
                prefixRangesBuilder_.addMessage(m);
              }
              break;
            } // case 26
            case 34: {
              addressSuffix_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 34
            case 42: {
              input.readMessage(
                  getSuffixLenFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000008;
              break;
            } // case 42
            case 50: {
              io.envoyproxy.envoy.config.core.v3.CidrRange m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.core.v3.CidrRange.parser(),
                      extensionRegistry);
              if (sourcePrefixRangesBuilder_ == null) {
                ensureSourcePrefixRangesIsMutable();
                sourcePrefixRanges_.add(m);
              } else {
                sourcePrefixRangesBuilder_.addMessage(m);
              }
              break;
            } // case 50
            case 56: {
              int v = input.readUInt32();
              ensureSourcePortsIsMutable();
              sourcePorts_.addInt(v);
              break;
            } // case 56
            case 58: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              ensureSourcePortsIsMutable();
              while (input.getBytesUntilLimit() > 0) {
                sourcePorts_.addInt(input.readUInt32());
              }
              input.popLimit(limit);
              break;
            } // case 58
            case 66: {
              input.readMessage(
                  getDestinationPortFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000001;
              break;
            } // case 66
            case 74: {
              transportProtocol_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000200;
              break;
            } // case 74
            case 82: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureApplicationProtocolsIsMutable();
              applicationProtocols_.add(s);
              break;
            } // case 82
            case 90: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureServerNamesIsMutable();
              serverNames_.add(s);
              break;
            } // case 90
            case 96: {
              sourceType_ = input.readEnum();
              bitField0_ |= 0x00000020;
              break;
            } // case 96
            case 106: {
              io.envoyproxy.envoy.config.core.v3.CidrRange m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.core.v3.CidrRange.parser(),
                      extensionRegistry);
              if (directSourcePrefixRangesBuilder_ == null) {
                ensureDirectSourcePrefixRangesIsMutable();
                directSourcePrefixRanges_.add(m);
              } else {
                directSourcePrefixRangesBuilder_.addMessage(m);
              }
              break;
            } // case 106
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.UInt32Value destinationPort_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> destinationPortBuilder_;
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     * @return Whether the destinationPort field is set.
     */
    public boolean hasDestinationPort() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     * @return The destinationPort.
     */
    public com.google.protobuf.UInt32Value getDestinationPort() {
      if (destinationPortBuilder_ == null) {
        return destinationPort_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : destinationPort_;
      } else {
        return destinationPortBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder setDestinationPort(com.google.protobuf.UInt32Value value) {
      if (destinationPortBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationPort_ = value;
      } else {
        destinationPortBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder setDestinationPort(
        com.google.protobuf.UInt32Value.Builder builderForValue) {
      if (destinationPortBuilder_ == null) {
        destinationPort_ = builderForValue.build();
      } else {
        destinationPortBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder mergeDestinationPort(com.google.protobuf.UInt32Value value) {
      if (destinationPortBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0) &&
          destinationPort_ != null &&
          destinationPort_ != com.google.protobuf.UInt32Value.getDefaultInstance()) {
          getDestinationPortBuilder().mergeFrom(value);
        } else {
          destinationPort_ = value;
        }
      } else {
        destinationPortBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public Builder clearDestinationPort() {
      bitField0_ = (bitField0_ & ~0x00000001);
      destinationPort_ = null;
      if (destinationPortBuilder_ != null) {
        destinationPortBuilder_.dispose();
        destinationPortBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public com.google.protobuf.UInt32Value.Builder getDestinationPortBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDestinationPortFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    public com.google.protobuf.UInt32ValueOrBuilder getDestinationPortOrBuilder() {
      if (destinationPortBuilder_ != null) {
        return destinationPortBuilder_.getMessageOrBuilder();
      } else {
        return destinationPort_ == null ?
            com.google.protobuf.UInt32Value.getDefaultInstance() : destinationPort_;
      }
    }
    /**
     * <pre>
     * Optional destination port to consider when use_original_dst is set on the
     * listener in determining a filter chain match.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value destination_port = 8 [(.validate.rules) = { ... }</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> 
        getDestinationPortFieldBuilder() {
      if (destinationPortBuilder_ == null) {
        destinationPortBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder>(
                getDestinationPort(),
                getParentForChildren(),
                isClean());
        destinationPort_ = null;
      }
      return destinationPortBuilder_;
    }

    private java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> prefixRanges_ =
      java.util.Collections.emptyList();
    private void ensurePrefixRangesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        prefixRanges_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v3.CidrRange>(prefixRanges_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> prefixRangesBuilder_;

    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> getPrefixRangesList() {
      if (prefixRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(prefixRanges_);
      } else {
        return prefixRangesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public int getPrefixRangesCount() {
      if (prefixRangesBuilder_ == null) {
        return prefixRanges_.size();
      } else {
        return prefixRangesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange getPrefixRanges(int index) {
      if (prefixRangesBuilder_ == null) {
        return prefixRanges_.get(index);
      } else {
        return prefixRangesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder setPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (prefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrefixRangesIsMutable();
        prefixRanges_.set(index, value);
        onChanged();
      } else {
        prefixRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder setPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        prefixRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (prefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(value);
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (prefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(index, value);
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(
        io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(builderForValue.build());
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addPrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        prefixRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder addAllPrefixRanges(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.core.v3.CidrRange> values) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, prefixRanges_);
        onChanged();
      } else {
        prefixRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder clearPrefixRanges() {
      if (prefixRangesBuilder_ == null) {
        prefixRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        prefixRangesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public Builder removePrefixRanges(int index) {
      if (prefixRangesBuilder_ == null) {
        ensurePrefixRangesIsMutable();
        prefixRanges_.remove(index);
        onChanged();
      } else {
        prefixRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder getPrefixRangesBuilder(
        int index) {
      return getPrefixRangesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder getPrefixRangesOrBuilder(
        int index) {
      if (prefixRangesBuilder_ == null) {
        return prefixRanges_.get(index);  } else {
        return prefixRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
         getPrefixRangesOrBuilderList() {
      if (prefixRangesBuilder_ != null) {
        return prefixRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(prefixRanges_);
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder addPrefixRangesBuilder() {
      return getPrefixRangesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.core.v3.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder addPrefixRangesBuilder(
        int index) {
      return getPrefixRangesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.core.v3.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * If non-empty, an IP address and prefix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange prefix_ranges = 3;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange.Builder> 
         getPrefixRangesBuilderList() {
      return getPrefixRangesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
        getPrefixRangesFieldBuilder() {
      if (prefixRangesBuilder_ == null) {
        prefixRangesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder>(
                prefixRanges_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        prefixRanges_ = null;
      }
      return prefixRangesBuilder_;
    }

    private java.lang.Object addressSuffix_ = "";
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     * @return The addressSuffix.
     */
    public java.lang.String getAddressSuffix() {
      java.lang.Object ref = addressSuffix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        addressSuffix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     * @return The bytes for addressSuffix.
     */
    public com.google.protobuf.ByteString
        getAddressSuffixBytes() {
      java.lang.Object ref = addressSuffix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        addressSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     * @param value The addressSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setAddressSuffix(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      addressSuffix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearAddressSuffix() {
      addressSuffix_ = getDefaultInstance().getAddressSuffix();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, an IP address and suffix length to match addresses when the
     * listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>string address_suffix = 4;</code>
     * @param value The bytes for addressSuffix to set.
     * @return This builder for chaining.
     */
    public Builder setAddressSuffixBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      addressSuffix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.UInt32Value suffixLen_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> suffixLenBuilder_;
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     * @return Whether the suffixLen field is set.
     */
    public boolean hasSuffixLen() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     * @return The suffixLen.
     */
    public com.google.protobuf.UInt32Value getSuffixLen() {
      if (suffixLenBuilder_ == null) {
        return suffixLen_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : suffixLen_;
      } else {
        return suffixLenBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder setSuffixLen(com.google.protobuf.UInt32Value value) {
      if (suffixLenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suffixLen_ = value;
      } else {
        suffixLenBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder setSuffixLen(
        com.google.protobuf.UInt32Value.Builder builderForValue) {
      if (suffixLenBuilder_ == null) {
        suffixLen_ = builderForValue.build();
      } else {
        suffixLenBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder mergeSuffixLen(com.google.protobuf.UInt32Value value) {
      if (suffixLenBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0) &&
          suffixLen_ != null &&
          suffixLen_ != com.google.protobuf.UInt32Value.getDefaultInstance()) {
          getSuffixLenBuilder().mergeFrom(value);
        } else {
          suffixLen_ = value;
        }
      } else {
        suffixLenBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public Builder clearSuffixLen() {
      bitField0_ = (bitField0_ & ~0x00000008);
      suffixLen_ = null;
      if (suffixLenBuilder_ != null) {
        suffixLenBuilder_.dispose();
        suffixLenBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public com.google.protobuf.UInt32Value.Builder getSuffixLenBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getSuffixLenFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    public com.google.protobuf.UInt32ValueOrBuilder getSuffixLenOrBuilder() {
      if (suffixLenBuilder_ != null) {
        return suffixLenBuilder_.getMessageOrBuilder();
      } else {
        return suffixLen_ == null ?
            com.google.protobuf.UInt32Value.getDefaultInstance() : suffixLen_;
      }
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value suffix_len = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> 
        getSuffixLenFieldBuilder() {
      if (suffixLenBuilder_ == null) {
        suffixLenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder>(
                getSuffixLen(),
                getParentForChildren(),
                isClean());
        suffixLen_ = null;
      }
      return suffixLenBuilder_;
    }

    private java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> directSourcePrefixRanges_ =
      java.util.Collections.emptyList();
    private void ensureDirectSourcePrefixRangesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        directSourcePrefixRanges_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v3.CidrRange>(directSourcePrefixRanges_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> directSourcePrefixRangesBuilder_;

    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> getDirectSourcePrefixRangesList() {
      if (directSourcePrefixRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(directSourcePrefixRanges_);
      } else {
        return directSourcePrefixRangesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public int getDirectSourcePrefixRangesCount() {
      if (directSourcePrefixRangesBuilder_ == null) {
        return directSourcePrefixRanges_.size();
      } else {
        return directSourcePrefixRangesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange getDirectSourcePrefixRanges(int index) {
      if (directSourcePrefixRangesBuilder_ == null) {
        return directSourcePrefixRanges_.get(index);
      } else {
        return directSourcePrefixRangesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder setDirectSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (directSourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectSourcePrefixRangesIsMutable();
        directSourcePrefixRanges_.set(index, value);
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder setDirectSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (directSourcePrefixRangesBuilder_ == null) {
        ensureDirectSourcePrefixRangesIsMutable();
        directSourcePrefixRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder addDirectSourcePrefixRanges(io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (directSourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectSourcePrefixRangesIsMutable();
        directSourcePrefixRanges_.add(value);
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder addDirectSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (directSourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDirectSourcePrefixRangesIsMutable();
        directSourcePrefixRanges_.add(index, value);
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder addDirectSourcePrefixRanges(
        io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (directSourcePrefixRangesBuilder_ == null) {
        ensureDirectSourcePrefixRangesIsMutable();
        directSourcePrefixRanges_.add(builderForValue.build());
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder addDirectSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (directSourcePrefixRangesBuilder_ == null) {
        ensureDirectSourcePrefixRangesIsMutable();
        directSourcePrefixRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder addAllDirectSourcePrefixRanges(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.core.v3.CidrRange> values) {
      if (directSourcePrefixRangesBuilder_ == null) {
        ensureDirectSourcePrefixRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, directSourcePrefixRanges_);
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder clearDirectSourcePrefixRanges() {
      if (directSourcePrefixRangesBuilder_ == null) {
        directSourcePrefixRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public Builder removeDirectSourcePrefixRanges(int index) {
      if (directSourcePrefixRangesBuilder_ == null) {
        ensureDirectSourcePrefixRangesIsMutable();
        directSourcePrefixRanges_.remove(index);
        onChanged();
      } else {
        directSourcePrefixRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder getDirectSourcePrefixRangesBuilder(
        int index) {
      return getDirectSourcePrefixRangesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder getDirectSourcePrefixRangesOrBuilder(
        int index) {
      if (directSourcePrefixRangesBuilder_ == null) {
        return directSourcePrefixRanges_.get(index);  } else {
        return directSourcePrefixRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
         getDirectSourcePrefixRangesOrBuilderList() {
      if (directSourcePrefixRangesBuilder_ != null) {
        return directSourcePrefixRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(directSourcePrefixRanges_);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder addDirectSourcePrefixRangesBuilder() {
      return getDirectSourcePrefixRangesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.core.v3.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder addDirectSourcePrefixRangesBuilder(
        int index) {
      return getDirectSourcePrefixRangesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.core.v3.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * The criteria is satisfied if the directly connected source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the parameter is not
     * specified or the list is empty, the directly connected source IP address is ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange direct_source_prefix_ranges = 13;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange.Builder> 
         getDirectSourcePrefixRangesBuilderList() {
      return getDirectSourcePrefixRangesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
        getDirectSourcePrefixRangesFieldBuilder() {
      if (directSourcePrefixRangesBuilder_ == null) {
        directSourcePrefixRangesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder>(
                directSourcePrefixRanges_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        directSourcePrefixRanges_ = null;
      }
      return directSourcePrefixRangesBuilder_;
    }

    private int sourceType_ = 0;
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     * @return The enum numeric value on the wire for sourceType.
     */
    @java.lang.Override public int getSourceTypeValue() {
      return sourceType_;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     * @param value The enum numeric value on the wire for sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTypeValue(int value) {
      sourceType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     * @return The sourceType.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType getSourceType() {
      io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType result = io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType.forNumber(sourceType_);
      return result == null ? io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     * @param value The sourceType to set.
     * @return This builder for chaining.
     */
    public Builder setSourceType(io.envoyproxy.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      sourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the connection source IP match type. Can be any, local or external network.
     * </pre>
     *
     * <code>.envoy.config.listener.v3.FilterChainMatch.ConnectionSourceType source_type = 12 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearSourceType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      sourceType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> sourcePrefixRanges_ =
      java.util.Collections.emptyList();
    private void ensureSourcePrefixRangesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        sourcePrefixRanges_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v3.CidrRange>(sourcePrefixRanges_);
        bitField0_ |= 0x00000040;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> sourcePrefixRangesBuilder_;

    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange> getSourcePrefixRangesList() {
      if (sourcePrefixRangesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sourcePrefixRanges_);
      } else {
        return sourcePrefixRangesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public int getSourcePrefixRangesCount() {
      if (sourcePrefixRangesBuilder_ == null) {
        return sourcePrefixRanges_.size();
      } else {
        return sourcePrefixRangesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange getSourcePrefixRanges(int index) {
      if (sourcePrefixRangesBuilder_ == null) {
        return sourcePrefixRanges_.get(index);
      } else {
        return sourcePrefixRangesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder setSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (sourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.set(index, value);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder setSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.set(index, builderForValue.build());
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (sourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(value);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange value) {
      if (sourcePrefixRangesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(index, value);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(
        io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(builderForValue.build());
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addSourcePrefixRanges(
        int index, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder builderForValue) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.add(index, builderForValue.build());
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder addAllSourcePrefixRanges(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.core.v3.CidrRange> values) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, sourcePrefixRanges_);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder clearSourcePrefixRanges() {
      if (sourcePrefixRangesBuilder_ == null) {
        sourcePrefixRanges_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public Builder removeSourcePrefixRanges(int index) {
      if (sourcePrefixRangesBuilder_ == null) {
        ensureSourcePrefixRangesIsMutable();
        sourcePrefixRanges_.remove(index);
        onChanged();
      } else {
        sourcePrefixRangesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder getSourcePrefixRangesBuilder(
        int index) {
      return getSourcePrefixRangesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder getSourcePrefixRangesOrBuilder(
        int index) {
      if (sourcePrefixRangesBuilder_ == null) {
        return sourcePrefixRanges_.get(index);  } else {
        return sourcePrefixRangesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
         getSourcePrefixRangesOrBuilderList() {
      if (sourcePrefixRangesBuilder_ != null) {
        return sourcePrefixRangesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sourcePrefixRanges_);
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder addSourcePrefixRangesBuilder() {
      return getSourcePrefixRangesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.core.v3.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.CidrRange.Builder addSourcePrefixRangesBuilder(
        int index) {
      return getSourcePrefixRangesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.core.v3.CidrRange.getDefaultInstance());
    }
    /**
     * <pre>
     * The criteria is satisfied if the source IP address of the downstream
     * connection is contained in at least one of the specified subnets. If the
     * parameter is not specified or the list is empty, the source IP address is
     * ignored.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.CidrRange source_prefix_ranges = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.CidrRange.Builder> 
         getSourcePrefixRangesBuilderList() {
      return getSourcePrefixRangesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder> 
        getSourcePrefixRangesFieldBuilder() {
      if (sourcePrefixRangesBuilder_ == null) {
        sourcePrefixRangesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.CidrRange, io.envoyproxy.envoy.config.core.v3.CidrRange.Builder, io.envoyproxy.envoy.config.core.v3.CidrRangeOrBuilder>(
                sourcePrefixRanges_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        sourcePrefixRanges_ = null;
      }
      return sourcePrefixRangesBuilder_;
    }

    private com.google.protobuf.Internal.IntList sourcePorts_ = emptyIntList();
    private void ensureSourcePortsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        sourcePorts_ = mutableCopy(sourcePorts_);
        bitField0_ |= 0x00000080;
      }
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     * @return A list containing the sourcePorts.
     */
    public java.util.List<java.lang.Integer>
        getSourcePortsList() {
      return ((bitField0_ & 0x00000080) != 0) ?
               java.util.Collections.unmodifiableList(sourcePorts_) : sourcePorts_;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     * @return The count of sourcePorts.
     */
    public int getSourcePortsCount() {
      return sourcePorts_.size();
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     * @param index The index of the element to return.
     * @return The sourcePorts at the given index.
     */
    public int getSourcePorts(int index) {
      return sourcePorts_.getInt(index);
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     * @param index The index to set the value at.
     * @param value The sourcePorts to set.
     * @return This builder for chaining.
     */
    public Builder setSourcePorts(
        int index, int value) {

      ensureSourcePortsIsMutable();
      sourcePorts_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     * @param value The sourcePorts to add.
     * @return This builder for chaining.
     */
    public Builder addSourcePorts(int value) {

      ensureSourcePortsIsMutable();
      sourcePorts_.addInt(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     * @param values The sourcePorts to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourcePorts(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureSourcePortsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, sourcePorts_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The criteria is satisfied if the source port of the downstream connection
     * is contained in at least one of the specified ports. If the parameter is
     * not specified, the source port is ignored.
     * </pre>
     *
     * <code>repeated uint32 source_ports = 7 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearSourcePorts() {
      sourcePorts_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList serverNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureServerNamesIsMutable() {
      if (!serverNames_.isModifiable()) {
        serverNames_ = new com.google.protobuf.LazyStringArrayList(serverNames_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @return A list containing the serverNames.
     */
    public com.google.protobuf.ProtocolStringList
        getServerNamesList() {
      serverNames_.makeImmutable();
      return serverNames_;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @return The count of serverNames.
     */
    public int getServerNamesCount() {
      return serverNames_.size();
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @param index The index of the element to return.
     * @return The serverNames at the given index.
     */
    public java.lang.String getServerNames(int index) {
      return serverNames_.get(index);
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @param index The index of the value to return.
     * @return The bytes of the serverNames at the given index.
     */
    public com.google.protobuf.ByteString
        getServerNamesBytes(int index) {
      return serverNames_.getByteString(index);
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @param index The index to set the value at.
     * @param value The serverNames to set.
     * @return This builder for chaining.
     */
    public Builder setServerNames(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureServerNamesIsMutable();
      serverNames_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @param value The serverNames to add.
     * @return This builder for chaining.
     */
    public Builder addServerNames(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureServerNamesIsMutable();
      serverNames_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @param values The serverNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllServerNames(
        java.lang.Iterable<java.lang.String> values) {
      ensureServerNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, serverNames_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @return This builder for chaining.
     */
    public Builder clearServerNames() {
      serverNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of server names (e.g. SNI for TLS protocol) to consider when determining
     * a filter chain match. Those values will be compared against the server names of a new
     * connection, when detected by one of the listener filters.
     *
     * The server name will be matched against all wildcard domains, i.e. ``www.example.com``
     * will be first matched against ``www.example.com``, then ``*.example.com``, then ``*.com``.
     *
     * Note that partial wildcards are not supported, and values like ``*w.example.com`` are invalid.
     * The value ``*`` is also not supported, and ``server_names`` should be omitted instead.
     *
     * .. attention::
     *
     *   See the :ref:`FAQ entry &lt;faq_how_to_setup_sni&gt;` on how to configure SNI for more
     *   information.
     * </pre>
     *
     * <code>repeated string server_names = 11;</code>
     * @param value The bytes of the serverNames to add.
     * @return This builder for chaining.
     */
    public Builder addServerNamesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureServerNamesIsMutable();
      serverNames_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object transportProtocol_ = "";
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     * @return The transportProtocol.
     */
    public java.lang.String getTransportProtocol() {
      java.lang.Object ref = transportProtocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transportProtocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     * @return The bytes for transportProtocol.
     */
    public com.google.protobuf.ByteString
        getTransportProtocolBytes() {
      java.lang.Object ref = transportProtocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        transportProtocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     * @param value The transportProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setTransportProtocol(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      transportProtocol_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     * @return This builder for chaining.
     */
    public Builder clearTransportProtocol() {
      transportProtocol_ = getDefaultInstance().getTransportProtocol();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a transport protocol to consider when determining a filter chain match.
     * This value will be compared against the transport protocol of a new connection, when
     * it's detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``raw_buffer`` - default, used when no transport protocol is detected,
     * * ``tls`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *   when TLS protocol is detected.
     * </pre>
     *
     * <code>string transport_protocol = 9;</code>
     * @param value The bytes for transportProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setTransportProtocolBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      transportProtocol_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList applicationProtocols_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureApplicationProtocolsIsMutable() {
      if (!applicationProtocols_.isModifiable()) {
        applicationProtocols_ = new com.google.protobuf.LazyStringArrayList(applicationProtocols_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @return A list containing the applicationProtocols.
     */
    public com.google.protobuf.ProtocolStringList
        getApplicationProtocolsList() {
      applicationProtocols_.makeImmutable();
      return applicationProtocols_;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @return The count of applicationProtocols.
     */
    public int getApplicationProtocolsCount() {
      return applicationProtocols_.size();
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @param index The index of the element to return.
     * @return The applicationProtocols at the given index.
     */
    public java.lang.String getApplicationProtocols(int index) {
      return applicationProtocols_.get(index);
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @param index The index of the value to return.
     * @return The bytes of the applicationProtocols at the given index.
     */
    public com.google.protobuf.ByteString
        getApplicationProtocolsBytes(int index) {
      return applicationProtocols_.getByteString(index);
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @param index The index to set the value at.
     * @param value The applicationProtocols to set.
     * @return This builder for chaining.
     */
    public Builder setApplicationProtocols(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureApplicationProtocolsIsMutable();
      applicationProtocols_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @param value The applicationProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addApplicationProtocols(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureApplicationProtocolsIsMutable();
      applicationProtocols_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @param values The applicationProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addAllApplicationProtocols(
        java.lang.Iterable<java.lang.String> values) {
      ensureApplicationProtocolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, applicationProtocols_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @return This builder for chaining.
     */
    public Builder clearApplicationProtocols() {
      applicationProtocols_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * If non-empty, a list of application protocols (e.g. ALPN for TLS protocol) to consider when
     * determining a filter chain match. Those values will be compared against the application
     * protocols of a new connection, when detected by one of the listener filters.
     *
     * Suggested values include:
     *
     * * ``http/1.1`` - set by :ref:`envoy.filters.listener.tls_inspector
     *   &lt;config_listener_filters_tls_inspector&gt;`,
     * * ``h2`` - set by :ref:`envoy.filters.listener.tls_inspector &lt;config_listener_filters_tls_inspector&gt;`
     *
     * .. attention::
     *
     *   Currently, only :ref:`TLS Inspector &lt;config_listener_filters_tls_inspector&gt;` provides
     *   application protocol detection based on the requested
     *   `ALPN &lt;https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation&gt;`_ values.
     *
     *   However, the use of ALPN is pretty much limited to the HTTP/2 traffic on the Internet,
     *   and matching on values other than ``h2`` is going to lead to a lot of false negatives,
     *   unless all connecting clients are known to use ALPN.
     * </pre>
     *
     * <code>repeated string application_protocols = 10;</code>
     * @param value The bytes of the applicationProtocols to add.
     * @return This builder for chaining.
     */
    public Builder addApplicationProtocolsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureApplicationProtocolsIsMutable();
      applicationProtocols_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.config.listener.v3.FilterChainMatch)
  }

  // @@protoc_insertion_point(class_scope:envoy.config.listener.v3.FilterChainMatch)
  private static final io.envoyproxy.envoy.config.listener.v3.FilterChainMatch DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.listener.v3.FilterChainMatch();
  }

  public static io.envoyproxy.envoy.config.listener.v3.FilterChainMatch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FilterChainMatch>
      PARSER = new com.google.protobuf.AbstractParser<FilterChainMatch>() {
    @java.lang.Override
    public FilterChainMatch parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<FilterChainMatch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FilterChainMatch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.config.listener.v3.FilterChainMatch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

