/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.xds.ClusterManagerLoadBalancerProvider;
import io.grpc.xds.XdsNameResolver;
import io.grpc.xds.client.XdsLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class ClusterManagerLoadBalancer
extends MultiChildLoadBalancer {
    @VisibleForTesting
    public static final int DELAYED_CHILD_DELETION_TIME_MINUTES = 15;
    protected final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final XdsLogger logger;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        super(helper);
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster_manager-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    protected LoadBalancer.ResolvedAddresses getChildAddresses(Object key, LoadBalancer.ResolvedAddresses resolvedAddresses, Object childConfig) {
        return resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(childConfig).build();
    }

    protected Map<Object, MultiChildLoadBalancer.ChildLbState> createChildLbMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<Object, MultiChildLoadBalancer.ChildLbState> newChildPolicies = new HashMap<Object, MultiChildLoadBalancer.ChildLbState>();
        if (config != null) {
            for (Map.Entry<String, ServiceConfigUtil.PolicySelection> entry : config.childPolicies.entrySet()) {
                MultiChildLoadBalancer.ChildLbState child = this.getChildLbState(entry.getKey());
                if (child == null) {
                    child = new ClusterManagerLbState(entry.getKey(), entry.getValue().getProvider(), entry.getValue().getConfig(), this.getInitialPicker());
                }
                newChildPolicies.put(entry.getKey(), child);
            }
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", newChildPolicies.keySet());
        return newChildPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            MultiChildLoadBalancer.AcceptResolvedAddrRetVal acceptRetVal = this.acceptResolvedAddressesInternal(resolvedAddresses);
            if (!acceptRetVal.status.isOk()) {
                Status status = acceptRetVal.status;
                return status;
            }
            this.updateOverallBalancingState();
            Status status = acceptRetVal.status;
            return status;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    protected void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        HashMap<Object, LoadBalancer.SubchannelPicker> childPickers = new HashMap<Object, LoadBalancer.SubchannelPicker>();
        for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
            if (childLbState.isDeactivated()) continue;
            childPickers.put(childLbState.getKey(), childLbState.getCurrentPicker());
            overallState = ClusterManagerLoadBalancer.aggregateState(overallState, (ConnectivityState)childLbState.getCurrentState());
        }
        if (overallState != null) {
            this.getHelper().updateBalancingState(overallState, this.getSubchannelPicker(childPickers));
            this.currentConnectivityState = overallState;
        }
    }

    protected LoadBalancer.SubchannelPicker getSubchannelPicker(final Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        return new LoadBalancer.SubchannelPicker(){

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                String clusterName = (String)args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                LoadBalancer.SubchannelPicker childPicker = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                if (childPicker == null) {
                    return LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("CDS encountered error: unable to find available subchannel for cluster " + clusterName));
                }
                return childPicker.pickSubchannel(args);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("pickers", (Object)childPickers).toString();
            }
        };
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (MultiChildLoadBalancer.ChildLbState state : this.getChildLbStates()) {
            if (state.isDeactivated()) continue;
            gotoTransientFailure = false;
            this.handleNameResolutionError(state, error);
        }
        if (gotoTransientFailure) {
            this.getHelper().updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.getErrorPicker(error));
        }
    }

    private class ClusterManagerLbState
    extends MultiChildLoadBalancer.ChildLbState {
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        public ClusterManagerLbState(Object key, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker) {
            super((MultiChildLoadBalancer)ClusterManagerLoadBalancer.this, key, policyProvider, childConfig, initialPicker);
        }

        protected MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper createChildHelper() {
            return new ClusterManagerChildHelper();
        }

        protected void shutdown() {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
            }
            super.shutdown();
        }

        protected void reactivate(LoadBalancerProvider policyProvider) {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
                ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} reactivated", this.getKey());
            }
            super.reactivate(policyProvider);
        }

        protected void deactivate() {
            if (this.isDeactivated()) {
                return;
            }
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ClusterManagerLbState.this.shutdown();
                    ClusterManagerLoadBalancer.this.removeChild(ClusterManagerLbState.this.getKey());
                }
            }
            this.deletionTimer = ClusterManagerLoadBalancer.this.syncContext.schedule((Runnable)new DeletionTask(), 15L, TimeUnit.MINUTES, ClusterManagerLoadBalancer.this.timeService);
            this.setDeactivated();
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deactivated", this.getKey());
        }

        private class ClusterManagerChildHelper
        extends MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper {
            private ClusterManagerChildHelper() {
                super((MultiChildLoadBalancer.ChildLbState)ClusterManagerLbState.this);
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (ClusterManagerLoadBalancer.this.getChildLbState(ClusterManagerLbState.this.getKey()) == null) {
                    return;
                }
                ClusterManagerLbState.this.setCurrentState(newState);
                ClusterManagerLbState.this.setCurrentPicker(newPicker);
                if (!ClusterManagerLbState.this.isDeactivated() && !ClusterManagerLoadBalancer.this.resolvingAddresses) {
                    ClusterManagerLoadBalancer.this.updateOverallBalancingState();
                }
            }
        }
    }
}

