/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.WeightedRandomPicker;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.client.XdsLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class WeightedTargetLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final Map<String, GracefulSwitchLoadBalancer> childBalancers = new HashMap<String, GracefulSwitchLoadBalancer>();
    private final Map<String, ChildHelper> childHelpers = new HashMap<String, ChildHelper>();
    private final LoadBalancer.Helper helper;
    private Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = ImmutableMap.of();
    private boolean resolvingAddresses;

    WeightedTargetLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"weighted-target-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            Status status = this.acceptResolvedAddressesInternal(resolvedAddresses);
            return status;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    public Status acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)lbConfig, (Object)"missing weighted_target lb config");
        WeightedTargetLoadBalancerProvider.WeightedTargetConfig weightedTargetConfig = (WeightedTargetLoadBalancerProvider.WeightedTargetConfig)lbConfig;
        Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> newTargets = weightedTargetConfig.targets;
        for (String targetName : newTargets.keySet()) {
            WeightedTargetLoadBalancerProvider.WeightedPolicySelection weightedChildLbConfig = newTargets.get(targetName);
            if (!this.targets.containsKey(targetName)) {
                ChildHelper childHelper = new ChildHelper(targetName);
                GracefulSwitchLoadBalancer childBalancer = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)childHelper);
                childBalancer.switchTo((LoadBalancer.Factory)weightedChildLbConfig.policySelection.getProvider());
                this.childHelpers.put(targetName, childHelper);
                this.childBalancers.put(targetName, childBalancer);
                continue;
            }
            if (weightedChildLbConfig.policySelection.getProvider().equals((Object)this.targets.get((Object)targetName).policySelection.getProvider())) continue;
            this.childBalancers.get(targetName).switchTo((LoadBalancer.Factory)weightedChildLbConfig.policySelection.getProvider());
        }
        this.targets = newTargets;
        for (String targetName : this.targets.keySet()) {
            this.childBalancers.get(targetName).handleResolvedAddresses(resolvedAddresses.toBuilder().setAddresses(AddressFilter.filter(resolvedAddresses.getAddresses(), targetName)).setLoadBalancingPolicyConfig(this.targets.get((Object)targetName).policySelection.getConfig()).build());
        }
        for (String targetName : this.childBalancers.keySet()) {
            if (this.targets.containsKey(targetName)) continue;
            this.childBalancers.get(targetName).shutdown();
        }
        this.childBalancers.keySet().retainAll(this.targets.keySet());
        this.childHelpers.keySet().retainAll(this.targets.keySet());
        this.updateOverallBalancingState();
        return Status.OK;
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.childBalancers.isEmpty()) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
        }
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.handleNameResolutionError(error);
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.shutdown();
        }
        this.childBalancers.clear();
    }

    private void updateOverallBalancingState() {
        ArrayList<WeightedRandomPicker.WeightedChildPicker> childPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
        ConnectivityState overallState = null;
        ArrayList<WeightedRandomPicker.WeightedChildPicker> errorPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
        for (String name : this.targets.keySet()) {
            ChildHelper childHelper = this.childHelpers.get(name);
            ConnectivityState childState = childHelper.currentState;
            overallState = WeightedTargetLoadBalancer.aggregateState(overallState, childState);
            int weight = this.targets.get((Object)name).weight;
            if (ConnectivityState.READY == childState) {
                childPickers.add(new WeightedRandomPicker.WeightedChildPicker(weight, childHelper.currentPicker));
                continue;
            }
            if (ConnectivityState.TRANSIENT_FAILURE != childState) continue;
            errorPickers.add(new WeightedRandomPicker.WeightedChildPicker(weight, childHelper.currentPicker));
        }
        WeightedRandomPicker picker = childPickers.isEmpty() ? (overallState == ConnectivityState.TRANSIENT_FAILURE ? new WeightedRandomPicker(errorPickers) : new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult())) : new WeightedRandomPicker(childPickers);
        if (overallState != null) {
            this.helper.updateBalancingState(overallState, (LoadBalancer.SubchannelPicker)picker);
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private final class ChildHelper
    extends ForwardingLoadBalancerHelper {
        String name;
        ConnectivityState currentState = ConnectivityState.CONNECTING;
        LoadBalancer.SubchannelPicker currentPicker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());

        private ChildHelper(String name) {
            this.name = name;
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            if (!WeightedTargetLoadBalancer.this.resolvingAddresses && WeightedTargetLoadBalancer.this.childBalancers.containsKey(this.name)) {
                WeightedTargetLoadBalancer.this.updateOverallBalancingState();
            }
        }

        protected LoadBalancer.Helper delegate() {
            return WeightedTargetLoadBalancer.this.helper;
        }
    }
}

