/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Internal;
import io.grpc.InternalLogId;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.xds.client.EnvoyProtoData;
import io.grpc.xds.client.LoadStatsManager2;
import io.grpc.xds.client.Stats;
import io.grpc.xds.client.XdsLogger;
import io.grpc.xds.client.XdsTransportFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.EndpointLoadMetricStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.UpstreamLocalityStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadReportingServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Internal
public final class LoadReportClient {
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final XdsTransportFactory.XdsTransport xdsTransport;
    private final EnvoyProtoData.Node node;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timerService;
    private final Stopwatch retryStopwatch;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    @VisibleForTesting
    public final LoadStatsManager2 loadStatsManager;
    private boolean started;
    @Nullable
    private BackoffPolicy lrsRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lrsRpcRetryTimer;
    @Nullable
    private LrsStream lrsStream;
    private static final MethodDescriptor<LoadStatsRequest, LoadStatsResponse> method = LoadReportingServiceGrpc.getStreamLoadStatsMethod();

    @VisibleForTesting
    public LoadReportClient(LoadStatsManager2 loadStatsManager, XdsTransportFactory.XdsTransport xdsTransport, EnvoyProtoData.Node node, SynchronizationContext syncContext, ScheduledExecutorService scheduledExecutorService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.loadStatsManager = (LoadStatsManager2)Preconditions.checkNotNull((Object)loadStatsManager, (Object)"loadStatsManager");
        this.xdsTransport = (XdsTransportFactory.XdsTransport)Preconditions.checkNotNull((Object)xdsTransport, (Object)"xdsTransport");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"timeService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.retryStopwatch = (Stopwatch)((Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier")).get();
        this.node = ((EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node")).toBuilder().addClientFeatures("envoy.lrs.supports_send_all_clusters").build();
        this.logId = InternalLogId.allocate((String)"lrs-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @VisibleForTesting
    public boolean lrsStreamIsNull() {
        return this.lrsStream == null;
    }

    public void startLoadReporting() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.started) {
            return;
        }
        this.started = true;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Starting load reporting RPC");
        this.startLrsRpc();
    }

    public void stopLoadReporting() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (!this.started) {
            return;
        }
        this.started = false;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stopping load reporting RPC");
        if (this.lrsRpcRetryTimer != null && this.lrsRpcRetryTimer.isPending()) {
            this.lrsRpcRetryTimer.cancel();
        }
        if (this.lrsStream != null) {
            this.lrsStream.close((Exception)((Object)Status.CANCELLED.withDescription("stop load reporting").asException()));
        }
    }

    private void startLrsRpc() {
        if (!this.started) {
            return;
        }
        Preconditions.checkState((this.lrsStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        this.retryStopwatch.reset().start();
        this.lrsStream = new LrsStream();
    }

    private final class LrsStream
    implements XdsTransportFactory.EventHandler<LoadStatsResponse> {
        boolean initialResponseReceived;
        boolean closed;
        long intervalNano = -1L;
        boolean reportAllClusters;
        List<String> clusterNames;
        SynchronizationContext.ScheduledHandle loadReportTimer;
        private final XdsTransportFactory.StreamingCall<LoadStatsRequest, LoadStatsResponse> call;

        LrsStream() {
            this.call = LoadReportClient.this.xdsTransport.createStreamingCall(method.getFullMethodName(), method.getRequestMarshaller(), method.getResponseMarshaller());
            this.call.start(this);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sending initial LRS request");
            this.sendLoadStatsRequest(Collections.emptyList());
        }

        @Override
        public void onReady() {
        }

        @Override
        public void onRecvMessage(final LoadStatsResponse response) {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS response:\n{0}", response);
                    LrsStream.this.handleRpcResponse((List<String>)response.getClustersList(), response.getSendAllClusters(), Durations.toNanos((Duration)response.getLoadReportingInterval()));
                    LrsStream.this.call.startRecvMessage();
                }
            });
        }

        @Override
        public void onStatusReceived(final Status status) {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (status.isOk()) {
                        LrsStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
                    } else {
                        LrsStream.this.handleStreamClosed(status);
                    }
                }
            });
        }

        void sendLoadStatsRequest(List<Stats.ClusterStats> clusterStatsList) {
            LoadStatsRequest.Builder requestBuilder = LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node.toEnvoyProtoNode());
            for (Stats.ClusterStats stats : clusterStatsList) {
                requestBuilder.addClusterStats(this.buildClusterStats(stats));
            }
            LoadStatsRequest request = requestBuilder.build();
            this.call.sendMessage(request);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", request);
        }

        void handleRpcResponse(List<String> clusters, boolean sendAllClusters, long loadReportIntervalNano) {
            if (this.closed) {
                return;
            }
            if (!this.initialResponseReceived) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Initial LRS response received");
                this.initialResponseReceived = true;
            }
            this.reportAllClusters = sendAllClusters;
            if (this.reportAllClusters) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for all clusters");
            } else {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for clusters: ", clusters);
                this.clusterNames = clusters;
            }
            this.intervalNano = loadReportIntervalNano;
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load reporting interval to {0} ns", this.intervalNano);
            this.scheduleNextLoadReport();
        }

        private void sendLoadReport() {
            ArrayList<Stats.ClusterStats> clusterStatsList;
            if (this.closed) {
                return;
            }
            if (this.reportAllClusters) {
                clusterStatsList = LoadReportClient.this.loadStatsManager.getAllClusterStatsReports();
            } else {
                clusterStatsList = new ArrayList();
                for (String name : this.clusterNames) {
                    clusterStatsList.addAll(LoadReportClient.this.loadStatsManager.getClusterStatsReports(name));
                }
            }
            this.sendLoadStatsRequest(clusterStatsList);
            this.scheduleNextLoadReport();
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (this.intervalNano > 0L) {
                this.loadReportTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LoadReportingTask(this), this.intervalNano, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void handleStreamClosed(Status status) {
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "LRS stream closed with status {0}: {1}. Cause: {2}", status.getCode(), status.getDescription(), status.getCause());
            this.closed = true;
            this.cleanUp();
            if (this.initialResponseReceived || LoadReportClient.this.lrsRpcRetryPolicy == null) {
                LoadReportClient.this.lrsRpcRetryPolicy = LoadReportClient.this.backoffPolicyProvider.get();
            }
            long delayNanos = LoadReportClient.this.lrsRpcRetryPolicy.nextBackoffNanos() - LoadReportClient.this.retryStopwatch.elapsed(TimeUnit.NANOSECONDS);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry LRS stream in {0} ns", delayNanos);
            if (delayNanos <= 0L) {
                LoadReportClient.this.startLrsRpc();
            } else {
                LoadReportClient.this.lrsRpcRetryTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LrsRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.call.sendError(error);
        }

        private void cleanUp() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (LoadReportClient.this.lrsStream == this) {
                LoadReportClient.this.lrsStream = null;
            }
        }

        private ClusterStats buildClusterStats(Stats.ClusterStats stats) {
            ClusterStats.Builder builder = ClusterStats.newBuilder().setClusterName(stats.clusterName());
            if (stats.clusterServiceName() != null) {
                builder.setClusterServiceName(stats.clusterServiceName());
            }
            for (Stats.UpstreamLocalityStats upstreamLocalityStats : stats.upstreamLocalityStatsList()) {
                builder.addUpstreamLocalityStats(UpstreamLocalityStats.newBuilder().setLocality(Locality.newBuilder().setRegion(upstreamLocalityStats.locality().region()).setZone(upstreamLocalityStats.locality().zone()).setSubZone(upstreamLocalityStats.locality().subZone())).setTotalSuccessfulRequests(upstreamLocalityStats.totalSuccessfulRequests()).setTotalErrorRequests(upstreamLocalityStats.totalErrorRequests()).setTotalRequestsInProgress(upstreamLocalityStats.totalRequestsInProgress()).setTotalIssuedRequests(upstreamLocalityStats.totalIssuedRequests()).addAllLoadMetricStats(upstreamLocalityStats.loadMetricStatsMap().entrySet().stream().map(e -> EndpointLoadMetricStats.newBuilder().setMetricName((String)e.getKey()).setNumRequestsFinishedWithMetric(((Stats.BackendLoadMetricStats)e.getValue()).numRequestsFinishedWithMetric()).setTotalMetricValue(((Stats.BackendLoadMetricStats)e.getValue()).totalMetricValue()).build()).collect(Collectors.toList())));
            }
            for (Stats.DroppedRequests droppedRequests : stats.droppedRequestsList()) {
                builder.addDroppedRequests(ClusterStats.DroppedRequests.newBuilder().setCategory(droppedRequests.category()).setDroppedCount(droppedRequests.droppedCount()));
            }
            return builder.setTotalDroppedRequests(stats.totalDroppedRequests()).setLoadReportInterval(Durations.fromNanos((long)stats.loadReportIntervalNano())).build();
        }
    }

    private class LrsRpcRetryTask
    implements Runnable {
        private LrsRpcRetryTask() {
        }

        @Override
        public void run() {
            LoadReportClient.this.startLrsRpc();
        }
    }

    private static class LoadReportingTask
    implements Runnable {
        private final LrsStream stream;

        LoadReportingTask(LrsStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.sendLoadReport();
        }
    }
}

