/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.Durations;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.AutoValue_XdsClusterResource_CdsUpdate;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadBalancerConfigFactory;
import io.grpc.xds.MetadataRegistry;
import io.grpc.xds.StructOrError;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.internal.security.CommonTlsContextUtil;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.CircuitBreakers;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.OutlierDetection;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.RoutingPriority;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TransportSocket;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.clusters.aggregate.v3.ClusterConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.http_11_proxy.v3.Http11ProxyUpstreamTransport;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

class XdsClusterResource
extends XdsResourceType<CdsUpdate> {
    @VisibleForTesting
    static boolean enableLeastRequest = !Strings.isNullOrEmpty((String)System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) ? Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) : Boolean.parseBoolean(System.getProperty("io.grpc.xds.experimentalEnableLeastRequest", "true"));
    @VisibleForTesting
    public static boolean enableSystemRootCerts = GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_XDS_SYSTEM_ROOT_CERTS", (boolean)false);
    static boolean isEnabledXdsHttpConnect = GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_XDS_HTTP_CONNECT", (boolean)false);
    @VisibleForTesting
    static final String AGGREGATE_CLUSTER_TYPE_NAME = "envoy.clusters.aggregate";
    static final String ADS_TYPE_URL_CDS = "type.googleapis.com/envoy.config.cluster.v3.Cluster";
    private static final String TYPE_URL_CLUSTER_CONFIG = "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT = "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT_V2 = "type.googleapis.com/envoy.api.v2.auth.UpstreamTlsContext";
    static final String TRANSPORT_SOCKET_NAME_HTTP11_PROXY = "type.googleapis.com/envoy.extensions.transport_sockets.http_11_proxy.v3.Http11ProxyUpstreamTransport";
    private final LoadBalancerRegistry loadBalancerRegistry = LoadBalancerRegistry.getDefaultRegistry();
    private static final XdsClusterResource instance = new XdsClusterResource();

    XdsClusterResource() {
    }

    public static XdsClusterResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof Cluster)) {
            return null;
        }
        return ((Cluster)unpackedResource).getName();
    }

    @Override
    public String typeName() {
        return "CDS";
    }

    @Override
    public String typeUrl() {
        return ADS_TYPE_URL_CDS;
    }

    @Override
    public boolean shouldRetrieveResourceKeysForArgs() {
        return true;
    }

    @Override
    protected boolean isFullStateOfTheWorld() {
        return true;
    }

    @Override
    protected Class<Cluster> unpackedClassName() {
        return Cluster.class;
    }

    @Override
    protected CdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage) throws XdsResourceType.ResourceInvalidException {
        if (!(unpackedMessage instanceof Cluster)) {
            throw new XdsResourceType.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        ImmutableSet certProviderInstances = null;
        if (args.getBootstrapInfo() != null && args.getBootstrapInfo().certProviders() != null) {
            certProviderInstances = args.getBootstrapInfo().certProviders().keySet();
        }
        return XdsClusterResource.processCluster((Cluster)unpackedMessage, certProviderInstances, args.getServerInfo(), this.loadBalancerRegistry);
    }

    @VisibleForTesting
    static CdsUpdate processCluster(Cluster cluster, Set<String> certProviderInstances, Bootstrapper.ServerInfo serverInfo, LoadBalancerRegistry loadBalancerRegistry) throws XdsResourceType.ResourceInvalidException {
        StructOrError<CdsUpdate.Builder> structOrError;
        switch (cluster.getClusterDiscoveryTypeCase()) {
            case TYPE: {
                structOrError = XdsClusterResource.parseNonAggregateCluster(cluster, certProviderInstances, serverInfo);
                break;
            }
            case CLUSTER_TYPE: {
                structOrError = XdsClusterResource.parseAggregateCluster(cluster);
                break;
            }
            default: {
                throw new XdsResourceType.ResourceInvalidException("Cluster " + cluster.getName() + ": unspecified cluster discovery type");
            }
        }
        if (structOrError.getErrorDetail() != null) {
            throw new XdsResourceType.ResourceInvalidException(structOrError.getErrorDetail());
        }
        CdsUpdate.Builder updateBuilder = structOrError.getStruct();
        ImmutableMap<String, ?> lbPolicyConfig = LoadBalancerConfigFactory.newConfig(cluster, enableLeastRequest);
        ServiceConfigUtil.LbConfig lbConfig = ServiceConfigUtil.unwrapLoadBalancingConfig(lbPolicyConfig);
        NameResolver.ConfigOrError configOrError = loadBalancerRegistry.getProvider(lbConfig.getPolicyName()).parseLoadBalancingPolicyConfig(lbConfig.getRawConfigValue());
        if (configOrError.getError() != null) {
            throw new XdsResourceType.ResourceInvalidException(structOrError.getErrorDetail());
        }
        updateBuilder.lbPolicyConfig(lbPolicyConfig);
        updateBuilder.filterMetadata((ImmutableMap<String, Struct>)ImmutableMap.copyOf(cluster.getMetadata().getFilterMetadataMap()));
        try {
            MetadataRegistry registry = MetadataRegistry.getInstance();
            ImmutableMap<String, Object> parsedFilterMetadata = registry.parseMetadata(cluster.getMetadata());
            updateBuilder.parsedMetadata(parsedFilterMetadata);
        }
        catch (XdsResourceType.ResourceInvalidException e) {
            throw new XdsResourceType.ResourceInvalidException("Failed to parse xDS filter metadata for cluster '" + cluster.getName() + "': " + e.getMessage(), e);
        }
        return updateBuilder.build();
    }

    private static StructOrError<CdsUpdate.Builder> parseAggregateCluster(Cluster cluster) {
        ClusterConfig clusterConfig;
        String clusterName = cluster.getName();
        Cluster.CustomClusterType customType = cluster.getClusterType();
        String typeName = customType.getName();
        if (!typeName.equals(AGGREGATE_CLUSTER_TYPE_NAME)) {
            return StructOrError.fromError("Cluster " + clusterName + ": unsupported custom cluster type: " + typeName);
        }
        try {
            clusterConfig = XdsClusterResource.unpackCompatibleType(customType.getTypedConfig(), ClusterConfig.class, TYPE_URL_CLUSTER_CONFIG, null);
        }
        catch (InvalidProtocolBufferException e) {
            return StructOrError.fromError("Cluster " + clusterName + ": malformed ClusterConfig: " + (Object)((Object)e));
        }
        return StructOrError.fromStruct(CdsUpdate.forAggregate(clusterName, (List<String>)clusterConfig.getClustersList()));
    }

    private static StructOrError<CdsUpdate.Builder> parseNonAggregateCluster(Cluster cluster, Set<String> certProviderInstances, Bootstrapper.ServerInfo serverInfo) {
        Cluster.DiscoveryType type;
        String clusterName = cluster.getName();
        Bootstrapper.ServerInfo lrsServerInfo = null;
        Long maxConcurrentRequests = null;
        EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = null;
        EnvoyServerProtoData.OutlierDetection outlierDetection = null;
        boolean isHttp11ProxyAvailable = false;
        if (cluster.hasLrsServer()) {
            if (!cluster.getLrsServer().hasSelf()) {
                return StructOrError.fromError("Cluster " + clusterName + ": only support LRS for the same management server");
            }
            lrsServerInfo = serverInfo;
        }
        if (cluster.hasCircuitBreakers()) {
            List<CircuitBreakers.Thresholds> thresholds = cluster.getCircuitBreakers().getThresholdsList();
            for (CircuitBreakers.Thresholds threshold : thresholds) {
                if (threshold.getPriority() != RoutingPriority.DEFAULT || !threshold.hasMaxRequests()) continue;
                maxConcurrentRequests = Integer.toUnsignedLong(threshold.getMaxRequests().getValue());
            }
        }
        if (cluster.getTransportSocketMatchesCount() > 0) {
            return StructOrError.fromError("Cluster " + clusterName + ": transport-socket-matches not supported.");
        }
        boolean hasTransportSocket = cluster.hasTransportSocket();
        TransportSocket transportSocket = cluster.getTransportSocket();
        if (!(!hasTransportSocket || "envoy.transport_sockets.tls".equals(transportSocket.getName()) || isEnabledXdsHttpConnect && TRANSPORT_SOCKET_NAME_HTTP11_PROXY.equals(transportSocket.getName()))) {
            return StructOrError.fromError("transport-socket with name " + transportSocket.getName() + " not supported.");
        }
        if (hasTransportSocket && isEnabledXdsHttpConnect && TRANSPORT_SOCKET_NAME_HTTP11_PROXY.equals(transportSocket.getName())) {
            isHttp11ProxyAvailable = true;
            try {
                Http11ProxyUpstreamTransport wrappedTransportSocket = (Http11ProxyUpstreamTransport)transportSocket.getTypedConfig().unpack(Http11ProxyUpstreamTransport.class);
                hasTransportSocket = wrappedTransportSocket.hasTransportSocket();
                transportSocket = wrappedTransportSocket.getTransportSocket();
            }
            catch (InvalidProtocolBufferException e) {
                return StructOrError.fromError("Cluster " + clusterName + ": malformed Http11ProxyUpstreamTransport: " + (Object)((Object)e));
            }
            catch (ClassCastException e) {
                return StructOrError.fromError("Cluster " + clusterName + ": invalid transport_socket type in Http11ProxyUpstreamTransport");
            }
        }
        if (hasTransportSocket && "envoy.transport_sockets.tls".equals(transportSocket.getName())) {
            try {
                upstreamTlsContext = EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext(XdsClusterResource.validateUpstreamTlsContext(XdsClusterResource.unpackCompatibleType(transportSocket.getTypedConfig(), UpstreamTlsContext.class, TYPE_URL_UPSTREAM_TLS_CONTEXT, TYPE_URL_UPSTREAM_TLS_CONTEXT_V2), certProviderInstances));
            }
            catch (InvalidProtocolBufferException | XdsResourceType.ResourceInvalidException e) {
                return StructOrError.fromError("Cluster " + clusterName + ": malformed UpstreamTlsContext: " + e);
            }
        }
        if (cluster.hasOutlierDetection()) {
            try {
                outlierDetection = EnvoyServerProtoData.OutlierDetection.fromEnvoyOutlierDetection(XdsClusterResource.validateOutlierDetection(cluster.getOutlierDetection()));
            }
            catch (XdsResourceType.ResourceInvalidException e) {
                return StructOrError.fromError("Cluster " + clusterName + ": malformed outlier_detection: " + e);
            }
        }
        if ((type = cluster.getType()) == Cluster.DiscoveryType.EDS) {
            String edsServiceName = null;
            Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
            if (!edsClusterConfig.getEdsConfig().hasAds() && !edsClusterConfig.getEdsConfig().hasSelf()) {
                return StructOrError.fromError("Cluster " + clusterName + ": field eds_cluster_config must be set to indicate to use EDS over ADS or self ConfigSource");
            }
            if (!edsClusterConfig.getServiceName().isEmpty()) {
                edsServiceName = edsClusterConfig.getServiceName();
            }
            if (edsServiceName == null && clusterName.toLowerCase(Locale.ROOT).startsWith("xdstp:")) {
                return StructOrError.fromError("EDS service_name must be set when Cluster resource has an xdstp name");
            }
            return StructOrError.fromStruct(CdsUpdate.forEds(clusterName, edsServiceName, lrsServerInfo, maxConcurrentRequests, upstreamTlsContext, outlierDetection, isHttp11ProxyAvailable));
        }
        if (type.equals((Object)Cluster.DiscoveryType.LOGICAL_DNS)) {
            if (!cluster.hasLoadAssignment()) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single host");
            }
            ClusterLoadAssignment assignment = cluster.getLoadAssignment();
            if (assignment.getEndpointsCount() != 1 || assignment.getEndpoints(0).getLbEndpointsCount() != 1) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single locality_lb_endpoint and a single lb_endpoint");
            }
            LbEndpoint lbEndpoint = assignment.getEndpoints(0).getLbEndpoints(0);
            if (!(lbEndpoint.hasEndpoint() && lbEndpoint.getEndpoint().hasAddress() && lbEndpoint.getEndpoint().getAddress().hasSocketAddress())) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have an endpoint with address and socket_address");
            }
            SocketAddress socketAddress = lbEndpoint.getEndpoint().getAddress().getSocketAddress();
            if (!socketAddress.getResolverName().isEmpty()) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters must NOT have a custom resolver name set");
            }
            if (socketAddress.getPortSpecifierCase() != SocketAddress.PortSpecifierCase.PORT_VALUE) {
                return StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters socket_address must have port_value");
            }
            String dnsHostName = String.format(Locale.US, "%s:%d", socketAddress.getAddress(), socketAddress.getPortValue());
            return StructOrError.fromStruct(CdsUpdate.forLogicalDns(clusterName, dnsHostName, lrsServerInfo, maxConcurrentRequests, upstreamTlsContext, isHttp11ProxyAvailable));
        }
        return StructOrError.fromError("Cluster " + clusterName + ": unsupported built-in discovery type: " + (Object)((Object)type));
    }

    static OutlierDetection validateOutlierDetection(OutlierDetection outlierDetection) throws XdsResourceType.ResourceInvalidException {
        if (outlierDetection.hasInterval()) {
            if (!Durations.isValid((Duration)outlierDetection.getInterval())) {
                throw new XdsResourceType.ResourceInvalidException("outlier_detection interval is not a valid Duration");
            }
            if (XdsClusterResource.hasNegativeValues(outlierDetection.getInterval())) {
                throw new XdsResourceType.ResourceInvalidException("outlier_detection interval has a negative value");
            }
        }
        if (outlierDetection.hasBaseEjectionTime()) {
            if (!Durations.isValid((Duration)outlierDetection.getBaseEjectionTime())) {
                throw new XdsResourceType.ResourceInvalidException("outlier_detection base_ejection_time is not a valid Duration");
            }
            if (XdsClusterResource.hasNegativeValues(outlierDetection.getBaseEjectionTime())) {
                throw new XdsResourceType.ResourceInvalidException("outlier_detection base_ejection_time has a negative value");
            }
        }
        if (outlierDetection.hasMaxEjectionTime()) {
            if (!Durations.isValid((Duration)outlierDetection.getMaxEjectionTime())) {
                throw new XdsResourceType.ResourceInvalidException("outlier_detection max_ejection_time is not a valid Duration");
            }
            if (XdsClusterResource.hasNegativeValues(outlierDetection.getMaxEjectionTime())) {
                throw new XdsResourceType.ResourceInvalidException("outlier_detection max_ejection_time has a negative value");
            }
        }
        if (outlierDetection.hasMaxEjectionPercent() && outlierDetection.getMaxEjectionPercent().getValue() > 100) {
            throw new XdsResourceType.ResourceInvalidException("outlier_detection max_ejection_percent is > 100");
        }
        if (outlierDetection.hasEnforcingSuccessRate() && outlierDetection.getEnforcingSuccessRate().getValue() > 100) {
            throw new XdsResourceType.ResourceInvalidException("outlier_detection enforcing_success_rate is > 100");
        }
        if (outlierDetection.hasFailurePercentageThreshold() && outlierDetection.getFailurePercentageThreshold().getValue() > 100) {
            throw new XdsResourceType.ResourceInvalidException("outlier_detection failure_percentage_threshold is > 100");
        }
        if (outlierDetection.hasEnforcingFailurePercentage() && outlierDetection.getEnforcingFailurePercentage().getValue() > 100) {
            throw new XdsResourceType.ResourceInvalidException("outlier_detection enforcing_failure_percentage is > 100");
        }
        return outlierDetection;
    }

    static boolean hasNegativeValues(Duration duration) {
        return duration.getSeconds() < 0L || duration.getNanos() < 0;
    }

    @VisibleForTesting
    static UpstreamTlsContext validateUpstreamTlsContext(UpstreamTlsContext upstreamTlsContext, Set<String> certProviderInstances) throws XdsResourceType.ResourceInvalidException {
        if (!upstreamTlsContext.hasCommonTlsContext()) {
            throw new XdsResourceType.ResourceInvalidException("common-tls-context is required in upstream-tls-context");
        }
        XdsClusterResource.validateCommonTlsContext(upstreamTlsContext.getCommonTlsContext(), certProviderInstances, false);
        return upstreamTlsContext;
    }

    @VisibleForTesting
    static void validateCommonTlsContext(CommonTlsContext commonTlsContext, Set<String> certProviderInstances, boolean server) throws XdsResourceType.ResourceInvalidException {
        String rootCaInstanceName;
        if (commonTlsContext.hasCustomHandshaker()) {
            throw new XdsResourceType.ResourceInvalidException("common-tls-context with custom_handshaker is not supported");
        }
        if (commonTlsContext.hasTlsParams()) {
            throw new XdsResourceType.ResourceInvalidException("common-tls-context with tls_params is not supported");
        }
        if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            throw new XdsResourceType.ResourceInvalidException("common-tls-context with validation_context_sds_secret_config is not supported");
        }
        String certInstanceName = XdsClusterResource.getIdentityCertInstanceName(commonTlsContext);
        if (certInstanceName == null) {
            if (server) {
                throw new XdsResourceType.ResourceInvalidException("tls_certificate_provider_instance is required in downstream-tls-context");
            }
            if (commonTlsContext.getTlsCertificatesCount() > 0) {
                throw new XdsResourceType.ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
            if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
                throw new XdsResourceType.ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
        } else if (certProviderInstances == null || !certProviderInstances.contains(certInstanceName)) {
            throw new XdsResourceType.ResourceInvalidException("CertificateProvider instance name '" + certInstanceName + "' not defined in the bootstrap file.");
        }
        if ((rootCaInstanceName = XdsClusterResource.getRootCertInstanceName(commonTlsContext)) == null) {
            if (!(server || enableSystemRootCerts && CommonTlsContextUtil.isUsingSystemRootCerts(commonTlsContext))) {
                throw new XdsResourceType.ResourceInvalidException("ca_certificate_provider_instance or system_root_certs is required in upstream-tls-context");
            }
        } else {
            if (certProviderInstances == null || !certProviderInstances.contains(rootCaInstanceName)) {
                throw new XdsResourceType.ResourceInvalidException("ca_certificate_provider_instance name '" + rootCaInstanceName + "' not defined in the bootstrap file.");
            }
            CertificateValidationContext certificateValidationContext = null;
            if (commonTlsContext.hasValidationContext()) {
                certificateValidationContext = commonTlsContext.getValidationContext();
            } else if (commonTlsContext.hasCombinedValidationContext() && commonTlsContext.getCombinedValidationContext().hasDefaultValidationContext()) {
                certificateValidationContext = commonTlsContext.getCombinedValidationContext().getDefaultValidationContext();
            }
            if (certificateValidationContext != null) {
                int matchSubjectAltNamesCount = certificateValidationContext.getMatchSubjectAltNamesCount();
                if (matchSubjectAltNamesCount > 0 && server) {
                    throw new XdsResourceType.ResourceInvalidException("match_subject_alt_names only allowed in upstream_tls_context");
                }
                if (certificateValidationContext.getVerifyCertificateSpkiCount() > 0) {
                    throw new XdsResourceType.ResourceInvalidException("verify_certificate_spki in default_validation_context is not supported");
                }
                if (certificateValidationContext.getVerifyCertificateHashCount() > 0) {
                    throw new XdsResourceType.ResourceInvalidException("verify_certificate_hash in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasRequireSignedCertificateTimestamp()) {
                    throw new XdsResourceType.ResourceInvalidException("require_signed_certificate_timestamp in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasCrl()) {
                    throw new XdsResourceType.ResourceInvalidException("crl in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasCustomValidatorConfig()) {
                    throw new XdsResourceType.ResourceInvalidException("custom_validator_config in default_validation_context is not supported");
                }
            }
        }
    }

    private static String getIdentityCertInstanceName(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasTlsCertificateProviderInstance()) {
            return commonTlsContext.getTlsCertificateProviderInstance().getInstanceName();
        }
        return null;
    }

    private static String getRootCertInstanceName(CommonTlsContext commonTlsContext) {
        CommonTlsContext.CombinedCertificateValidationContext combinedCertificateValidationContext;
        if (commonTlsContext.hasValidationContext()) {
            if (commonTlsContext.getValidationContext().hasCaCertificateProviderInstance()) {
                return commonTlsContext.getValidationContext().getCaCertificateProviderInstance().getInstanceName();
            }
        } else if (commonTlsContext.hasCombinedValidationContext() && (combinedCertificateValidationContext = commonTlsContext.getCombinedValidationContext()).hasDefaultValidationContext() && combinedCertificateValidationContext.getDefaultValidationContext().hasCaCertificateProviderInstance()) {
            return combinedCertificateValidationContext.getDefaultValidationContext().getCaCertificateProviderInstance().getInstanceName();
        }
        return null;
    }

    @AutoValue
    static abstract class CdsUpdate
    implements XdsClient.ResourceUpdate {
        CdsUpdate() {
        }

        abstract String clusterName();

        abstract ClusterType clusterType();

        abstract ImmutableMap<String, ?> lbPolicyConfig();

        abstract long minRingSize();

        abstract long maxRingSize();

        abstract int choiceCount();

        @Nullable
        abstract String edsServiceName();

        @Nullable
        abstract String dnsHostName();

        @Nullable
        abstract Bootstrapper.ServerInfo lrsServerInfo();

        @Nullable
        abstract Long maxConcurrentRequests();

        @Nullable
        abstract EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext();

        abstract boolean isHttp11ProxyAvailable();

        @Nullable
        abstract ImmutableList<String> prioritizedClusterNames();

        @Nullable
        abstract EnvoyServerProtoData.OutlierDetection outlierDetection();

        abstract ImmutableMap<String, Struct> filterMetadata();

        abstract ImmutableMap<String, Object> parsedMetadata();

        private static Builder newBuilder(String clusterName) {
            return new AutoValue_XdsClusterResource_CdsUpdate.Builder().clusterName(clusterName).minRingSize(0L).maxRingSize(0L).choiceCount(0).filterMetadata((ImmutableMap<String, Struct>)ImmutableMap.of()).parsedMetadata((ImmutableMap<String, Object>)ImmutableMap.of()).isHttp11ProxyAvailable(false);
        }

        static Builder forAggregate(String clusterName, List<String> prioritizedClusterNames) {
            Preconditions.checkNotNull(prioritizedClusterNames, (Object)"prioritizedClusterNames");
            return CdsUpdate.newBuilder(clusterName).clusterType(ClusterType.AGGREGATE).prioritizedClusterNames((List<String>)ImmutableList.copyOf(prioritizedClusterNames));
        }

        static Builder forEds(String clusterName, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, @Nullable EnvoyServerProtoData.OutlierDetection outlierDetection, boolean isHttp11ProxyAvailable) {
            return CdsUpdate.newBuilder(clusterName).clusterType(ClusterType.EDS).edsServiceName(edsServiceName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext).outlierDetection(outlierDetection).isHttp11ProxyAvailable(isHttp11ProxyAvailable);
        }

        static Builder forLogicalDns(String clusterName, String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, boolean isHttp11ProxyAvailable) {
            return CdsUpdate.newBuilder(clusterName).clusterType(ClusterType.LOGICAL_DNS).dnsHostName(dnsHostName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext).isHttp11ProxyAvailable(isHttp11ProxyAvailable);
        }

        public final String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName()).add("clusterType", (Object)this.clusterType()).add("lbPolicyConfig", this.lbPolicyConfig()).add("minRingSize", this.minRingSize()).add("maxRingSize", this.maxRingSize()).add("choiceCount", this.choiceCount()).add("edsServiceName", (Object)this.edsServiceName()).add("dnsHostName", (Object)this.dnsHostName()).add("lrsServerInfo", (Object)this.lrsServerInfo()).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests()).add("prioritizedClusterNames", this.prioritizedClusterNames()).toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            protected abstract Builder clusterName(String var1);

            protected abstract Builder clusterType(ClusterType var1);

            protected abstract Builder lbPolicyConfig(ImmutableMap<String, ?> var1);

            Builder roundRobinLbPolicy() {
                return this.lbPolicyConfig(ImmutableMap.of((Object)"round_robin", (Object)ImmutableMap.of()));
            }

            Builder ringHashLbPolicy(Long minRingSize, Long maxRingSize) {
                return this.lbPolicyConfig(ImmutableMap.of((Object)"ring_hash_experimental", (Object)ImmutableMap.of((Object)"minRingSize", (Object)minRingSize.doubleValue(), (Object)"maxRingSize", (Object)maxRingSize.doubleValue())));
            }

            Builder leastRequestLbPolicy(Integer choiceCount) {
                return this.lbPolicyConfig(ImmutableMap.of((Object)"least_request_experimental", (Object)ImmutableMap.of((Object)"choiceCount", (Object)choiceCount.doubleValue())));
            }

            protected abstract Builder choiceCount(int var1);

            protected abstract Builder minRingSize(long var1);

            protected abstract Builder maxRingSize(long var1);

            protected abstract Builder edsServiceName(String var1);

            protected abstract Builder dnsHostName(String var1);

            protected abstract Builder lrsServerInfo(Bootstrapper.ServerInfo var1);

            protected abstract Builder maxConcurrentRequests(Long var1);

            protected abstract Builder isHttp11ProxyAvailable(boolean var1);

            protected abstract Builder upstreamTlsContext(EnvoyServerProtoData.UpstreamTlsContext var1);

            protected abstract Builder prioritizedClusterNames(List<String> var1);

            protected abstract Builder outlierDetection(EnvoyServerProtoData.OutlierDetection var1);

            protected abstract Builder filterMetadata(ImmutableMap<String, Struct> var1);

            protected abstract Builder parsedMetadata(ImmutableMap<String, Object> var1);

            abstract CdsUpdate build();
        }

        static enum LbPolicy {
            ROUND_ROBIN,
            RING_HASH,
            LEAST_REQUEST;

        }

        static enum ClusterType {
            EDS,
            LOGICAL_DNS,
            AGGREGATE;

        }
    }
}

