/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.StatusOr;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClusterResource;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.XdsListenerResource;
import io.grpc.xds.XdsRouteConfigureResource;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class XdsConfig {
    private final XdsListenerResource.LdsUpdate listener;
    private final XdsRouteConfigureResource.RdsUpdate route;
    private final VirtualHost virtualHost;
    private final ImmutableMap<String, StatusOr<XdsClusterConfig>> clusters;
    private final int hashCode;

    XdsConfig(XdsListenerResource.LdsUpdate listener, XdsRouteConfigureResource.RdsUpdate route, Map<String, StatusOr<XdsClusterConfig>> clusters, VirtualHost virtualHost) {
        this(listener, route, virtualHost, (ImmutableMap<String, StatusOr<XdsClusterConfig>>)ImmutableMap.copyOf(clusters));
    }

    public XdsConfig(XdsListenerResource.LdsUpdate listener, XdsRouteConfigureResource.RdsUpdate route, VirtualHost virtualHost, ImmutableMap<String, StatusOr<XdsClusterConfig>> clusters) {
        this.listener = listener;
        this.route = route;
        this.virtualHost = virtualHost;
        this.clusters = clusters;
        this.hashCode = Objects.hash(listener, route, virtualHost, clusters);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XdsConfig)) {
            return false;
        }
        XdsConfig o = (XdsConfig)obj;
        return this.hashCode() == o.hashCode() && Objects.equals(this.listener, o.listener) && Objects.equals(this.route, o.route) && Objects.equals(this.virtualHost, o.virtualHost) && Objects.equals(this.clusters, o.clusters);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XdsConfig{").append("\n  listener=").append(this.listener).append(",\n  route=").append(this.route).append(",\n  virtualHost=").append(this.virtualHost).append(",\n  clusters=").append(this.clusters).append("\n}");
        return builder.toString();
    }

    public XdsListenerResource.LdsUpdate getListener() {
        return this.listener;
    }

    public XdsRouteConfigureResource.RdsUpdate getRoute() {
        return this.route;
    }

    public VirtualHost getVirtualHost() {
        return this.virtualHost;
    }

    public ImmutableMap<String, StatusOr<XdsClusterConfig>> getClusters() {
        return this.clusters;
    }

    public static interface XdsClusterSubscriptionRegistry {
        public Closeable subscribeToCluster(String var1);
    }

    static final class XdsConfigBuilder {
        private XdsListenerResource.LdsUpdate listener;
        private XdsRouteConfigureResource.RdsUpdate route;
        private Map<String, StatusOr<XdsClusterConfig>> clusters = new HashMap<String, StatusOr<XdsClusterConfig>>();
        private VirtualHost virtualHost;

        XdsConfigBuilder() {
        }

        XdsConfigBuilder setListener(XdsListenerResource.LdsUpdate listener) {
            this.listener = (XdsListenerResource.LdsUpdate)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            return this;
        }

        XdsConfigBuilder setRoute(XdsRouteConfigureResource.RdsUpdate route) {
            this.route = (XdsRouteConfigureResource.RdsUpdate)Preconditions.checkNotNull((Object)route, (Object)"route");
            return this;
        }

        XdsConfigBuilder addCluster(String name, StatusOr<XdsClusterConfig> clusterConfig) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull(clusterConfig, (Object)"clusterConfig");
            this.clusters.put(name, clusterConfig);
            return this;
        }

        XdsConfigBuilder setVirtualHost(VirtualHost virtualHost) {
            this.virtualHost = (VirtualHost)Preconditions.checkNotNull((Object)virtualHost, (Object)"virtualHost");
            return this;
        }

        XdsConfig build() {
            Preconditions.checkNotNull((Object)this.listener, (Object)"listener");
            Preconditions.checkNotNull((Object)this.route, (Object)"route");
            Preconditions.checkNotNull((Object)this.virtualHost, (Object)"virtualHost");
            return new XdsConfig(this.listener, this.route, this.clusters, this.virtualHost);
        }
    }

    static final class XdsClusterConfig {
        private final String clusterName;
        private final XdsClusterResource.CdsUpdate clusterResource;
        private final ClusterChild children;

        XdsClusterConfig(String clusterName, XdsClusterResource.CdsUpdate clusterResource, ClusterChild details) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.clusterResource = (XdsClusterResource.CdsUpdate)Preconditions.checkNotNull((Object)clusterResource, (Object)"clusterResource");
            this.children = (ClusterChild)Preconditions.checkNotNull((Object)details, (Object)"details");
        }

        public int hashCode() {
            return this.clusterName.hashCode() + this.clusterResource.hashCode() + this.children.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XdsClusterConfig)) {
                return false;
            }
            XdsClusterConfig o = (XdsClusterConfig)obj;
            return Objects.equals(this.clusterName, o.clusterName) && Objects.equals(this.clusterResource, o.clusterResource) && Objects.equals(this.children, o.children);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("XdsClusterConfig{clusterName=").append(this.clusterName).append(", clusterResource=").append(this.clusterResource).append(", children={").append(this.children).append("}");
            return builder.toString();
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public XdsClusterResource.CdsUpdate getClusterResource() {
            return this.clusterResource;
        }

        public ClusterChild getChildren() {
            return this.children;
        }

        static final class AggregateConfig
        implements ClusterChild {
            private final List<String> leafNames;

            public AggregateConfig(List<String> leafNames) {
                this.leafNames = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(leafNames, (Object)"leafNames")));
            }

            public List<String> getLeafNames() {
                return this.leafNames;
            }

            public int hashCode() {
                return this.leafNames.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof AggregateConfig)) {
                    return false;
                }
                return Objects.equals(this.leafNames, ((AggregateConfig)obj).leafNames);
            }
        }

        static final class EndpointConfig
        implements ClusterChild {
            private final StatusOr<XdsEndpointResource.EdsUpdate> endpoint;

            public EndpointConfig(StatusOr<XdsEndpointResource.EdsUpdate> endpoint) {
                this.endpoint = (StatusOr)Preconditions.checkNotNull(endpoint, (Object)"endpoint");
            }

            public int hashCode() {
                return this.endpoint.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof EndpointConfig)) {
                    return false;
                }
                return Objects.equals(this.endpoint, ((EndpointConfig)obj).endpoint);
            }

            public StatusOr<XdsEndpointResource.EdsUpdate> getEndpoint() {
                return this.endpoint;
            }

            public String toString() {
                if (this.endpoint.hasValue()) {
                    return "EndpointConfig{endpoint=" + this.endpoint.getValue() + "}";
                }
                return "EndpointConfig{error=" + this.endpoint.getStatus() + "}";
            }
        }

        static interface ClusterChild {
        }
    }
}

