/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.StatusOr;
import io.grpc.SynchronizationContext;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.RoutingUtils;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClusterResource;
import io.grpc.xds.XdsConfig;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.XdsListenerResource;
import io.grpc.xds.XdsRouteConfigureResource;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsResourceType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

final class XdsDependencyManager
implements XdsConfig.XdsClusterSubscriptionRegistry {
    public static final XdsClusterResource CLUSTER_RESOURCE = XdsClusterResource.getInstance();
    public static final XdsEndpointResource ENDPOINT_RESOURCE = XdsEndpointResource.getInstance();
    private static final int MAX_CLUSTER_RECURSION_DEPTH = 16;
    private final String listenerName;
    private final XdsClient xdsClient;
    private final XdsConfigWatcher xdsConfigWatcher;
    private final SynchronizationContext syncContext;
    private final String dataPlaneAuthority;
    private StatusOr<XdsConfig> lastUpdate = null;
    private final Map<XdsResourceType<?>, TypeWatchers<?>> resourceWatchers = new HashMap();
    private final Set<ClusterSubscription> subscriptions = new HashSet<ClusterSubscription>();

    XdsDependencyManager(XdsClient xdsClient, XdsConfigWatcher xdsConfigWatcher, SynchronizationContext syncContext, String dataPlaneAuthority, String listenerName, NameResolver.Args nameResolverArgs, ScheduledExecutorService scheduler) {
        this.listenerName = (String)Preconditions.checkNotNull((Object)listenerName, (Object)"listenerName");
        this.xdsClient = (XdsClient)Preconditions.checkNotNull((Object)xdsClient, (Object)"xdsClient");
        this.xdsConfigWatcher = (XdsConfigWatcher)Preconditions.checkNotNull((Object)xdsConfigWatcher, (Object)"xdsConfigWatcher");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.dataPlaneAuthority = (String)Preconditions.checkNotNull((Object)dataPlaneAuthority, (Object)"dataPlaneAuthority");
        Preconditions.checkNotNull((Object)nameResolverArgs, (Object)"nameResolverArgs");
        Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler");
        syncContext.execute(() -> this.addWatcher(new LdsWatcher(listenerName)));
    }

    public static String toContextStr(String typeName, String resourceName) {
        return typeName + " resource " + resourceName;
    }

    @Override
    public Closeable subscribeToCluster(String clusterName) {
        Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
        ClusterSubscription subscription = new ClusterSubscription(clusterName);
        this.syncContext.execute(() -> {
            if (this.getWatchers(XdsListenerResource.getInstance()).isEmpty()) {
                subscription.closed = true;
                return;
            }
            this.subscriptions.add(subscription);
            this.addClusterWatcher(clusterName);
        });
        return subscription;
    }

    private <T extends XdsClient.ResourceUpdate> void addWatcher(XdsWatcherBase<T> watcher) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        XdsResourceType type = ((XdsWatcherBase)watcher).type;
        String resourceName = ((XdsWatcherBase)watcher).resourceName;
        this.getWatchers(type).put(resourceName, watcher);
        this.xdsClient.watchXdsResource(type, resourceName, watcher, (Executor)this.syncContext);
    }

    public void shutdown() {
        this.syncContext.execute(() -> {
            for (TypeWatchers<?> watchers : this.resourceWatchers.values()) {
                this.shutdownWatchersForType(watchers);
            }
            this.resourceWatchers.clear();
            this.subscriptions.clear();
        });
    }

    private <T extends XdsClient.ResourceUpdate> void shutdownWatchersForType(TypeWatchers<T> watchers) {
        for (Map.Entry watcherEntry : watchers.watchers.entrySet()) {
            this.xdsClient.cancelXdsResourceWatch(watchers.resourceType, watcherEntry.getKey(), watcherEntry.getValue());
            watcherEntry.getValue().cancelled = true;
        }
    }

    private void releaseSubscription(ClusterSubscription subscription) {
        Preconditions.checkNotNull((Object)subscription, (Object)"subscription");
        this.syncContext.execute(() -> {
            if (subscription.closed) {
                return;
            }
            subscription.closed = true;
            if (!this.subscriptions.remove(subscription)) {
                return;
            }
            this.maybePublishConfig();
        });
    }

    private void maybePublishConfig() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.getWatchers(XdsListenerResource.getInstance()).isEmpty()) {
            return;
        }
        boolean waitingOnResource = this.resourceWatchers.values().stream().flatMap(typeWatchers -> typeWatchers.watchers.values().stream()).anyMatch(XdsWatcherBase::missingResult);
        if (waitingOnResource) {
            return;
        }
        StatusOr<XdsConfig> newUpdate = this.buildUpdate();
        if (Objects.equals(newUpdate, this.lastUpdate)) {
            return;
        }
        assert (newUpdate.hasValue() || newUpdate.getStatus().getCode() == Status.Code.UNAVAILABLE || newUpdate.getStatus().getCode() == Status.Code.INTERNAL);
        this.lastUpdate = newUpdate;
        this.xdsConfigWatcher.onUpdate(this.lastUpdate);
    }

    @VisibleForTesting
    StatusOr<XdsConfig> buildUpdate() {
        WatcherTracer tracer = new WatcherTracer(this.resourceWatchers);
        StatusOr<XdsConfig> config = XdsDependencyManager.buildUpdate(tracer, this.listenerName, this.dataPlaneAuthority, this.subscriptions);
        tracer.closeUnusedWatchers();
        return config;
    }

    private static StatusOr<XdsConfig> buildUpdate(WatcherTracer tracer, String listenerName, String dataPlaneAuthority, Set<ClusterSubscription> subscriptions) {
        XdsConfig.XdsConfigBuilder builder = new XdsConfig.XdsConfigBuilder();
        XdsWatcherBase<XdsListenerResource.LdsUpdate> ldsWatcher = tracer.getWatcher(XdsListenerResource.getInstance(), listenerName);
        if (ldsWatcher == null) {
            return StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription("Bug: No listener watcher found for " + listenerName));
        }
        if (!ldsWatcher.getData().hasValue()) {
            return StatusOr.fromStatus((Status)ldsWatcher.getData().getStatus());
        }
        XdsListenerResource.LdsUpdate ldsUpdate = (XdsListenerResource.LdsUpdate)ldsWatcher.getData().getValue();
        builder.setListener(ldsUpdate);
        RdsUpdateSupplier routeSource = ((LdsWatcher)ldsWatcher).getRouteSource(tracer);
        if (routeSource == null) {
            return StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription("Bug: No route source found for listener " + dataPlaneAuthority));
        }
        StatusOr<XdsRouteConfigureResource.RdsUpdate> statusOrRdsUpdate = routeSource.getRdsUpdate();
        if (!statusOrRdsUpdate.hasValue()) {
            return StatusOr.fromStatus((Status)statusOrRdsUpdate.getStatus());
        }
        XdsRouteConfigureResource.RdsUpdate rdsUpdate = (XdsRouteConfigureResource.RdsUpdate)statusOrRdsUpdate.getValue();
        builder.setRoute(rdsUpdate);
        VirtualHost activeVirtualHost = RoutingUtils.findVirtualHostForHostName(rdsUpdate.virtualHosts, dataPlaneAuthority);
        if (activeVirtualHost == null) {
            String error = "Failed to find virtual host matching hostname: " + dataPlaneAuthority;
            return StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription(error));
        }
        builder.setVirtualHost(activeVirtualHost);
        HashMap<String, StatusOr<XdsConfig.XdsClusterConfig>> clusters = new HashMap<String, StatusOr<XdsConfig.XdsClusterConfig>>();
        LinkedHashSet<String> ancestors = new LinkedHashSet<String>();
        for (String string : XdsDependencyManager.getClusterNamesFromVirtualHost(activeVirtualHost)) {
            XdsDependencyManager.addConfigForCluster(clusters, string, ancestors, tracer);
        }
        for (ClusterSubscription clusterSubscription : subscriptions) {
            XdsDependencyManager.addConfigForCluster(clusters, clusterSubscription.getClusterName(), ancestors, tracer);
        }
        for (Map.Entry entry : clusters.entrySet()) {
            builder.addCluster((String)entry.getKey(), (StatusOr<XdsConfig.XdsClusterConfig>)((StatusOr)entry.getValue()));
        }
        return StatusOr.fromValue((Object)builder.build());
    }

    private <T extends XdsClient.ResourceUpdate> Map<String, XdsWatcherBase<T>> getWatchers(XdsResourceType<T> resourceType) {
        TypeWatchers<Object> typeWatchers = this.resourceWatchers.get(resourceType);
        if (typeWatchers == null) {
            typeWatchers = new TypeWatchers<T>(resourceType);
            this.resourceWatchers.put(resourceType, typeWatchers);
        }
        assert (typeWatchers.resourceType == resourceType);
        TypeWatchers<?> tTypeWatchers = typeWatchers;
        return tTypeWatchers.watchers;
    }

    private static void addConfigForCluster(Map<String, StatusOr<XdsConfig.XdsClusterConfig>> clusters, String clusterName, LinkedHashSet<String> ancestors, WatcherTracer tracer) {
        XdsConfig.XdsClusterConfig.ClusterChild child;
        if (clusters.containsKey(clusterName)) {
            return;
        }
        if (ancestors.contains(clusterName)) {
            clusters.put(clusterName, (StatusOr<XdsConfig.XdsClusterConfig>)StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("Aggregate cluster cycle detected: " + ancestors)));
            return;
        }
        if (ancestors.size() > 16) {
            clusters.put(clusterName, (StatusOr<XdsConfig.XdsClusterConfig>)StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("Recursion limit reached: " + ancestors)));
            return;
        }
        CdsWatcher cdsWatcher = (CdsWatcher)tracer.getWatcher(CLUSTER_RESOURCE, clusterName);
        StatusOr cdsWatcherDataOr = cdsWatcher.getData();
        if (!cdsWatcherDataOr.hasValue()) {
            clusters.put(clusterName, (StatusOr<XdsConfig.XdsClusterConfig>)StatusOr.fromStatus((Status)cdsWatcherDataOr.getStatus()));
            return;
        }
        XdsClusterResource.CdsUpdate cdsUpdate = (XdsClusterResource.CdsUpdate)cdsWatcherDataOr.getValue();
        switch (cdsUpdate.clusterType()) {
            case AGGREGATE: {
                LinkedHashSet<String> leafNames = new LinkedHashSet<String>();
                ancestors.add(clusterName);
                for (String childCluster : cdsUpdate.prioritizedClusterNames()) {
                    XdsDependencyManager.addConfigForCluster(clusters, childCluster, ancestors, tracer);
                    StatusOr<XdsConfig.XdsClusterConfig> config = clusters.get(childCluster);
                    if (!config.hasValue()) {
                        clusters.put(clusterName, (StatusOr<XdsConfig.XdsClusterConfig>)StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("Unable to get leaves for " + clusterName + ": " + config.getStatus().getDescription())));
                        return;
                    }
                    XdsConfig.XdsClusterConfig.ClusterChild children = ((XdsConfig.XdsClusterConfig)config.getValue()).getChildren();
                    if (children instanceof XdsConfig.XdsClusterConfig.AggregateConfig) {
                        leafNames.addAll(((XdsConfig.XdsClusterConfig.AggregateConfig)children).getLeafNames());
                        continue;
                    }
                    leafNames.add(childCluster);
                }
                ancestors.remove(clusterName);
                child = new XdsConfig.XdsClusterConfig.AggregateConfig((List<String>)ImmutableList.copyOf(leafNames));
                break;
            }
            case EDS: {
                XdsWatcherBase<XdsEndpointResource.EdsUpdate> edsWatcher = tracer.getWatcher(ENDPOINT_RESOURCE, cdsWatcher.getEdsServiceName());
                if (edsWatcher != null) {
                    child = new XdsConfig.XdsClusterConfig.EndpointConfig(edsWatcher.getData());
                    break;
                }
                child = new XdsConfig.XdsClusterConfig.EndpointConfig((StatusOr<XdsEndpointResource.EdsUpdate>)StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("EDS resource not found for cluster " + clusterName)));
                break;
            }
            case LOGICAL_DNS: {
                child = new XdsConfig.XdsClusterConfig.EndpointConfig((StatusOr<XdsEndpointResource.EdsUpdate>)StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("Logical DNS in dependency manager unsupported")));
                break;
            }
            default: {
                child = new XdsConfig.XdsClusterConfig.EndpointConfig((StatusOr<XdsEndpointResource.EdsUpdate>)StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription("Unknown type in cluster " + clusterName + " " + (Object)((Object)cdsUpdate.clusterType()))));
            }
        }
        clusters.put(clusterName, (StatusOr<XdsConfig.XdsClusterConfig>)StatusOr.fromValue((Object)new XdsConfig.XdsClusterConfig(clusterName, cdsUpdate, child)));
    }

    private void addRdsWatcher(String resourceName) {
        if (this.getWatchers(XdsRouteConfigureResource.getInstance()).containsKey(resourceName)) {
            return;
        }
        this.addWatcher(new RdsWatcher(resourceName));
    }

    private void addEdsWatcher(String edsServiceName) {
        if (this.getWatchers(XdsEndpointResource.getInstance()).containsKey(edsServiceName)) {
            return;
        }
        this.addWatcher(new EdsWatcher(edsServiceName));
    }

    private void addClusterWatcher(String clusterName) {
        if (this.getWatchers(CLUSTER_RESOURCE).containsKey(clusterName)) {
            return;
        }
        this.addWatcher(new CdsWatcher(clusterName));
    }

    private void updateRoutes(List<VirtualHost> virtualHosts) {
        VirtualHost virtualHost = RoutingUtils.findVirtualHostForHostName(virtualHosts, this.dataPlaneAuthority);
        Set<String> newClusters = XdsDependencyManager.getClusterNamesFromVirtualHost(virtualHost);
        newClusters.forEach(cluster -> this.addClusterWatcher((String)cluster));
    }

    private String nodeInfo() {
        return " nodeID: " + this.xdsClient.getBootstrapInfo().node().getId();
    }

    private static Set<String> getClusterNamesFromVirtualHost(VirtualHost virtualHost) {
        if (virtualHost == null) {
            return Collections.emptySet();
        }
        HashSet<String> clusters = new HashSet<String>();
        for (VirtualHost.Route route : virtualHost.routes()) {
            VirtualHost.Route.RouteAction action = route.routeAction();
            if (action == null) continue;
            if (action.cluster() != null) {
                clusters.add(action.cluster());
                continue;
            }
            if (action.weightedClusters() == null) continue;
            for (VirtualHost.Route.RouteAction.ClusterWeight weighedCluster : action.weightedClusters()) {
                clusters.add(weighedCluster.name());
            }
        }
        return clusters;
    }

    private class EdsWatcher
    extends XdsWatcherBase<XdsEndpointResource.EdsUpdate> {
        private EdsWatcher(String resourceName) {
            super(ENDPOINT_RESOURCE, (String)Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName"));
        }

        @Override
        public void subscribeToChildren(XdsEndpointResource.EdsUpdate update) {
        }
    }

    private class CdsWatcher
    extends XdsWatcherBase<XdsClusterResource.CdsUpdate> {
        CdsWatcher(String resourceName) {
            super(CLUSTER_RESOURCE, (String)Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName"));
        }

        @Override
        public void subscribeToChildren(XdsClusterResource.CdsUpdate update) {
            switch (update.clusterType()) {
                case EDS: {
                    XdsDependencyManager.this.addEdsWatcher(this.getEdsServiceName());
                    break;
                }
                case LOGICAL_DNS: {
                    break;
                }
                case AGGREGATE: {
                    update.prioritizedClusterNames().forEach(name -> XdsDependencyManager.this.addClusterWatcher(name));
                    break;
                }
            }
        }

        public String getEdsServiceName() {
            XdsClusterResource.CdsUpdate cdsUpdate = (XdsClusterResource.CdsUpdate)this.getData().getValue();
            assert (cdsUpdate.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.EDS);
            String edsServiceName = cdsUpdate.edsServiceName();
            if (edsServiceName == null) {
                edsServiceName = cdsUpdate.clusterName();
            }
            return edsServiceName;
        }
    }

    private class RdsWatcher
    extends XdsWatcherBase<XdsRouteConfigureResource.RdsUpdate>
    implements RdsUpdateSupplier {
        public RdsWatcher(String resourceName) {
            super(XdsRouteConfigureResource.getInstance(), (String)Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName"));
        }

        @Override
        public void subscribeToChildren(XdsRouteConfigureResource.RdsUpdate update) {
            XdsDependencyManager.this.updateRoutes(update.virtualHosts);
        }

        @Override
        public StatusOr<XdsRouteConfigureResource.RdsUpdate> getRdsUpdate() {
            if (this.missingResult()) {
                return StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription("Not yet loaded"));
            }
            return this.getData();
        }
    }

    private class LdsWatcher
    extends XdsWatcherBase<XdsListenerResource.LdsUpdate>
    implements RdsUpdateSupplier {
        private LdsWatcher(String resourceName) {
            super(XdsListenerResource.getInstance(), resourceName);
        }

        @Override
        public void subscribeToChildren(XdsListenerResource.LdsUpdate update) {
            String rdsName;
            HttpConnectionManager httpConnectionManager = update.httpConnectionManager();
            List<Object> virtualHosts = httpConnectionManager == null ? Collections.emptyList() : httpConnectionManager.virtualHosts();
            if (virtualHosts != null) {
                XdsDependencyManager.this.updateRoutes(virtualHosts);
            }
            if ((rdsName = this.getRdsName(update)) != null) {
                XdsDependencyManager.this.addRdsWatcher(rdsName);
            }
        }

        private String getRdsName(XdsListenerResource.LdsUpdate update) {
            HttpConnectionManager httpConnectionManager = update.httpConnectionManager();
            if (httpConnectionManager == null) {
                return null;
            }
            return httpConnectionManager.rdsName();
        }

        private RdsWatcher getRdsWatcher(XdsListenerResource.LdsUpdate update, WatcherTracer tracer) {
            String rdsName = this.getRdsName(update);
            if (rdsName == null) {
                return null;
            }
            return (RdsWatcher)tracer.getWatcher(XdsRouteConfigureResource.getInstance(), rdsName);
        }

        public RdsUpdateSupplier getRouteSource(WatcherTracer tracer) {
            if (!this.hasDataValue()) {
                return this;
            }
            HttpConnectionManager hcm = ((XdsListenerResource.LdsUpdate)this.getData().getValue()).httpConnectionManager();
            if (hcm == null) {
                return this;
            }
            ImmutableList<VirtualHost> virtualHosts = hcm.virtualHosts();
            if (virtualHosts != null) {
                return this;
            }
            RdsWatcher rdsWatcher = this.getRdsWatcher((XdsListenerResource.LdsUpdate)this.getData().getValue(), tracer);
            assert (rdsWatcher != null);
            return rdsWatcher;
        }

        @Override
        public StatusOr<XdsRouteConfigureResource.RdsUpdate> getRdsUpdate() {
            if (this.missingResult()) {
                return StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription("Not yet loaded"));
            }
            if (!this.getData().hasValue()) {
                return StatusOr.fromStatus((Status)this.getData().getStatus());
            }
            HttpConnectionManager hcm = ((XdsListenerResource.LdsUpdate)this.getData().getValue()).httpConnectionManager();
            if (hcm == null) {
                return StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription("Not an API listener" + XdsDependencyManager.this.nodeInfo()));
            }
            ImmutableList<VirtualHost> virtualHosts = hcm.virtualHosts();
            if (virtualHosts == null) {
                return StatusOr.fromStatus((Status)Status.INTERNAL.withDescription("Routes are in RDS, not LDS"));
            }
            return StatusOr.fromValue((Object)new XdsRouteConfigureResource.RdsUpdate((List<VirtualHost>)virtualHosts));
        }
    }

    private static interface RdsUpdateSupplier {
        public StatusOr<XdsRouteConfigureResource.RdsUpdate> getRdsUpdate();
    }

    private abstract class XdsWatcherBase<T extends XdsClient.ResourceUpdate>
    implements XdsClient.ResourceWatcher<T> {
        private final XdsResourceType<T> type;
        private final String resourceName;
        boolean cancelled;
        @Nullable
        private StatusOr<T> data;

        private XdsWatcherBase(XdsResourceType<T> type, String resourceName) {
            this.type = (XdsResourceType)Preconditions.checkNotNull(type, (Object)"type");
            this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"resourceName");
        }

        @Override
        public void onError(Status error) {
            Preconditions.checkNotNull((Object)error, (Object)"error");
            if (this.cancelled) {
                return;
            }
            if (!this.hasDataValue()) {
                this.data = StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription(String.format("Error retrieving %s: %s: %s", this.toContextString(), error.getCode(), error.getDescription())));
                XdsDependencyManager.this.maybePublishConfig();
            }
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            if (this.cancelled) {
                return;
            }
            Preconditions.checkArgument((boolean)this.resourceName.equals(resourceName), (Object)"Resource name does not match");
            this.data = StatusOr.fromStatus((Status)Status.UNAVAILABLE.withDescription(this.toContextString() + " does not exist" + XdsDependencyManager.this.nodeInfo()));
            XdsDependencyManager.this.maybePublishConfig();
        }

        @Override
        public void onChanged(T update) {
            Preconditions.checkNotNull(update, (Object)"update");
            if (this.cancelled) {
                return;
            }
            this.data = StatusOr.fromValue(update);
            this.subscribeToChildren(update);
            XdsDependencyManager.this.maybePublishConfig();
        }

        protected abstract void subscribeToChildren(T var1);

        public void close() {
            this.cancelled = true;
            XdsDependencyManager.this.xdsClient.cancelXdsResourceWatch(this.type, this.resourceName, this);
        }

        boolean missingResult() {
            return this.data == null;
        }

        @Nullable
        StatusOr<T> getData() {
            return this.data;
        }

        boolean hasDataValue() {
            return this.data != null && this.data.hasValue();
        }

        public String toContextString() {
            return XdsDependencyManager.toContextStr(this.type.typeName(), this.resourceName);
        }
    }

    private static final class WatcherTracer {
        private final Map<XdsResourceType<?>, TypeWatchers<?>> resourceWatchers;
        private final Map<XdsResourceType<?>, TypeWatchers<?>> usedWatchers;

        public WatcherTracer(Map<XdsResourceType<?>, TypeWatchers<?>> resourceWatchers) {
            this.resourceWatchers = resourceWatchers;
            this.usedWatchers = new HashMap();
            for (XdsResourceType<?> type : resourceWatchers.keySet()) {
                this.usedWatchers.put(type, WatcherTracer.newTypeWatchers(type));
            }
        }

        private static <T extends XdsClient.ResourceUpdate> TypeWatchers<T> newTypeWatchers(XdsResourceType<T> type) {
            return new TypeWatchers<T>(type);
        }

        public <T extends XdsClient.ResourceUpdate> XdsWatcherBase<T> getWatcher(XdsResourceType<T> resourceType, String name) {
            TypeWatchers<?> typeWatchers = this.resourceWatchers.get(resourceType);
            if (typeWatchers == null) {
                return null;
            }
            assert (typeWatchers.resourceType == resourceType);
            TypeWatchers<?> tTypeWatchers = typeWatchers;
            XdsWatcherBase watcher = tTypeWatchers.watchers.get(name);
            if (watcher == null) {
                return null;
            }
            TypeWatchers<?> usedTypeWatchers = this.usedWatchers.get(resourceType);
            usedTypeWatchers.watchers.put(name, watcher);
            return watcher;
        }

        public void closeUnusedWatchers() {
            boolean changed = false;
            for (XdsResourceType<?> type : this.resourceWatchers.keySet()) {
                TypeWatchers<?> orig = this.resourceWatchers.get(type);
                TypeWatchers<?> used = this.usedWatchers.get(type);
                for (String name : orig.watchers.keySet()) {
                    if (used.watchers.containsKey(name)) continue;
                    orig.watchers.get(name).close();
                    changed = true;
                }
            }
            if (changed) {
                this.resourceWatchers.putAll(this.usedWatchers);
            }
        }
    }

    private final class ClusterSubscription
    implements Closeable {
        private final String clusterName;
        boolean closed;

        public ClusterSubscription(String clusterName) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
        }

        String getClusterName() {
            return this.clusterName;
        }

        @Override
        public void close() throws IOException {
            XdsDependencyManager.this.releaseSubscription(this);
        }
    }

    public static interface XdsConfigWatcher {
        public void onUpdate(StatusOr<XdsConfig> var1);
    }

    private static class TypeWatchers<T extends XdsClient.ResourceUpdate> {
        final Map<String, XdsWatcherBase<T>> watchers = new HashMap<String, XdsWatcherBase<T>>();
        final XdsResourceType<T> resourceType;

        TypeWatchers(XdsResourceType<T> resourceType) {
            this.resourceType = resourceType;
        }
    }
}

