/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ObjectCountHashMap;
import java.util.Arrays;

@GwtCompatible(serializable=true, emulated=true)
class ObjectCountLinkedHashMap<K>
extends ObjectCountHashMap<K> {
    private static final int ENDPOINT = -2;
    @VisibleForTesting
    transient long[] links;
    private transient int firstEntry;
    private transient int lastEntry;

    public static <K> ObjectCountLinkedHashMap<K> create() {
        return new ObjectCountLinkedHashMap<K>();
    }

    public static <K> ObjectCountLinkedHashMap<K> createWithExpectedSize(int expectedSize) {
        return new ObjectCountLinkedHashMap<K>(expectedSize);
    }

    ObjectCountLinkedHashMap() {
        this(3);
    }

    ObjectCountLinkedHashMap(int expectedSize) {
        this(expectedSize, 1.0f);
    }

    ObjectCountLinkedHashMap(int expectedSize, float loadFactor) {
        super(expectedSize, loadFactor);
    }

    ObjectCountLinkedHashMap(ObjectCountHashMap<K> map2) {
        this.init(map2.size(), 1.0f);
        int i = map2.firstIndex();
        while (i != -1) {
            this.put(map2.getKey(i), map2.getValue(i));
            i = map2.nextIndex(i);
        }
    }

    @Override
    void init(int expectedSize, float loadFactor) {
        super.init(expectedSize, loadFactor);
        this.firstEntry = -2;
        this.lastEntry = -2;
        this.links = new long[expectedSize];
        Arrays.fill(this.links, -1L);
    }

    @Override
    int firstIndex() {
        return this.firstEntry == -2 ? -1 : this.firstEntry;
    }

    @Override
    int nextIndex(int index) {
        int result2 = this.getSuccessor(index);
        return result2 == -2 ? -1 : result2;
    }

    @Override
    int nextIndexAfterRemove(int oldNextIndex, int removedIndex) {
        return oldNextIndex == this.size() ? removedIndex : oldNextIndex;
    }

    private int getPredecessor(int entry) {
        return (int)(this.links[entry] >>> 32);
    }

    private int getSuccessor(int entry) {
        return (int)this.links[entry];
    }

    private void setSuccessor(int entry, int succ) {
        long succMask = 0xFFFFFFFFL;
        this.links[entry] = this.links[entry] & (succMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)succ & succMask;
    }

    private void setPredecessor(int entry, int pred) {
        long predMask = -4294967296L;
        this.links[entry] = this.links[entry] & (predMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)pred << 32;
    }

    private void setSucceeds(int pred, int succ) {
        if (pred == -2) {
            this.firstEntry = succ;
        } else {
            this.setSuccessor(pred, succ);
        }
        if (succ == -2) {
            this.lastEntry = pred;
        } else {
            this.setPredecessor(succ, pred);
        }
    }

    @Override
    void insertEntry(int entryIndex, K key, int value, int hash) {
        super.insertEntry(entryIndex, key, value, hash);
        this.setSucceeds(this.lastEntry, entryIndex);
        this.setSucceeds(entryIndex, -2);
    }

    @Override
    void moveLastEntry(int dstIndex) {
        int srcIndex = this.size() - 1;
        this.setSucceeds(this.getPredecessor(dstIndex), this.getSuccessor(dstIndex));
        if (dstIndex < srcIndex) {
            this.setSucceeds(this.getPredecessor(srcIndex), dstIndex);
            this.setSucceeds(dstIndex, this.getSuccessor(srcIndex));
        }
        super.moveLastEntry(dstIndex);
    }

    @Override
    void resizeEntries(int newCapacity) {
        super.resizeEntries(newCapacity);
        int oldCapacity = this.links.length;
        this.links = Arrays.copyOf(this.links, newCapacity);
        Arrays.fill(this.links, oldCapacity, newCapacity, -1L);
    }

    @Override
    public void clear() {
        super.clear();
        this.firstEntry = -2;
        this.lastEntry = -2;
    }
}

