/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.kotlin.AbstractCoroutineStub;
import io.grpc.kotlin.ClientCalls;
import io.grpc.kotlin.StubFor;
import io.grpc.kotlin.generator.GrpcClientStubGenerator$WhenMappings;
import io.grpc.kotlin.generator.ServiceCodeGenerator;
import io.grpc.kotlin.generator.protoc.ClassSimpleName;
import io.grpc.kotlin.generator.protoc.ClassSimpleNameKt;
import io.grpc.kotlin.generator.protoc.Declarations;
import io.grpc.kotlin.generator.protoc.GeneratorConfig;
import io.grpc.kotlin.generator.protoc.KtPoetUtilKt;
import io.grpc.kotlin.generator.protoc.MemberSimpleName;
import io.grpc.kotlin.generator.protoc.MemberSimpleNameKt;
import io.grpc.kotlin.generator.protoc.ProtoMethodNameKt;
import io.grpc.kotlin.generator.protoc.ProtoServiceNameKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lio/grpc/kotlin/generator/GrpcClientStubGenerator;", "Lio/grpc/kotlin/generator/ServiceCodeGenerator;", "config", "Lio/grpc/kotlin/generator/protoc/GeneratorConfig;", "(Lio/grpc/kotlin/generator/protoc/GeneratorConfig;)V", "buildFun", "Lcom/squareup/kotlinpoet/FunSpec;", "stubName", "Lcom/squareup/kotlinpoet/TypeName;", "generate", "Lio/grpc/kotlin/generator/protoc/Declarations;", "service", "Lcom/google/protobuf/Descriptors$ServiceDescriptor;", "generateRpcStub", "method", "Lcom/google/protobuf/Descriptors$MethodDescriptor;", "generateStub", "Lcom/squareup/kotlinpoet/TypeSpec;", "rpcStubKDoc", "Lcom/squareup/kotlinpoet/CodeBlock;", "parameter", "Lcom/squareup/kotlinpoet/ParameterSpec;", "Companion", "compiler"})
public final class GrpcClientStubGenerator
extends ServiceCodeGenerator {
    private static final String STUB_CLASS_SUFFIX = "CoroutineStub";
    private static final MemberSimpleName UNARY_PARAMETER_NAME;
    private static final MemberSimpleName STREAMING_PARAMETER_NAME;
    private static final MemberSimpleName GRPC_CHANNEL_PARAMETER_NAME;
    private static final MemberSimpleName CALL_OPTIONS_PARAMETER_NAME;
    @NotNull
    private static final ParameterSpec GRPC_CHANNEL_PARAMETER;
    @NotNull
    private static final ParameterSpec CALL_OPTIONS_PARAMETER;
    private static final ClassName FLOW;
    private static final MemberName UNARY_RPC_HELPER;
    private static final MemberName CLIENT_STREAMING_RPC_HELPER;
    private static final MemberName SERVER_STREAMING_RPC_HELPER;
    private static final MemberName BIDI_STREAMING_RPC_HELPER;
    private static final Map<MethodDescriptor.MethodType, MemberName> RPC_HELPER;
    public static final Companion Companion;

    @Override
    @NotNull
    public Declarations generate(@NotNull Descriptors.ServiceDescriptor service) {
        Intrinsics.checkParameterIsNotNull(service, "service");
        boolean $i$f$declarations = false;
        Declarations.Builder builder = new Declarations.Builder();
        boolean bl = false;
        boolean bl2 = false;
        Declarations.Builder $this$declarations = builder;
        boolean bl3 = false;
        $this$declarations.addType(this.generateStub(service));
        return builder.build();
    }

    @VisibleForTesting
    @NotNull
    public final TypeSpec generateStub(@NotNull Descriptors.ServiceDescriptor service) {
        Intrinsics.checkParameterIsNotNull(service, "service");
        ClassSimpleName stubName = ProtoServiceNameKt.getServiceName(service).toClassSimpleName().withSuffix(STUB_CLASS_SUFFIX);
        TypeName stubSelfReference = TypeVariableName.Companion.get$default(TypeVariableName.Companion, stubName.toString(), null, 2, null);
        TypeSpec.Builder builder = ClassSimpleNameKt.classBuilder(TypeSpec.Companion, stubName).superclass(ParameterizedTypeName.Companion.get(TypeNames.get(Reflection.getOrCreateKotlinClass(AbstractCoroutineStub.class)), new TypeName[]{stubSelfReference}));
        Object[] objectArray = new Object[1];
        String string = service.getFullName();
        Intrinsics.checkExpressionValueIsNotNull(string, "service.fullName");
        objectArray[0] = string;
        TypeSpec.Builder builder2 = builder.addKdoc("A stub for issuing RPCs to a(n) %L service as suspending coroutines.", objectArray).addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(StubFor.class)).addMember("%T::class", this.getGrpcClass(service)).build()).primaryConstructor(FunSpec.Companion.constructorBuilder().addParameter(GRPC_CHANNEL_PARAMETER).addParameter(CALL_OPTIONS_PARAMETER).addAnnotation(Reflection.getOrCreateKotlinClass(JvmOverloads.class)).build()).addSuperclassConstructorParameter("%N", GRPC_CHANNEL_PARAMETER).addSuperclassConstructorParameter("%N", CALL_OPTIONS_PARAMETER).addFunction(this.buildFun(stubSelfReference));
        Iterator<Descriptors.MethodDescriptor> iterator2 = service.getMethods().iterator();
        while (iterator2.hasNext()) {
            Descriptors.MethodDescriptor method;
            Descriptors.MethodDescriptor methodDescriptor = method = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(methodDescriptor, "method");
            builder2.addFunction(this.generateRpcStub(methodDescriptor));
        }
        return builder2.build();
    }

    private final FunSpec buildFun(TypeName stubName) {
        return FunSpec.Builder.returns$default(FunSpec.Companion.builder("build"), stubName, null, 2, null).addModifiers(KModifier.OVERRIDE).addParameter(GRPC_CHANNEL_PARAMETER).addParameter(MemberSimpleNameKt.of(ParameterSpec.Companion, CALL_OPTIONS_PARAMETER_NAME, Reflection.getOrCreateKotlinClass(CallOptions.class), new KModifier[0])).addStatement("return %T(%N, %N)", stubName, GRPC_CHANNEL_PARAMETER, CALL_OPTIONS_PARAMETER).build();
    }

    @VisibleForTesting
    @NotNull
    public final FunSpec generateRpcStub(@NotNull Descriptors.MethodDescriptor method) {
        Intrinsics.checkParameterIsNotNull(method, "method");
        GeneratorConfig generatorConfig = this.getConfig();
        boolean bl = false;
        boolean bl2 = false;
        GeneratorConfig $this$with = generatorConfig;
        boolean bl3 = false;
        MemberSimpleName name = ProtoMethodNameKt.getMethodName(method).toMemberSimpleName();
        Descriptors.Descriptor descriptor2 = method.getInputType();
        Intrinsics.checkExpressionValueIsNotNull(descriptor2, "method.inputType");
        ClassName requestType = $this$with.messageClass(descriptor2);
        ParameterSpec parameter = method.isClientStreaming() ? MemberSimpleNameKt.of(ParameterSpec.Companion, STREAMING_PARAMETER_NAME, (TypeName)ParameterizedTypeName.Companion.get(FLOW, new TypeName[]{requestType}), new KModifier[0]) : MemberSimpleNameKt.of(ParameterSpec.Companion, UNARY_PARAMETER_NAME, (TypeName)requestType, new KModifier[0]);
        Descriptors.Descriptor descriptor3 = method.getOutputType();
        Intrinsics.checkExpressionValueIsNotNull(descriptor3, "method.outputType");
        ClassName responseType = $this$with.messageClass(descriptor3);
        TypeName returnType = method.isServerStreaming() ? (TypeName)ParameterizedTypeName.Companion.get(FLOW, new TypeName[]{responseType}) : (TypeName)responseType;
        MemberName memberName = RPC_HELPER.get((Object)GrpcClientStubGenerator.Companion.getType(method));
        if (memberName == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        MemberName helperMethod = memberName;
        FunSpec.Builder funSpecBuilder = FunSpec.Builder.returns$default($this$with.funSpecBuilder(name).addParameter(parameter), returnType, null, 2, null).addKdoc(this.rpcStubKDoc(method, parameter));
        Map codeBlockMap = MapsKt.mapOf(TuplesKt.to("helperMethod", helperMethod), TuplesKt.to("methodDescriptor", this.getDescriptorCode(method)), TuplesKt.to("parameter", parameter), TuplesKt.to("headers", Reflection.getOrCreateKotlinClass(Metadata.class)));
        if (!method.isServerStreaming()) {
            funSpecBuilder.addModifiers(KModifier.SUSPEND);
        }
        funSpecBuilder.addNamedCode("return %helperMethod:M(\n  channel,\n  %methodDescriptor:L,\n  %parameter:N,\n  callOptions,\n  %headers:T()\n)", codeBlockMap);
        return funSpecBuilder.build();
    }

    private final CodeBlock rpcStubKDoc(Descriptors.MethodDescriptor method, ParameterSpec parameter) {
        Map kDocBindings = MapsKt.mapOf(TuplesKt.to("parameter", parameter), TuplesKt.to("flow", Reflection.getOrCreateKotlinClass(Flow.class)), TuplesKt.to("status", Reflection.getOrCreateKotlinClass(Status.class)), TuplesKt.to("statusException", Reflection.getOrCreateKotlinClass(StatusException.class)));
        boolean bl = false;
        List kDocComponents = new ArrayList();
        kDocComponents.add(method.isServerStreaming() ? "Returns a [%flow:T] that, when collected, executes this RPC and emits responses from the\nserver as they arrive.  That flow finishes normally if the server closes its response with\n[`Status.OK`][%status:T], and fails by throwing a [%statusException:T] otherwise.  If\ncollecting the flow downstream fails exceptionally (including via cancellation), the RPC\nis cancelled with that exception as a cause." : "Executes this RPC and returns the response message, suspending until the RPC completes\nwith [`Status.OK`][%status:T].  If the RPC completes with another status, a corresponding\n[%statusException:T] is thrown.  If this coroutine is cancelled, the RPC is also cancelled\nwith the corresponding exception as a cause.");
        switch (GrpcClientStubGenerator$WhenMappings.$EnumSwitchMapping$0[GrpcClientStubGenerator.Companion.getType(method).ordinal()]) {
            case 1: {
                kDocComponents.add("The [%flow:T] of requests is collected once each time the [%flow:T] of responses is\ncollected. If collection of the [%flow:T] of responses completes normally or\nexceptionally before collection of `%parameter:N` completes, the collection of\n`%parameter:N` is cancelled.  If the collection of `%parameter:N` completes\nexceptionally for any other reason, then the collection of the [%flow:T] of responses\ncompletes exceptionally for the same reason and the RPC is cancelled with that reason.");
                break;
            }
            case 2: {
                kDocComponents.add("This function collects the [%flow:T] of requests.  If the server terminates the RPC\nfor any reason before collection of requests is complete, the collection of requests\nwill be cancelled.  If the collection of requests completes exceptionally for any other\nreason, the RPC will be cancelled for that reason and this method will throw that\nexception.");
                break;
            }
        }
        kDocComponents.add(method.isClientStreaming() ? "@param %parameter:N A [%flow:T] of request messages." : "@param %parameter:N The request message to send to the server.");
        kDocComponents.add(method.isServerStreaming() ? "@return A flow that, when collected, emits the responses from the server." : "@return The single response from the server.");
        return CodeBlock.Companion.builder().addNamed(CollectionsKt.joinToString$default(kDocComponents, "\n\n", null, null, 0, null, null, 62, null), kDocBindings).build();
    }

    public GrpcClientStubGenerator(@NotNull GeneratorConfig config) {
        Intrinsics.checkParameterIsNotNull(config, "config");
        super(config);
    }

    static {
        Companion = new Companion(null);
        UNARY_PARAMETER_NAME = new MemberSimpleName("request");
        STREAMING_PARAMETER_NAME = new MemberSimpleName("requests");
        GRPC_CHANNEL_PARAMETER_NAME = new MemberSimpleName("channel");
        CALL_OPTIONS_PARAMETER_NAME = new MemberSimpleName("callOptions");
        GRPC_CHANNEL_PARAMETER = MemberSimpleNameKt.of(ParameterSpec.Companion, GRPC_CHANNEL_PARAMETER_NAME, Reflection.getOrCreateKotlinClass(Channel.class), new KModifier[0]);
        CALL_OPTIONS_PARAMETER = MemberSimpleNameKt.builder(ParameterSpec.Companion, new MemberSimpleName("callOptions"), Reflection.getOrCreateKotlinClass(CallOptions.class), new KModifier[0]).defaultValue("%M", KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(CallOptions.class), "DEFAULT")).build();
        FLOW = ClassNames.get(Reflection.getOrCreateKotlinClass(Flow.class));
        UNARY_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "unaryRpc");
        CLIENT_STREAMING_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "clientStreamingRpc");
        SERVER_STREAMING_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "serverStreamingRpc");
        BIDI_STREAMING_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "bidiStreamingRpc");
        RPC_HELPER = MapsKt.mapOf(TuplesKt.to(MethodDescriptor.MethodType.UNARY, UNARY_RPC_HELPER), TuplesKt.to(MethodDescriptor.MethodType.CLIENT_STREAMING, CLIENT_STREAMING_RPC_HELPER), TuplesKt.to(MethodDescriptor.MethodType.SERVER_STREAMING, SERVER_STREAMING_RPC_HELPER), TuplesKt.to(MethodDescriptor.MethodType.BIDI_STREAMING, BIDI_STREAMING_RPC_HELPER));
    }

    @kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u00020\u0013*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lio/grpc/kotlin/generator/GrpcClientStubGenerator$Companion;", "", "()V", "BIDI_STREAMING_RPC_HELPER", "Lcom/squareup/kotlinpoet/MemberName;", "CALL_OPTIONS_PARAMETER", "Lcom/squareup/kotlinpoet/ParameterSpec;", "getCALL_OPTIONS_PARAMETER", "()Lcom/squareup/kotlinpoet/ParameterSpec;", "CALL_OPTIONS_PARAMETER_NAME", "Lio/grpc/kotlin/generator/protoc/MemberSimpleName;", "CLIENT_STREAMING_RPC_HELPER", "FLOW", "Lcom/squareup/kotlinpoet/ClassName;", "GRPC_CHANNEL_PARAMETER", "getGRPC_CHANNEL_PARAMETER", "GRPC_CHANNEL_PARAMETER_NAME", "RPC_HELPER", "", "Lio/grpc/MethodDescriptor$MethodType;", "SERVER_STREAMING_RPC_HELPER", "STREAMING_PARAMETER_NAME", "STUB_CLASS_SUFFIX", "", "UNARY_PARAMETER_NAME", "UNARY_RPC_HELPER", "type", "Lcom/google/protobuf/Descriptors$MethodDescriptor;", "getType", "(Lcom/google/protobuf/Descriptors$MethodDescriptor;)Lio/grpc/MethodDescriptor$MethodType;", "compiler"})
    public static final class Companion {
        @NotNull
        public final ParameterSpec getGRPC_CHANNEL_PARAMETER() {
            return GRPC_CHANNEL_PARAMETER;
        }

        @NotNull
        public final ParameterSpec getCALL_OPTIONS_PARAMETER() {
            return CALL_OPTIONS_PARAMETER;
        }

        private final MethodDescriptor.MethodType getType(@NotNull Descriptors.MethodDescriptor $this$type) {
            return $this$type.isClientStreaming() ? ($this$type.isServerStreaming() ? MethodDescriptor.MethodType.BIDI_STREAMING : MethodDescriptor.MethodType.CLIENT_STREAMING) : ($this$type.isServerStreaming() ? MethodDescriptor.MethodType.SERVER_STREAMING : MethodDescriptor.MethodType.UNARY);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

