/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyField;
import com.google.protobuf.MessageLite;
import com.google.protobuf.SmallSortedMap;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private static final int DEFAULT_FIELD_MAP_ARRAY_SIZE = 16;
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    private FieldSet(SmallSortedMap<T, Object> fields2) {
        this.fields = fields2;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder();
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSet)) {
            return false;
        }
        FieldSet other = (FieldSet)o;
        return this.fields.equals(other.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet<T> clone() {
        FieldSet<FieldDescriptorLite> clone = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            clone.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        clone.hasLazyField = this.hasLazyField;
        return clone;
    }

    public void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap<T, Object> result2 = FieldSet.cloneAllFieldsMap(this.fields, false);
            if (this.fields.isImmutable()) {
                result2.makeImmutable();
            }
            return result2;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> fields2, boolean copyList) {
        SmallSortedMap result2 = SmallSortedMap.newFieldMap(16);
        for (int i = 0; i < fields2.getNumArrayEntries(); ++i) {
            FieldSet.cloneFieldEntry(result2, fields2.getArrayEntryAt(i), copyList);
        }
        for (Map.Entry<T, Object> entry : fields2.getOverflowEntries()) {
            FieldSet.cloneFieldEntry(result2, entry, copyList);
        }
        return result2;
    }

    private static <T extends FieldDescriptorLite<T>> void cloneFieldEntry(Map<T, Object> map2, Map.Entry<T, Object> entry, boolean copyList) {
        FieldDescriptorLite key = (FieldDescriptorLite)entry.getKey();
        Object value = entry.getValue();
        if (value instanceof LazyField) {
            map2.put(key, ((LazyField)value).getValue());
        } else if (copyList && value instanceof List) {
            map2.put(key, new ArrayList((List)value));
        } else {
            map2.put(key, value);
        }
    }

    public Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    Iterator<Map.Entry<T, Object>> descendingIterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
        }
        return this.fields.descendingEntrySet().iterator();
    }

    public boolean hasField(T descriptor2) {
        if (descriptor2.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(descriptor2) != null;
    }

    public Object getField(T descriptor2) {
        Object o = this.fields.get(descriptor2);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return o;
    }

    public void setField(T descriptor2, Object value) {
        if (descriptor2.isRepeated()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll(value);
            for (Object element : newList) {
                this.verifyType(descriptor2.getLiteType(), element);
            }
            value = newList;
        } else {
            this.verifyType(descriptor2.getLiteType(), value);
        }
        if (value instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(descriptor2, (Object)value);
    }

    public void clearField(T descriptor2) {
        this.fields.remove(descriptor2);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public int getRepeatedFieldCount(T descriptor2) {
        if (!descriptor2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value = this.getField(descriptor2);
        if (value == null) {
            return 0;
        }
        return ((List)value).size();
    }

    public Object getRepeatedField(T descriptor2, int index) {
        if (!descriptor2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value = this.getField(descriptor2);
        if (value == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)value).get(index);
    }

    public void setRepeatedField(T descriptor2, int index, Object value) {
        if (!descriptor2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object list = this.getField(descriptor2);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyType(descriptor2.getLiteType(), value);
        ((List)list).set(index, value);
    }

    public void addRepeatedField(T descriptor2, Object value) {
        ArrayList<Object> list;
        if (!descriptor2.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(descriptor2.getLiteType(), value);
        Object existingValue = this.getField(descriptor2);
        if (existingValue == null) {
            list = new ArrayList<Object>();
            this.fields.put(descriptor2, (Object)list);
        } else {
            list = (ArrayList<Object>)existingValue;
        }
        list.add(value);
    }

    private void verifyType(WireFormat.FieldType type2, Object value) {
        if (!FieldSet.isValidType(type2, value)) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    private static boolean isValidType(WireFormat.FieldType type2, Object value) {
        Internal.checkNotNull(value);
        switch (type2.getJavaType()) {
            case INT: {
                return value instanceof Integer;
            }
            case LONG: {
                return value instanceof Long;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case BYTE_STRING: {
                return value instanceof ByteString || value instanceof byte[];
            }
            case ENUM: {
                return value instanceof Integer || value instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                return value instanceof MessageLite || value instanceof LazyField;
            }
        }
        return false;
    }

    public boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor2 = (FieldDescriptorLite)entry.getKey();
        if (descriptor2.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (descriptor2.isRepeated()) {
                for (MessageLite element : (List)entry.getValue()) {
                    if (element.isInitialized()) continue;
                    return false;
                }
            } else {
                Object value = entry.getValue();
                if (value instanceof MessageLite) {
                    if (!((MessageLite)value).isInitialized()) {
                        return false;
                    }
                } else {
                    if (value instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type2, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type2.getWireType();
    }

    public void mergeFrom(FieldSet<T> other) {
        for (int i = 0; i < other.fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(other.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : other.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private static Object cloneIfMutable(Object value) {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            byte[] copy2 = new byte[bytes.length];
            System.arraycopy(bytes, 0, copy2, 0, bytes.length);
            return copy2;
        }
        return value;
    }

    private void mergeFromField(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor2 = (FieldDescriptorLite)entry.getKey();
        Object otherValue = entry.getValue();
        if (otherValue instanceof LazyField) {
            otherValue = ((LazyField)otherValue).getValue();
        }
        if (descriptor2.isRepeated()) {
            ArrayList value = this.getField(descriptor2);
            if (value == null) {
                value = new ArrayList();
            }
            for (Object element : (List)otherValue) {
                ((List)value).add(FieldSet.cloneIfMutable(element));
            }
            this.fields.put((T)descriptor2, (Object)value);
        } else if (descriptor2.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object value = this.getField(descriptor2);
            if (value == null) {
                this.fields.put((T)descriptor2, FieldSet.cloneIfMutable(otherValue));
            } else {
                value = descriptor2.internalMergeFrom(((MessageLite)value).toBuilder(), (MessageLite)otherValue).build();
                this.fields.put((T)descriptor2, value);
            }
        } else {
            this.fields.put((T)descriptor2, FieldSet.cloneIfMutable(otherValue));
        }
    }

    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type2, boolean checkUtf8) throws IOException {
        if (checkUtf8) {
            return WireFormat.readPrimitiveField(input, type2, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(input, type2, WireFormat.Utf8Validation.LOOSE);
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
    }

    public void writeMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, output);
        }
    }

    private void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream output) throws IOException {
        FieldDescriptorLite descriptor2 = (FieldDescriptorLite)entry.getKey();
        if (descriptor2.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor2.isRepeated() && !descriptor2.isPacked()) {
            Object value = entry.getValue();
            if (value instanceof LazyField) {
                value = ((LazyField)value).getValue();
            }
            output.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value);
        } else {
            FieldSet.writeField(descriptor2, entry.getValue(), output);
        }
    }

    static void writeElement(CodedOutputStream output, WireFormat.FieldType type2, int number, Object value) throws IOException {
        if (type2 == WireFormat.FieldType.GROUP) {
            output.writeGroup(number, (MessageLite)value);
        } else {
            output.writeTag(number, FieldSet.getWireFormatForFieldType(type2, false));
            FieldSet.writeElementNoTag(output, type2, value);
        }
    }

    static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type2, Object value) throws IOException {
        switch (type2) {
            case DOUBLE: {
                output.writeDoubleNoTag((Double)value);
                break;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value).floatValue());
                break;
            }
            case INT64: {
                output.writeInt64NoTag((Long)value);
                break;
            }
            case UINT64: {
                output.writeUInt64NoTag((Long)value);
                break;
            }
            case INT32: {
                output.writeInt32NoTag((Integer)value);
                break;
            }
            case FIXED64: {
                output.writeFixed64NoTag((Long)value);
                break;
            }
            case FIXED32: {
                output.writeFixed32NoTag((Integer)value);
                break;
            }
            case BOOL: {
                output.writeBoolNoTag((Boolean)value);
                break;
            }
            case GROUP: {
                output.writeGroupNoTag((MessageLite)value);
                break;
            }
            case MESSAGE: {
                output.writeMessageNoTag((MessageLite)value);
                break;
            }
            case STRING: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    break;
                }
                output.writeStringNoTag((String)value);
                break;
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    break;
                }
                output.writeByteArrayNoTag((byte[])value);
                break;
            }
            case UINT32: {
                output.writeUInt32NoTag((Integer)value);
                break;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag((Integer)value);
                break;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag((Long)value);
                break;
            }
            case SINT32: {
                output.writeSInt32NoTag((Integer)value);
                break;
            }
            case SINT64: {
                output.writeSInt64NoTag((Long)value);
                break;
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value).getNumber());
                    break;
                }
                output.writeEnumNoTag((Integer)value);
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> descriptor2, Object value, CodedOutputStream output) throws IOException {
        WireFormat.FieldType type2 = descriptor2.getLiteType();
        int number = descriptor2.getNumber();
        if (descriptor2.isRepeated()) {
            List valueList = (List)value;
            if (descriptor2.isPacked()) {
                output.writeTag(number, 2);
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                output.writeRawVarint32(dataSize);
                for (Object element : valueList) {
                    FieldSet.writeElementNoTag(output, type2, element);
                }
            } else {
                for (Object element : valueList) {
                    FieldSet.writeElement(output, type2, number, element);
                }
            }
        } else if (value instanceof LazyField) {
            FieldSet.writeElement(output, type2, number, ((LazyField)value).getValue());
        } else {
            FieldSet.writeElement(output, type2, number, value);
        }
    }

    public int getSerializedSize() {
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return size;
    }

    public int getMessageSetSerializedSize() {
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            size += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            size += this.getMessageSetSerializedSize(entry);
        }
        return size;
    }

    private int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        FieldDescriptorLite descriptor2 = (FieldDescriptorLite)entry.getKey();
        Object value = entry.getValue();
        if (descriptor2.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor2.isRepeated() && !descriptor2.isPacked()) {
            if (value instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value);
        }
        return FieldSet.computeFieldSize(descriptor2, value);
    }

    static int computeElementSize(WireFormat.FieldType type2, int number, Object value) {
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type2 == WireFormat.FieldType.GROUP) {
            tagSize *= 2;
        }
        return tagSize + FieldSet.computeElementSizeNoTag(type2, value);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType type2, Object value) {
        switch (type2) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value);
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value);
            }
            case STRING: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value);
            }
            case MESSAGE: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)value);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> descriptor2, Object value) {
        WireFormat.FieldType type2 = descriptor2.getLiteType();
        int number = descriptor2.getNumber();
        if (descriptor2.isRepeated()) {
            if (descriptor2.isPacked()) {
                int dataSize = 0;
                for (Object element : (List)value) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeRawVarint32Size(dataSize);
            }
            int size = 0;
            for (Object element : (List)value) {
                size += FieldSet.computeElementSize(type2, number, element);
            }
            return size;
        }
        return FieldSet.computeElementSize(type2, number, value);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap(16));
        }

        private Builder(SmallSortedMap<T, Object> fields2) {
            this.fields = fields2;
            this.isMutable = true;
        }

        public FieldSet<T> build() {
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap fieldsForBuild = this.fields;
            if (this.hasNestedBuilders) {
                fieldsForBuild = FieldSet.cloneAllFieldsMap(this.fields, false);
                Builder.replaceBuilders(fieldsForBuild);
            }
            FieldSet fieldSet = new FieldSet(fieldsForBuild);
            fieldSet.hasLazyField = this.hasLazyField;
            return fieldSet;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> fieldMap) {
            for (int i = 0; i < fieldMap.getNumArrayEntries(); ++i) {
                Builder.replaceBuilders(fieldMap.getArrayEntryAt(i));
            }
            for (Map.Entry<T, Object> entry : fieldMap.getOverflowEntries()) {
                Builder.replaceBuilders(entry);
            }
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry) {
            entry.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry.getKey(), entry.getValue()));
        }

        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T descriptor2, Object value) {
            if (value == null) {
                return value;
            }
            if (descriptor2.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                if (descriptor2.isRepeated()) {
                    if (!(value instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + value.getClass());
                    }
                    ArrayList<Object> list = (ArrayList<Object>)value;
                    for (int i = 0; i < list.size(); ++i) {
                        Object oldElement = list.get(i);
                        Object newElement = Builder.replaceBuilder(oldElement);
                        if (newElement == oldElement) continue;
                        if (list == value) {
                            list = new ArrayList<Object>(list);
                        }
                        list.set(i, newElement);
                    }
                    return list;
                }
                return Builder.replaceBuilder(value);
            }
            return value;
        }

        private static Object replaceBuilder(Object value) {
            return value instanceof MessageLite.Builder ? ((MessageLite.Builder)value).build() : value;
        }

        public static <T extends FieldDescriptorLite<T>> Builder<T> fromFieldSet(FieldSet<T> fieldSet) {
            Builder<T> builder = new Builder<T>(FieldSet.cloneAllFieldsMap(((FieldSet)fieldSet).fields, true));
            builder.hasLazyField = ((FieldSet)fieldSet).hasLazyField;
            return builder;
        }

        public Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                SmallSortedMap result2 = FieldSet.cloneAllFieldsMap(this.fields, false);
                if (this.fields.isImmutable()) {
                    result2.makeImmutable();
                } else {
                    Builder.replaceBuilders(result2);
                }
                return result2;
            }
            return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
        }

        public boolean hasField(T descriptor2) {
            if (descriptor2.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(descriptor2) != null;
        }

        public Object getField(T descriptor2) {
            Object value = this.getFieldAllowBuilders(descriptor2);
            return Builder.replaceBuilders(descriptor2, value);
        }

        Object getFieldAllowBuilders(T descriptor2) {
            Object o = this.fields.get(descriptor2);
            if (o instanceof LazyField) {
                return ((LazyField)o).getValue();
            }
            return o;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.cloneAllFieldsMap(this.fields, true);
                this.isMutable = true;
            }
        }

        public void setField(T descriptor2, Object value) {
            this.ensureIsMutable();
            if (descriptor2.isRepeated()) {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList newList = new ArrayList();
                newList.addAll(value);
                for (Object element : newList) {
                    Builder.verifyType(descriptor2.getLiteType(), element);
                    this.hasNestedBuilders = this.hasNestedBuilders || element instanceof MessageLite.Builder;
                }
                value = newList;
            } else {
                Builder.verifyType(descriptor2.getLiteType(), value);
            }
            if (value instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            this.fields.put(descriptor2, (Object)value);
        }

        public void clearField(T descriptor2) {
            this.ensureIsMutable();
            this.fields.remove(descriptor2);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        public int getRepeatedFieldCount(T descriptor2) {
            if (!descriptor2.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object value = this.getField(descriptor2);
            if (value == null) {
                return 0;
            }
            return ((List)value).size();
        }

        public Object getRepeatedField(T descriptor2, int index) {
            if (this.hasNestedBuilders) {
                this.ensureIsMutable();
            }
            Object value = this.getRepeatedFieldAllowBuilders(descriptor2, index);
            return Builder.replaceBuilder(value);
        }

        Object getRepeatedFieldAllowBuilders(T descriptor2, int index) {
            if (!descriptor2.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object value = this.getFieldAllowBuilders(descriptor2);
            if (value == null) {
                throw new IndexOutOfBoundsException();
            }
            return ((List)value).get(index);
        }

        public void setRepeatedField(T descriptor2, int index, Object value) {
            this.ensureIsMutable();
            if (!descriptor2.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            Object list = this.getField(descriptor2);
            if (list == null) {
                throw new IndexOutOfBoundsException();
            }
            Builder.verifyType(descriptor2.getLiteType(), value);
            ((List)list).set(index, value);
        }

        public void addRepeatedField(T descriptor2, Object value) {
            ArrayList<Object> list;
            this.ensureIsMutable();
            if (!descriptor2.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            Builder.verifyType(descriptor2.getLiteType(), value);
            Object existingValue = this.getField(descriptor2);
            if (existingValue == null) {
                list = new ArrayList<Object>();
                this.fields.put(descriptor2, (Object)list);
            } else {
                list = (ArrayList<Object>)existingValue;
            }
            list.add(value);
        }

        private static void verifyType(WireFormat.FieldType type2, Object value) {
            if (!FieldSet.isValidType(type2, value)) {
                if (type2.getJavaType() == WireFormat.JavaType.MESSAGE && value instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
        }

        public boolean isInitialized() {
            for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        public void mergeFrom(FieldSet<T> other) {
            this.ensureIsMutable();
            for (int i = 0; i < ((FieldSet)other).fields.getNumArrayEntries(); ++i) {
                this.mergeFromField(((FieldSet)other).fields.getArrayEntryAt(i));
            }
            for (Map.Entry entry : ((FieldSet)other).fields.getOverflowEntries()) {
                this.mergeFromField(entry);
            }
        }

        private void mergeFromField(Map.Entry<T, Object> entry) {
            FieldDescriptorLite descriptor2 = (FieldDescriptorLite)entry.getKey();
            Object otherValue = entry.getValue();
            if (otherValue instanceof LazyField) {
                otherValue = ((LazyField)otherValue).getValue();
            }
            if (descriptor2.isRepeated()) {
                ArrayList value = this.getField(descriptor2);
                if (value == null) {
                    value = new ArrayList();
                }
                for (Object element : (List)otherValue) {
                    ((List)value).add(FieldSet.cloneIfMutable(element));
                }
                this.fields.put((T)descriptor2, (Object)value);
            } else if (descriptor2.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                Object value = this.getField(descriptor2);
                if (value == null) {
                    this.fields.put((T)descriptor2, FieldSet.cloneIfMutable(otherValue));
                } else if (value instanceof MessageLite.Builder) {
                    descriptor2.internalMergeFrom((MessageLite.Builder)value, (MessageLite)otherValue);
                } else {
                    value = descriptor2.internalMergeFrom(((MessageLite)value).toBuilder(), (MessageLite)otherValue).build();
                    this.fields.put((T)descriptor2, value);
                }
            } else {
                this.fields.put((T)descriptor2, FieldSet.cloneIfMutable(otherValue));
            }
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

