/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator;

import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.TypeSpec;
import io.grpc.kotlin.generator.ServiceCodeGenerator;
import io.grpc.kotlin.generator.protoc.ClassSimpleName;
import io.grpc.kotlin.generator.protoc.ClassSimpleNameKt;
import io.grpc.kotlin.generator.protoc.Declarations;
import io.grpc.kotlin.generator.protoc.DescriptorUtilKt;
import io.grpc.kotlin.generator.protoc.GeneratorConfig;
import io.grpc.kotlin.generator.protoc.ProtoServiceNameKt;
import io.grpc.kotlin.generator.protoc.ScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/grpc/kotlin/generator/ProtoFileCodeGenerator;", "", "generators", "", "Lkotlin/Function1;", "Lio/grpc/kotlin/generator/protoc/GeneratorConfig;", "Lio/grpc/kotlin/generator/ServiceCodeGenerator;", "config", "topLevelSuffix", "", "(Ljava/util/List;Lio/grpc/kotlin/generator/protoc/GeneratorConfig;Ljava/lang/String;)V", "generateCodeForFile", "Lcom/squareup/kotlinpoet/FileSpec;", "fileDescriptor", "Lcom/google/protobuf/Descriptors$FileDescriptor;", "compiler"})
public final class ProtoFileCodeGenerator {
    private final List<ServiceCodeGenerator> generators;
    private final GeneratorConfig config;
    private final String topLevelSuffix;

    @Nullable
    public final FileSpec generateCodeForFile(@NotNull Descriptors.FileDescriptor fileDescriptor) {
        Intrinsics.checkParameterIsNotNull(fileDescriptor, "fileDescriptor");
        GeneratorConfig generatorConfig = this.config;
        boolean bl = false;
        boolean bl2 = false;
        GeneratorConfig $this$with = generatorConfig;
        boolean bl3 = false;
        ClassSimpleName outerTypeName = DescriptorUtilKt.getOuterClassSimpleName(fileDescriptor).withSuffix(this.topLevelSuffix);
        boolean wroteAnything = false;
        FileSpec.Builder fileBuilder = ScopeKt.builder(FileSpec.Companion, $this$with.javaPackage(fileDescriptor), outerTypeName);
        for (Descriptors.ServiceDescriptor service : fileDescriptor.getServices()) {
            boolean $i$f$declarations = false;
            Declarations.Builder builder = new Declarations.Builder();
            boolean bl4 = false;
            boolean bl5 = false;
            Declarations.Builder $this$declarations = builder;
            boolean bl6 = false;
            for (ServiceCodeGenerator generator2 : this.generators) {
                Descriptors.ServiceDescriptor serviceDescriptor = service;
                Intrinsics.checkExpressionValueIsNotNull(serviceDescriptor, "service");
                $this$declarations.merge(generator2.generate(serviceDescriptor));
            }
            Declarations serviceDecls = builder.build();
            if (serviceDecls.getHasEnclosingScopeDeclarations()) {
                wroteAnything = true;
                Descriptors.ServiceDescriptor serviceDescriptor = service;
                Intrinsics.checkExpressionValueIsNotNull(serviceDescriptor, "service");
                TypeSpec.Builder builder2 = ClassSimpleNameKt.objectBuilder(TypeSpec.Companion, ProtoServiceNameKt.getServiceName(serviceDescriptor).toClassSimpleName().withSuffix(this.topLevelSuffix));
                Object[] objectArray = new Object[1];
                String string = service.getFullName();
                Intrinsics.checkExpressionValueIsNotNull(string, "service.fullName");
                objectArray[0] = string;
                TypeSpec.Builder serviceObjectBuilder = builder2.addKdoc("Holder for Kotlin coroutine-based client and server APIs for %L.", objectArray);
                serviceDecls.writeToEnclosingType(serviceObjectBuilder);
                fileBuilder.addType(serviceObjectBuilder.build());
            }
            if (!serviceDecls.getHasTopLevelDeclarations()) continue;
            wroteAnything = true;
            serviceDecls.writeOnlyTopLevel(fileBuilder);
        }
        return wroteAnything ? fileBuilder.build() : null;
    }

    /*
     * WARNING - void declaration
     */
    public ProtoFileCodeGenerator(@NotNull List<? extends Function1<? super GeneratorConfig, ? extends ServiceCodeGenerator>> generators, @NotNull GeneratorConfig config, @NotNull String topLevelSuffix) {
        Collection<ServiceCodeGenerator> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(generators, "generators");
        Intrinsics.checkParameterIsNotNull(config, "config");
        Intrinsics.checkParameterIsNotNull(topLevelSuffix, "topLevelSuffix");
        this.config = config;
        this.topLevelSuffix = topLevelSuffix;
        Iterable iterable = generators;
        ProtoFileCodeGenerator protoFileCodeGenerator = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Function1 function1 = (Function1)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ServiceCodeGenerator serviceCodeGenerator = (ServiceCodeGenerator)it.invoke(this.config);
            collection.add(serviceCodeGenerator);
        }
        collection = (List)destination$iv$iv;
        protoFileCodeGenerator.generators = collection;
    }
}

