/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.collect.Range;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ComparableSubject<T extends Comparable>
extends Subject {
    private final T actual;

    protected ComparableSubject(FailureMetadata metadata2, @NullableDecl T actual) {
        super(metadata2, actual);
        this.actual = actual;
    }

    public final void isIn(Range<T> range) {
        if (!range.contains(this.actual)) {
            this.failWithActual("expected to be in range", range);
        }
    }

    public final void isNotIn(Range<T> range) {
        if (range.contains(this.actual)) {
            this.failWithActual("expected not to be in range", range);
        }
    }

    public void isEquivalentAccordingToCompareTo(T expected) {
        if (this.actual.compareTo(expected) != 0) {
            this.failWithActual("expected value that sorts equal to", expected);
        }
    }

    public final void isGreaterThan(T other) {
        if (this.actual.compareTo(other) <= 0) {
            this.failWithActual("expected to be greater than", other);
        }
    }

    public final void isLessThan(T other) {
        if (this.actual.compareTo(other) >= 0) {
            this.failWithActual("expected to be less than", other);
        }
    }

    public final void isAtMost(T other) {
        if (this.actual.compareTo(other) > 0) {
            this.failWithActual("expected to be at most", other);
        }
    }

    public final void isAtLeast(T other) {
        if (this.actual.compareTo(other) < 0) {
            this.failWithActual("expected to be at least", other);
        }
    }
}

