/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.Facts;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Platform;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Correspondence<A, E> {
    public static <A, E> Correspondence<A, E> from(BinaryPredicate<A, E> predicate, String description2) {
        return new FromBinaryPredicate(predicate, description2);
    }

    public static <A, E> Correspondence<A, E> transforming(Function<A, ? extends E> actualTransform, String description2) {
        return new Transforming(actualTransform, Functions.identity(), description2);
    }

    public static <A, E> Correspondence<A, E> transforming(Function<A, ?> actualTransform, Function<E, ?> expectedTransform, String description2) {
        return new Transforming(actualTransform, expectedTransform, description2);
    }

    public static Correspondence<Number, Number> tolerance(double tolerance) {
        return new TolerantNumericEquality(tolerance);
    }

    @Deprecated
    Correspondence() {
    }

    public Correspondence<A, E> formattingDiffsUsing(DiffFormatter<? super A, ? super E> formatter) {
        return new FormattingDiffs<A, E>(this, formatter);
    }

    public abstract boolean compare(@NullableDecl A var1, @NullableDecl E var2);

    final boolean safeCompare(@NullableDecl A actual, @NullableDecl E expected, ExceptionStore exceptions) {
        try {
            return this.compare(actual, expected);
        }
        catch (RuntimeException e) {
            exceptions.addCompareException(Correspondence.class, e, actual, expected);
            return false;
        }
    }

    @NullableDecl
    public String formatDiff(@NullableDecl A actual, @NullableDecl E expected) {
        return null;
    }

    @NullableDecl
    final String safeFormatDiff(@NullableDecl A actual, @NullableDecl E expected, ExceptionStore exceptions) {
        try {
            return this.formatDiff(actual, expected);
        }
        catch (RuntimeException e) {
            exceptions.addFormatDiffException(Correspondence.class, e, actual, expected);
            return null;
        }
    }

    public abstract String toString();

    final Fact describeForIterable() {
        return Fact.fact("testing whether", "actual element " + this + " expected element");
    }

    final Fact describeForMapValues() {
        return Fact.fact("testing whether", "expected element " + this + " actual element");
    }

    @Deprecated
    public final boolean equals(@NullableDecl Object o) {
        throw new UnsupportedOperationException("Correspondence.equals(object) is not supported. If you meant to compare objects, use .compare(actual, expected) instead.");
    }

    @Deprecated
    public final int hashCode() {
        throw new UnsupportedOperationException("Correspondence.hashCode() is not supported.");
    }

    static final class ExceptionStore {
        private final String argumentLabel;
        private StoredException firstCompareException = null;
        private StoredException firstPairingException = null;
        private StoredException firstFormatDiffException = null;

        static ExceptionStore forIterable() {
            return new ExceptionStore("elements");
        }

        static ExceptionStore forMapValues() {
            return new ExceptionStore("values");
        }

        private ExceptionStore(String argumentLabel) {
            this.argumentLabel = argumentLabel;
        }

        void addCompareException(Class<?> callingClass, Exception exception, Object actual, Object expected) {
            if (this.firstCompareException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstCompareException = new StoredException(exception, "compare", Arrays.asList(actual, expected));
            }
        }

        void addActualKeyFunctionException(Class<?> callingClass, Exception exception, Object actual) {
            if (this.firstPairingException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstPairingException = new StoredException(exception, "actualKeyFunction.apply", Arrays.asList(actual));
            }
        }

        void addExpectedKeyFunctionException(Class<?> callingClass, Exception exception, Object expected) {
            if (this.firstPairingException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstPairingException = new StoredException(exception, "expectedKeyFunction.apply", Arrays.asList(expected));
            }
        }

        void addFormatDiffException(Class<?> callingClass, Exception exception, Object actual, Object expected) {
            if (this.firstFormatDiffException == null) {
                ExceptionStore.truncateStackTrace(exception, callingClass);
                this.firstFormatDiffException = new StoredException(exception, "formatDiff", Arrays.asList(actual, expected));
            }
        }

        boolean hasCompareException() {
            return this.firstCompareException != null;
        }

        Facts describeAsMainCause() {
            Preconditions.checkState(this.firstCompareException != null);
            Preconditions.checkState(this.firstPairingException == null);
            Preconditions.checkState(this.firstFormatDiffException == null);
            return Facts.facts(Fact.simpleFact("one or more exceptions were thrown while comparing " + this.argumentLabel), Fact.fact("first exception", this.firstCompareException.describe()));
        }

        Facts describeAsAdditionalInfo() {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.firstCompareException != null) {
                builder.add(Fact.simpleFact("additionally, one or more exceptions were thrown while comparing " + this.argumentLabel));
                builder.add(Fact.fact("first exception", this.firstCompareException.describe()));
            }
            if (this.firstPairingException != null) {
                builder.add(Fact.simpleFact("additionally, one or more exceptions were thrown while keying " + this.argumentLabel + " for pairing"));
                builder.add(Fact.fact("first exception", this.firstPairingException.describe()));
            }
            if (this.firstFormatDiffException != null) {
                builder.add(Fact.simpleFact("additionally, one or more exceptions were thrown while formatting diffs"));
                builder.add(Fact.fact("first exception", this.firstFormatDiffException.describe()));
            }
            return Facts.facts(builder.build());
        }

        private static void truncateStackTrace(Exception exception, Class<?> callingClass) {
            int keep;
            StackTraceElement[] original = exception.getStackTrace();
            for (keep = 0; keep < original.length && !original[keep].getClassName().equals(callingClass.getName()); ++keep) {
            }
            exception.setStackTrace(Arrays.copyOf(original, keep));
        }
    }

    private static class StoredException {
        private static final Joiner ARGUMENT_JOINER = Joiner.on(", ").useForNull("null");
        private final Exception exception;
        private final String methodName;
        private final List<Object> methodArguments;

        StoredException(Exception exception, String methodName, List<Object> methodArguments) {
            this.exception = Preconditions.checkNotNull(exception);
            this.methodName = Preconditions.checkNotNull(methodName);
            this.methodArguments = Preconditions.checkNotNull(methodArguments);
        }

        private String describe() {
            return Strings.lenientFormat("%s(%s) threw %s\n---", this.methodName, ARGUMENT_JOINER.join(this.methodArguments), Platform.getStackTraceAsString(this.exception));
        }
    }

    private static class FormattingDiffs<A, E>
    extends Correspondence<A, E> {
        private final Correspondence<A, E> delegate;
        private final DiffFormatter<? super A, ? super E> formatter;

        FormattingDiffs(Correspondence<A, E> delegate, DiffFormatter<? super A, ? super E> formatter) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.formatter = Preconditions.checkNotNull(formatter);
        }

        @Override
        public boolean compare(@NullableDecl A actual, @NullableDecl E expected) {
            return this.delegate.compare(actual, expected);
        }

        @Override
        @NullableDecl
        public String formatDiff(@NullableDecl A actual, @NullableDecl E expected) {
            return this.formatter.formatDiff(actual, expected);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }

    public static interface DiffFormatter<A, E> {
        @NullableDecl
        public String formatDiff(@NullableDecl A var1, @NullableDecl E var2);
    }

    private static final class TolerantNumericEquality
    extends Correspondence<Number, Number> {
        private final double tolerance;

        private TolerantNumericEquality(double tolerance) {
            DoubleSubject.checkTolerance(tolerance);
            this.tolerance = tolerance;
        }

        @Override
        public boolean compare(Number actual, Number expected) {
            double actualDouble = Preconditions.checkNotNull(actual).doubleValue();
            double expectedDouble = Preconditions.checkNotNull(expected).doubleValue();
            return MathUtil.equalWithinTolerance(actualDouble, expectedDouble, this.tolerance);
        }

        @Override
        public String toString() {
            return "is a finite number within " + this.tolerance + " of";
        }
    }

    private static final class Transforming<A, E>
    extends Correspondence<A, E> {
        private final Function<? super A, ?> actualTransform;
        private final Function<? super E, ?> expectedTransform;
        private final String description;

        private Transforming(Function<? super A, ?> actualTransform, Function<? super E, ?> expectedTransform, String description2) {
            this.actualTransform = actualTransform;
            this.expectedTransform = expectedTransform;
            this.description = description2;
        }

        @Override
        public boolean compare(@NullableDecl A actual, @NullableDecl E expected) {
            return Objects.equal(this.actualTransform.apply(actual), this.expectedTransform.apply(expected));
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static final class FromBinaryPredicate<A, E>
    extends Correspondence<A, E> {
        private final BinaryPredicate<A, E> predicate;
        private final String description;

        private FromBinaryPredicate(BinaryPredicate<A, E> correspondencePredicate, String description2) {
            this.predicate = Preconditions.checkNotNull(correspondencePredicate);
            this.description = Preconditions.checkNotNull(description2);
        }

        @Override
        public boolean compare(@NullableDecl A actual, @NullableDecl E expected) {
            return this.predicate.apply(actual, expected);
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    public static interface BinaryPredicate<A, E> {
        public boolean apply(@NullableDecl A var1, @NullableDecl E var2);
    }
}

