/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Optional;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class GuavaOptionalSubject
extends Subject {
    private final Optional<?> actual;

    GuavaOptionalSubject(FailureMetadata metadata2, @NullableDecl Optional<?> actual, @NullableDecl String typeDescription) {
        super(metadata2, actual, typeDescription);
        this.actual = actual;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be present"), new Fact[0]);
        }
    }

    public void isAbsent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected absent optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be absent"), Fact.fact("but was present with value", this.actual.get()));
        }
    }

    public void hasValue(Object expected) {
        if (expected == null) {
            throw new NullPointerException("Optional cannot have a null value.");
        }
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact("expected to have value", expected), Fact.simpleFact("but was absent"));
        } else {
            this.checkNoNeedToDisplayBothValues("get()", new Object[0]).that(this.actual.get()).isEqualTo(expected);
        }
    }
}

