/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.Facts;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.GraphMatching;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class IterableSubject
extends Subject {
    private final Iterable<?> actual;
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    protected IterableSubject(FailureMetadata metadata2, @NullableDecl Iterable<?> iterable) {
        super(metadata2, iterable);
        this.actual = iterable;
    }

    @Override
    protected String actualCustomStringRepresentation() {
        if (this.actual != null) {
            String objectToString = this.actual.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this.actual));
            if (this.actual.toString().equals(objectToString)) {
                return Iterables.toString(this.actual);
            }
        }
        return super.actualCustomStringRepresentation();
    }

    @Override
    public void isEqualTo(@NullableDecl Object expected) {
        boolean equal = Objects.equal(this.actual, expected);
        if (equal) {
            return;
        }
        if (this.actual instanceof List && expected instanceof List) {
            this.containsExactlyElementsIn((List)expected).inOrder();
        } else if (this.actual instanceof Set && expected instanceof Set || this.actual instanceof Multiset && expected instanceof Multiset) {
            this.containsExactlyElementsIn((Collection)expected);
        } else {
            super.isEqualTo(expected);
        }
    }

    public final void isEmpty() {
        if (!Iterables.isEmpty(this.actual)) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (Iterables.isEmpty(this.actual)) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "expectedSize(%s) must be >= 0", expectedSize);
        int actualSize = Iterables.size(this.actual);
        this.check("size()", new Object[0]).that(actualSize).isEqualTo(expectedSize);
    }

    public final void contains(@NullableDecl Object element) {
        if (!Iterables.contains(this.actual, element)) {
            ArrayList<Object> elementList = Lists.newArrayList(element);
            if (SubjectUtils.hasMatchingToStringPair(this.actual, elementList)) {
                this.failWithoutActual(Fact.fact("expected to contain", element), Fact.fact("an instance of", SubjectUtils.objectToTypeName(element)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual, elementList))), this.fullContents());
            } else {
                this.failWithActual("expected to contain", element);
            }
        }
    }

    public final void doesNotContain(@NullableDecl Object element) {
        if (Iterables.contains(this.actual, element)) {
            this.failWithActual("expected not to contain", element);
        }
    }

    public final void containsNoDuplicates() {
        ArrayList<Multiset.Entry> duplicates = Lists.newArrayList();
        for (Multiset.Entry entry : LinkedHashMultiset.create(this.actual).entrySet()) {
            if (entry.getCount() <= 1) continue;
            duplicates.add(entry);
        }
        if (!duplicates.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to contain duplicates"), Fact.fact("but contained", duplicates), this.fullContents());
        }
    }

    public final void containsAnyOf(@NullableDecl Object first2, @NullableDecl Object second, Object ... rest) {
        this.containsAnyIn(SubjectUtils.accumulate(first2, second, rest));
    }

    public final void containsAnyIn(Iterable<?> expected) {
        Collection<?> actual = SubjectUtils.iterableToCollection(this.actual);
        for (Object item : expected) {
            if (!actual.contains(item)) continue;
            return;
        }
        if (SubjectUtils.hasMatchingToStringPair(actual, expected)) {
            this.failWithoutActual(Fact.fact("expected to contain any of", SubjectUtils.countDuplicatesAndAddTypeInfo(expected)), Fact.simpleFact("but did not"), Fact.fact("though it did contain", SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual, expected))), this.fullContents());
        } else {
            this.failWithActual("expected to contain any of", expected);
        }
    }

    public final void containsAnyIn(Object[] expected) {
        this.containsAnyIn(Arrays.asList(expected));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(@NullableDecl Object firstExpected, @NullableDecl Object secondExpected, Object ... restOfExpected) {
        return this.containsAtLeastElementsIn(SubjectUtils.accumulate(firstExpected, secondExpected, restOfExpected));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastElementsIn(Iterable<?> expectedIterable) {
        LinkedList<?> actual = Lists.newLinkedList(this.actual);
        final Collection<?> expected = SubjectUtils.iterableToCollection(expectedIterable);
        ArrayList<?> missing = Lists.newArrayList();
        ArrayList<Object> actualNotInOrder = Lists.newArrayList();
        boolean ordered = true;
        for (Object e : expected) {
            int index = actual.indexOf(e);
            if (index != -1) {
                IterableSubject.moveElements(actual, actualNotInOrder, index);
                actual.remove(0);
                continue;
            }
            if (actualNotInOrder.remove(e)) {
                ordered = false;
                continue;
            }
            missing.add(e);
        }
        if (!missing.isEmpty()) {
            return this.failAtLeast(expected, missing);
        }
        return ordered ? IN_ORDER : new Ordered(){

            @Override
            public void inOrder() {
                IterableSubject.this.failWithActual(Fact.simpleFact("required elements were all found, but order was wrong"), Fact.fact("expected order for required elements", expected));
            }
        };
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastElementsIn(Object[] expected) {
        return this.containsAtLeastElementsIn(Arrays.asList(expected));
    }

    private Ordered failAtLeast(Collection<?> expected, Collection<?> missingRawObjects) {
        List<Object> nearMissRawObjects = SubjectUtils.retainMatchingToString(this.actual, missingRawObjects);
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.addAll(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "though it did contain", nearMissRawObjects));
        facts.add(Fact.fact("expected to contain at least", expected));
        facts.add(this.butWas());
        this.failWithoutActual(facts.build());
        return ALREADY_FAILED;
    }

    private static void moveElements(List<?> input, Collection<Object> output, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            output.add(input.remove(0));
        }
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(Object ... varargs) {
        List<Object> expected = varargs == null ? Lists.newArrayList(new Object[]{null}) : Arrays.asList(varargs);
        return this.containsExactlyElementsIn(expected, varargs != null && varargs.length == 1 && varargs[0] instanceof Iterable);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.containsExactlyElementsIn(expected, false);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyElementsIn(Object[] expected) {
        return this.containsExactlyElementsIn(Arrays.asList(expected));
    }

    private Ordered containsExactlyElementsIn(final Iterable<?> required, boolean addElementsInWarning) {
        Iterator<?> actualIter = this.actual.iterator();
        Iterator<?> requiredIter = required.iterator();
        if (!requiredIter.hasNext()) {
            if (actualIter.hasNext()) {
                this.isEmpty();
                return ALREADY_FAILED;
            }
            return IN_ORDER;
        }
        boolean isFirst = true;
        while (actualIter.hasNext() && requiredIter.hasNext()) {
            Object requiredElement;
            Object actualElement = actualIter.next();
            if (!Objects.equal(actualElement, requiredElement = requiredIter.next())) {
                if (isFirst && !actualIter.hasNext() && !requiredIter.hasNext()) {
                    this.checkNoNeedToDisplayBothValues("onlyElement()", new Object[0]).that(actualElement).failEqualityCheckForEqualsWithoutDescription(requiredElement);
                    return ALREADY_FAILED;
                }
                ArrayList<?> missing = Lists.newArrayList();
                missing.add(requiredElement);
                Iterators.addAll(missing, requiredIter);
                ArrayList<?> extra = Lists.newArrayList();
                if (!missing.remove(actualElement)) {
                    extra.add(actualElement);
                }
                while (actualIter.hasNext()) {
                    Object item = actualIter.next();
                    if (missing.remove(item)) continue;
                    extra.add(item);
                }
                if (missing.isEmpty() && extra.isEmpty()) {
                    return new Ordered(){

                        @Override
                        public void inOrder() {
                            IterableSubject.this.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.fact("expected", required));
                        }
                    };
                }
                return this.failExactly(required, addElementsInWarning, missing, extra);
            }
            isFirst = false;
        }
        if (actualIter.hasNext()) {
            return this.failExactly(required, addElementsInWarning, ImmutableList.of(), Lists.newArrayList(actualIter));
        }
        if (requiredIter.hasNext()) {
            return this.failExactly(required, addElementsInWarning, Lists.newArrayList(requiredIter), ImmutableList.of());
        }
        return IN_ORDER;
    }

    private Ordered failExactly(Iterable<?> required, boolean addElementsInWarning, Collection<?> missingRawObjects, Collection<?> extraRawObjects) {
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.addAll(IterableSubject.makeElementFactsForBoth("missing", missingRawObjects, "unexpected", extraRawObjects));
        facts.add(Fact.fact("expected", required));
        facts.add(this.butWas());
        if (addElementsInWarning) {
            facts.add(Fact.simpleFact("Passing an iterable to the varargs method containsExactly(Object...) is often not the correct thing to do. Did you mean to call containsExactlyElementsIn(Iterable) instead?"));
        }
        this.failWithoutActual(facts.build());
        return ALREADY_FAILED;
    }

    private static ImmutableList<Fact> makeElementFactsForBoth(String firstKey, Collection<?> firstCollection, String secondKey, Collection<?> secondCollection) {
        boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(firstCollection, secondCollection);
        SubjectUtils.DuplicateGroupedAndTyped first2 = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(firstCollection, addTypeInfo);
        SubjectUtils.DuplicateGroupedAndTyped second = SubjectUtils.countDuplicatesAndMaybeAddTypeInfoReturnObject(secondCollection, addTypeInfo);
        ElementFactGrouping grouping = IterableSubject.pickGrouping(first2.entrySet(), second.entrySet());
        ImmutableList.Builder facts = ImmutableList.builder();
        ImmutableList<Fact> firstFacts = IterableSubject.makeElementFacts(firstKey, first2, grouping);
        ImmutableList<Fact> secondFacts = IterableSubject.makeElementFacts(secondKey, second, grouping);
        facts.addAll(firstFacts);
        if (firstFacts.size() > 1 && secondFacts.size() > 1) {
            facts.add(Fact.simpleFact(""));
        }
        facts.addAll(secondFacts);
        facts.add(Fact.simpleFact("---"));
        return facts.build();
    }

    private static ImmutableList<Fact> makeElementFacts(String label, SubjectUtils.DuplicateGroupedAndTyped elements, ElementFactGrouping grouping) {
        if (elements.isEmpty()) {
            return ImmutableList.of();
        }
        if (grouping == ElementFactGrouping.ALL_IN_ONE_FACT) {
            return ImmutableList.of(Fact.fact(IterableSubject.keyToGoWithElementsString(label, elements), elements));
        }
        ImmutableList.Builder facts = ImmutableList.builder();
        facts.add(Fact.simpleFact(IterableSubject.keyToServeAsHeader(label, elements)));
        int n = 1;
        for (Multiset.Entry<?> entry : elements.entrySet()) {
            int count2 = entry.getCount();
            Object item = entry.getElement();
            facts.add(Fact.fact(IterableSubject.numberString(n, count2), item));
            n += count2;
        }
        return facts.build();
    }

    private static String keyToGoWithElementsString(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        return Strings.lenientFormat("%s (%s)", label, elements.totalCopies());
    }

    private static String keyToServeAsHeader(String label, SubjectUtils.DuplicateGroupedAndTyped elements) {
        String key = IterableSubject.keyToGoWithElementsString(label, elements);
        if (elements.homogeneousTypeToDisplay.isPresent()) {
            key = key + " (" + elements.homogeneousTypeToDisplay.get() + ")";
        }
        return key;
    }

    private static String numberString(int n, int count2) {
        return count2 == 1 ? Strings.lenientFormat("#%s", n) : Strings.lenientFormat("#%s [%s copies]", n, count2);
    }

    private static ElementFactGrouping pickGrouping(Iterable<Multiset.Entry<?>> first2, Iterable<Multiset.Entry<?>> second) {
        boolean firstHasMultiple = IterableSubject.hasMultiple(first2);
        boolean secondHasMultiple = IterableSubject.hasMultiple(second);
        if ((firstHasMultiple || secondHasMultiple) && IterableSubject.anyContainsCommaOrNewline(first2, second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (firstHasMultiple && IterableSubject.containsEmptyOrLong(first2)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        if (secondHasMultiple && IterableSubject.containsEmptyOrLong(second)) {
            return ElementFactGrouping.FACT_PER_ELEMENT;
        }
        return ElementFactGrouping.ALL_IN_ONE_FACT;
    }

    private static boolean anyContainsCommaOrNewline(Iterable<Multiset.Entry<?>> ... lists) {
        for (Multiset.Entry<?> entry : Iterables.concat(lists)) {
            String s = String.valueOf(entry.getElement());
            if (!s.contains("\n") && !s.contains(",")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMultiple(Iterable<Multiset.Entry<?>> entries) {
        int totalCount = 0;
        for (Multiset.Entry<?> entry : entries) {
            if ((totalCount += entry.getCount()) <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean containsEmptyOrLong(Iterable<Multiset.Entry<?>> entries) {
        int totalLength = 0;
        for (Multiset.Entry<?> entry : entries) {
            String s = SubjectUtils.entryString(entry);
            if (s.isEmpty()) {
                return true;
            }
            totalLength += s.length();
        }
        return totalLength > 200;
    }

    public final void containsNoneOf(@NullableDecl Object firstExcluded, @NullableDecl Object secondExcluded, Object ... restOfExcluded) {
        this.containsNoneIn(SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
    }

    public final void containsNoneIn(Iterable<?> excluded) {
        Collection<?> actual = SubjectUtils.iterableToCollection(this.actual);
        ArrayList present = new ArrayList();
        for (Object item : Sets.newLinkedHashSet(excluded)) {
            if (!actual.contains(item)) continue;
            present.add(item);
        }
        if (!present.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected not to contain any of", SubjectUtils.annotateEmptyStrings(excluded)), Fact.fact("but contained", SubjectUtils.annotateEmptyStrings(present)), this.fullContents());
        }
    }

    public final void containsNoneIn(Object[] excluded) {
        this.containsNoneIn(Arrays.asList(excluded));
    }

    public void isInStrictOrder() {
        this.isInStrictOrder(Ordering.natural());
    }

    public final void isInStrictOrder(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck("expected to be in strict order", new PairwiseChecker(){

            @Override
            public boolean check(Object prev, Object next) {
                return comparator.compare(prev, next) < 0;
            }
        });
    }

    public void isInOrder() {
        this.isInOrder(Ordering.natural());
    }

    public final void isInOrder(final Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck("expected to be in order", new PairwiseChecker(){

            @Override
            public boolean check(Object prev, Object next) {
                return comparator.compare(prev, next) <= 0;
            }
        });
    }

    private void pairwiseCheck(String expectedFact, PairwiseChecker checker) {
        Iterator<?> iterator2 = this.actual.iterator();
        if (iterator2.hasNext()) {
            Object prev = iterator2.next();
            while (iterator2.hasNext()) {
                Object next = iterator2.next();
                if (!checker.check(prev, next)) {
                    this.failWithoutActual(Fact.simpleFact(expectedFact), Fact.fact("but contained", prev), Fact.fact("followed by", next), this.fullContents());
                    return;
                }
                prev = next;
            }
        }
    }

    @Override
    @Deprecated
    public void isNoneOf(@NullableDecl Object first2, @NullableDecl Object second, Object ... rest) {
        super.isNoneOf(first2, second, rest);
    }

    @Override
    @Deprecated
    public void isNotIn(Iterable<?> iterable) {
        if (Iterables.contains(iterable, this.actual)) {
            this.failWithActual("expected not to be any of", iterable);
        }
        ArrayList nonIterables = new ArrayList();
        for (Object element : iterable) {
            if (element instanceof Iterable) continue;
            nonIterables.add(element);
        }
        if (!nonIterables.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("The actual value is an Iterable, and you've written a test that compares it to some objects that are not Iterables. Did you instead mean to check whether its *contents* match any of the *contents* of the given values? If so, call containsNoneOf(...)/containsNoneIn(...) instead. Non-iterables: %s", nonIterables)), new Fact[0]);
        }
    }

    private Fact fullContents() {
        return Fact.fact("full contents", this.actualCustomStringRepresentationForPackageMembersToCall());
    }

    public <A, E> UsingCorrespondence<A, E> comparingElementsUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence<A, E>(this, correspondence);
    }

    public static class UsingCorrespondence<A, E> {
        private final IterableSubject subject;
        private final Correspondence<? super A, ? super E> correspondence;
        private final Optional<Pairer> pairer;

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence) {
            this.subject = Preconditions.checkNotNull(subject);
            this.correspondence = Preconditions.checkNotNull(correspondence);
            this.pairer = Optional.absent();
        }

        UsingCorrespondence(IterableSubject subject, Correspondence<? super A, ? super E> correspondence, Pairer pairer) {
            this.subject = Preconditions.checkNotNull(subject);
            this.correspondence = Preconditions.checkNotNull(correspondence);
            this.pairer = Optional.of(pairer);
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super E, ?> keyFunction) {
            Function<? super E, ?> actualKeyFunction = keyFunction;
            return this.displayingDiffsPairedBy(actualKeyFunction, keyFunction);
        }

        public UsingCorrespondence<A, E> displayingDiffsPairedBy(Function<? super A, ?> actualKeyFunction, Function<? super E, ?> expectedKeyFunction) {
            return new UsingCorrespondence<A, E>(this.subject, this.correspondence, new Pairer(actualKeyFunction, expectedKeyFunction));
        }

        public void contains(@NullableDecl E expected) {
            List keyMatches;
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.safeCompare(actual, expected, exceptions)) continue;
                if (exceptions.hasCompareException()) {
                    this.subject.failWithoutActual(exceptions.describeAsMainCause().and(Fact.fact("expected to contain", expected), this.correspondence.describeForIterable(), Fact.fact("found match (but failing because of exception)", actual), this.subject.fullContents()));
                }
                return;
            }
            if (this.pairer.isPresent() && !(keyMatches = this.pairer.get().pairOne(expected, this.getCastActual(), exceptions)).isEmpty()) {
                this.subject.failWithoutActual(Facts.facts(Fact.fact("expected to contain", expected), this.correspondence.describeForIterable(), Fact.simpleFact("but did not")).and(this.formatExtras("though it did contain elements with correct key", expected, keyMatches, exceptions)).and(this.subject.fullContents()).and(exceptions.describeAsAdditionalInfo()));
                return;
            }
            this.subject.failWithoutActual(Facts.facts(Fact.fact("expected to contain", expected), this.correspondence.describeForIterable(), this.subject.butWas()).and(exceptions.describeAsAdditionalInfo()));
        }

        public void doesNotContain(@NullableDecl E excluded) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            ArrayList<A> matchingElements = new ArrayList<A>();
            for (A actual : this.getCastActual()) {
                if (!this.correspondence.safeCompare(actual, excluded, exceptions)) continue;
                matchingElements.add(actual);
            }
            if (!matchingElements.isEmpty()) {
                this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("<%s> should not have contained an element that %s <%s>. It contained the following such elements: <%s>", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), this.correspondence, excluded, matchingElements))).and(exceptions.describeAsAdditionalInfo()));
                return;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that no element " + this.correspondence + " the forbidden value"), Fact.fact("expected not to contain", excluded)));
            }
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Ordered containsExactly(E ... expected) {
            return this.containsExactlyElementsIn(expected == null ? Lists.newArrayList(new Object[]{null}) : Arrays.asList(expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(final Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List<E> expectedList = SubjectUtils.iterableToList(expected);
            if (expectedList.isEmpty()) {
                if (actualList.isEmpty()) {
                    return IN_ORDER;
                }
                this.subject.isEmpty();
                return ALREADY_FAILED;
            }
            if (this.correspondInOrderExactly(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            ImmutableSetMultimap<Integer, Integer> candidateMapping = this.findCandidateMapping(actualList, expectedList, exceptions);
            if (this.failIfCandidateMappingHasMissingOrExtra(actualList, expectedList, candidateMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            ImmutableBiMap<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping(candidateMapping);
            if (this.failIfOneToOneMappingHasMissingOrExtra(actualList, expectedList, maximalOneToOneMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that each element " + this.correspondence + " an expected value"), Fact.fact("expected", expected)));
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    UsingCorrespondence.this.subject.failWithActual(Fact.simpleFact("contents match, but order was wrong"), Fact.simpleFact("comparing contents by testing that each element " + UsingCorrespondence.this.correspondence + " an expected value"), Fact.fact("expected", expected));
                }
            };
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyElementsIn(E[] expected) {
            return this.containsExactlyElementsIn(Arrays.asList(expected));
        }

        private boolean correspondInOrderExactly(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            while (actual.hasNext() && expected.hasNext()) {
                E expectedElement;
                A actualElement = actual.next();
                if (this.correspondence.safeCompare(actualElement, expectedElement = expected.next(), exceptions)) continue;
                return false;
            }
            return !actual.hasNext() && !expected.hasNext();
        }

        private ImmutableSetMultimap<Integer, Integer> findCandidateMapping(List<? extends A> actual, List<? extends E> expected, Correspondence.ExceptionStore exceptions) {
            ImmutableSetMultimap.Builder mapping = ImmutableSetMultimap.builder();
            for (int actualIndex = 0; actualIndex < actual.size(); ++actualIndex) {
                for (int expectedIndex = 0; expectedIndex < expected.size(); ++expectedIndex) {
                    if (!this.correspondence.safeCompare(actual.get(actualIndex), expected.get(expectedIndex), exceptions)) continue;
                    mapping.put((Object)actualIndex, (Object)expectedIndex);
                }
            }
            return mapping.build();
        }

        private boolean failIfCandidateMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, ImmutableSetMultimap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<A> extra = this.findNotIndexed(actual, mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, mapping.inverse().keySet());
            if (!missing.isEmpty() || !extra.isEmpty()) {
                this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains exactly one element that %s each element of <%s>. It %s", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), this.correspondence, expected, this.describeMissingOrExtra(missing, extra, exceptions)))).and(exceptions.describeAsAdditionalInfo()));
                return true;
            }
            return false;
        }

        private String describeMissingOrExtra(List<? extends E> missing, List<? extends A> extra, Correspondence.ExceptionStore exceptions) {
            if (this.pairer.isPresent()) {
                Pairing pairing = this.pairer.get().pair(missing, extra, exceptions);
                if (pairing != null) {
                    return this.describeMissingOrExtraWithPairing(pairing, exceptions);
                }
                return this.describeMissingOrExtraWithoutPairing(this.correspondence.toString(), missing, extra) + ". (N.B. A key function which does not uniquely key the expected elements was provided and has consequently been ignored.)";
            }
            if (missing.size() == 1 && extra.size() >= 1) {
                return Strings.lenientFormat("is missing an element that %s <%s> and has unexpected elements <%s>", this.correspondence, missing.get(0), this.formatExtrasInline(missing.get(0), extra, exceptions));
            }
            return this.describeMissingOrExtraWithoutPairing(this.correspondence.toString(), missing, extra);
        }

        private String describeMissingOrExtraWithoutPairing(String verb, List<? extends E> missing, List<? extends A> extra) {
            ArrayList<String> messages = Lists.newArrayList();
            if (!missing.isEmpty()) {
                messages.add(Strings.lenientFormat("is missing an element that %s %s", verb, this.formatMissing(missing)));
            }
            if (!extra.isEmpty()) {
                messages.add(Strings.lenientFormat("has unexpected elements <%s>", extra));
            }
            return Joiner.on(" and ").join(messages);
        }

        private String describeMissingOrExtraWithPairing(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ArrayList<String> messages = Lists.newArrayList();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.get(key);
                messages.add(Strings.lenientFormat("is missing an element that corresponds to <%s> and has unexpected elements <%s> with key %s", missing, this.formatExtrasInline(missing, extras, exceptions), key));
            }
            if (!pairing.unpairedActualValues.isEmpty() || !pairing.unpairedExpectedValues.isEmpty()) {
                messages.add(this.describeMissingOrExtraWithoutPairing("corresponds to", pairing.unpairedExpectedValues, pairing.unpairedActualValues) + " without matching keys");
            }
            if (messages.size() > 1) {
                messages.set(messages.size() - 1, "and " + (String)messages.get(messages.size() - 1));
            }
            return Joiner.on(", ").join(messages);
        }

        private Facts formatExtras(String label, E missing, List<? extends A> extras, Correspondence.ExceptionStore exceptions) {
            ArrayList<String> diffs = new ArrayList<String>(extras.size());
            boolean hasDiffs = false;
            for (int i = 0; i < extras.size(); ++i) {
                A extra = extras.get(i);
                String diff = this.correspondence.safeFormatDiff(extra, missing, exceptions);
                diffs.add(diff);
                if (diff == null) continue;
                hasDiffs = true;
            }
            if (hasDiffs) {
                ArrayList<Fact> extraFacts = new ArrayList<Fact>();
                extraFacts.add(Fact.simpleFact(Strings.lenientFormat("%s (%s)", label, extras.size())));
                for (int i = 0; i < extras.size(); ++i) {
                    A extra = extras.get(i);
                    extraFacts.add(Fact.fact(Strings.lenientFormat("#%s", i + 1), extra));
                    if (diffs.get(i) == null) continue;
                    extraFacts.add(Fact.fact("diff", diffs.get(i)));
                }
                extraFacts.add(Fact.simpleFact("---"));
                return Facts.facts(extraFacts);
            }
            return Facts.facts(Fact.fact(Strings.lenientFormat("%s (%s)", label, extras.size()), extras));
        }

        private List<Object> formatExtrasInline(E missing, List<? extends A> extras, Correspondence.ExceptionStore exceptions) {
            ArrayList<Object> extrasFormatted = new ArrayList<Object>();
            for (A extra : extras) {
                String diff = this.correspondence.safeFormatDiff(extra, missing, exceptions);
                if (diff != null) {
                    extrasFormatted.add(Strings.lenientFormat("%s (diff: %s)", extra, diff));
                    continue;
                }
                extrasFormatted.add(extra);
            }
            return extrasFormatted;
        }

        private <T> List<T> findNotIndexed(List<T> list, Set<Integer> indexes) {
            if (indexes.size() == list.size()) {
                return Arrays.asList(new Object[0]);
            }
            ArrayList<T> notIndexed = Lists.newArrayList();
            for (int index = 0; index < list.size(); ++index) {
                if (indexes.contains(index)) continue;
                notIndexed.add(list.get(index));
            }
            return notIndexed;
        }

        private String formatMissing(List<?> missing) {
            if (missing.size() == 1) {
                return "<" + missing.get(0) + ">";
            }
            return "each of <" + missing + ">";
        }

        private ImmutableBiMap<Integer, Integer> findMaximalOneToOneMapping(ImmutableMultimap<Integer, Integer> edges) {
            return GraphMatching.maximumCardinalityBipartiteMatching(edges);
        }

        private boolean failIfOneToOneMappingHasMissingOrExtra(List<? extends A> actual, List<? extends E> expected, BiMap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<A> extra = this.findNotIndexed(actual, mapping.keySet());
            List<E> missing = this.findNotIndexed(expected, mapping.values());
            if (!missing.isEmpty() || !extra.isEmpty()) {
                this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains exactly one element that %s each element of <%s>. It contains at least one element that matches each expected element, and every element it contains matches at least one expected element, but there was no 1:1 mapping between all the actual and expected elements. Using the most complete 1:1 mapping (or one such mapping, if there is a tie), it %s", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), this.correspondence, expected, this.describeMissingOrExtra(missing, extra, exceptions)))).and(exceptions.describeAsAdditionalInfo()));
                return true;
            }
            return false;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Ordered containsAtLeast(@NullableDecl E first2, @NullableDecl E second, E ... rest) {
            return this.containsAtLeastElementsIn(SubjectUtils.accumulate(first2, second, rest));
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastElementsIn(final Iterable<? extends E> expected) {
            List<A> actualList = SubjectUtils.iterableToList(this.getCastActual());
            List<E> expectedList = SubjectUtils.iterableToList(expected);
            if (this.correspondInOrderAllIn(actualList.iterator(), expectedList.iterator())) {
                return IN_ORDER;
            }
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            ImmutableSetMultimap<Integer, Integer> candidateMapping = this.findCandidateMapping(actualList, expectedList, exceptions);
            if (this.failIfCandidateMappingHasMissing(actualList, expectedList, candidateMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            ImmutableBiMap<Integer, Integer> maximalOneToOneMapping = this.findMaximalOneToOneMapping(candidateMapping);
            if (this.failIfOneToOneMappingHasMissing(actualList, expectedList, maximalOneToOneMapping, exceptions)) {
                return ALREADY_FAILED;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that each element " + this.correspondence + " an expected value"), Fact.fact("expected", expected)));
                return ALREADY_FAILED;
            }
            return new Ordered(){

                @Override
                public void inOrder() {
                    UsingCorrespondence.this.subject.failWithActual(Fact.simpleFact("required elements were all found, but order was wrong"), Fact.simpleFact("comparing contents by testing that each element " + UsingCorrespondence.this.correspondence + " an expected value"), Fact.fact("expected order for required elements", expected));
                }
            };
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastElementsIn(E[] expected) {
            return this.containsAtLeastElementsIn(Arrays.asList(expected));
        }

        private boolean correspondInOrderAllIn(Iterator<? extends A> actual, Iterator<? extends E> expected) {
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            while (expected.hasNext()) {
                E expectedElement = expected.next();
                if (this.findCorresponding(actual, expectedElement, exceptions) && !exceptions.hasCompareException()) continue;
                return false;
            }
            return true;
        }

        private boolean findCorresponding(Iterator<? extends A> actual, E expectedElement, Correspondence.ExceptionStore exceptions) {
            while (actual.hasNext()) {
                A actualElement = actual.next();
                if (!this.correspondence.safeCompare(actualElement, expectedElement, exceptions)) continue;
                return true;
            }
            return false;
        }

        private boolean failIfCandidateMappingHasMissing(List<? extends A> actual, List<? extends E> expected, ImmutableSetMultimap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<E> missing = this.findNotIndexed(expected, mapping.inverse().keySet());
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, mapping.keySet());
                this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains at least one element that %s each element of <%s>. It %s", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), this.correspondence, expected, this.describeMissing(missing, extra, exceptions)))).and(exceptions.describeAsAdditionalInfo()));
                return true;
            }
            return false;
        }

        private String describeMissing(List<? extends E> missing, List<? extends A> extra, Correspondence.ExceptionStore exceptions) {
            if (this.pairer.isPresent()) {
                Pairing pairing = this.pairer.get().pair(missing, extra, exceptions);
                if (pairing != null) {
                    return this.describeMissingWithPairing(pairing, exceptions);
                }
                return this.describeMissingWithoutPairing(this.correspondence.toString(), missing) + ". (N.B. A key function which does not uniquely key the expected elements was provided and has consequently been ignored.)";
            }
            return this.describeMissingWithoutPairing(this.correspondence.toString(), missing);
        }

        private String describeMissingWithoutPairing(String verb, List<? extends E> missing) {
            return Strings.lenientFormat("is missing an element that %s %s", verb, this.formatMissing(missing));
        }

        private String describeMissingWithPairing(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ArrayList<String> messages = Lists.newArrayList();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object missing = pairing.pairedKeysToExpectedValues.get(key);
                List extras = pairing.pairedKeysToActualValues.get(key);
                messages.add(Strings.lenientFormat("is missing an element that corresponds to <%s> (but did have elements <%s> with matching key %s)", missing, this.formatExtrasInline(missing, extras, exceptions), key));
            }
            if (!pairing.unpairedExpectedValues.isEmpty()) {
                messages.add(this.describeMissingWithoutPairing("corresponds to", pairing.unpairedExpectedValues) + " (without matching keys)");
            }
            if (messages.size() > 1) {
                messages.set(messages.size() - 1, "and " + (String)messages.get(messages.size() - 1));
            }
            return Joiner.on(", ").join(messages);
        }

        private boolean failIfOneToOneMappingHasMissing(List<? extends A> actual, List<? extends E> expected, BiMap<Integer, Integer> mapping, Correspondence.ExceptionStore exceptions) {
            List<E> missing = this.findNotIndexed(expected, mapping.values());
            if (!missing.isEmpty()) {
                List<? extends A> extra = this.findNotIndexed(actual, mapping.keySet());
                this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains at least one element that %s each element of <%s>. It contains at least one element that matches each expected element, but there was no 1:1 mapping between all the expected elements and any subset of the actual elements. Using the most complete 1:1 mapping (or one such mapping, if there is a tie), it %s", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), this.correspondence, expected, this.describeMissing(missing, extra, exceptions)))).and(exceptions.describeAsAdditionalInfo()));
                return true;
            }
            return false;
        }

        @SafeVarargs
        public final void containsAnyOf(@NullableDecl E first2, @NullableDecl E second, E ... rest) {
            this.containsAny(Strings.lenientFormat("contains at least one element that %s any of", this.correspondence), SubjectUtils.accumulate(first2, second, rest));
        }

        public void containsAnyIn(Iterable<? extends E> expected) {
            this.containsAny(Strings.lenientFormat("contains at least one element that %s any element in", this.correspondence), expected);
        }

        public void containsAnyIn(E[] expected) {
            this.containsAnyIn(Arrays.asList(expected));
        }

        private void containsAny(String failVerb, Iterable<? extends E> expected) {
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (E expectedItem : expected) {
                for (A actualItem : actual) {
                    if (!this.correspondence.safeCompare(actualItem, expectedItem, exceptions)) continue;
                    if (exceptions.hasCompareException()) {
                        this.subject.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that at least one element " + this.correspondence + " any expected value"), Fact.fact("expected to contain any of", expected)));
                    }
                    return;
                }
            }
            if (this.pairer.isPresent()) {
                Pairing pairing = this.pairer.get().pair(SubjectUtils.iterableToList(expected), SubjectUtils.iterableToList(actual), exceptions);
                if (pairing != null) {
                    if (!pairing.pairedKeysToExpectedValues.isEmpty()) {
                        this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> %s <%s>. It contains the following values that match by key: %s", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), failVerb, expected, this.describeAnyMatchesByKey(pairing, exceptions)))).and(exceptions.describeAsAdditionalInfo()));
                    } else {
                        this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> %s <%s>. It does not contain any matches by key, either", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), failVerb, expected))).and(exceptions.describeAsAdditionalInfo()));
                    }
                } else {
                    this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> %s <%s>. (N.B. A key function which does not uniquely key the expected elements was provided and has consequently been ignored.)", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), failVerb, expected))).and(exceptions.describeAsAdditionalInfo()));
                }
            } else {
                this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> %s <%s>", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), failVerb, expected))).and(exceptions.describeAsAdditionalInfo()));
            }
        }

        private String describeAnyMatchesByKey(Pairing pairing, Correspondence.ExceptionStore exceptions) {
            ArrayList<String> messages = Lists.newArrayList();
            for (Object key : pairing.pairedKeysToExpectedValues.keySet()) {
                Object expected = pairing.pairedKeysToExpectedValues.get(key);
                List got = pairing.pairedKeysToActualValues.get(key);
                messages.add(Strings.lenientFormat("with key %s, would have accepted %s, but got %s", key, expected, this.formatExtrasInline(expected, got, exceptions)));
            }
            return Joiner.on("; ").join(messages);
        }

        @SafeVarargs
        public final void containsNoneOf(@NullableDecl E firstExcluded, @NullableDecl E secondExcluded, E ... restOfExcluded) {
            this.containsNone("any of", SubjectUtils.accumulate(firstExcluded, secondExcluded, restOfExcluded));
        }

        public void containsNoneIn(Iterable<? extends E> excluded) {
            this.containsNone("any element in", excluded);
        }

        public void containsNoneIn(E[] excluded) {
            this.containsNoneIn(Arrays.asList(excluded));
        }

        private void containsNone(String excludedPrefix, Iterable<? extends E> excluded) {
            Collection<A> actual = SubjectUtils.iterableToCollection(this.getCastActual());
            LinkedListMultimap<Object, A> present = LinkedListMultimap.create();
            Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forIterable();
            for (Object excludedItem : Sets.newLinkedHashSet(excluded)) {
                for (A actualItem : actual) {
                    if (!this.correspondence.safeCompare(actualItem, excludedItem, exceptions)) continue;
                    present.put(excludedItem, actualItem);
                }
            }
            if (!present.isEmpty()) {
                StringBuilder presentDescription = new StringBuilder();
                for (Object excludedItem : present.keySet()) {
                    List actualItems;
                    if (presentDescription.length() > 0) {
                        presentDescription.append(", ");
                    }
                    if ((actualItems = present.get(excludedItem)).size() == 1) {
                        presentDescription.append(actualItems.get(0)).append(" which corresponds to ").append(excludedItem);
                        continue;
                    }
                    presentDescription.append(actualItems).append(" which all correspond to ").append(excludedItem);
                }
                this.subject.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains no element that %s %s <%s>. It contains <[%s]>", this.subject.actualCustomStringRepresentationForPackageMembersToCall(), this.correspondence, excludedPrefix, excluded, presentDescription))).and(exceptions.describeAsAdditionalInfo()));
                return;
            }
            if (exceptions.hasCompareException()) {
                this.subject.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that no element " + this.correspondence + " any forbidden value"), Fact.fact("expected not to contain any of", excluded)));
            }
        }

        private Iterable<A> getCastActual() {
            return this.subject.actual;
        }

        private final class Pairing {
            private final Map<Object, E> pairedKeysToExpectedValues = new LinkedHashMap();
            private final ListMultimap<Object, A> pairedKeysToActualValues = LinkedListMultimap.create();
            private final List<E> unpairedExpectedValues = Lists.newArrayList();
            private final List<A> unpairedActualValues = Lists.newArrayList();

            private Pairing() {
            }
        }

        private final class Pairer {
            private final Function<? super A, ?> actualKeyFunction;
            private final Function<? super E, ?> expectedKeyFunction;

            Pairer(Function<? super A, ?> actualKeyFunction, Function<? super E, ?> expectedKeyFunction) {
                this.actualKeyFunction = actualKeyFunction;
                this.expectedKeyFunction = expectedKeyFunction;
            }

            @NullableDecl
            Pairing pair(List<? extends E> expectedValues, List<? extends A> actualValues, Correspondence.ExceptionStore exceptions) {
                Object key;
                Object expected2;
                Pairing pairing = new Pairing();
                ArrayList<Object> expectedKeys = new ArrayList<Object>(expectedValues.size());
                for (Object expected2 : expectedValues) {
                    expectedKeys.add(this.expectedKey(expected2, exceptions));
                }
                for (int i = 0; i < expectedValues.size(); ++i) {
                    expected2 = expectedValues.get(i);
                    key = expectedKeys.get(i);
                    if (key == null) continue;
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        return null;
                    }
                    pairing.pairedKeysToExpectedValues.put(key, expected2);
                }
                for (Object actual : actualValues) {
                    key = this.actualKey(actual, exceptions);
                    if (pairing.pairedKeysToExpectedValues.containsKey(key)) {
                        pairing.pairedKeysToActualValues.put(key, actual);
                        continue;
                    }
                    pairing.unpairedActualValues.add(actual);
                }
                for (int i = 0; i < expectedValues.size(); ++i) {
                    expected2 = expectedValues.get(i);
                    key = expectedKeys.get(i);
                    if (pairing.pairedKeysToActualValues.containsKey(key)) continue;
                    pairing.unpairedExpectedValues.add(expected2);
                    pairing.pairedKeysToExpectedValues.remove(key);
                }
                return pairing;
            }

            List<A> pairOne(E expectedValue, Iterable<? extends A> actualValues, Correspondence.ExceptionStore exceptions) {
                Object key = this.expectedKey(expectedValue, exceptions);
                ArrayList matches = new ArrayList();
                if (key != null) {
                    for (Object actual : actualValues) {
                        if (!key.equals(this.actualKey(actual, exceptions))) continue;
                        matches.add(actual);
                    }
                }
                return matches;
            }

            @NullableDecl
            private Object actualKey(A actual, Correspondence.ExceptionStore exceptions) {
                try {
                    return this.actualKeyFunction.apply(actual);
                }
                catch (RuntimeException e) {
                    exceptions.addActualKeyFunctionException(Pairer.class, e, actual);
                    return null;
                }
            }

            @NullableDecl
            private Object expectedKey(E expected, Correspondence.ExceptionStore exceptions) {
                try {
                    return this.expectedKeyFunction.apply(expected);
                }
                catch (RuntimeException e) {
                    exceptions.addExpectedKeyFunctionException(Pairer.class, e, expected);
                    return null;
                }
            }
        }
    }

    private static interface PairwiseChecker {
        public boolean check(Object var1, Object var2);
    }

    static enum ElementFactGrouping {
        ALL_IN_ONE_FACT,
        FACT_PER_ELEMENT;

    }
}

