/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.Facts;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class MultimapSubject
extends Subject {
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private final Multimap<?, ?> actual;

    protected MultimapSubject(FailureMetadata metadata2, @NullableDecl Multimap<?, ?> multimap) {
        this(metadata2, multimap, null);
    }

    MultimapSubject(FailureMetadata metadata2, @NullableDecl Multimap<?, ?> multimap, @NullableDecl String typeDescription) {
        super(metadata2, multimap, typeDescription);
        this.actual = multimap;
    }

    public final void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public final void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "expectedSize(%s) must be >= 0", expectedSize);
        this.check("size()", new Object[0]).that(this.actual.size()).isEqualTo(expectedSize);
    }

    public final void containsKey(@NullableDecl Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).contains(key);
    }

    public final void doesNotContainKey(@NullableDecl Object key) {
        this.check("keySet()", new Object[0]).that(this.actual.keySet()).doesNotContain(key);
    }

    public final void containsEntry(@NullableDecl Object key, @NullableDecl Object value) {
        if (!this.actual.containsEntry(key, value)) {
            Map.Entry<Object, Object> entry = Maps.immutableEntry(key, value);
            ImmutableList<Map.Entry<Object, Object>> entryList = ImmutableList.of(entry);
            if (SubjectUtils.hasMatchingToStringPair(this.actual.entries(), entryList)) {
                this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains entry <%s (%s)>. However, it does contain entries <%s>", this.actualCustomStringRepresentationForPackageMembersToCall(), entry, SubjectUtils.objectToTypeName(entry), SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(this.actual.entries(), entryList)))), new Fact[0]);
            } else if (this.actual.containsKey(key)) {
                this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains entry <%s>. However, it has a mapping from <%s> to <%s>", this.actualCustomStringRepresentationForPackageMembersToCall(), entry, key, this.actual.asMap().get(key))), new Fact[0]);
            } else if (this.actual.containsValue(value)) {
                LinkedHashSet keys2 = new LinkedHashSet();
                for (Map.Entry<?, ?> actualEntry : this.actual.entries()) {
                    if (!Objects.equal(actualEntry.getValue(), value)) continue;
                    keys2.add(actualEntry.getKey());
                }
                this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains entry <%s>. However, the following keys are mapped to <%s>: %s", this.actualCustomStringRepresentationForPackageMembersToCall(), entry, value, keys2)), new Fact[0]);
            } else {
                this.failWithActual("expected to contain entry", Maps.immutableEntry(key, value));
            }
        }
    }

    public final void doesNotContainEntry(@NullableDecl Object key, @NullableDecl Object value) {
        this.checkNoNeedToDisplayBothValues("entries()", new Object[0]).that(this.actual.entries()).doesNotContain(Maps.immutableEntry(key, value));
    }

    public IterableSubject valuesForKey(@NullableDecl Object key) {
        return this.check("valuesForKey(%s)", key).that(this.actual.get(key));
    }

    @Override
    public final void isEqualTo(@NullableDecl Object other) {
        boolean isEqual = Objects.equal(this.actual, other);
        if (isEqual) {
            return;
        }
        if (this.actual instanceof ListMultimap && other instanceof SetMultimap || this.actual instanceof SetMultimap && other instanceof ListMultimap) {
            String mapType1 = this.actual instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            String mapType2 = other instanceof ListMultimap ? "ListMultimap" : "SetMultimap";
            this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that %s <%s> is equal to %s <%s>. A %s cannot equal a %s if either is non-empty.", mapType1, this.actualCustomStringRepresentationForPackageMembersToCall(), mapType2, other, mapType1, mapType2)), new Fact[0]);
        } else if (this.actual instanceof ListMultimap) {
            this.containsExactlyEntriesIn((Multimap)other).inOrder();
        } else if (this.actual instanceof SetMultimap) {
            this.containsExactlyEntriesIn((Multimap)other);
        } else {
            super.isEqualTo(other);
        }
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactlyEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, "expectedMultimap");
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        ListMultimap<?, ?> extra = MultimapSubject.difference(this.actual, expectedMultimap);
        if (!missing.isEmpty()) {
            if (!extra.isEmpty()) {
                boolean addTypeInfo = SubjectUtils.hasMatchingToStringPair(missing.entries(), extra.entries());
                this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains exactly <%s>. It is missing <%s> and has unexpected items <%s>", this.actualCustomStringRepresentationForPackageMembersToCall(), MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap), addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(missing).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing)), addTypeInfo ? SubjectUtils.countDuplicatesAndAddTypeInfo(MultimapSubject.annotateEmptyStringsMultimap(extra).entries()) : MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra)))), new Fact[0]);
                return ALREADY_FAILED;
            }
            this.failWithBadResults("contains exactly", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap), "is missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing)));
            return ALREADY_FAILED;
        }
        if (!extra.isEmpty()) {
            this.failWithBadResults("contains exactly", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap), "has unexpected items", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(extra)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder("contains exactly", expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeastEntriesIn(Multimap<?, ?> expectedMultimap) {
        Preconditions.checkNotNull(expectedMultimap, "expectedMultimap");
        ListMultimap<?, ?> missing = MultimapSubject.difference(expectedMultimap, this.actual);
        if (!missing.isEmpty()) {
            this.failWithBadResults("contains at least", MultimapSubject.annotateEmptyStringsMultimap(expectedMultimap), "is missing", MultimapSubject.countDuplicatesMultimap(MultimapSubject.annotateEmptyStringsMultimap(missing)));
            return ALREADY_FAILED;
        }
        return new MultimapInOrder("contains at least", expectedMultimap);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly() {
        return this.check().about(this.iterableEntries()).that(this.actual.entries()).containsExactly(new Object[0]);
    }

    @CanIgnoreReturnValue
    public final Ordered containsExactly(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    @CanIgnoreReturnValue
    public final Ordered containsAtLeast(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        return this.containsAtLeastEntriesIn(MultimapSubject.accumulateMultimap(k0, v0, rest));
    }

    private static Multimap<Object, Object> accumulateMultimap(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        Preconditions.checkArgument(rest.length % 2 == 0, "There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", rest.length + 2);
        LinkedListMultimap<Object, Object> expectedMultimap = LinkedListMultimap.create();
        expectedMultimap.put(k0, v0);
        for (int i = 0; i < rest.length; i += 2) {
            expectedMultimap.put(rest[i], rest[i + 1]);
        }
        return expectedMultimap;
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterableEntries() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata2, Iterable<?> actual) {
                return new IterableEntries(metadata2, MultimapSubject.this, actual);
            }
        };
    }

    private static boolean advanceToFind(Iterator<?> iterator2, Object value) {
        while (iterator2.hasNext()) {
            if (!Objects.equal(iterator2.next(), value)) continue;
            return true;
        }
        return false;
    }

    private static <V> Collection<V> get(Multimap<?, V> multimap, @NullableDecl Object key) {
        if (multimap.containsKey(key)) {
            return multimap.asMap().get(key);
        }
        return Collections.emptyList();
    }

    private static ListMultimap<?, ?> difference(Multimap<?, ?> minuend, Multimap<?, ?> subtrahend) {
        LinkedListMultimap<?, ?> difference = LinkedListMultimap.create();
        for (Object key : minuend.keySet()) {
            List<?> valDifference = MultimapSubject.difference(Lists.newArrayList(MultimapSubject.get(minuend, key)), Lists.newArrayList(MultimapSubject.get(subtrahend, key)));
            difference.putAll(key, valDifference);
        }
        return difference;
    }

    private static List<?> difference(List<?> minuend, List<?> subtrahend) {
        LinkedHashMultiset<?> remaining = LinkedHashMultiset.create(subtrahend);
        ArrayList<?> difference = Lists.newArrayList();
        for (Object elem : minuend) {
            if (remaining.remove(elem)) continue;
            difference.add(elem);
        }
        return difference;
    }

    private static String countDuplicatesMultimap(Multimap<?, ?> multimap) {
        ArrayList<String> entries = new ArrayList<String>();
        for (Object key : multimap.keySet()) {
            entries.add(key + "=" + SubjectUtils.countDuplicates(MultimapSubject.get(multimap, key)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Joiner.on(", ").appendTo(sb, (Iterable<?>)entries);
        sb.append("}");
        return sb.toString();
    }

    private static Multimap<?, ?> annotateEmptyStringsMultimap(Multimap<?, ?> multimap) {
        if (multimap.containsKey("") || multimap.containsValue("")) {
            LinkedListMultimap<String, String> annotatedMultimap = LinkedListMultimap.create();
            for (Map.Entry<?, ?> entry : multimap.entries()) {
                String key = "".equals(entry.getKey()) ? "\"\" (empty String)" : entry.getKey();
                String value = "".equals(entry.getValue()) ? "\"\" (empty String)" : entry.getValue();
                annotatedMultimap.put(key, value);
            }
            return annotatedMultimap;
        }
        return multimap;
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<? super A, ? super E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    private static final class EntryCorrespondence<K, A, E>
    extends Correspondence<Map.Entry<K, A>, Map.Entry<K, E>> {
        private final Correspondence<? super A, ? super E> valueCorrespondence;

        EntryCorrespondence(Correspondence<? super A, ? super E> valueCorrespondence) {
            this.valueCorrespondence = valueCorrespondence;
        }

        @Override
        public boolean compare(Map.Entry<K, A> actual, Map.Entry<K, E> expected) {
            return actual.getKey().equals(expected.getKey()) && this.valueCorrespondence.compare(actual.getValue(), expected.getValue());
        }

        @Override
        public String toString() {
            return Strings.lenientFormat("has a key that is equal to and a value that %s the key and value of", this.valueCorrespondence);
        }
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<? super A, ? super E> correspondence;

        private UsingCorrespondence(Correspondence<? super A, ? super E> correspondence) {
            this.correspondence = Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@NullableDecl Object expectedKey, @NullableDecl E expectedValue) {
            if (MultimapSubject.this.actual.containsKey(expectedKey)) {
                Collection<A> actualValues = this.getCastActual().asMap().get(expectedKey);
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (A actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, expectedValue, exceptions)) continue;
                    if (exceptions.hasCompareException()) {
                        MultimapSubject.this.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that at least one entry had a key equal to the expected key and a value that " + this.correspondence + " the expected value"), Fact.fact("expected key", expectedKey), Fact.fact("expected value", expectedValue)));
                    }
                    return;
                }
                MultimapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains at least one entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s>", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), expectedKey, this.correspondence, expectedValue, actualValues))).and(exceptions.describeAsAdditionalInfo()));
            } else {
                LinkedHashSet keys2 = new LinkedHashSet();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (Map.Entry<?, A> actualEntry : this.getCastActual().entries()) {
                    if (!this.correspondence.safeCompare(actualEntry.getValue(), expectedValue, exceptions)) continue;
                    keys2.add(actualEntry.getKey());
                }
                if (!keys2.isEmpty()) {
                    MultimapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains at least one entry with key <%s> and a value that %s <%s>. However, the following keys are mapped to such values: <%s>", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), expectedKey, this.correspondence, expectedValue, keys2))).and(exceptions.describeAsAdditionalInfo()));
                } else {
                    MultimapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> contains at least one entry with key <%s> and a value that %s <%s>", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), expectedKey, this.correspondence, expectedValue))).and(exceptions.describeAsAdditionalInfo()));
                }
            }
        }

        public void doesNotContainEntry(@NullableDecl Object excludedKey, @NullableDecl E excludedValue) {
            if (MultimapSubject.this.actual.containsKey(excludedKey)) {
                Collection<A> actualValues = this.getCastActual().asMap().get(excludedKey);
                ArrayList<A> matchingValues = new ArrayList<A>();
                Correspondence.ExceptionStore exceptions = Correspondence.ExceptionStore.forMapValues();
                for (A actualValue : actualValues) {
                    if (!this.correspondence.safeCompare(actualValue, excludedValue, exceptions)) continue;
                    matchingValues.add(actualValue);
                }
                if (!matchingValues.isEmpty()) {
                    MultimapSubject.this.failWithoutActual(Facts.facts(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> did not contain an entry with key <%s> and a value that %s <%s>. It maps that key to the following such values: <%s>", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), excludedKey, this.correspondence, excludedValue, matchingValues))).and(exceptions.describeAsAdditionalInfo()));
                } else if (exceptions.hasCompareException()) {
                    MultimapSubject.this.failWithActual(exceptions.describeAsMainCause().and(Fact.simpleFact("comparing contents by testing that no entry had the forbidden key and a value that " + this.correspondence + " the forbidden value"), Fact.fact("forbidden key", excludedKey), Fact.fact("forbidden value", excludedValue)));
                }
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactlyEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsExactlyEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsExactlyEntriesIn(Multimap<K, V> expectedMultimap) {
            return ((IterableSubject)MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(MultimapSubject.this.actual.entries())).comparingElementsUsing(new EntryCorrespondence(this.correspondence)).containsExactlyElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeastEntriesIn(Multimap<?, ? extends E> expectedMultimap) {
            return this.internalContainsAtLeastEntriesIn(expectedMultimap);
        }

        private <K, V extends E> Ordered internalContainsAtLeastEntriesIn(Multimap<K, V> expectedMultimap) {
            return ((IterableSubject)MultimapSubject.this.check().about(MultimapSubject.this.iterableEntries()).that(MultimapSubject.this.actual.entries())).comparingElementsUsing(new EntryCorrespondence(this.correspondence)).containsAtLeastElementsIn(expectedMultimap.entries());
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl E v0, Object ... rest) {
            Multimap expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMultimap);
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly() {
            return MultimapSubject.this.containsExactly();
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(@NullableDecl Object k0, @NullableDecl E v0, Object ... rest) {
            Multimap expectedMultimap = MultimapSubject.accumulateMultimap(k0, v0, rest);
            return this.containsAtLeastEntriesIn(expectedMultimap);
        }

        private Multimap<?, A> getCastActual() {
            return MultimapSubject.this.actual;
        }
    }

    private class MultimapInOrder
    implements Ordered {
        private final Multimap<?, ?> expectedMultimap;
        private final String verb;

        MultimapInOrder(String verb, Multimap<?, ?> expectedMultimap) {
            this.expectedMultimap = expectedMultimap;
            this.verb = verb;
        }

        @Override
        public void inOrder() {
            boolean keysInOrder = Lists.newArrayList(Sets.intersection(MultimapSubject.this.actual.keySet(), this.expectedMultimap.keySet())).equals(Lists.newArrayList(this.expectedMultimap.keySet()));
            LinkedHashSet<?> keysWithValuesOutOfOrder = Sets.newLinkedHashSet();
            block0: for (Object key : this.expectedMultimap.keySet()) {
                ArrayList actualVals = Lists.newArrayList(MultimapSubject.get(MultimapSubject.this.actual, key));
                ArrayList expectedVals = Lists.newArrayList(MultimapSubject.get(this.expectedMultimap, key));
                Iterator actualIterator = actualVals.iterator();
                for (Object value : expectedVals) {
                    if (MultimapSubject.advanceToFind(actualIterator, value)) continue;
                    keysWithValuesOutOfOrder.add(key);
                    continue block0;
                }
            }
            if (!keysInOrder) {
                if (!keysWithValuesOutOfOrder.isEmpty()) {
                    MultimapSubject.this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> %s <%s> in order. The keys are not in order, and the values for keys <%s> are not in order either", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), this.verb, this.expectedMultimap, keysWithValuesOutOfOrder)), new Fact[0]);
                } else {
                    MultimapSubject.this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> %s <%s> in order. The keys are not in order", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), this.verb, this.expectedMultimap)), new Fact[0]);
                }
            } else if (!keysWithValuesOutOfOrder.isEmpty()) {
                MultimapSubject.this.failWithoutActual(Fact.simpleFact(Strings.lenientFormat("Not true that <%s> %s <%s> in order. The values for keys <%s> are not in order", MultimapSubject.this.actualCustomStringRepresentationForPackageMembersToCall(), this.verb, this.expectedMultimap, keysWithValuesOutOfOrder)), new Fact[0]);
            }
        }
    }

    private static class IterableEntries
    extends IterableSubject {
        private final String stringRepresentation;

        IterableEntries(FailureMetadata metadata2, MultimapSubject multimapSubject, Iterable<?> actual) {
            super(metadata2, actual);
            this.stringRepresentation = multimapSubject.actual.toString();
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return this.stringRepresentation;
        }
    }
}

