/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Fact;
import com.google.common.truth.StackTraceCleaner;
import difflib.DiffUtils;
import difflib.Patch;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.junit.ComparisonFailure;
import org.junit.rules.TestRule;

final class Platform {
    static final String EXPECT_FAILURE_WARNING_IF_GWT = "";

    private Platform() {
    }

    static boolean isInstanceOfType(Object instance, Class<?> clazz) {
        return clazz.isInstance(instance);
    }

    static boolean containsMatch(String actual, String regex) {
        return Pattern.compile(regex).matcher(actual).find();
    }

    static Throwable[] getSuppressed(Throwable throwable) {
        try {
            Method getSuppressed = throwable.getClass().getMethod("getSuppressed", new Class[0]);
            return (Throwable[])getSuppressed.invoke((Object)throwable, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return new Throwable[0];
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void cleanStackTrace(Throwable throwable) {
        StackTraceCleaner.cleanStackTrace(throwable);
    }

    static String inferDescription() {
        if (Platform.isInferDescriptionDisabled()) {
            return null;
        }
        AssertionError stack = new AssertionError();
        Platform.cleanStackTrace((Throwable)((Object)stack));
        if (((Throwable)((Object)stack)).getStackTrace().length == 0) {
            return null;
        }
        StackTraceElement top = ((Throwable)((Object)stack)).getStackTrace()[0];
        try {
            return (String)Class.forName("com.google.common.truth.ActualValueInference").getDeclaredMethod("describeActualValue", String.class, String.class, Integer.TYPE).invoke(null, top.getClassName(), top.getMethodName(), top.getLineNumber());
        }
        catch (ClassNotFoundException | IllegalAccessException | LinkageError | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            return null;
        }
    }

    @NullableDecl
    static ImmutableList<Fact> makeDiff(String expected, String actual) {
        ImmutableList<String> actualLines;
        Patch<String> diff;
        ImmutableList<String> expectedLines = Platform.splitLines(expected);
        List<String> unifiedDiff = DiffUtils.generateUnifiedDiff("expected", "actual", expectedLines, diff = DiffUtils.diff(expectedLines, actualLines = Platform.splitLines(actual)), 3);
        if (unifiedDiff.isEmpty()) {
            return ImmutableList.of(Fact.fact("diff", "(line contents match, but line-break characters differ)"));
        }
        unifiedDiff = unifiedDiff.subList(2, unifiedDiff.size());
        String result2 = Joiner.on("\n").join(unifiedDiff);
        if (result2.length() > expected.length() && result2.length() > actual.length()) {
            return null;
        }
        return ImmutableList.of(Fact.fact("diff", result2));
    }

    private static ImmutableList<String> splitLines(String s) {
        return ImmutableList.copyOf(Splitter.onPattern("\r?\n").split(s));
    }

    static String doubleToString(double value) {
        return Double.toString(value);
    }

    static String floatToString(float value) {
        return Float.toString(value);
    }

    static String getStackTraceAsString(Throwable throwable) {
        return Throwables.getStackTraceAsString(throwable);
    }

    static boolean isAndroid() {
        return System.getProperties().getProperty("java.runtime.name").contains("Android");
    }

    private static boolean isInferDescriptionDisabled() {
        try {
            return Boolean.parseBoolean(System.getProperty("com.google.common.truth.disable_infer_description"));
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static interface JUnitTestRule
    extends TestRule {
    }

    static abstract class PlatformComparisonFailure
    extends ComparisonFailure {
        private final String message;
        @NullableDecl
        private final Throwable cause;

        PlatformComparisonFailure(String message, String expected, String actual, @NullableDecl Throwable cause) {
            super(message, expected, actual);
            this.message = message;
            this.cause = cause;
            try {
                this.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public final String getMessage() {
            return this.message;
        }

        public final Throwable getCause() {
            return this.cause;
        }

        public final String toString() {
            return this.getLocalizedMessage();
        }
    }
}

