/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.TableSubject;
import com.google.common.truth.ThrowableSubject;
import java.math.BigDecimal;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Truth {
    private static final FailureStrategy THROW_ASSERTION_ERROR = new FailureStrategy(){

        @Override
        public void fail(AssertionError failure) {
            throw failure;
        }
    };
    private static final StandardSubjectBuilder ASSERT = StandardSubjectBuilder.forCustomFailureStrategy(THROW_ASSERTION_ERROR);

    private Truth() {
    }

    public static StandardSubjectBuilder assert_() {
        return ASSERT;
    }

    public static StandardSubjectBuilder assertWithMessage(String messageToPrepend) {
        return Truth.assert_().withMessage(messageToPrepend);
    }

    public static StandardSubjectBuilder assertWithMessage(String format, Object ... args2) {
        return Truth.assert_().withMessage(format, args2);
    }

    public static <S extends Subject, T> SimpleSubjectBuilder<S, T> assertAbout(Subject.Factory<S, T> factory) {
        return Truth.assert_().about(factory);
    }

    public static <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT assertAbout(CustomSubjectBuilder.Factory<CustomSubjectBuilderT> factory) {
        return Truth.assert_().about(factory);
    }

    public static <T extends Comparable<?>> ComparableSubject<T> assertThat(@NullableDecl T actual) {
        return Truth.assert_().that(actual);
    }

    public static BigDecimalSubject assertThat(@NullableDecl BigDecimal actual) {
        return Truth.assert_().that(actual);
    }

    public static Subject assertThat(@NullableDecl Object actual) {
        return Truth.assert_().that(actual);
    }

    @GwtIncompatible(value="ClassSubject.java")
    public static ClassSubject assertThat(@NullableDecl Class<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static ThrowableSubject assertThat(@NullableDecl Throwable actual) {
        return Truth.assert_().that(actual);
    }

    public static LongSubject assertThat(@NullableDecl Long actual) {
        return Truth.assert_().that(actual);
    }

    public static DoubleSubject assertThat(@NullableDecl Double actual) {
        return Truth.assert_().that(actual);
    }

    public static FloatSubject assertThat(@NullableDecl Float actual) {
        return Truth.assert_().that(actual);
    }

    public static IntegerSubject assertThat(@NullableDecl Integer actual) {
        return Truth.assert_().that(actual);
    }

    public static BooleanSubject assertThat(@NullableDecl Boolean actual) {
        return Truth.assert_().that(actual);
    }

    public static StringSubject assertThat(@NullableDecl String actual) {
        return Truth.assert_().that(actual);
    }

    public static IterableSubject assertThat(@NullableDecl Iterable<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static <T> ObjectArraySubject<T> assertThat(@NullableDecl T[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveBooleanArraySubject assertThat(@NullableDecl boolean[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveShortArraySubject assertThat(@NullableDecl short[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveIntArraySubject assertThat(@NullableDecl int[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveLongArraySubject assertThat(@NullableDecl long[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveByteArraySubject assertThat(@NullableDecl byte[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveCharArraySubject assertThat(@NullableDecl char[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveFloatArraySubject assertThat(@NullableDecl float[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveDoubleArraySubject assertThat(@NullableDecl double[] actual) {
        return Truth.assert_().that(actual);
    }

    public static GuavaOptionalSubject assertThat(@NullableDecl Optional<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MapSubject assertThat(@NullableDecl Map<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MultimapSubject assertThat(@NullableDecl Multimap<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MultisetSubject assertThat(@NullableDecl Multiset<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static TableSubject assertThat(@NullableDecl Table<?, ?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    static final class SimpleAssertionError
    extends AssertionError {
        @NullableDecl
        private final Throwable cause;

        private SimpleAssertionError(String message, @NullableDecl Throwable cause) {
            super((Object)Preconditions.checkNotNull(message));
            this.cause = cause;
            try {
                this.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        static SimpleAssertionError create(String message, @NullableDecl Throwable cause) {
            return new SimpleAssertionError(message, cause);
        }

        static SimpleAssertionError createWithNoStack(String message, @NullableDecl Throwable cause) {
            SimpleAssertionError error = SimpleAssertionError.create(message, cause);
            error.setStackTrace(new StackTraceElement[0]);
            return error;
        }

        static SimpleAssertionError createWithNoStack(String message) {
            return SimpleAssertionError.createWithNoStack(message, null);
        }

        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return this.getLocalizedMessage();
        }
    }
}

