/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Fact;
import com.google.common.truth.Platform;
import com.google.common.truth.SubjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ComparisonFailures {
    private static final int CONTEXT = 20;
    private static final int WORTH_HIDING = 60;

    static ImmutableList<Fact> makeComparisonFailureFacts(ImmutableList<Fact> headFacts, ImmutableList<Fact> tailFacts, String expected, String actual) {
        return SubjectUtils.concat(headFacts, ComparisonFailures.formatExpectedAndActual(expected, actual), tailFacts);
    }

    @VisibleForTesting
    static ImmutableList<Fact> formatExpectedAndActual(String expected, String actual) {
        ImmutableList<Fact> result2 = Platform.makeDiff(expected, actual);
        if (result2 != null) {
            return result2;
        }
        result2 = ComparisonFailures.removeCommonPrefixAndSuffix(expected, actual);
        if (result2 != null) {
            return result2;
        }
        return ImmutableList.of(Fact.fact("expected", expected), Fact.fact("but was", actual));
    }

    @Nullable
    private static ImmutableList<Fact> removeCommonPrefixAndSuffix(String expected, String actual) {
        int originalExpectedLength = expected.length();
        int prefix = Strings.commonPrefix(expected, actual).length();
        for (prefix = Math.max(0, prefix - 20); prefix > 0 && ComparisonFailures.validSurrogatePairAt(expected, prefix - 1); --prefix) {
        }
        if (prefix > 3) {
            String string = String.valueOf(expected.substring(prefix));
            expected = string.length() != 0 ? "\u2026".concat(string) : new String("\u2026");
            String string2 = String.valueOf(actual.substring(prefix));
            actual = string2.length() != 0 ? "\u2026".concat(string2) : new String("\u2026");
        }
        int suffix = Strings.commonSuffix(expected, actual).length();
        for (suffix = Math.max(0, suffix - 20); suffix > 0 && ComparisonFailures.validSurrogatePairAt(expected, expected.length() - suffix - 1); --suffix) {
        }
        if (suffix > 3) {
            expected = String.valueOf(expected.substring(0, expected.length() - suffix)).concat("\u2026");
            actual = String.valueOf(actual.substring(0, actual.length() - suffix)).concat("\u2026");
        }
        if (originalExpectedLength - expected.length() < 60) {
            return null;
        }
        return ImmutableList.of(Fact.fact("expected", expected), Fact.fact("but was", actual));
    }

    private static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    private ComparisonFailures() {
    }
}

