/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Fact
implements Serializable {
    final String key;
    @Nullable
    final String value;

    public static Fact fact(String key, @Nullable Object value) {
        return new Fact(key, String.valueOf(value));
    }

    public static Fact simpleFact(String key) {
        return new Fact(key, null);
    }

    private Fact(String key, @Nullable String value) {
        this.key = Preconditions.checkNotNull(key);
        this.value = value;
    }

    public String toString() {
        String string;
        if (this.value == null) {
            string = this.key;
        } else {
            String string2 = this.key;
            String string3 = this.value;
            string = new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(": ").append(string3).toString();
        }
        return string;
    }

    static String makeMessage(ImmutableList<String> messages, ImmutableList<Fact> facts) {
        int longestKeyLength = 0;
        boolean seenNewlineInValue = false;
        for (Fact fact : facts) {
            if (fact.value == null) continue;
            longestKeyLength = Math.max(longestKeyLength, fact.key.length());
            seenNewlineInValue |= fact.value.contains("\n");
        }
        StringBuilder builder = new StringBuilder();
        for (String message : messages) {
            builder.append(message);
            builder.append('\n');
        }
        for (Fact fact : facts) {
            if (fact.value == null) {
                builder.append(fact.key);
            } else if (seenNewlineInValue) {
                builder.append(fact.key);
                builder.append(":\n");
                builder.append(Fact.indent(fact.value));
            } else {
                builder.append(Strings.padEnd(fact.key, longestKeyLength, ' '));
                builder.append(": ");
                builder.append(fact.value);
            }
            builder.append('\n');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static String indent(String value) {
        String string = String.valueOf(value.replaceAll("\n", "\n    "));
        return string.length() != 0 ? "    ".concat(string) : new String("    ");
    }
}

