/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

final class LazyMessage {
    private static final String PLACEHOLDER_ERR = "Incorrect number of args (%s) for the given placeholders (%s) in string template:\"%s\"";
    private final String format;
    private final Object[] args;

    LazyMessage(String format, Object ... args2) {
        this.format = format;
        this.args = args2;
        int placeholders = LazyMessage.countPlaceholders(format);
        Preconditions.checkArgument(placeholders == args2.length, PLACEHOLDER_ERR, (Object)args2.length, (Object)placeholders, (Object)format);
    }

    public String toString() {
        return Strings.lenientFormat(this.format, this.args);
    }

    @VisibleForTesting
    static int countPlaceholders(String template) {
        int index = 0;
        int count2 = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count2;
        }
        return count2;
    }

    static ImmutableList<String> evaluateAll(ImmutableList<LazyMessage> messages) {
        ImmutableList.Builder result2 = ImmutableList.builder();
        for (LazyMessage message : messages) {
            result2.add(message.toString());
        }
        return result2.build();
    }
}

