/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PrimitiveDoubleArraySubject
extends AbstractArraySubject {
    private final double[] actual;
    private static final Correspondence<Double, Number> EXACT_EQUALITY_CORRESPONDENCE = Correspondence.from(new Correspondence.BinaryPredicate<Double, Number>(){

        @Override
        public boolean apply(Double actual, Number expected) {
            return Double.doubleToLongBits(actual) == Double.doubleToLongBits(PrimitiveDoubleArraySubject.checkedToDouble(expected));
        }
    }, "is exactly equal to");

    PrimitiveDoubleArraySubject(FailureMetadata metadata2, double[] o, @Nullable String typeDescription) {
        super(metadata2, o, typeDescription);
        this.actual = o;
    }

    @Override
    public void isEqualTo(Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isNotEqualTo(Object expected) {
        super.isNotEqualTo(expected);
    }

    public DoubleArrayAsIterable usingTolerance(double tolerance) {
        return new DoubleArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static double checkedToDouble(Number expected) {
        Preconditions.checkNotNull(expected);
        Preconditions.checkArgument(expected instanceof Double || expected instanceof Float || expected instanceof Integer || expected instanceof Long, "Expected value in assertion using exact double equality was of unsupported type %s (it may not have an exact double representation)", expected.getClass());
        if (expected instanceof Long) {
            Preconditions.checkArgument(Math.abs((Long)expected) <= 0x20000000000000L, "Expected value %s in assertion using exact double equality was a long with an absolute value greater than 2^52 which has no exact double representation", (Object)expected);
        }
        return expected.doubleValue();
    }

    public DoubleArrayAsIterable usingExactEquality() {
        return new DoubleArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.checkNoNeedToDisplayBothValues("asList()", new Object[0]).about(this.iterablesWithCustomDoubleToString()).that(Doubles.asList(this.actual));
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterablesWithCustomDoubleToString() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata2, Iterable<?> actual) {
                return new IterableSubjectWithInheritedToString(metadata2, actual);
            }
        };
    }

    private final class IterableSubjectWithInheritedToString
    extends IterableSubject {
        IterableSubjectWithInheritedToString(FailureMetadata metadata2, Iterable<?> actual) {
            super(metadata2, actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return PrimitiveDoubleArraySubject.this.actualCustomStringRepresentationForPackageMembersToCall();
        }
    }

    public static final class DoubleArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Double, Number> {
        DoubleArrayAsIterable(Correspondence<? super Double, Number> correspondence, IterableSubject subject) {
            super(subject, correspondence);
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(double[] expected) {
            return this.containsAtLeastElementsIn(Doubles.asList(expected));
        }

        public void containsAnyOf(double[] expected) {
            this.containsAnyIn(Doubles.asList(expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(double[] expected) {
            return this.containsExactlyElementsIn(Doubles.asList(expected));
        }

        public void containsNoneOf(double[] excluded) {
            this.containsNoneIn(Doubles.asList(excluded));
        }
    }
}

