/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StandardSubjectBuilder;
import org.junit.internal.AssumptionViolatedException;

@GwtIncompatible(value="JUnit4")
public final class TruthJUnit {
    private static final FailureStrategy THROW_ASSUMPTION_ERROR = new FailureStrategy(){

        @Override
        public void fail(AssertionError failure2) {
            ThrowableAssumptionViolatedException assumptionViolated = new ThrowableAssumptionViolatedException(((Throwable)((Object)failure2)).getMessage(), ((Throwable)((Object)failure2)).getCause());
            assumptionViolated.setStackTrace(((Throwable)((Object)failure2)).getStackTrace());
            throw assumptionViolated;
        }
    };
    private static final StandardSubjectBuilder ASSUME = StandardSubjectBuilder.forCustomFailureStrategy(THROW_ASSUMPTION_ERROR);

    public static final StandardSubjectBuilder assume() {
        return ASSUME;
    }

    private TruthJUnit() {
    }

    private static class ThrowableAssumptionViolatedException
    extends AssumptionViolatedException {
        public ThrowableAssumptionViolatedException(String message, Throwable throwable) {
            super(message);
            if (throwable != null) {
                this.initCause(throwable);
            }
        }
    }
}

