/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.kotlin.AbstractCoroutineServerImpl;
import io.grpc.kotlin.ServerCalls;
import io.grpc.kotlin.generator.ServiceCodeGenerator;
import io.grpc.kotlin.generator.protoc.ClassSimpleName;
import io.grpc.kotlin.generator.protoc.ClassSimpleNameKt;
import io.grpc.kotlin.generator.protoc.Declarations;
import io.grpc.kotlin.generator.protoc.GeneratorConfig;
import io.grpc.kotlin.generator.protoc.MemberSimpleName;
import io.grpc.kotlin.generator.protoc.MemberSimpleNameKt;
import io.grpc.kotlin.generator.protoc.ProtoMethodNameKt;
import io.grpc.kotlin.generator.protoc.ProtoServiceNameKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lio/grpc/kotlin/generator/GrpcCoroutineServerGenerator;", "Lio/grpc/kotlin/generator/ServiceCodeGenerator;", "config", "Lio/grpc/kotlin/generator/protoc/GeneratorConfig;", "(Lio/grpc/kotlin/generator/protoc/GeneratorConfig;)V", "generate", "Lio/grpc/kotlin/generator/protoc/Declarations;", "service", "Lcom/google/protobuf/Descriptors$ServiceDescriptor;", "implClass", "Lcom/squareup/kotlinpoet/TypeSpec;", "serviceMethodStub", "Lio/grpc/kotlin/generator/GrpcCoroutineServerGenerator$MethodImplStub;", "method", "Lcom/google/protobuf/Descriptors$MethodDescriptor;", "stubKDoc", "Lcom/squareup/kotlinpoet/CodeBlock;", "requestParam", "Lcom/squareup/kotlinpoet/ParameterSpec;", "Companion", "MethodImplStub", "compiler"})
public final class GrpcCoroutineServerGenerator
extends ServiceCodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String IMPL_BASE_SUFFIX = "CoroutineImplBase";
    @NotNull
    private static final ClassName FLOW = ClassNames.get(Reflection.getOrCreateKotlinClass(Flow.class));
    @NotNull
    private static final MemberSimpleName UNARY_REQUEST_NAME = new MemberSimpleName("request");
    @NotNull
    private static final MemberSimpleName STREAMING_REQUEST_NAME = new MemberSimpleName("requests");
    @NotNull
    private static final ParameterSpec coroutineContextParameter;
    @NotNull
    private static final MemberName SERVER_SERVICE_DEFINITION_BUILDER_FACTORY;
    @NotNull
    private static final MemberName UNARY_SMD;
    @NotNull
    private static final MemberName CLIENT_STREAMING_SMD;
    @NotNull
    private static final MemberName SERVER_STREAMING_SMD;
    @NotNull
    private static final MemberName BIDI_STREAMING_SMD;
    @NotNull
    private static final MemberName UNIMPLEMENTED_STATUS;

    public GrpcCoroutineServerGenerator(@NotNull GeneratorConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config);
    }

    @Override
    @NotNull
    public Declarations generate(@NotNull Descriptors.ServiceDescriptor service) {
        Declarations.Builder builder;
        Intrinsics.checkNotNullParameter(service, "service");
        boolean $i$f$declarations = false;
        Declarations.Builder $this$generate_u24lambda_u2d0 = builder = new Declarations.Builder();
        boolean bl = false;
        $this$generate_u24lambda_u2d0.addType(this.implClass(service));
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeSpec implClass(@NotNull Descriptors.ServiceDescriptor service) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(service, "service");
        ClassSimpleName serviceImplClassName = ProtoServiceNameKt.getServiceName(service).toClassSimpleName().withSuffix(IMPL_BASE_SUFFIX);
        List<Descriptors.MethodDescriptor> list = service.getMethods();
        Intrinsics.checkNotNullExpressionValue(list, "service.methods");
        Object[] $this$map$iv = (Object[])list;
        boolean $i$f$map22 = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Descriptors.MethodDescriptor methodDescriptor = (Descriptors.MethodDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection.add(this.serviceMethodStub((Descriptors.MethodDescriptor)it));
        }
        List stubs = (List)destination$iv$iv;
        Object[] $i$f$map22 = new KModifier[]{KModifier.ABSTRACT};
        TypeSpec.Builder builder = ClassSimpleNameKt.classBuilder(TypeSpec.Companion, serviceImplClassName).addModifiers((KModifier[])$i$f$map22);
        $i$f$map22 = new Object[1];
        Intrinsics.checkNotNullExpressionValue(service.getFullName(), "service.fullName");
        TypeSpec.Builder builder2 = builder.addKdoc("Skeletal implementation of the %L service based on Kotlin coroutines.", $i$f$map22).primaryConstructor(FunSpec.Companion.constructorBuilder().addParameter(coroutineContextParameter).build()).superclass(Reflection.getOrCreateKotlinClass(AbstractCoroutineServerImpl.class));
        $i$f$map22 = new Object[]{coroutineContextParameter};
        TypeSpec.Builder implBuilder = builder2.addSuperclassConstructorParameter("%N", $i$f$map22);
        object = new Object[]{SERVER_SERVICE_DEFINITION_BUILDER_FACTORY, this.getGrpcDescriptor(service)};
        CodeBlock serverServiceDefinitionBuilder = CodeBlock.Companion.of("%M(%M())", (Object[])object);
        for (MethodImplStub stub : stubs) {
            implBuilder.addFunction(stub.getMethodSpec());
            Object[] objectArray = new Object[]{serverServiceDefinitionBuilder, stub.getServerMethodDef()};
            serverServiceDefinitionBuilder = CodeBlock.Companion.of("%L\n  .addMethod(%L)", objectArray);
        }
        object = new KModifier[]{KModifier.OVERRIDE, KModifier.FINAL};
        FunSpec.Builder builder3 = FunSpec.Builder.returns$default(FunSpec.Companion.builder("bindService").addModifiers((KModifier[])object), Reflection.getOrCreateKotlinClass(ServerServiceDefinition.class), null, 2, null);
        object = new Object[]{serverServiceDefinitionBuilder};
        implBuilder.addFunction(builder3.addStatement("return %L.build()", (Object[])object).build());
        return implBuilder.build();
    }

    @VisibleForTesting
    @NotNull
    public final MethodImplStub serviceMethodStub(@NotNull Descriptors.MethodDescriptor method) {
        Object[] objectArray;
        ParameterSpec parameterSpec;
        Intrinsics.checkNotNullParameter(method, "method");
        GeneratorConfig $this$serviceMethodStub_u24lambda_u2d2 = this.getConfig();
        boolean bl = false;
        Descriptors.Descriptor descriptor2 = method.getInputType();
        Intrinsics.checkNotNullExpressionValue(descriptor2, "method.inputType");
        ClassName requestType = $this$serviceMethodStub_u24lambda_u2d2.messageClass(descriptor2);
        if (method.isClientStreaming()) {
            TypeName[] typeNameArray = new TypeName[]{requestType};
            parameterSpec = MemberSimpleNameKt.of(ParameterSpec.Companion, STREAMING_REQUEST_NAME, (TypeName)ParameterizedTypeName.Companion.get(FLOW, typeNameArray), new KModifier[0]);
        } else {
            parameterSpec = MemberSimpleNameKt.of(ParameterSpec.Companion, UNARY_REQUEST_NAME, (TypeName)requestType, new KModifier[0]);
        }
        ParameterSpec requestParam = parameterSpec;
        Object[] objectArray2 = new KModifier[]{KModifier.OPEN};
        FunSpec.Builder builder = MemberSimpleNameKt.builder(FunSpec.Companion, ProtoMethodNameKt.getMethodName(method).toMemberSimpleName()).addModifiers((KModifier[])objectArray2).addParameter(requestParam);
        objectArray2 = new Object[]{Reflection.getOrCreateKotlinClass(StatusException.class), UNIMPLEMENTED_STATUS, "Method " + method.getFullName() + " is unimplemented"};
        FunSpec.Builder methodSpecBuilder = builder.addStatement("throw %T(%M.withDescription(%S))", objectArray2);
        if (method.getOptions().getDeprecated()) {
            objectArray2 = new Object[]{"The underlying service method is marked deprecated."};
            methodSpecBuilder.addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Deprecated.class)).addMember("%S", objectArray2).build());
        }
        Descriptors.Descriptor descriptor3 = method.getOutputType();
        Intrinsics.checkNotNullExpressionValue(descriptor3, "method.outputType");
        ClassName responseType = $this$serviceMethodStub_u24lambda_u2d2.messageClass(descriptor3);
        if (method.isServerStreaming()) {
            objectArray = new TypeName[]{responseType};
            FunSpec.Builder.returns$default(methodSpecBuilder, ParameterizedTypeName.Companion.get(FLOW, (TypeName[])objectArray), null, 2, null);
        } else {
            FunSpec.Builder.returns$default(methodSpecBuilder, responseType, null, 2, null);
            objectArray = new KModifier[]{KModifier.SUSPEND};
            methodSpecBuilder.addModifiers((KModifier[])objectArray);
        }
        methodSpecBuilder.addKdoc(this.stubKDoc(method, requestParam));
        FunSpec methodSpec = methodSpecBuilder.build();
        MemberName smdFactory = method.isServerStreaming() ? (method.isClientStreaming() ? BIDI_STREAMING_SMD : SERVER_STREAMING_SMD) : (method.isClientStreaming() ? CLIENT_STREAMING_SMD : UNARY_SMD);
        Object[] objectArray3 = new Object[]{smdFactory, this.getDescriptorCode(method), methodSpec};
        CodeBlock serverMethodDef = CodeBlock.Companion.of("%M(\n  context = this.context,\n  descriptor = %L,\n  implementation = ::%N\n)", objectArray3);
        return new MethodImplStub(methodSpec, serverMethodDef);
    }

    private final CodeBlock stubKDoc(Descriptors.MethodDescriptor method, ParameterSpec requestParam) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("requestParam", requestParam), TuplesKt.to("methodName", method.getFullName()), TuplesKt.to("flow", FLOW), TuplesKt.to("status", Reflection.getOrCreateKotlinClass(Status.class)), TuplesKt.to("statusException", Reflection.getOrCreateKotlinClass(StatusException.class)), TuplesKt.to("cancellationException", Reflection.getOrCreateKotlinClass(CancellationException.class)), TuplesKt.to("illegalStateException", Reflection.getOrCreateKotlinClass(IllegalStateException.class))};
        Map kDocBindings = MapsKt.mapOf(pairArray);
        List kDocSections = new ArrayList();
        if (method.isServerStreaming()) {
            kDocSections.add("Returns a [%flow:T] of responses to an RPC for %methodName:L.");
            kDocSections.add("If creating or collecting the returned flow fails with a [%statusException:T], the RPC\nwill fail with the corresponding [%status:T].  If it fails with a\n[%cancellationException:T], the RPC will fail with status `Status.CANCELLED`.  If creating\nor collecting the returned flow fails for any other reason, the RPC will fail with\n`Status.UNKNOWN` with the exception as a cause.");
        } else {
            kDocSections.add("Returns the response to an RPC for %methodName:L.");
            kDocSections.add("If this method fails with a [%statusException:T], the RPC will fail with the corresponding\n[%status:T].  If this method fails with a [%cancellationException:T], the RPC will fail\nwith status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will\nfail with `Status.UNKNOWN` with the exception as a cause.");
        }
        if (method.isClientStreaming()) {
            kDocSections.add("@param %requestParam:N A [%flow:T] of requests from the client.  This flow can be\n       collected only once and throws [%illegalStateException:T] on attempts to collect\n       it more than once.");
        } else {
            kDocSections.add("@param %requestParam:N The request from the client.");
        }
        return CodeBlock.Companion.builder().addNamed(CollectionsKt.joinToString$default(kDocSections, "\n\n", null, null, 0, null, null, 62, null), kDocBindings).build();
    }

    static {
        Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(EmptyCoroutineContext.class)};
        coroutineContextParameter = ParameterSpec.Companion.builder("coroutineContext", Reflection.getOrCreateKotlinClass(CoroutineContext.class), new KModifier[0]).defaultValue("%T", objectArray).build();
        SERVER_SERVICE_DEFINITION_BUILDER_FACTORY = MemberName.Companion.get(Reflection.getOrCreateKotlinClass(ServerServiceDefinition.class), "builder");
        UNARY_SMD = MemberName.Companion.get(Reflection.getOrCreateKotlinClass(ServerCalls.class), "unaryServerMethodDefinition");
        CLIENT_STREAMING_SMD = MemberName.Companion.get(Reflection.getOrCreateKotlinClass(ServerCalls.class), "clientStreamingServerMethodDefinition");
        SERVER_STREAMING_SMD = MemberName.Companion.get(Reflection.getOrCreateKotlinClass(ServerCalls.class), "serverStreamingServerMethodDefinition");
        BIDI_STREAMING_SMD = MemberName.Companion.get(Reflection.getOrCreateKotlinClass(ServerCalls.class), "bidiStreamingServerMethodDefinition");
        UNIMPLEMENTED_STATUS = MemberName.Companion.get(Reflection.getOrCreateKotlinClass(Status.class), "UNIMPLEMENTED");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/grpc/kotlin/generator/GrpcCoroutineServerGenerator$Companion;", "", "()V", "BIDI_STREAMING_SMD", "Lcom/squareup/kotlinpoet/MemberName;", "CLIENT_STREAMING_SMD", "FLOW", "Lcom/squareup/kotlinpoet/ClassName;", "IMPL_BASE_SUFFIX", "", "SERVER_SERVICE_DEFINITION_BUILDER_FACTORY", "SERVER_STREAMING_SMD", "STREAMING_REQUEST_NAME", "Lio/grpc/kotlin/generator/protoc/MemberSimpleName;", "UNARY_REQUEST_NAME", "UNARY_SMD", "UNIMPLEMENTED_STATUS", "coroutineContextParameter", "Lcom/squareup/kotlinpoet/ParameterSpec;", "compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/grpc/kotlin/generator/GrpcCoroutineServerGenerator$MethodImplStub;", "", "methodSpec", "Lcom/squareup/kotlinpoet/FunSpec;", "serverMethodDef", "Lcom/squareup/kotlinpoet/CodeBlock;", "(Lcom/squareup/kotlinpoet/FunSpec;Lcom/squareup/kotlinpoet/CodeBlock;)V", "getMethodSpec", "()Lcom/squareup/kotlinpoet/FunSpec;", "getServerMethodDef", "()Lcom/squareup/kotlinpoet/CodeBlock;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "compiler"})
    public static final class MethodImplStub {
        @NotNull
        private final FunSpec methodSpec;
        @NotNull
        private final CodeBlock serverMethodDef;

        public MethodImplStub(@NotNull FunSpec methodSpec, @NotNull CodeBlock serverMethodDef) {
            Intrinsics.checkNotNullParameter(methodSpec, "methodSpec");
            Intrinsics.checkNotNullParameter(serverMethodDef, "serverMethodDef");
            this.methodSpec = methodSpec;
            this.serverMethodDef = serverMethodDef;
        }

        @NotNull
        public final FunSpec getMethodSpec() {
            return this.methodSpec;
        }

        @NotNull
        public final CodeBlock getServerMethodDef() {
            return this.serverMethodDef;
        }

        @NotNull
        public final FunSpec component1() {
            return this.methodSpec;
        }

        @NotNull
        public final CodeBlock component2() {
            return this.serverMethodDef;
        }

        @NotNull
        public final MethodImplStub copy(@NotNull FunSpec methodSpec, @NotNull CodeBlock serverMethodDef) {
            Intrinsics.checkNotNullParameter(methodSpec, "methodSpec");
            Intrinsics.checkNotNullParameter(serverMethodDef, "serverMethodDef");
            return new MethodImplStub(methodSpec, serverMethodDef);
        }

        public static /* synthetic */ MethodImplStub copy$default(MethodImplStub methodImplStub, FunSpec funSpec, CodeBlock codeBlock, int n, Object object) {
            if ((n & 1) != 0) {
                funSpec = methodImplStub.methodSpec;
            }
            if ((n & 2) != 0) {
                codeBlock = methodImplStub.serverMethodDef;
            }
            return methodImplStub.copy(funSpec, codeBlock);
        }

        @NotNull
        public String toString() {
            return "MethodImplStub(methodSpec=" + this.methodSpec + ", serverMethodDef=" + this.serverMethodDef + ')';
        }

        public int hashCode() {
            int result2 = this.methodSpec.hashCode();
            result2 = result2 * 31 + this.serverMethodDef.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodImplStub)) {
                return false;
            }
            MethodImplStub methodImplStub = (MethodImplStub)other;
            if (!Intrinsics.areEqual(this.methodSpec, methodImplStub.methodSpec)) {
                return false;
            }
            return Intrinsics.areEqual(this.serverMethodDef, methodImplStub.serverMethodDef);
        }
    }
}

