/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BigDecimalSubject
extends ComparableSubject<BigDecimal> {
    private final @Nullable BigDecimal actual;

    BigDecimalSubject(FailureMetadata metadata2, @Nullable BigDecimal actual) {
        super(metadata2, actual);
        this.actual = actual;
    }

    public void isEqualToIgnoringScale(BigDecimal expected) {
        this.compareValues(expected);
    }

    public void isEqualToIgnoringScale(String expected) {
        this.compareValues(new BigDecimal(expected));
    }

    public void isEqualToIgnoringScale(long expected) {
        this.compareValues(new BigDecimal(expected));
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isEquivalentAccordingToCompareTo(@Nullable BigDecimal expected) {
        this.compareValues(expected);
    }

    private void compareValues(@Nullable BigDecimal expected) {
        if (Preconditions.checkNotNull(this.actual).compareTo(Preconditions.checkNotNull(expected)) != 0) {
            this.failWithoutActual(Fact.fact("expected", expected), this.butWas(), Fact.simpleFact("(scale is ignored)"));
        }
    }
}

