/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BooleanSubject
extends Subject {
    private final @Nullable Boolean actual;

    BooleanSubject(FailureMetadata metadata2, @Nullable Boolean actual) {
        super(metadata2, actual);
        this.actual = actual;
    }

    public void isTrue() {
        if (this.actual == null) {
            this.isEqualTo(true);
        } else if (!this.actual.booleanValue()) {
            this.failWithoutActual(Fact.simpleFact("expected to be true"), new Fact[0]);
        }
    }

    public void isFalse() {
        if (this.actual == null) {
            this.isEqualTo(false);
        } else if (this.actual.booleanValue()) {
            this.failWithoutActual(Fact.simpleFact("expected to be false"), new Fact[0]);
        }
    }
}

