/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.AssertionErrorWithFacts;
import com.google.common.truth.ComparisonFailures;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.LazyMessage;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FailureMetadata {
    private final FailureStrategy strategy;
    private final ImmutableList<LazyMessage> messages;
    private final ImmutableList<Step> steps;

    static FailureMetadata forFailureStrategy(FailureStrategy failureStrategy) {
        return new FailureMetadata(failureStrategy, ImmutableList.of(), ImmutableList.of());
    }

    FailureMetadata(FailureStrategy strategy, ImmutableList<LazyMessage> messages, ImmutableList<Step> steps) {
        this.strategy = Preconditions.checkNotNull(strategy);
        this.messages = Preconditions.checkNotNull(messages);
        this.steps = Preconditions.checkNotNull(steps);
    }

    FailureMetadata updateForSubject(Subject subject) {
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.subjectCreation(subject));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall() {
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(null, null));
        return this.derive(this.messages, steps);
    }

    FailureMetadata updateForCheckCall(OldAndNewValuesAreSimilar valuesAreSimilar, Function<String, String> descriptionUpdate) {
        Preconditions.checkNotNull(descriptionUpdate);
        ImmutableList<Step> steps = SubjectUtils.append(this.steps, Step.checkCall(valuesAreSimilar, descriptionUpdate));
        return this.derive(this.messages, steps);
    }

    FailureMetadata withMessage(String format, @Nullable Object[] args2) {
        ImmutableList<LazyMessage> messages = SubjectUtils.append(this.messages, new LazyMessage(format, args2));
        return this.derive(messages, this.steps);
    }

    void failEqualityCheck(ImmutableList<Fact> tailFacts, String expected, String actual) {
        this.doFail(Platform.makeComparisonFailure(LazyMessage.evaluateAll(this.messages), ComparisonFailures.makeComparisonFailureFacts(this.description(), SubjectUtils.concat(tailFacts, this.rootUnlessThrowable()), expected, actual), expected, actual, this.rootCause()));
    }

    void fail(ImmutableList<Fact> facts) {
        this.doFail(new AssertionErrorWithFacts(LazyMessage.evaluateAll(this.messages), SubjectUtils.concat(this.description(), facts, this.rootUnlessThrowable()), this.rootCause()));
    }

    private void doFail(AssertionError failure2) {
        Platform.cleanStackTrace((Throwable)((Object)failure2));
        this.strategy.fail(failure2);
    }

    private FailureMetadata derive(ImmutableList<LazyMessage> messages, ImmutableList<Step> steps) {
        return new FailureMetadata(this.strategy, messages, steps);
    }

    private ImmutableList<Fact> description() {
        String description2 = Platform.inferDescription();
        boolean descriptionIsInteresting = description2 != null;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                Preconditions.checkState(description2 != null);
                if (step.descriptionUpdate == null) {
                    description2 = null;
                    descriptionIsInteresting = false;
                    continue;
                }
                description2 = Verify.verifyNotNull(step.descriptionUpdate.apply(description2));
                descriptionIsInteresting = true;
                continue;
            }
            if (description2 != null) continue;
            description2 = Preconditions.checkNotNull(step.subject).typeDescription();
        }
        return descriptionIsInteresting ? ImmutableList.of(Fact.fact("value of", description2)) : ImmutableList.of();
    }

    private ImmutableList<Fact> rootUnlessThrowable() {
        Step rootSubject = null;
        boolean seenDerivation = false;
        for (Step step : this.steps) {
            if (step.isCheckCall()) {
                seenDerivation |= step.descriptionUpdate != null && step.valuesAreSimilar == OldAndNewValuesAreSimilar.DIFFERENT;
                continue;
            }
            if (rootSubject != null) continue;
            if (Preconditions.checkNotNull(step.subject).actual() instanceof Throwable) {
                return ImmutableList.of();
            }
            rootSubject = step;
        }
        return seenDerivation ? ImmutableList.of(Fact.fact(Preconditions.checkNotNull(((Step)Preconditions.checkNotNull(rootSubject)).subject).typeDescription() + " was", Preconditions.checkNotNull(Preconditions.checkNotNull(rootSubject).subject).actualCustomStringRepresentationForPackageMembersToCall())) : ImmutableList.of();
    }

    private @Nullable Throwable rootCause() {
        for (Step step : this.steps) {
            if (step.isCheckCall() || !(Preconditions.checkNotNull(step.subject).actual() instanceof Throwable)) continue;
            return (Throwable)step.subject.actual();
        }
        return null;
    }

    static enum OldAndNewValuesAreSimilar {
        SIMILAR,
        DIFFERENT;

    }

    private static final class Step {
        final @Nullable Subject subject;
        final @Nullable Function<String, String> descriptionUpdate;
        final @Nullable OldAndNewValuesAreSimilar valuesAreSimilar;

        static Step subjectCreation(Subject subject) {
            return new Step(Preconditions.checkNotNull(subject), null, null);
        }

        static Step checkCall(@Nullable OldAndNewValuesAreSimilar valuesAreSimilar, @Nullable Function<String, String> descriptionUpdate) {
            return new Step(null, descriptionUpdate, valuesAreSimilar);
        }

        private Step(@Nullable Subject subject, @Nullable Function<String, String> descriptionUpdate, @Nullable OldAndNewValuesAreSimilar valuesAreSimilar) {
            this.subject = subject;
            this.descriptionUpdate = descriptionUpdate;
            this.valuesAreSimilar = valuesAreSimilar;
        }

        boolean isCheckCall() {
            return this.subject == null;
        }
    }
}

