/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Doubles;

final class MathUtil {
    private MathUtil() {
    }

    public static boolean equalWithinTolerance(double left, double right, double tolerance) {
        return Math.abs(left - right) <= Math.abs(tolerance);
    }

    public static boolean equalWithinTolerance(float left, float right, float tolerance) {
        return MathUtil.equalWithinTolerance((double)left, (double)right, (double)tolerance);
    }

    public static boolean notEqualWithinTolerance(double left, double right, double tolerance) {
        if (Doubles.isFinite(left) && Doubles.isFinite(right)) {
            return Math.abs(left - right) > Math.abs(tolerance);
        }
        return false;
    }

    public static boolean notEqualWithinTolerance(float left, float right, float tolerance) {
        return MathUtil.notEqualWithinTolerance((double)left, (double)right, (double)tolerance);
    }
}

