/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.AssertionErrorWithFacts;
import com.google.common.truth.DiffUtils;
import com.google.common.truth.Fact;
import com.google.common.truth.StackTraceCleaner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.ComparisonFailure;
import org.junit.rules.TestRule;

final class Platform {
    private static final String DIFF_KEY = "diff (-expected +actual)";
    static final String EXPECT_FAILURE_WARNING_IF_GWT = "";
    private static final Supplier<@Nullable Class<?>> closedRangeClassIfAvailable = Suppliers.memoize(() -> {
        try {
            return Class.forName("kotlin.ranges.ClosedRange");
        }
        catch (ClassNotFoundException notAvailable) {
            return null;
        }
    });
    private static final Supplier<Method> closedRangeContainsMethod = Suppliers.memoize(() -> {
        try {
            return Preconditions.checkNotNull(closedRangeClassIfAvailable.get()).getMethod("contains", Comparable.class);
        }
        catch (NoSuchMethodException e) {
            throw Platform.newLinkageError(e);
        }
    });

    private Platform() {
    }

    static boolean isInstanceOfType(Object instance, Class<?> clazz) {
        return clazz.isInstance(instance);
    }

    static boolean containsMatch(String actual, String regex) {
        return Pattern.compile(regex).matcher(actual).find();
    }

    static Throwable[] getSuppressed(Throwable throwable) {
        try {
            Method getSuppressed = throwable.getClass().getMethod("getSuppressed", new Class[0]);
            return (Throwable[])Preconditions.checkNotNull(getSuppressed.invoke((Object)throwable, new Object[0]));
        }
        catch (NoSuchMethodException e) {
            return new Throwable[0];
        }
        catch (IllegalAccessException e) {
            throw Platform.newLinkageError(e);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked(e.getCause());
            throw Platform.newLinkageError(e);
        }
    }

    static void cleanStackTrace(Throwable throwable) {
        StackTraceCleaner.cleanStackTrace(throwable);
    }

    static @Nullable String inferDescription() {
        if (Platform.isInferDescriptionDisabled()) {
            return null;
        }
        AssertionError stack = new AssertionError();
        Platform.cleanStackTrace((Throwable)((Object)stack));
        if (((Throwable)((Object)stack)).getStackTrace().length == 0) {
            return null;
        }
        StackTraceElement top = ((Throwable)((Object)stack)).getStackTrace()[0];
        try {
            String clazz = Joiner.on('.').join("com", "google", "common", "truth", "ActualValueInference");
            return (String)Class.forName(clazz).getDeclaredMethod("describeActualValue", String.class, String.class, Integer.TYPE).invoke(null, top.getClassName(), top.getMethodName(), top.getLineNumber());
        }
        catch (ClassNotFoundException | IllegalAccessException | LinkageError | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            return null;
        }
    }

    static @Nullable ImmutableList<Fact> makeDiff(String expected, String actual) {
        ImmutableList<String> actualLines;
        ImmutableList<String> expectedLines = Platform.splitLines(expected);
        List<String> unifiedDiff = DiffUtils.generateUnifiedDiff(expectedLines, actualLines = Platform.splitLines(actual), 3);
        if (unifiedDiff.isEmpty()) {
            return ImmutableList.of(Fact.fact(DIFF_KEY, "(line contents match, but line-break characters differ)"));
        }
        String result2 = Joiner.on("\n").join(unifiedDiff);
        if (result2.length() > expected.length() && result2.length() > actual.length()) {
            return null;
        }
        return ImmutableList.of(Fact.fact(DIFF_KEY, result2));
    }

    private static ImmutableList<String> splitLines(String s2) {
        return ImmutableList.copyOf(Splitter.onPattern("\r?\n").split(s2));
    }

    static String doubleToString(double value) {
        return Double.toString(value);
    }

    static String floatToString(float value) {
        return Float.toString(value);
    }

    static String stringValueOfNonFloatingPoint(@Nullable Object o) {
        return String.valueOf(o);
    }

    static String getStackTraceAsString(Throwable throwable) {
        return Throwables.getStackTraceAsString(throwable);
    }

    static boolean isAndroid() {
        return Preconditions.checkNotNull(System.getProperty("java.runtime.name", EXPECT_FAILURE_WARNING_IF_GWT)).contains("Android");
    }

    private static boolean isInferDescriptionDisabled() {
        try {
            return Boolean.parseBoolean(System.getProperty("com.google.common.truth.disable_infer_description"));
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static AssertionError makeComparisonFailure(ImmutableList<String> messages, ImmutableList<Fact> facts, String expected, String actual, @Nullable Throwable cause) {
        Constructor<AssertionError> constructor;
        Class<?> comparisonFailureClass;
        try {
            comparisonFailureClass = Class.forName("com.google.common.truth.ComparisonFailureWithFacts");
        }
        catch (ClassNotFoundException | LinkageError probablyJunitNotOnClasspath) {
            return new AssertionErrorWithFacts(messages, facts, cause);
        }
        Class<AssertionError> asAssertionErrorSubclass = comparisonFailureClass.asSubclass(AssertionError.class);
        try {
            constructor = asAssertionErrorSubclass.getDeclaredConstructor(ImmutableList.class, ImmutableList.class, String.class, String.class, Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw Platform.newLinkageError(e);
        }
        try {
            return constructor.newInstance(messages, facts, expected, actual, cause);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked(e.getCause());
            throw Platform.newLinkageError(e);
        }
        catch (InstantiationException e) {
            throw Platform.newLinkageError(e);
        }
        catch (IllegalAccessException e) {
            throw Platform.newLinkageError(e);
        }
    }

    private static LinkageError newLinkageError(Throwable cause) {
        LinkageError error = new LinkageError(cause.toString());
        error.initCause(cause);
        return error;
    }

    static boolean isKotlinRange(Iterable<?> iterable) {
        return closedRangeClassIfAvailable.get() != null && closedRangeClassIfAvailable.get().isInstance(iterable);
    }

    static boolean kotlinRangeContains(Iterable<?> haystack, @Nullable Object needle) {
        try {
            return (Boolean)closedRangeContainsMethod.get().invoke(haystack, needle);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ClassCastException) {
                return false;
            }
            Throwables.throwIfUnchecked(e.getCause());
            throw Platform.newLinkageError(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw Platform.newLinkageError(e);
        }
    }

    static interface JUnitTestRule
    extends TestRule {
    }

    static abstract class PlatformComparisonFailure
    extends ComparisonFailure {
        private final String message;
        private final @Nullable Throwable cause;

        PlatformComparisonFailure(String message, String expected, String actual, @Nullable Throwable cause) {
            super(message, expected, actual);
            this.message = message;
            this.cause = cause;
            try {
                this.initCause(cause);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public final String getMessage() {
            return this.message;
        }

        public final @Nullable Throwable getCause() {
            return this.cause;
        }

        public final String toString() {
            return Preconditions.checkNotNull(this.getLocalizedMessage());
        }
    }
}

