/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Floats;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PrimitiveFloatArraySubject
extends AbstractArraySubject {
    private final float @Nullable [] actual;
    private static final Correspondence<Float, Number> EXACT_EQUALITY_CORRESPONDENCE = Correspondence.from(new Correspondence.BinaryPredicate<Float, Number>(){

        @Override
        public boolean apply(Float actual, Number expected) {
            return Float.floatToIntBits(actual.floatValue()) == Float.floatToIntBits(PrimitiveFloatArraySubject.checkedToFloat(expected));
        }
    }, "is exactly equal to");

    PrimitiveFloatArraySubject(FailureMetadata metadata2, float @Nullable [] o, @Nullable String typeDescription) {
        super(metadata2, o, typeDescription);
        this.actual = o;
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isNotEqualTo(@Nullable Object expected) {
        super.isNotEqualTo(expected);
    }

    public FloatArrayAsIterable usingTolerance(double tolerance) {
        return new FloatArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static float checkedToFloat(Number expected) {
        Preconditions.checkNotNull(expected);
        Preconditions.checkArgument(!(expected instanceof Double), "Expected value in assertion using exact float equality was a double, which is not supported as a double may not have an exact float representation");
        Preconditions.checkArgument(expected instanceof Float || expected instanceof Integer || expected instanceof Long, "Expected value in assertion using exact float equality was of unsupported type %s (it may not have an exact float representation)", expected.getClass());
        if (expected instanceof Integer) {
            Preconditions.checkArgument(Math.abs((Integer)expected) <= 0x1000000, "Expected value %s in assertion using exact float equality was an int with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        if (expected instanceof Long) {
            Preconditions.checkArgument(Math.abs((Long)expected) <= 0x1000000L, "Expected value %s in assertion using exact float equality was a long with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        return expected.floatValue();
    }

    public FloatArrayAsIterable usingExactEquality() {
        return new FloatArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.checkNoNeedToDisplayBothValues("asList()", new Object[0]).about(this.iterablesWithCustomFloatToString()).that(Floats.asList(Preconditions.checkNotNull(this.actual)));
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterablesWithCustomFloatToString() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata2, @Nullable Iterable<?> actual) {
                return new IterableSubjectWithInheritedToString(metadata2, actual);
            }
        };
    }

    private final class IterableSubjectWithInheritedToString
    extends IterableSubject {
        IterableSubjectWithInheritedToString(@Nullable FailureMetadata metadata2, Iterable<?> actual) {
            super(metadata2, actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return PrimitiveFloatArraySubject.this.actualCustomStringRepresentationForPackageMembersToCall();
        }
    }

    public static final class FloatArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Float, Number> {
        FloatArrayAsIterable(Correspondence<? super Float, Number> correspondence, IterableSubject subject) {
            super(subject, correspondence);
        }

        @CanIgnoreReturnValue
        public Ordered containsAtLeast(float[] expected) {
            return this.containsAtLeastElementsIn(Floats.asList(expected));
        }

        public void containsAnyOf(float[] expected) {
            this.containsAnyIn(Floats.asList(expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(float[] expected) {
            return this.containsExactlyElementsIn(Floats.asList(expected));
        }

        public void containsNoneOf(float[] excluded) {
            this.containsNoneIn(Floats.asList(excluded));
        }
    }
}

