/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.J2ktIncompatible;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.TableSubject;
import com.google.common.truth.ThrowableSubject;
import java.math.BigDecimal;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StandardSubjectBuilder {
    private final FailureMetadata metadataDoNotReferenceDirectly;

    public static StandardSubjectBuilder forCustomFailureStrategy(FailureStrategy failureStrategy) {
        return new StandardSubjectBuilder(FailureMetadata.forFailureStrategy(failureStrategy));
    }

    StandardSubjectBuilder(FailureMetadata metadata2) {
        this.metadataDoNotReferenceDirectly = Preconditions.checkNotNull(metadata2);
    }

    public final <ComparableT extends Comparable<?>> ComparableSubject<ComparableT> that(@Nullable ComparableT actual) {
        return new ComparableSubject<ComparableT>(this, this.metadata(), actual){};
    }

    public final BigDecimalSubject that(@Nullable BigDecimal actual) {
        return new BigDecimalSubject(this.metadata(), actual);
    }

    public final Subject that(@Nullable Object actual) {
        return new Subject(this.metadata(), actual);
    }

    @GwtIncompatible(value="ClassSubject.java")
    @J2ktIncompatible
    public final ClassSubject that(@Nullable Class<?> actual) {
        return new ClassSubject(this.metadata(), actual);
    }

    public final ThrowableSubject that(@Nullable Throwable actual) {
        return new ThrowableSubject(this.metadata(), actual, "throwable");
    }

    public final LongSubject that(@Nullable Long actual) {
        return new LongSubject(this.metadata(), actual);
    }

    public final DoubleSubject that(@Nullable Double actual) {
        return new DoubleSubject(this.metadata(), actual);
    }

    public final FloatSubject that(@Nullable Float actual) {
        return new FloatSubject(this.metadata(), actual);
    }

    public final IntegerSubject that(@Nullable Integer actual) {
        return new IntegerSubject(this.metadata(), actual);
    }

    public final BooleanSubject that(@Nullable Boolean actual) {
        return new BooleanSubject(this.metadata(), actual);
    }

    public final StringSubject that(@Nullable String actual) {
        return new StringSubject(this.metadata(), actual);
    }

    public final IterableSubject that(@Nullable Iterable<?> actual) {
        return new IterableSubject(this.metadata(), actual);
    }

    public final <T> ObjectArraySubject<T> that(@Nullable T @Nullable [] actual) {
        return new ObjectArraySubject<T>(this.metadata(), actual, "array");
    }

    public final PrimitiveBooleanArraySubject that(boolean @Nullable [] actual) {
        return new PrimitiveBooleanArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveShortArraySubject that(short @Nullable [] actual) {
        return new PrimitiveShortArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveIntArraySubject that(int @Nullable [] actual) {
        return new PrimitiveIntArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveLongArraySubject that(long @Nullable [] actual) {
        return new PrimitiveLongArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveCharArraySubject that(char @Nullable [] actual) {
        return new PrimitiveCharArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveByteArraySubject that(byte @Nullable [] actual) {
        return new PrimitiveByteArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveFloatArraySubject that(float @Nullable [] actual) {
        return new PrimitiveFloatArraySubject(this.metadata(), actual, "array");
    }

    public final PrimitiveDoubleArraySubject that(double @Nullable [] actual) {
        return new PrimitiveDoubleArraySubject(this.metadata(), actual, "array");
    }

    public final GuavaOptionalSubject that(@Nullable Optional<?> actual) {
        return new GuavaOptionalSubject(this.metadata(), actual, "optional");
    }

    public final MapSubject that(@Nullable Map<?, ?> actual) {
        return new MapSubject(this.metadata(), actual);
    }

    public final MultimapSubject that(@Nullable Multimap<?, ?> actual) {
        return new MultimapSubject(this.metadata(), actual, "multimap");
    }

    public final MultisetSubject that(@Nullable Multiset<?> actual) {
        return new MultisetSubject(this.metadata(), actual);
    }

    public final TableSubject that(@Nullable Table<?, ?, ?> actual) {
        return new TableSubject(this.metadata(), actual);
    }

    public final StandardSubjectBuilder withMessage(@Nullable String messageToPrepend) {
        return this.withMessage("%s", messageToPrepend);
    }

    public final StandardSubjectBuilder withMessage(String format, Object ... args2) {
        return new StandardSubjectBuilder(this.metadata().withMessage(format, args2));
    }

    public final <S extends Subject, A> SimpleSubjectBuilder<S, A> about(Subject.Factory<S, A> factory) {
        return new SimpleSubjectBuilder<S, A>(this.metadata(), factory);
    }

    public final <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT about(CustomSubjectBuilder.Factory<CustomSubjectBuilderT> factory) {
        return factory.createSubjectBuilder(this.metadata());
    }

    public final void fail() {
        this.metadata().fail(ImmutableList.of());
    }

    private FailureMetadata metadata() {
        this.checkStatePreconditions();
        return this.metadataDoNotReferenceDirectly;
    }

    void checkStatePreconditions() {
    }
}

