/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SubjectUtils {
    static final String HUMAN_UNDERSTANDABLE_EMPTY_STRING = "\"\" (empty String)";

    private SubjectUtils() {
    }

    static <T> List<T> accumulate(T first2, T second2, T ... rest) {
        ArrayList<T> items = new ArrayList<T>(2 + (rest == null ? 1 : rest.length));
        items.add(first2);
        items.add(second2);
        if (rest == null) {
            items.add(null);
        } else {
            items.addAll(Arrays.asList(rest));
        }
        return items;
    }

    static <T> int countOf(T t2, Iterable<T> items) {
        int count2 = 0;
        for (T item : items) {
            if (!(t2 == null ? item == null : t2.equals(item))) continue;
            ++count2;
        }
        return count2;
    }

    static String countDuplicates(Iterable<?> items) {
        return SubjectUtils.countDuplicatesToMultiset(items).toStringWithBrackets();
    }

    static String entryString(Multiset.Entry<?> entry) {
        int count2 = entry.getCount();
        String item = String.valueOf(entry.getElement());
        return count2 > 1 ? item + " [" + count2 + " copies]" : item;
    }

    private static <T> NonHashingMultiset<T> countDuplicatesToMultiset(Iterable<T> items) {
        NonHashingMultiset<T> multiset = new NonHashingMultiset<T>();
        for (T item : items) {
            multiset.add(item);
        }
        return multiset;
    }

    static String countDuplicatesAndAddTypeInfo(Iterable<?> itemsIterable) {
        Collection<?> items = SubjectUtils.iterableToCollection(itemsIterable);
        Optional<String> homogeneousTypeName = SubjectUtils.getHomogeneousTypeName(items);
        return homogeneousTypeName.isPresent() ? Strings.lenientFormat("%s (%s)", SubjectUtils.countDuplicates(items), homogeneousTypeName.get()) : SubjectUtils.countDuplicates(SubjectUtils.addTypeInfoToEveryItem(items));
    }

    static DuplicateGroupedAndTyped countDuplicatesAndMaybeAddTypeInfoReturnObject(Iterable<?> itemsIterable, boolean addTypeInfo) {
        if (addTypeInfo) {
            Collection<?> items = SubjectUtils.iterableToCollection(itemsIterable);
            Optional<String> homogeneousTypeName = SubjectUtils.getHomogeneousTypeName(items);
            NonHashingMultiset<Object> valuesWithCountsAndMaybeTypes = homogeneousTypeName.isPresent() ? SubjectUtils.countDuplicatesToMultiset(items) : SubjectUtils.countDuplicatesToMultiset(SubjectUtils.addTypeInfoToEveryItem(items));
            return new DuplicateGroupedAndTyped(valuesWithCountsAndMaybeTypes, homogeneousTypeName);
        }
        return new DuplicateGroupedAndTyped(SubjectUtils.countDuplicatesToMultiset(itemsIterable), Optional.absent());
    }

    static String iterableToStringWithTypeInfo(Iterable<?> itemsIterable) {
        Collection<?> items = SubjectUtils.iterableToCollection(itemsIterable);
        Optional<String> homogeneousTypeName = SubjectUtils.getHomogeneousTypeName(items);
        if (homogeneousTypeName.isPresent()) {
            return Strings.lenientFormat("%s (%s)", items, homogeneousTypeName.get());
        }
        return SubjectUtils.addTypeInfoToEveryItem(items).toString();
    }

    static List<@Nullable Object> retainMatchingToString(Iterable<?> items, Iterable<?> itemsToCheck) {
        ArrayListMultimap<String, @Nullable ?> stringValueToItemsToCheck = ArrayListMultimap.create();
        for (Object itemToCheck : itemsToCheck) {
            stringValueToItemsToCheck.put(String.valueOf(itemToCheck), itemToCheck);
        }
        ArrayList<@Nullable Object> result2 = Lists.newArrayList();
        block1: for (Object item : items) {
            for (Object itemToCheck : stringValueToItemsToCheck.get((Object)String.valueOf(item))) {
                if (Objects.equal(itemToCheck, item)) continue;
                result2.add(item);
                continue block1;
            }
        }
        return result2;
    }

    static boolean hasMatchingToStringPair(Iterable<?> items1, Iterable<?> items2) {
        if (Iterables.isEmpty(items1) || Iterables.isEmpty(items2)) {
            return false;
        }
        return !SubjectUtils.retainMatchingToString(items1, items2).isEmpty();
    }

    static String objectToTypeName(@Nullable Object item) {
        if (item == null) {
            return "null type";
        }
        if (item instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)item;
            String valueTypeName = entry.getValue() == entry ? "Map.Entry" : SubjectUtils.objectToTypeName(entry.getValue());
            return Strings.lenientFormat("Map.Entry<%s, %s>", SubjectUtils.objectToTypeName(entry.getKey()), valueTypeName);
        }
        return item.getClass().getName();
    }

    private static Optional<String> getHomogeneousTypeName(Iterable<?> items) {
        Optional<String> homogeneousTypeName = Optional.absent();
        for (Object item : items) {
            if (item == null) {
                return Optional.absent();
            }
            if (!homogeneousTypeName.isPresent()) {
                homogeneousTypeName = Optional.of(SubjectUtils.objectToTypeName(item));
                continue;
            }
            if (SubjectUtils.objectToTypeName(item).equals(homogeneousTypeName.get())) continue;
            return Optional.absent();
        }
        return homogeneousTypeName;
    }

    private static List<String> addTypeInfoToEveryItem(Iterable<?> items) {
        ArrayList<String> itemsWithTypeInfo = Lists.newArrayList();
        for (Object item : items) {
            itemsWithTypeInfo.add(Strings.lenientFormat("%s (%s)", item, SubjectUtils.objectToTypeName(item)));
        }
        return itemsWithTypeInfo;
    }

    static <T> Collection<T> iterableToCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return Lists.newArrayList(iterable);
    }

    static <T> List<T> iterableToList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        return Lists.newArrayList(iterable);
    }

    static <T> Iterable<T> annotateEmptyStrings(Iterable<T> items) {
        if (Iterables.contains(items, "")) {
            ArrayList<String> annotatedItems = Lists.newArrayList();
            for (T item : items) {
                if (Objects.equal(item, "")) {
                    String newItem = HUMAN_UNDERSTANDABLE_EMPTY_STRING;
                    annotatedItems.add(newItem);
                    continue;
                }
                annotatedItems.add((String)item);
            }
            return annotatedItems;
        }
        return items;
    }

    @SafeVarargs
    static <E> ImmutableList<E> concat(Iterable<? extends E> ... inputs) {
        return ImmutableList.copyOf(Iterables.concat(inputs));
    }

    static <E> ImmutableList<E> append(E[] array, E object) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add((Object[])array)).add((Object)object)).build();
    }

    static <E> ImmutableList<E> append(ImmutableList<? extends E> list, E object) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(list)).add((Object)object)).build();
    }

    static <E> ImmutableList<E> sandwich(E first2, E[] array, E last2) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add((Object)first2)).add((Object[])array)).add((Object)last2)).build();
    }

    static final class DuplicateGroupedAndTyped {
        final NonHashingMultiset<?> valuesAndMaybeTypes;
        final Optional<String> homogeneousTypeToDisplay;

        DuplicateGroupedAndTyped(NonHashingMultiset<?> valuesAndMaybeTypes, Optional<String> homogeneousTypeToDisplay) {
            this.valuesAndMaybeTypes = valuesAndMaybeTypes;
            this.homogeneousTypeToDisplay = homogeneousTypeToDisplay;
        }

        int totalCopies() {
            return this.valuesAndMaybeTypes.totalCopies();
        }

        boolean isEmpty() {
            return this.valuesAndMaybeTypes.isEmpty();
        }

        Iterable<Multiset.Entry<?>> entrySet() {
            return this.valuesAndMaybeTypes.entrySet();
        }

        public String toString() {
            return this.homogeneousTypeToDisplay.isPresent() ? this.valuesAndMaybeTypes + " (" + this.homogeneousTypeToDisplay.get() + ")" : this.valuesAndMaybeTypes.toString();
        }
    }

    private static final class NonHashingMultiset<E> {
        private final Multiset<Equivalence.Wrapper<E>> contents = LinkedHashMultiset.create();
        private static final Equivalence<Object> EQUALITY_WITHOUT_USING_HASH_CODE = new Equivalence<Object>(){

            @Override
            protected boolean doEquivalent(Object a, Object b) {
                return Objects.equal(a, b);
            }

            @Override
            protected int doHash(Object o) {
                return 0;
            }
        };

        private NonHashingMultiset() {
        }

        private Multiset.Entry<?> unwrapKey(Multiset.Entry<Equivalence.Wrapper<E>> input) {
            return Multisets.immutableEntry(input.getElement().get(), input.getCount());
        }

        void add(E element) {
            this.contents.add(EQUALITY_WITHOUT_USING_HASH_CODE.wrap(element));
        }

        int totalCopies() {
            return this.contents.size();
        }

        boolean isEmpty() {
            return this.contents.isEmpty();
        }

        Iterable<Multiset.Entry<?>> entrySet() {
            return Iterables.transform(this.contents.entrySet(), this::unwrapKey);
        }

        String toStringWithBrackets() {
            ArrayList<String> parts = new ArrayList<String>();
            for (Multiset.Entry<?> entry : this.entrySet()) {
                parts.add(SubjectUtils.entryString(entry));
            }
            return ((Object)parts).toString();
        }

        public String toString() {
            String withBrackets = this.toStringWithBrackets();
            return withBrackets.substring(1, withBrackets.length() - 1);
        }
    }
}

