/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator;

import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.TypeSpec;
import io.grpc.kotlin.generator.ServiceCodeGenerator;
import io.grpc.kotlin.generator.protoc.ClassSimpleName;
import io.grpc.kotlin.generator.protoc.ClassSimpleNameKt;
import io.grpc.kotlin.generator.protoc.Declarations;
import io.grpc.kotlin.generator.protoc.DescriptorUtilKt;
import io.grpc.kotlin.generator.protoc.GeneratorConfig;
import io.grpc.kotlin.generator.protoc.ProtoServiceNameKt;
import io.grpc.kotlin.generator.protoc.ScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/grpc/kotlin/generator/ProtoFileCodeGenerator;", "", "generators", "", "Lkotlin/Function1;", "Lio/grpc/kotlin/generator/protoc/GeneratorConfig;", "Lio/grpc/kotlin/generator/ServiceCodeGenerator;", "config", "topLevelSuffix", "", "(Ljava/util/List;Lio/grpc/kotlin/generator/protoc/GeneratorConfig;Ljava/lang/String;)V", "generateCodeForFile", "Lcom/squareup/kotlinpoet/FileSpec;", "fileDescriptor", "Lcom/google/protobuf/Descriptors$FileDescriptor;", "compiler"})
@SourceDebugExtension(value={"SMAP\nProtoFileCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtoFileCodeGenerator.kt\nio/grpc/kotlin/generator/ProtoFileCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Declarations.kt\nio/grpc/kotlin/generator/protoc/DeclarationsKt\n*L\n1#1,78:1\n1549#2:79\n1620#2,3:80\n26#3:83\n*S KotlinDebug\n*F\n+ 1 ProtoFileCodeGenerator.kt\nio/grpc/kotlin/generator/ProtoFileCodeGenerator\n*L\n39#1:79\n39#1:80,3\n48#1:83\n*E\n"})
public final class ProtoFileCodeGenerator {
    @NotNull
    private final GeneratorConfig config;
    @NotNull
    private final String topLevelSuffix;
    @NotNull
    private final List<ServiceCodeGenerator> generators;

    /*
     * WARNING - void declaration
     */
    public ProtoFileCodeGenerator(@NotNull List<? extends Function1<? super GeneratorConfig, ? extends ServiceCodeGenerator>> generators, @NotNull GeneratorConfig config, @NotNull String topLevelSuffix) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(generators, "generators");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(topLevelSuffix, "topLevelSuffix");
        this.config = config;
        this.topLevelSuffix = topLevelSuffix;
        Iterable iterable = generators;
        ProtoFileCodeGenerator protoFileCodeGenerator = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Function1 function1 = (Function1)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ServiceCodeGenerator)it.invoke(this.config));
        }
        protoFileCodeGenerator.generators = (List)destination$iv$iv;
    }

    @Nullable
    public final FileSpec generateCodeForFile(@NotNull Descriptors.FileDescriptor fileDescriptor) {
        Intrinsics.checkNotNullParameter(fileDescriptor, "fileDescriptor");
        GeneratorConfig $this$generateCodeForFile_u24lambda_u242 = this.config;
        boolean bl = false;
        ClassSimpleName outerTypeName = DescriptorUtilKt.getOuterClassSimpleName(fileDescriptor).withSuffix(this.topLevelSuffix);
        boolean wroteAnything = false;
        FileSpec.Builder fileBuilder = ScopeKt.builder(FileSpec.Companion, $this$generateCodeForFile_u24lambda_u242.javaPackage(fileDescriptor), outerTypeName);
        for (Descriptors.ServiceDescriptor service : fileDescriptor.getServices()) {
            Object[] objectArray;
            boolean $i$f$declarations = false;
            Object[] $this$generateCodeForFile_u24lambda_u242_u24lambda_u241 = objectArray = new Declarations.Builder();
            boolean bl2 = false;
            for (ServiceCodeGenerator generator2 : this.generators) {
                Intrinsics.checkNotNullExpressionValue(service, "service");
                $this$generateCodeForFile_u24lambda_u242_u24lambda_u241.merge(generator2.generate(service));
            }
            Declarations serviceDecls = objectArray.build();
            if (serviceDecls.getHasEnclosingScopeDeclarations()) {
                wroteAnything = true;
                Intrinsics.checkNotNullExpressionValue(service, "service");
                TypeSpec.Builder builder = ClassSimpleNameKt.objectBuilder(TypeSpec.Companion, ProtoServiceNameKt.getServiceName(service).toClassSimpleName().withSuffix(this.topLevelSuffix));
                objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue(service.getFullName(), "service.fullName");
                TypeSpec.Builder serviceObjectBuilder = builder.addKdoc("Holder for Kotlin coroutine-based client and server APIs for %L.", objectArray);
                serviceDecls.writeToEnclosingType(serviceObjectBuilder);
                fileBuilder.addType(serviceObjectBuilder.build());
            }
            if (!serviceDecls.getHasTopLevelDeclarations()) continue;
            wroteAnything = true;
            serviceDecls.writeOnlyTopLevel(fileBuilder);
        }
        return wroteAnything ? fileBuilder.build() : null;
    }
}

