/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator.protoc;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import io.grpc.kotlin.generator.protoc.ClassSimpleName;
import io.grpc.kotlin.generator.protoc.ConstantName;
import io.grpc.kotlin.generator.protoc.MemberSimpleName;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0096\u0003J\t\u0010\u0018\u001a\u00020\nH\u00d6\u0001J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0019\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nH\u0096\u0001J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006("}, d2={"Lio/grpc/kotlin/generator/protoc/ProtoFieldName;", "", "name", "", "(Ljava/lang/String;)V", "javaSimpleName", "Lio/grpc/kotlin/generator/protoc/MemberSimpleName;", "getJavaSimpleName", "()Lio/grpc/kotlin/generator/protoc/MemberSimpleName;", "length", "", "getLength", "()I", "propertySimpleName", "getPropertySimpleName", "component1", "copy", "equals", "", "other", "", "get", "", "index", "hashCode", "nameToCase", "caseFormat", "Lcom/google/common/base/CaseFormat;", "subSequence", "startIndex", "endIndex", "toClassSimpleNameWithSuffix", "Lio/grpc/kotlin/generator/protoc/ClassSimpleName;", "suffix", "toEnumConstantName", "Lio/grpc/kotlin/generator/protoc/ConstantName;", "toString", "upperCaseAfterNumeric", "input", "Companion", "compiler"})
public final class ProtoFieldName
implements CharSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Set<ProtoFieldName> SPECIAL_CASES;
    @NotNull
    private static final CharMatcher LETTER;
    @NotNull
    private static final CharMatcher DIGIT;

    public ProtoFieldName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
    }

    public int getLength() {
        return this.name.length();
    }

    public char get(int index) {
        return this.name.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        return this.name.subSequence(startIndex, endIndex);
    }

    private final String nameToCase(CaseFormat caseFormat) {
        String string = CaseFormat.LOWER_UNDERSCORE.to(caseFormat, this.name);
        Intrinsics.checkNotNullExpressionValue(string, "LOWER_UNDERSCORE.to(caseFormat, name)");
        return string;
    }

    @NotNull
    public final MemberSimpleName getPropertySimpleName() {
        char[] cArray = new char[]{'_'};
        List nameComponents = StringsKt.split$default((CharSequence)this.name, cArray, false, 0, 6, null);
        StringBuilder finalCamelCaseName = new StringBuilder(this.name.length());
        for (String word : nameComponents) {
            if (((CharSequence)finalCamelCaseName).length() == 0) {
                finalCamelCaseName.append(Ascii.toLowerCase(word.charAt(0))).append(this.upperCaseAfterNumeric(word), 1, word.length());
                continue;
            }
            finalCamelCaseName.append(Ascii.toUpperCase(word.charAt(0))).append(this.upperCaseAfterNumeric(word), 1, word.length());
        }
        String string = finalCamelCaseName.toString();
        Intrinsics.checkNotNullExpressionValue(string, "finalCamelCaseName.toString()");
        return new MemberSimpleName(string);
    }

    private final String upperCaseAfterNumeric(String input) {
        StringBuilder result2 = new StringBuilder(input.length());
        boolean lastCharNum = false;
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            if (lastCharNum && ProtoFieldName.Companion.contains(ProtoFieldName.LETTER, c)) {
                result2.append(Ascii.toUpperCase(c));
            } else {
                result2.append(c);
            }
            lastCharNum = ProtoFieldName.Companion.contains(ProtoFieldName.DIGIT, c);
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "result.toString()");
        return string;
    }

    @NotNull
    public final MemberSimpleName getJavaSimpleName() {
        return SPECIAL_CASES.contains(this) ? this.getPropertySimpleName().withSuffix("_") : this.getPropertySimpleName();
    }

    @NotNull
    public final ClassSimpleName toClassSimpleNameWithSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        StringBuilder finalCamelCaseName = new StringBuilder(this.name.length() + suffix.length());
        char[] cArray = new char[]{'_'};
        for (String word : StringsKt.split$default((CharSequence)this.name, cArray, false, 0, 6, null)) {
            finalCamelCaseName.append(Ascii.toUpperCase(word.charAt(0))).append(word, 1, word.length());
        }
        finalCamelCaseName.append(suffix);
        String string = finalCamelCaseName.toString();
        Intrinsics.checkNotNullExpressionValue(string, "finalCamelCaseName.toString()");
        return new ClassSimpleName(string);
    }

    @NotNull
    public final ConstantName toEnumConstantName() {
        String string = Ascii.toUpperCase(this.name);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(name)");
        return new ConstantName(string);
    }

    @Override
    @NotNull
    public String toString() {
        return this.name;
    }

    private final String component1() {
        return this.name;
    }

    @NotNull
    public final ProtoFieldName copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new ProtoFieldName(name);
    }

    public static /* synthetic */ ProtoFieldName copy$default(ProtoFieldName protoFieldName, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = protoFieldName.name;
        }
        return protoFieldName.copy(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProtoFieldName)) {
            return false;
        }
        ProtoFieldName protoFieldName = (ProtoFieldName)other;
        return Intrinsics.areEqual(this.name, protoFieldName.name);
    }

    static {
        ProtoFieldName[] protoFieldNameArray = new ProtoFieldName[]{new ProtoFieldName("class"), new ProtoFieldName("cached_size"), new ProtoFieldName("serialized_size")};
        SPECIAL_CASES = SetsKt.setOf(protoFieldNameArray);
        CharMatcher charMatcher = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z'));
        Intrinsics.checkNotNullExpressionValue(charMatcher, "inRange('A', 'Z').or(Cha\u2026atcher.inRange('a', 'z'))");
        LETTER = charMatcher;
        CharMatcher charMatcher2 = CharMatcher.inRange('0', '9');
        Intrinsics.checkNotNullExpressionValue(charMatcher2, "inRange('0', '9')");
        DIGIT = charMatcher2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/grpc/kotlin/generator/protoc/ProtoFieldName$Companion;", "", "()V", "DIGIT", "Lcom/google/common/base/CharMatcher;", "LETTER", "SPECIAL_CASES", "", "Lio/grpc/kotlin/generator/protoc/ProtoFieldName;", "contains", "", "c", "", "compiler"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean contains(CharMatcher $this$contains, char c) {
            Intrinsics.checkNotNullParameter($this$contains, "<this>");
            return $this$contains.matches(c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

