/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IgnoreJRERequirement;
import com.google.common.truth.Subject;
import java.util.OptionalDouble;
import org.jspecify.annotations.Nullable;

@IgnoreJRERequirement
public final class OptionalDoubleSubject
extends Subject {
    private final @Nullable OptionalDouble actual;

    OptionalDoubleSubject(FailureMetadata failureMetadata, @Nullable OptionalDouble subject, @Nullable String typeDescription) {
        super(failureMetadata, subject, typeDescription);
        this.actual = subject;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be present"), new Fact[0]);
        }
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected empty optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be empty"), Fact.fact("but was present with value", this.actual.getAsDouble()));
        }
    }

    public void hasValue(double expected) {
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact("expected to have value", expected), Fact.simpleFact("but was absent"));
        } else {
            this.checkNoNeedToDisplayBothValues("getAsDouble()", new Object[0]).that(this.actual.getAsDouble()).isEqualTo(expected);
        }
    }

    @Deprecated
    public static Subject.Factory<OptionalDoubleSubject, OptionalDouble> optionalDoubles() {
        return (metadata, subject) -> new OptionalDoubleSubject(metadata, (OptionalDouble)subject, "optionalDouble");
    }
}

