/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.kotlin.AbstractCoroutineStub;
import io.grpc.kotlin.ClientCalls;
import io.grpc.kotlin.StubFor;
import io.grpc.kotlin.generator.ServiceCodeGenerator;
import io.grpc.kotlin.generator.protoc.ClassSimpleName;
import io.grpc.kotlin.generator.protoc.ClassSimpleNameKt;
import io.grpc.kotlin.generator.protoc.Declarations;
import io.grpc.kotlin.generator.protoc.GeneratorConfig;
import io.grpc.kotlin.generator.protoc.KtPoetUtilKt;
import io.grpc.kotlin.generator.protoc.MemberSimpleName;
import io.grpc.kotlin.generator.protoc.MemberSimpleNameKt;
import io.grpc.kotlin.generator.protoc.ProtoMethodNameKt;
import io.grpc.kotlin.generator.protoc.ProtoServiceNameKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lio/grpc/kotlin/generator/GrpcClientStubGenerator;", "Lio/grpc/kotlin/generator/ServiceCodeGenerator;", "config", "Lio/grpc/kotlin/generator/protoc/GeneratorConfig;", "<init>", "(Lio/grpc/kotlin/generator/protoc/GeneratorConfig;)V", "generate", "Lio/grpc/kotlin/generator/protoc/Declarations;", "service", "Lcom/google/protobuf/Descriptors$ServiceDescriptor;", "generateStub", "Lcom/squareup/kotlinpoet/TypeSpec;", "buildFun", "Lcom/squareup/kotlinpoet/FunSpec;", "stubName", "Lcom/squareup/kotlinpoet/TypeName;", "generateRpcStub", "method", "Lcom/google/protobuf/Descriptors$MethodDescriptor;", "rpcStubKDoc", "Lcom/squareup/kotlinpoet/CodeBlock;", "parameter", "Lcom/squareup/kotlinpoet/ParameterSpec;", "Companion", "compiler"})
@SourceDebugExtension(value={"SMAP\nGrpcClientStubGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcClientStubGenerator.kt\nio/grpc/kotlin/generator/GrpcClientStubGenerator\n+ 2 Declarations.kt\nio/grpc/kotlin/generator/protoc/DeclarationsKt\n*L\n1#1,297:1\n26#2:298\n*S KotlinDebug\n*F\n+ 1 GrpcClientStubGenerator.kt\nio/grpc/kotlin/generator/GrpcClientStubGenerator\n*L\n99#1:298\n*E\n"})
public final class GrpcClientStubGenerator
extends ServiceCodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String STUB_CLASS_SUFFIX = "CoroutineStub";
    @NotNull
    private static final MemberSimpleName UNARY_PARAMETER_NAME = new MemberSimpleName("request");
    @NotNull
    private static final MemberSimpleName STREAMING_PARAMETER_NAME = new MemberSimpleName("requests");
    @NotNull
    private static final MemberSimpleName GRPC_CHANNEL_PARAMETER_NAME = new MemberSimpleName("channel");
    @NotNull
    private static final MemberSimpleName CALL_OPTIONS_PARAMETER_NAME = new MemberSimpleName("callOptions");
    @NotNull
    private static final ParameterSpec HEADERS_PARAMETER;
    @NotNull
    private static final ParameterSpec GRPC_CHANNEL_PARAMETER;
    @NotNull
    private static final ParameterSpec CALL_OPTIONS_PARAMETER;
    @NotNull
    private static final ClassName FLOW;
    @NotNull
    private static final MemberName UNARY_RPC_HELPER;
    @NotNull
    private static final MemberName CLIENT_STREAMING_RPC_HELPER;
    @NotNull
    private static final MemberName SERVER_STREAMING_RPC_HELPER;
    @NotNull
    private static final MemberName BIDI_STREAMING_RPC_HELPER;
    @NotNull
    private static final Map<MethodDescriptor.MethodType, MemberName> RPC_HELPER;

    public GrpcClientStubGenerator(@NotNull GeneratorConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config);
    }

    @Override
    @NotNull
    public Declarations generate(@NotNull Descriptors.ServiceDescriptor service) {
        Declarations.Builder builder;
        Intrinsics.checkNotNullParameter(service, "service");
        boolean $i$f$declarations = false;
        Declarations.Builder $this$generate_u24lambda_u240 = builder = new Declarations.Builder();
        boolean bl = false;
        $this$generate_u24lambda_u240.addType(this.generateStub(service));
        return builder.build();
    }

    @VisibleForTesting
    @NotNull
    public final TypeSpec generateStub(@NotNull Descriptors.ServiceDescriptor service) {
        Intrinsics.checkNotNullParameter(service, "service");
        ClassSimpleName stubName = ProtoServiceNameKt.getServiceName(service).toClassSimpleName().withSuffix(STUB_CLASS_SUFFIX);
        TypeName stubSelfReference = TypeVariableName.Companion.get$default(TypeVariableName.Companion, stubName.toString(), null, 2, null);
        Object object = new TypeName[]{stubSelfReference};
        TypeSpec.Builder builder = ClassSimpleNameKt.classBuilder(TypeSpec.Companion, stubName).superclass(ParameterizedTypeName.Companion.get(TypeNames.get(Reflection.getOrCreateKotlinClass(AbstractCoroutineStub.class)), (TypeName[])object));
        object = new Object[1];
        Intrinsics.checkNotNullExpressionValue(service.getFullName(), "getFullName(...)");
        TypeSpec.Builder builder2 = builder.addKdoc("A stub for issuing RPCs to a(n) %L service as suspending coroutines.", (Object[])object);
        object = new Object[]{this.getGrpcClass(service)};
        TypeSpec.Builder builder3 = builder2.addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(StubFor.class)).addMember("%T::class", (Object[])object).build()).primaryConstructor(((FunSpec.Builder)FunSpec.Companion.constructorBuilder().addParameter(GRPC_CHANNEL_PARAMETER).addParameter(CALL_OPTIONS_PARAMETER).addAnnotation(Reflection.getOrCreateKotlinClass(JvmOverloads.class))).build());
        object = new Object[]{GRPC_CHANNEL_PARAMETER};
        TypeSpec.Builder builder4 = builder3.addSuperclassConstructorParameter("%N", (Object[])object);
        object = new Object[]{CALL_OPTIONS_PARAMETER};
        TypeSpec.Builder builder5 = builder4.addSuperclassConstructorParameter("%N", (Object[])object).addFunction(this.buildFun(stubSelfReference));
        for (Descriptors.MethodDescriptor method : service.getMethods()) {
            Intrinsics.checkNotNull(method);
            builder5.addFunction(this.generateRpcStub(method));
        }
        return builder5.build();
    }

    private final FunSpec buildFun(TypeName stubName) {
        Object[] objectArray = new KModifier[]{KModifier.OVERRIDE};
        FunSpec.Builder builder = FunSpec.Builder.returns$default(FunSpec.Companion.builder("build"), stubName, null, 2, null).addModifiers((KModifier[])objectArray).addParameter(GRPC_CHANNEL_PARAMETER).addParameter(MemberSimpleNameKt.of(ParameterSpec.Companion, CALL_OPTIONS_PARAMETER_NAME, Reflection.getOrCreateKotlinClass(CallOptions.class), new KModifier[0]));
        objectArray = new Object[]{stubName, GRPC_CHANNEL_PARAMETER, CALL_OPTIONS_PARAMETER};
        return builder.addStatement("return %T(%N, %N)", objectArray).build();
    }

    @VisibleForTesting
    @NotNull
    public final FunSpec generateRpcStub(@NotNull Descriptors.MethodDescriptor method) {
        TypeName typeName;
        ParameterSpec parameterSpec;
        Intrinsics.checkNotNullParameter(method, "method");
        GeneratorConfig $this$generateRpcStub_u24lambda_u240 = this.getConfig();
        boolean bl = false;
        MemberSimpleName name = ProtoMethodNameKt.getMethodName(method).toMemberSimpleName();
        Descriptors.Descriptor descriptor2 = method.getInputType();
        Intrinsics.checkNotNullExpressionValue(descriptor2, "getInputType(...)");
        ClassName requestType = $this$generateRpcStub_u24lambda_u240.messageClass(descriptor2);
        if (method.isClientStreaming()) {
            TypeName[] typeNameArray = new TypeName[]{requestType};
            parameterSpec = MemberSimpleNameKt.of(ParameterSpec.Companion, STREAMING_PARAMETER_NAME, (TypeName)ParameterizedTypeName.Companion.get(FLOW, typeNameArray), new KModifier[0]);
        } else {
            parameterSpec = MemberSimpleNameKt.of(ParameterSpec.Companion, UNARY_PARAMETER_NAME, (TypeName)requestType, new KModifier[0]);
        }
        ParameterSpec parameter = parameterSpec;
        Descriptors.Descriptor descriptor3 = method.getOutputType();
        Intrinsics.checkNotNullExpressionValue(descriptor3, "getOutputType(...)");
        ClassName responseType = $this$generateRpcStub_u24lambda_u240.messageClass(descriptor3);
        if (method.isServerStreaming()) {
            TypeName[] typeNameArray = new TypeName[]{responseType};
            typeName = ParameterizedTypeName.Companion.get(FLOW, typeNameArray);
        } else {
            typeName = responseType;
        }
        TypeName returnType = typeName;
        MemberName memberName = RPC_HELPER.get((Object)GrpcClientStubGenerator.Companion.getType(method));
        if (memberName == null) {
            throw new IllegalArgumentException();
        }
        MemberName helperMethod = memberName;
        FunSpec.Builder funSpecBuilder = FunSpec.Builder.returns$default($this$generateRpcStub_u24lambda_u240.funSpecBuilder(name).addParameter(parameter).addParameter(HEADERS_PARAMETER), returnType, null, 2, null).addKdoc(this.rpcStubKDoc(method, parameter));
        if (method.getOptions().getDeprecated()) {
            Object[] objectArray = new Object[]{"The underlying service method is marked deprecated."};
            funSpecBuilder.addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Deprecated.class)).addMember("%S", objectArray).build());
        }
        Object[] objectArray = new Pair[]{TuplesKt.to("helperMethod", helperMethod), TuplesKt.to("methodDescriptor", this.getDescriptorCode(method)), TuplesKt.to("parameter", parameter), TuplesKt.to("headers", HEADERS_PARAMETER)};
        Map codeBlockMap = MapsKt.mapOf(objectArray);
        if (!method.isServerStreaming()) {
            objectArray = new KModifier[]{KModifier.SUSPEND};
            funSpecBuilder.addModifiers((KModifier[])objectArray);
        }
        funSpecBuilder.addNamedCode("return %helperMethod:M(\n  channel,\n  %methodDescriptor:L,\n  %parameter:N,\n  callOptions,\n  %headers:N\n)", codeBlockMap);
        return funSpecBuilder.build();
    }

    private final CodeBlock rpcStubKDoc(Descriptors.MethodDescriptor method, ParameterSpec parameter) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("parameter", parameter), TuplesKt.to("flow", Reflection.getOrCreateKotlinClass(Flow.class)), TuplesKt.to("status", Reflection.getOrCreateKotlinClass(Status.class)), TuplesKt.to("statusException", Reflection.getOrCreateKotlinClass(StatusException.class)), TuplesKt.to("headers", HEADERS_PARAMETER)};
        Map kDocBindings = MapsKt.mapOf(pairArray);
        List kDocComponents = new ArrayList();
        kDocComponents.add(method.isServerStreaming() ? "Returns a [%flow:T] that, when collected, executes this RPC and emits responses from the\nserver as they arrive.  That flow finishes normally if the server closes its response with\n[`Status.OK`][%status:T], and fails by throwing a [%statusException:T] otherwise.  If\ncollecting the flow downstream fails exceptionally (including via cancellation), the RPC\nis cancelled with that exception as a cause." : "Executes this RPC and returns the response message, suspending until the RPC completes\nwith [`Status.OK`][%status:T].  If the RPC completes with another status, a corresponding\n[%statusException:T] is thrown.  If this coroutine is cancelled, the RPC is also cancelled\nwith the corresponding exception as a cause.");
        switch (WhenMappings.$EnumSwitchMapping$0[GrpcClientStubGenerator.Companion.getType(method).ordinal()]) {
            case 1: {
                kDocComponents.add("The [%flow:T] of requests is collected once each time the [%flow:T] of responses is\ncollected. If collection of the [%flow:T] of responses completes normally or\nexceptionally before collection of `%parameter:N` completes, the collection of\n`%parameter:N` is cancelled.  If the collection of `%parameter:N` completes\nexceptionally for any other reason, then the collection of the [%flow:T] of responses\ncompletes exceptionally for the same reason and the RPC is cancelled with that reason.");
                break;
            }
            case 2: {
                kDocComponents.add("This function collects the [%flow:T] of requests.  If the server terminates the RPC\nfor any reason before collection of requests is complete, the collection of requests\nwill be cancelled.  If the collection of requests completes exceptionally for any other\nreason, the RPC will be cancelled for that reason and this method will throw that\nexception.");
            }
        }
        kDocComponents.add(method.isClientStreaming() ? "@param %parameter:N A [%flow:T] of request messages." : "@param %parameter:N The request message to send to the server.");
        kDocComponents.add("@param %headers:N Metadata to attach to the request.  Most users will not need this.");
        kDocComponents.add(method.isServerStreaming() ? "@return A flow that, when collected, emits the responses from the server." : "@return The single response from the server.");
        return CodeBlock.Companion.builder().addNamed(CollectionsKt.joinToString$default(kDocComponents, "\n\n", null, null, 0, null, null, 62, null), kDocBindings).build();
    }

    static {
        Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(Metadata.class)};
        HEADERS_PARAMETER = ParameterSpec.Companion.builder("headers", Reflection.getOrCreateKotlinClass(Metadata.class), new KModifier[0]).defaultValue("%T()", objectArray).build();
        GRPC_CHANNEL_PARAMETER = MemberSimpleNameKt.of(ParameterSpec.Companion, GRPC_CHANNEL_PARAMETER_NAME, Reflection.getOrCreateKotlinClass(Channel.class), new KModifier[0]);
        objectArray = new Object[]{KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(CallOptions.class), "DEFAULT")};
        CALL_OPTIONS_PARAMETER = MemberSimpleNameKt.builder(ParameterSpec.Companion, new MemberSimpleName("callOptions"), Reflection.getOrCreateKotlinClass(CallOptions.class), new KModifier[0]).defaultValue("%M", objectArray).build();
        FLOW = ClassNames.get(Reflection.getOrCreateKotlinClass(Flow.class));
        UNARY_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "unaryRpc");
        CLIENT_STREAMING_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "clientStreamingRpc");
        SERVER_STREAMING_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "serverStreamingRpc");
        BIDI_STREAMING_RPC_HELPER = KtPoetUtilKt.member(Reflection.getOrCreateKotlinClass(ClientCalls.class), "bidiStreamingRpc");
        objectArray = new Pair[]{TuplesKt.to(MethodDescriptor.MethodType.UNARY, UNARY_RPC_HELPER), TuplesKt.to(MethodDescriptor.MethodType.CLIENT_STREAMING, CLIENT_STREAMING_RPC_HELPER), TuplesKt.to(MethodDescriptor.MethodType.SERVER_STREAMING, SERVER_STREAMING_RPC_HELPER), TuplesKt.to(MethodDescriptor.MethodType.BIDI_STREAMING, BIDI_STREAMING_RPC_HELPER)};
        RPC_HELPER = MapsKt.mapOf(objectArray);
    }

    @kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\u00020\u001b*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lio/grpc/kotlin/generator/GrpcClientStubGenerator$Companion;", "", "<init>", "()V", "STUB_CLASS_SUFFIX", "", "UNARY_PARAMETER_NAME", "Lio/grpc/kotlin/generator/protoc/MemberSimpleName;", "STREAMING_PARAMETER_NAME", "GRPC_CHANNEL_PARAMETER_NAME", "CALL_OPTIONS_PARAMETER_NAME", "HEADERS_PARAMETER", "Lcom/squareup/kotlinpoet/ParameterSpec;", "GRPC_CHANNEL_PARAMETER", "getGRPC_CHANNEL_PARAMETER", "()Lcom/squareup/kotlinpoet/ParameterSpec;", "CALL_OPTIONS_PARAMETER", "getCALL_OPTIONS_PARAMETER", "FLOW", "Lcom/squareup/kotlinpoet/ClassName;", "UNARY_RPC_HELPER", "Lcom/squareup/kotlinpoet/MemberName;", "CLIENT_STREAMING_RPC_HELPER", "SERVER_STREAMING_RPC_HELPER", "BIDI_STREAMING_RPC_HELPER", "RPC_HELPER", "", "Lio/grpc/MethodDescriptor$MethodType;", "type", "Lcom/google/protobuf/Descriptors$MethodDescriptor;", "getType", "(Lcom/google/protobuf/Descriptors$MethodDescriptor;)Lio/grpc/MethodDescriptor$MethodType;", "compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParameterSpec getGRPC_CHANNEL_PARAMETER() {
            return GRPC_CHANNEL_PARAMETER;
        }

        @NotNull
        public final ParameterSpec getCALL_OPTIONS_PARAMETER() {
            return CALL_OPTIONS_PARAMETER;
        }

        private final MethodDescriptor.MethodType getType(Descriptors.MethodDescriptor $this$type) {
            return $this$type.isClientStreaming() ? ($this$type.isServerStreaming() ? MethodDescriptor.MethodType.BIDI_STREAMING : MethodDescriptor.MethodType.CLIENT_STREAMING) : ($this$type.isServerStreaming() ? MethodDescriptor.MethodType.SERVER_STREAMING : MethodDescriptor.MethodType.UNARY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MethodDescriptor.MethodType.values().length];
            try {
                nArray[MethodDescriptor.MethodType.BIDI_STREAMING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MethodDescriptor.MethodType.CLIENT_STREAMING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

