/*
 * Decompiled with CFR 0.152.
 */
package io.gs2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import io.gs2.exception.BadGatewayException;
import io.gs2.exception.BadRequestException;
import io.gs2.exception.ConflictException;
import io.gs2.exception.InternalServerErrorException;
import io.gs2.exception.NotFoundException;
import io.gs2.exception.QuotaExceedException;
import io.gs2.exception.RequestTimeoutException;
import io.gs2.exception.ServiceUnavailableException;
import io.gs2.exception.UnauthorizedException;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import io.gs2.model.RequestError;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class AbstractGs2Client<T extends AbstractGs2Client<?>> {
    protected IGs2Credential credential;
    protected Region region;

    public AbstractGs2Client(IGs2Credential credential) {
        this.credential = credential;
        this.region = Region.AP_NORTHEAST_1;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public T withRegion(Region region) {
        this.setRegion(region);
        return (T)this;
    }

    protected HttpPost createHttpPost(String url, IGs2Credential credential, String service, String module, String function, String body) {
        Long timestamp = System.currentTimeMillis() / 1000L;
        url = StringUtils.replace((String)url, (String)"{service}", (String)service);
        url = StringUtils.replace((String)url, (String)"{region}", (String)this.region.getName());
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", "application/json");
        credential.authorized((HttpUriRequest)post, service, module, function, timestamp);
        post.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        return post;
    }

    protected HttpPut createHttpPut(String url, IGs2Credential credential, String service, String module, String function, String body) {
        Long timestamp = System.currentTimeMillis() / 1000L;
        url = StringUtils.replace((String)url, (String)"{service}", (String)service);
        url = StringUtils.replace((String)url, (String)"{region}", (String)this.region.getName());
        HttpPut put = new HttpPut(url);
        put.setHeader("Content-Type", "application/json");
        credential.authorized((HttpUriRequest)put, service, module, function, timestamp);
        put.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
        return put;
    }

    protected HttpGet createHttpGet(String url, IGs2Credential credential, String service, String module, String function) {
        Long timestamp = System.currentTimeMillis() / 1000L;
        url = StringUtils.replace((String)url, (String)"{service}", (String)service);
        url = StringUtils.replace((String)url, (String)"{region}", (String)this.region.getName());
        HttpGet get = new HttpGet(url);
        get.setHeader("Content-Type", "application/json");
        credential.authorized((HttpUriRequest)get, service, module, function, timestamp);
        return get;
    }

    protected HttpDelete createHttpDelete(String url, IGs2Credential credential, String service, String module, String function) {
        Long timestamp = System.currentTimeMillis() / 1000L;
        url = StringUtils.replace((String)url, (String)"{service}", (String)service);
        url = StringUtils.replace((String)url, (String)"{region}", (String)this.region.getName());
        HttpDelete delete = new HttpDelete(url);
        delete.setHeader("Content-Type", "application/json");
        credential.authorized((HttpUriRequest)delete, service, module, function, timestamp);
        return delete;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <U> U doRequest(HttpUriRequest request, Class<U> clazz) throws BadRequestException, UnauthorizedException, NotFoundException, InternalServerErrorException {
        try {
            String string;
            int retryCount;
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30000).setConnectTimeout(30000).setSocketTimeout(30000).build();
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            ObjectMapper mapper = new ObjectMapper();
            int statusCode = 200;
            String message = null;
            for (retryCount = 0; retryCount < 3; ++retryCount) {
                boolean timeout = false;
                try {
                    HttpResponse response = client.execute(request);
                    statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        if (clazz == null) {
                            return null;
                        }
                        try (InputStream in = response.getEntity().getContent();){
                            Object object = mapper.readValue(in, clazz);
                            return (U)object;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        JsonNode json = mapper.readTree(response.getEntity().getContent());
                        message = ((TextNode)json.get("message")).asText();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (statusCode == 504) {
                        timeout = true;
                    }
                }
                catch (SocketTimeoutException e) {
                    timeout = true;
                }
                if (!timeout) break;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (retryCount > 0 && request.getMethod().equals("DELETE") && statusCode == 404) {
                return null;
            }
            switch (statusCode) {
                case 400: {
                    throw new BadRequestException(message);
                }
                case 401: {
                    throw new UnauthorizedException(message);
                }
                case 402: {
                    throw new QuotaExceedException(message);
                }
                case 404: {
                    throw new NotFoundException(message);
                }
                case 409: {
                    throw new ConflictException(message);
                }
                case 500: {
                    throw new InternalServerErrorException(message);
                }
                case 502: {
                    throw new BadGatewayException(message);
                }
                case 503: {
                    throw new ServiceUnavailableException(new ArrayList<RequestError>());
                }
                case 504: {
                    throw new RequestTimeoutException(message);
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("[").append(statusCode).append("] ");
            if (message == null) {
                string = "unknown";
                throw new RuntimeException(stringBuilder.append(string).toString());
            }
            string = message;
            throw new RuntimeException(stringBuilder.append(string).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

