/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.model;

import io.gs2.model.IGs2Credential;
import io.gs2.util.SignUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.methods.HttpUriRequest;

public class BasicGs2Credential
implements IGs2Credential {
    String clientId;
    String clientSecret;

    public BasicGs2Credential(String clientId, String clientSecret) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("invalid credential");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public void authorized(HttpUriRequest request, String service, String module, String function, Long timestamp) {
        String sign = new Base64().encodeAsString(SignUtil.sign(this.getClientSecret(), module, function, timestamp));
        request.setHeader("X-GS2-CLIENT-ID", this.getClientId());
        request.setHeader("X-GS2-REQUEST-TIMESTAMP", String.valueOf(timestamp));
        request.setHeader("X-GS2-REQUEST-SIGN", sign);
    }
}

