/*
 * Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.gs2.gateway.request;

import org.json.JSONObject;
import java.util.List;
import java.util.Map;
import io.gs2.gateway.model.*;
import io.gs2.control.Gs2BasicRequest;

/**
 * ユーザIDを指定してデバイストークンを設定 のリクエストモデル
 *
 * @author Game Server Services, Inc.
 */
@SuppressWarnings("serial")
public class SetFirebaseTokenByUserIdRequest extends Gs2BasicRequest<SetFirebaseTokenByUserIdRequest> {

    /** ネームスペース名 */
    private String namespaceName;

    /**
     * ネームスペース名を取得
     *
     * @return ユーザIDを指定してデバイストークンを設定
     */
    public String getNamespaceName() {
        return namespaceName;
    }

    /**
     * ネームスペース名を設定
     *
     * @param namespaceName ユーザIDを指定してデバイストークンを設定
     */
    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    /**
     * ネームスペース名を設定
     *
     * @param namespaceName ユーザIDを指定してデバイストークンを設定
     * @return this
     */
    public SetFirebaseTokenByUserIdRequest withNamespaceName(String namespaceName) {
        setNamespaceName(namespaceName);
        return this;
    }

    /** ユーザーID */
    private String userId;

    /**
     * ユーザーIDを取得
     *
     * @return ユーザIDを指定してデバイストークンを設定
     */
    public String getUserId() {
        return userId;
    }

    /**
     * ユーザーIDを設定
     *
     * @param userId ユーザIDを指定してデバイストークンを設定
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * ユーザーIDを設定
     *
     * @param userId ユーザIDを指定してデバイストークンを設定
     * @return this
     */
    public SetFirebaseTokenByUserIdRequest withUserId(String userId) {
        setUserId(userId);
        return this;
    }

    /** Firebase Cloud Messaging のデバイストークン */
    private String token;

    /**
     * Firebase Cloud Messaging のデバイストークンを取得
     *
     * @return ユーザIDを指定してデバイストークンを設定
     */
    public String getToken() {
        return token;
    }

    /**
     * Firebase Cloud Messaging のデバイストークンを設定
     *
     * @param token ユーザIDを指定してデバイストークンを設定
     */
    public void setToken(String token) {
        this.token = token;
    }

    /**
     * Firebase Cloud Messaging のデバイストークンを設定
     *
     * @param token ユーザIDを指定してデバイストークンを設定
     * @return this
     */
    public SetFirebaseTokenByUserIdRequest withToken(String token) {
        setToken(token);
        return this;
    }

    /** 重複実行回避機能に使用するID */
    private String xGs2DuplicationAvoider;

    /**
     * 重複実行回避機能に使用するIDを取得
     *
     * @return ユーザIDを指定してデバイストークンを設定
     */
    public String getDuplicationAvoider() {
        return xGs2DuplicationAvoider;
    }

    /**
     * 重複実行回避機能に使用するIDを設定
     *
     * @param duplicationAvoider ユーザIDを指定してデバイストークンを設定
     */
    public void setDuplicationAvoider(String duplicationAvoider) {
        this.xGs2DuplicationAvoider = duplicationAvoider;
    }

    /**
     * 重複実行回避機能に使用するIDを設定
     *
     * @param duplicationAvoider ユーザIDを指定してデバイストークンを設定
     * @return this
     */
    public SetFirebaseTokenByUserIdRequest withDuplicationAvoider(String duplicationAvoider) {
        setDuplicationAvoider(duplicationAvoider);
        return this;
    }

}