/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gateway;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.gateway.request.CreateNamespaceRequest;
import io.gs2.gateway.request.DeleteFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.DeleteFirebaseTokenRequest;
import io.gs2.gateway.request.DeleteNamespaceRequest;
import io.gs2.gateway.request.DescribeNamespacesRequest;
import io.gs2.gateway.request.DescribeWebSocketSessionsByUserIdRequest;
import io.gs2.gateway.request.DescribeWebSocketSessionsRequest;
import io.gs2.gateway.request.GetFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.GetFirebaseTokenRequest;
import io.gs2.gateway.request.GetNamespaceRequest;
import io.gs2.gateway.request.GetNamespaceStatusRequest;
import io.gs2.gateway.request.GetWebSocketSessionByConnectionIdRequest;
import io.gs2.gateway.request.GetWebSocketSessionRequest;
import io.gs2.gateway.request.SendMobileNotificationByUserIdRequest;
import io.gs2.gateway.request.SendNotificationRequest;
import io.gs2.gateway.request.SetFirebaseTokenByUserIdRequest;
import io.gs2.gateway.request.SetFirebaseTokenRequest;
import io.gs2.gateway.request.SetUserIdByUserIdRequest;
import io.gs2.gateway.request.SetUserIdRequest;
import io.gs2.gateway.request.UpdateNamespaceRequest;
import io.gs2.gateway.result.CreateNamespaceResult;
import io.gs2.gateway.result.DeleteFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.DeleteFirebaseTokenResult;
import io.gs2.gateway.result.DeleteNamespaceResult;
import io.gs2.gateway.result.DescribeNamespacesResult;
import io.gs2.gateway.result.DescribeWebSocketSessionsByUserIdResult;
import io.gs2.gateway.result.DescribeWebSocketSessionsResult;
import io.gs2.gateway.result.GetFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.GetFirebaseTokenResult;
import io.gs2.gateway.result.GetNamespaceResult;
import io.gs2.gateway.result.GetNamespaceStatusResult;
import io.gs2.gateway.result.GetWebSocketSessionByConnectionIdResult;
import io.gs2.gateway.result.GetWebSocketSessionResult;
import io.gs2.gateway.result.SendMobileNotificationByUserIdResult;
import io.gs2.gateway.result.SendNotificationResult;
import io.gs2.gateway.result.SetFirebaseTokenByUserIdResult;
import io.gs2.gateway.result.SetFirebaseTokenResult;
import io.gs2.gateway.result.SetUserIdByUserIdResult;
import io.gs2.gateway.result.SetUserIdResult;
import io.gs2.gateway.result.UpdateNamespaceResult;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2GatewayRestClient
extends AbstractGs2Client<Gs2GatewayRestClient> {
    public static String ENDPOINT = "gateway";

    public Gs2GatewayRestClient(IGs2Credential credential) {
        super(credential);
    }

    public Gs2GatewayRestClient(IGs2Credential credential, Region region) {
        super(credential, region);
    }

    public Gs2GatewayRestClient(IGs2Credential credential, String region) {
        super(credential, region);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FNamespaceFunctionHandler.describeNamespaces";
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeNamespacesResult)this.doRequest((HttpUriRequest)http, DescribeNamespacesResult.class);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FNamespaceFunctionHandler.createNamespace";
        String name = null;
        if (request.getName() != null) {
            name = request.getName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String firebaseSecret = null;
        if (request.getFirebaseSecret() != null) {
            firebaseSecret = request.getFirebaseSecret();
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (name != null) {
            _body.put("name", name);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (firebaseSecret != null) {
            _body.put("firebaseSecret", firebaseSecret);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateNamespaceResult)this.doRequest((HttpUriRequest)http, CreateNamespaceResult.class);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FNamespaceFunctionHandler.getNamespaceStatus";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetNamespaceStatusResult)this.doRequest((HttpUriRequest)http, GetNamespaceStatusResult.class);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FNamespaceFunctionHandler.getNamespace";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetNamespaceResult)this.doRequest((HttpUriRequest)http, GetNamespaceResult.class);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FNamespaceFunctionHandler.updateNamespace";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String firebaseSecret = null;
        if (request.getFirebaseSecret() != null) {
            firebaseSecret = request.getFirebaseSecret();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (description != null) {
            _body.put("description", description);
        }
        if (firebaseSecret != null) {
            _body.put("firebaseSecret", firebaseSecret);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateNamespaceResult)this.doRequest((HttpUriRequest)http, UpdateNamespaceResult.class);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FNamespaceFunctionHandler.deleteNamespace";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteNamespaceResult)this.doRequest((HttpUriRequest)http, DeleteNamespaceResult.class);
    }

    public DescribeWebSocketSessionsResult describeWebSocketSessions(DescribeWebSocketSessionsRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FWebSocketSessionFunctionHandler.describeWebSocketSessions";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DescribeWebSocketSessionsResult)this.doRequest((HttpUriRequest)http, DescribeWebSocketSessionsResult.class);
    }

    public DescribeWebSocketSessionsByUserIdResult describeWebSocketSessionsByUserId(DescribeWebSocketSessionsByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FWebSocketSessionFunctionHandler.describeWebSocketSessionsByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DescribeWebSocketSessionsByUserIdResult)this.doRequest((HttpUriRequest)http, DescribeWebSocketSessionsByUserIdResult.class);
    }

    public SetUserIdResult setUserId(SetUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FWebSocketSessionFunctionHandler.setUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String connectionId = null;
        if (request.getConnectionId() != null) {
            connectionId = request.getConnectionId();
        }
        Boolean allowConcurrentAccess = null;
        if (request.getAllowConcurrentAccess() != null) {
            allowConcurrentAccess = request.getAllowConcurrentAccess();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (allowConcurrentAccess != null) {
            _body.put("allowConcurrentAccess", allowConcurrentAccess);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (SetUserIdResult)this.doRequest((HttpUriRequest)http, SetUserIdResult.class);
    }

    public SetUserIdByUserIdResult setUserIdByUserId(SetUserIdByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FWebSocketSessionFunctionHandler.setUserIdByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String connectionId = null;
        if (request.getConnectionId() != null) {
            connectionId = request.getConnectionId();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        Boolean allowConcurrentAccess = null;
        if (request.getAllowConcurrentAccess() != null) {
            allowConcurrentAccess = request.getAllowConcurrentAccess();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (allowConcurrentAccess != null) {
            _body.put("allowConcurrentAccess", allowConcurrentAccess);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (SetUserIdByUserIdResult)this.doRequest((HttpUriRequest)http, SetUserIdByUserIdResult.class);
    }

    public GetWebSocketSessionResult getWebSocketSession(GetWebSocketSessionRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FWebSocketSessionFunctionHandler.getWebSocketSession";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String connectionId = null;
        if (request.getConnectionId() != null) {
            connectionId = request.getConnectionId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetWebSocketSessionResult)this.doRequest((HttpUriRequest)http, GetWebSocketSessionResult.class);
    }

    public GetWebSocketSessionByConnectionIdResult getWebSocketSessionByConnectionId(GetWebSocketSessionByConnectionIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FWebSocketSessionFunctionHandler.getWebSocketSessionByConnectionId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String connectionId = null;
        if (request.getConnectionId() != null) {
            connectionId = request.getConnectionId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (connectionId != null) {
            _queryString.add(new BasicNameValuePair("connectionId", String.valueOf(connectionId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetWebSocketSessionByConnectionIdResult)this.doRequest((HttpUriRequest)http, GetWebSocketSessionByConnectionIdResult.class);
    }

    public SendNotificationResult sendNotification(SendNotificationRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FWebSocketSessionFunctionHandler.sendNotification";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String issuer = null;
        if (request.getIssuer() != null) {
            issuer = request.getIssuer();
        }
        String subject = null;
        if (request.getSubject() != null) {
            subject = request.getSubject();
        }
        String payload = null;
        if (request.getPayload() != null) {
            payload = request.getPayload();
        }
        Boolean enableTransferMobileNotification = null;
        if (request.getEnableTransferMobileNotification() != null) {
            enableTransferMobileNotification = request.getEnableTransferMobileNotification();
        }
        String sound = null;
        if (request.getSound() != null) {
            sound = request.getSound();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (subject != null) {
            _body.put("subject", subject);
        }
        if (payload != null) {
            _body.put("payload", payload);
        }
        if (enableTransferMobileNotification != null) {
            _body.put("enableTransferMobileNotification", enableTransferMobileNotification);
        }
        if (sound != null) {
            _body.put("sound", sound);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (SendNotificationResult)this.doRequest((HttpUriRequest)http, SendNotificationResult.class);
    }

    public SetFirebaseTokenResult setFirebaseToken(SetFirebaseTokenRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FFirebaseTokenFunctionHandler.setFirebaseToken";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String token = null;
        if (request.getToken() != null) {
            token = request.getToken();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (token != null) {
            _body.put("token", token);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (SetFirebaseTokenResult)this.doRequest((HttpUriRequest)http, SetFirebaseTokenResult.class);
    }

    public SetFirebaseTokenByUserIdResult setFirebaseTokenByUserId(SetFirebaseTokenByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FFirebaseTokenFunctionHandler.setFirebaseTokenByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String token = null;
        if (request.getToken() != null) {
            token = request.getToken();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (token != null) {
            _body.put("token", token);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (SetFirebaseTokenByUserIdResult)this.doRequest((HttpUriRequest)http, SetFirebaseTokenByUserIdResult.class);
    }

    public GetFirebaseTokenResult getFirebaseToken(GetFirebaseTokenRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FFirebaseTokenFunctionHandler.getFirebaseToken";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (GetFirebaseTokenResult)this.doRequest((HttpUriRequest)http, GetFirebaseTokenResult.class);
    }

    public GetFirebaseTokenByUserIdResult getFirebaseTokenByUserId(GetFirebaseTokenByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FFirebaseTokenFunctionHandler.getFirebaseTokenByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (GetFirebaseTokenByUserIdResult)this.doRequest((HttpUriRequest)http, GetFirebaseTokenByUserIdResult.class);
    }

    public DeleteFirebaseTokenResult deleteFirebaseToken(DeleteFirebaseTokenRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FFirebaseTokenFunctionHandler.deleteFirebaseToken";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        http.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DeleteFirebaseTokenResult)this.doRequest((HttpUriRequest)http, DeleteFirebaseTokenResult.class);
    }

    public DeleteFirebaseTokenByUserIdResult deleteFirebaseTokenByUserId(DeleteFirebaseTokenByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FFirebaseTokenFunctionHandler.deleteFirebaseTokenByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (DeleteFirebaseTokenByUserIdResult)this.doRequest((HttpUriRequest)http, DeleteFirebaseTokenByUserIdResult.class);
    }

    public SendMobileNotificationByUserIdResult sendMobileNotificationByUserId(SendMobileNotificationByUserIdRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/gateway-handler?handler=gs2_gateway%2Fhandler%2FFirebaseTokenFunctionHandler.sendMobileNotificationByUserId";
        String namespaceName = null;
        if (request.getNamespaceName() != null) {
            namespaceName = request.getNamespaceName();
        }
        String userId = null;
        if (request.getUserId() != null) {
            userId = request.getUserId();
        }
        String subject = null;
        if (request.getSubject() != null) {
            subject = request.getSubject();
        }
        String payload = null;
        if (request.getPayload() != null) {
            payload = request.getPayload();
        }
        String sound = null;
        if (request.getSound() != null) {
            sound = request.getSound();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (namespaceName != null) {
            _queryString.add(new BasicNameValuePair("namespaceName", String.valueOf(namespaceName)));
        }
        if (userId != null) {
            _queryString.add(new BasicNameValuePair("userId", String.valueOf(userId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (subject != null) {
            _body.put("subject", subject);
        }
        if (payload != null) {
            _body.put("payload", payload);
        }
        if (sound != null) {
            _body.put("sound", sound);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        if (request.getDuplicationAvoider() != null) {
            http.setHeader("X-GS2-DUPLICATION-AVOIDER", request.getDuplicationAvoider());
        }
        return (SendMobileNotificationByUserIdResult)this.doRequest((HttpUriRequest)http, SendMobileNotificationByUserIdResult.class);
    }
}

